<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class DemandeurExport implements FromCollection, WithHeadings
{
    protected $demandeurs;

    public function __construct($demandeurs)
    {
        $this->demandeurs = $demandeurs;
    }

    public function collection()
    {
        return $this->demandeurs;
    }

    public function headings():array
    {
        return [
            "ID",
            "NOM", 
            "PRENOMS", 
            "DATE DE NAISSANCE", 
            "LIEU DE NAISSANCE",
            "SEXE",  
            "NATIONALITE",
            "NIVEAU",
            "DIPLÔME",
            "AUTRE DIPLÔME",
            "FIIERES",
            "AUTRES FIIERES",
            "NUMERO TELEPHONE",
            "ADRESSE EMAIL"
        ];
    }
}
