<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class EntrepriseExport implements FromCollection, WithHeadings
{
	protected $entreprises;

    public function __construct($entreprises)
    {
        $this->entreprises = $entreprises;
    }

    public function collection()
    {
        return $this->entreprises;
    }

    public function headings():array
    {
        return [
            "DESIGNATION",
            "ADRESSE", 
            "CONTACT", 
            "INTERLOCUTEUR NOM", 
            "INTERLOCUTEUR QUALITE", 
            "INTERLOCUTEUR CONTACT", 
            "EMAIL",
            "ACTIVITE",
            "BRANCHE D'ACTIVITE",
            "HOMMES",
            "FEMMES",
            "TOTAL",
            "NATIONALITE",
            "STATUT",
            "N°CNSS",
            "SITUATION DE L'ACTIVITE",
            "DATE SITUATION"
        ];
    }
}
