<?php

namespace App\Exports;

use App\Models\Offre;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class OffreExport implements FromCollection, WithHeadings
{
    protected $offres;

    public function __construct($offres)
    {
        $this->offres = $offres;
    }

    public function collection()
    {
        return $this->offres;
    }

    public function headings():array
    {
        return [ 
            "ENTREPRISE",
            "TITRE OFFRE",
            "FILIÈRE",
            "DIPLÔME",
            "CONTRAT",
            "NOMBRE DE POSTE",
            "STATUT",
            "DATE CLÔTURE"
        ];
    }
}
