<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Actualite;
use App\Models\Categorie;
use App\Models\Commentaire;
use DB;

class ActualiteController extends Controller
{

    //Liste des actalite
    public function Actualite(){

        $actualites  = Actualite::join('categorie','categorie.categorie_id','actualite.categorie_id')
                                ->whereRaw('date(actualite_datefin) >= "'.gmdate("Y-m-d").'" ')
                                ->where(['actualite_statut'=>"PUBLIE"])
                                ->orderby('actualite_id','DESC')
                                ->paginate(18);

        $categories = Categorie::orderby('categorie_id','DESC')->get();

        return view('actualite.actualite',['actualites'=>$actualites, 'categories'=>$categories]);
    }

    //Détails actualité
    public function DetailsActualite($actualite_id){

        $actualite = Actualite::find($actualite_id);

        if(!empty($actualite)){

            $commentaires = DB::table('commentaire')
                                ->leftJoin('users', 'commentaire.commentaireemail', '=', 'users.email')
                                ->select('commentaire.*', 'users.*')
                                ->where('commentaire_statut','=','VALIDE')
                                ->where('commentaire.actualite_id','=',$actualite->actualite_id)
                                ->orderby('commentaire_datecrea','DESC')
                                ->get();

            $nombre_commentaire = $commentaires->count();

            $actualite_similaires = Actualite::where('actualite.categorie_id', $actualite->categorie_id)
                                            ->where('actualite.actualite_id', '<>', $actualite->actualite_id)
                                            ->whereRaw('date(actualite_datefin) >= "'.gmdate("Y-m-d").'"')
                                            ->orderBy('actualite_datefin', 'DESC')
                                            ->paginate(8);

            return view('actualite.details',['actualite'=>$actualite, 'commentaires'=>$commentaires, 'nombre_commentaire'=>$nombre_commentaire, 'actualite_similaires'=>$actualite_similaires]);
        }        
    }

    //Rechercher par catégorie
    public function DetailsCategorie($categorie_id){
        
        $categorie_id = Categorie::find($categorie_id);

        $actualites  = Actualite::join('categorie','categorie.categorie_id','actualite.categorie_id')
                                ->whereRaw('date(actualite_datefin) >= "'.gmdate("Y-m-d").'" ')
                                ->where(['actualite_statut'=>"PUBLIE", 'actualite.categorie_id'=>$categorie_id->categorie_id])
                                ->paginate(18);

        $categories = Categorie::orderby('categorie_id','DESC')->get();
                        
        return view('actualite.actualitecategorie',['categorie_id'=>$categorie_id, 'categories'=>$categories, 'actualites'=>$actualites]);
    }

    //Poster un commentaire
    public function SaveCommentaire(Request $request, $actualite_id){

        $actualite = Actualite::find($actualite_id);

        if($actualite){

            $rules = [
                'commentaire' => 'required',
                'email' => 'required|email',
                'nom' => 'required',
            ];
            
            $customMessages = [
                'nom.required' => 'Le nom est obligatoire',
                'commentaire.required' => 'Le commentaire est obligatoire',
                'email.required' => 'L\'adresse email est obligatoire',
                'email.email' => 'L\'adresse email n\'est pas valide',
            ];
            
            $this->validate($request,$rules,$customMessages);

            $commentaire = new Commentaire();

            $commentaire->actualite_id          = $actualite->actualite_id;
            $commentaire->commentairelib        = htmlspecialchars($request->commentaire);
            $commentaire->commentairename       = htmlspecialchars($request->nom);
            $commentaire->commentaireemail      = htmlspecialchars($request->email);
            $commentaire->commentaire_datecrea  = gmdate('Y-m-d');
            $commentaire->commentaire_statut    = "BROUILLON";
            $commentaire->save();

            return redirect()->back()->with('info_succes',"Commentaire envoyé avec succès !");
        }
    }
    
}
