<?php

namespace App\Http\Controllers\Administrateur;

use App\Http\Controllers\Controller; 

use Illuminate\Http\Request;  
use Dompdf\Dompdf;  
use App\Models\User; 
use App\Models\Fonction; 
use App\Models\Offre; 
use App\Models\Diplome;
use Carbon\Carbon;
use App\Models\TypeContrat; 
use App\Models\Candidature;
use App\Models\Region;
use App\Models\OffreRegion;
use App\Exports\EntrepriseExport; 
use App\Models\SecteurActivite;
use App\Models\Nationalite;
use App\Models\SituationActivite;
use App\Models\StatutEntreprise; 
use App\Models\Actualite; 
use App\Models\Metier;
use App\Models\Pays; 
use App\Models\Profil;
use App\Models\TrancheAge;
use App\Models\Categorie;
use App\Models\Commentaire;
use App\Models\LangueInternationale;
use App\Models\LangueLocale;
use App\Models\CategorieProfessionelle;
use App\Models\NewsLetter;
use App\Models\NiveauInstruction;
use App\Models\TypeDemandeur;
use App\Models\TypeInscription;
use App\Models\Action;
use App\Models\ActionAutorisee;
use App\Models\CvTheque;
use App\Models\CentreInteretLangue;
use App\Models\ExperienceProfessionnelle;
use App\Models\Formation;
use App\Models\Specialite; 
use App\Models\Publication;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\DemandeurExport;
use App\Exports\DemandeExport;
use App\Exports\OffreExport;
use App\Exports\DemandeurExtractExport;
use Illuminate\Support\Facades\Storage;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use App\Mail\ContactMail;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Str;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\File;
use Image;
use Auth;
use Mail; 
use PDF;
use View;
use Session;
use Stdfn;
use DB;

class AdministrateurController extends Controller
{

    public function __construct(){
        
        $this->middleware('auth'); 
    }

    //***** GESTION DES LIENS SUR LES EMPLOYEURS ******//

    //Liste des Employeurs à valider 
    public function EntrepriseaValider(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")){

                $region = $request->r;
                $statut      = $request->t;
                $nationalite  = $request->n;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($region)){
                    $whereRaw.= " AND users.region_id = $region ";
                }
                if(!empty($statut)){
                    $whereRaw.= " AND users.statutentreprise_id = $statut ";
                }
                if(!empty($nationalite)){
                    $whereRaw.= " AND users.nationalite_id = $nationalite ";
                }
                if(!empty($situation)){
                    $whereRaw.= " AND users.situationentreprise_id = $situation ";
                }
                
                $entreprises = User::join('region','region.region_id','users.region_id')
                                    ->where(['profil_id'=>2, 'user_statut'=>"BROUILLON"])
                                    ->whereRaw($whereRaw)
                                    ->orderby('users.id','DESC')
                                    ->get();
                
                $regions = Region::orderby('region_nom','ASC')->get();

                $statuts = StatutEntreprise::where(['statutentreprise_statut'=>"VALIDE"])->get();

                $situations = SituationActivite::where(['situationentreprise_statut'=>"VALIDE"])->get();

                $nationalites = Nationalite::get();

                // Stocker les données de recherche en session
                Session::put('recherche_employeur', [
                    'region' => $region,
                    'statut' => $statut,
                    'nationalite' => $nationalite,
                    'situation' => $situation,
                ]);

                return view('admin.entreprise.avalider',['entreprises'=>$entreprises, 'regions'=>$regions, 'statuts'=>$statuts, 'nationalites'=>$nationalites, 'situations'=>$situations, 'region_selected'=>$region, 'statut_selected'=>$statut, 'nationalite_selected'=>$nationalite, 'situation_selected'=>$situation]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Liste des Employeurs
    public function EntrepriseListe(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP")){
                
                $region = $request->r;
                $statut      = $request->t;
                $nationalite  = $request->n;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($region)){
                    $whereRaw.= " AND users.region_id = $region ";
                }
                if(!empty($statut)){
                    $whereRaw.= " AND users.statutentreprise_id = $statut ";
                }
                if(!empty($nationalite)){
                    $whereRaw.= " AND users.nationalite_id = $nationalite ";
                }
                if(!empty($situation)){
                    $whereRaw.= " AND users.situationentreprise_id = $situation ";
                }

                $entreprises = User::join('region','region.region_id','users.region_id')
                                    ->where(['profil_id'=>2, 'user_statut'=>"VALIDE"])
                                    ->whereRaw($whereRaw)
                                    ->orderby('users.id','DESC')
                                    ->get();

                $regions = Region::orderby('region_nom','ASC')->get();

                $statuts = StatutEntreprise::where(['statutentreprise_statut'=>"VALIDE"])->get();

                $situations = SituationActivite::where(['situationentreprise_statut'=>"VALIDE"])->get();

                $nationalites = Nationalite::get();

                // Stocker les données de recherche en session
                Session::put('recherche_employeur', [
                    'region' => $region,
                    'statut' => $statut,
                    'nationalite' => $nationalite,
                    'situation' => $situation,
                ]);
                
                return view('admin.entreprise.liste',['entreprises'=>$entreprises, 'regions'=>$regions, 'statuts'=>$statuts, 'nationalites'=>$nationalites, 'situations'=>$situations, 'region_selected'=>$region, 'statut_selected'=>$statut, 'nationalite_selected'=>$nationalite, 'situation_selected'=>$situation]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
             
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Valider Détails de l'employeur 
    public function EntrepriseDetailsValider($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP")){
                
                $user = User::find($id);

                if($user){ 

                    $nationalite = Nationalite::where(['nationalite.nationalite_id'=>$user->nationalite_id])->first();

                    $secteuractivite = SecteurActivite::where(['secteuractivite.secteuractivite_id'=>$user->secteuractivite_id])->first();

                    $situationentreprise = SituationActivite::where(['situationentreprise.situationentreprise_id'=>$user->situationentreprise_id])->first();
                    
                    $statutentreprise = StatutEntreprise::where(['statutentreprise.statutentreprise_id'=>$user->statutentreprise_id])->first();
                    
                    $region = Region::where(['region.region_id'=>$user->region_id])->first();

                    return view('admin.entreprise.detailsvalider',['user'=>$user, 'nationalite'=>$nationalite, 'secteuractivite'=>$secteuractivite, 'situationentreprise'=>$situationentreprise, 'statutentreprise'=>$statutentreprise, 'region'=>$region]);
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Détails de l'employeur
    public function EntrepriseDetails($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP")){
                
                $user = User::find($id);

                if($user){ 

                    $offres = Offre::where(['offre.user_id'=>$user->id])->orderby('offre_datepublic','DESC')->get();             
                    
                    $contrats = Candidature::join('typecontrat','typecontrat.typecontrat_id','candidature.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->join('offre','offre.offre_id','candidature.offre_id')
                                            ->where(['offre.user_id'=>$user->id, 'candidature.candidature_statut'=>"APPROUVE"])
                                            ->get();
                    // dd($contrats);
                    $nationalite = Nationalite::where(['nationalite.nationalite_id'=>$user->nationalite_id])->first();

                    $secteuractivite = SecteurActivite::where(['secteuractivite.secteuractivite_id'=>$user->secteuractivite_id])->first();

                    $situationentreprise = SituationActivite::where(['situationentreprise.situationentreprise_id'=>$user->situationentreprise_id])->first();
                    
                    $statutentreprise = StatutEntreprise::where(['statutentreprise.statutentreprise_id'=>$user->statutentreprise_id])->first();
                    
                    $region = Region::where(['region.region_id'=>$user->region_id])->first();

                    return view('admin.entreprise.details',['user'=>$user, 'offres'=>$offres, 'contrats'=>$contrats, 'nationalite'=>$nationalite, 'secteuractivite'=>$secteuractivite, 'situationentreprise'=>$situationentreprise, 'statutentreprise'=>$statutentreprise, 'region'=>$region]);
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Formulaire de création de compte employeur
    public function EntrepriseCreerCompte(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_EMP")){
                
                $regions = Region::where(['region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();
                
                $region_agent = Region::where(['region_statut'=>"VALIDE"])->where(['region.region_id'=>Auth::user()->region_id])->orderby('region_nom','ASC')->get();

                $statuts = StatutEntreprise::where(['statutentreprise_statut'=>"VALIDE"])->get();

                $activites = SecteurActivite::where(['secteuractivite_statut'=>"VALIDE"])->orderby('secteuractivitelib','ASC')->get();

                $situations = SituationActivite::where(['situationentreprise_statut'=>"VALIDE"])->get();

                $nationalites = Nationalite::where(['nationalite_statut'=>"VALIDE"])->get();

                return view('admin.entreprise.creercompte',['regions'=>$regions, 'region_agent'=>$region_agent, 'statuts'=>$statuts, 'activites'=>$activites, 'nationalites'=>$nationalites, 'situations'=>$situations]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Save création de compte employeur
    public function SaveEntrepriseCreerCompte(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){            
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_EMP")){
                
                $rules = [
                    'password' => ['required', 'string', 'min:6', 'confirmed'],
                    'situationentreprise_id' => ['required'],
                    'email' => ['required', 'string', 'email', 'unique:users'],
                    'statutentreprise_id' => ['required'],
                    'secteuractivite_id' => ['required'],
                    'region_id' => ['required'],
                    'nationalite_id' => ['required'],
                    'activite' => ['required'],
                    'nbrfemme' => ['required'],
                    'nbrehomme' => ['required'],
                    'qualite' => ['required', 'string', 'max:255'],
                    'contact' => ['required'],
                    'entreprise_logo' => 'mimes:png,jpg,jpeg',
                    'adresse' => ['required', 'string', 'max:255'],
                    'raisonsociale' => ['required'],
                    'nom' => ['required', 'string', 'max:255'],
                ];
                
                $customMessages = [
                    'email.required'=>"L'adresse email est obligatoire",
                    'email.email'=>"L'adresse email n'est pas valide",
                    'email.unique'=>"Cet adresse email est déjà utilisé",
                    'raisonsociale.required' => 'La raison sociale est obligatoire',
                    'nbrfemme.required' => 'Le nombre de femme est obligatoire',
                    'nbrehomme.required' => 'Le nombre d\'homme est obligatoire',
                    'qualite.required' => 'La qualité est obligatoire',
                    'adresse.required' => "L'adresse est obligatoire",
                    'contact.required' => 'Le contact est obligatoire',
                    'nom.required' => 'Le nom et prénoms est obligatoire',
                    'activite.required' => 'L\'activité est obligatoire',
                    'entreprise_logo.mimes' => 'L\'extension de l\'image ne correspond pas',
                    'nationalite_id.required' => 'La nationalité est obligatoire',
                    'region_id.required' => 'La région est obligatoire',
                    'secteuractivite_id.required' => 'La branche d\'activité est obligatoire',
                    'statutentreprise_id.required' => 'Le statut de l\'entreprise est obligatoire',
                    'situationentreprise_id.required' => 'La situation actuelle de l\'entreprise est obligatoire',                    
                    'password.required' => "Le mot de passe est obligatoire",
                    'password.confirmed' => "La confirmation du mot de passe n'est pas conforme au mot de passe",
                    'password.min' => "Le mot de passe doit être au moins de 6 caractères",
                ];
                
                $this->validate($request,$rules,$customMessages);

                $url = $request->root();

                $user = new User();

                // Upload Image de Profile
                if($request->hasFile('entreprise_logo')){

                    $EditEmployeurImageName = time().'.'.request()->entreprise_logo->getClientOriginalExtension();
                    request()->entreprise_logo->move(public_path('assets/img/entreprise'), $EditEmployeurImageName);

                }
                if($request->entreprise_logo !=null){
                    $user->entreprise_logo = $EditEmployeurImageName ?? NULL;
                }

                $user->profil_id                = 2; 
                $user->creerpar_id              = Auth::user()->id;
                $user->email                    = htmlspecialchars($request->email);
                $user->name                     = htmlspecialchars($request->nom);
                $user->region_id                = $request->region_id;
                $user->nationalite_id           = $request->nationalite_id;
                $user->secteuractivite_id       = $request->secteuractivite_id;
                $user->statutentreprise_id      = $request->statutentreprise_id;
                $user->situationentreprise_id   = $request->situationentreprise_id;
                $user->raisonsociale            = Str::upper(Str::ascii($request->raisonsociale));
                $user->ncnss                    = Str::upper(Str::ascii($request->ncnss));
                $user->activite                 = Str::upper(Str::ascii($request->activite));
                $user->nbrfemme                 = htmlspecialchars($request->nbrfemme);
                $user->nbrehomme                = htmlspecialchars($request->nbrehomme);
                $user->qualite                  = htmlspecialchars($request->qualite);
                $user->contact                  = htmlspecialchars($request->contact);
                $user->contactinterlo           = htmlspecialchars($request->contactinterlo);
                $user->telephone                = htmlspecialchars($request->contactinterlo);
                $user->adresse                  = Str::upper(Str::ascii($request->adresse));
                $user->effectiftotal            = $request->nbrfemme + $request->nbrehomme;
                $user->password                 = Hash::make($request->password);
                $user->date_validation          = gmdate('Y-m-d H:i:s');
                $user->user_statut              = "BROUILLON";
                $user->user_origine             = "Locale";
                $user->save();
                
                //Email data
                $email_data = array(
                    'nom' => $request->nom,
                    'raisonsociale' => $request->raisonsociale,
                    'email' => $request->email,
                    'motdepasse' => $request->password,
                    'anneencours'=>gmdate('Y'),
                );
                
                //Envoie des paramètres du mail
                Mail::send('emails.email_register', $email_data, function ($message) use ($email_data){
                $message->to($email_data['email'] ,$email_data['raisonsociale'])
                    ->subject("ANPE Inscription validé")
                    ->from('info@anpe-niger.ne' ,"ANPE");
                });

                return back()->with('info_succes',"Compte employeur crée avec succès");
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        } 
    }

    //Formulaire de modification de compte employeur
    public function EntrepriseModifierCompte($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_EMP")){
                
                $user = User::find($id);

                if($user){
                
                    $regions = Region::where(['region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();

                    $region_agent = Region::where(['region.region_id'=>Auth::user()->region_id, 'region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();

                    $statuts = StatutEntreprise::where(['statutentreprise_statut'=>"VALIDE"])->get();

                    $activites = SecteurActivite::where(['secteuractivite_statut'=>"VALIDE"])->orderby('secteuractivitelib','ASC')->get();

                    $situations = SituationActivite::where(['situationentreprise_statut'=>"VALIDE"])->get();

                    $nationalites = Nationalite::where(['nationalite_statut'=>"VALIDE"])->get();

                    return view('admin.entreprise.modifier',['user'=>$user, 'regions'=>$regions, 'region_agent'=>$region_agent, 'statuts'=>$statuts, 'activites'=>$activites, 'nationalites'=>$nationalites, 'situations'=>$situations]);
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Save modifier compte employeur
    public function SaveEntrepriseModifierCompte(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){            

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_EMP")){
                
                $user = User::find($id);

                if($user){
                    
                    $rules = [
                        'password' => ['required','min:6', 'confirmed'],
                        'situationentreprise_id' => ['required'],
                        'statutentreprise_id' => ['required'],
                        'secteuractivite_id' => ['required'],
                        'region_id' => ['required'],
                        'nationalite_id' => ['required'],
                        'activite' => ['required'],
                        'nbrfemme' => ['required'],
                        'nbrehomme' => ['required'],
                        'qualite' => ['required', 'string', 'max:255'],
                        'contact' => ['required'],
                        'entreprise_logo' => 'mimes:png,jpg,jpeg',
                        'adresse' => ['required', 'string', 'max:255'],
                        'raisonsociale' => ['required'],
                        'nom' => ['required', 'string', 'max:255'],
                    ];
                    
                    $customMessages = [
                        'raisonsociale.required' => 'La raison sociale est obligatoire',
                        'nbrfemme.required' => 'Le nombre de femme est obligatoire',
                        'nbrehomme.required' => 'Le nombre d\'homme est obligatoire',
                        'qualite.required' => 'La qualité est obligatoire',
                        'adresse.required' => "L'adresse est obligatoire",
                        'contact.required' => 'Le contact est obligatoire',
                        'nom.required' => 'Le nom et prénoms est obligatoire',
                        'activite.required' => 'L\'activité est obligatoire',
                        'entreprise_logo.mimes' => 'L\'extension de l\'image ne correspond pas',
                        'nationalite_id.required' => 'La nationalité est obligatoire',
                        'region_id.required' => 'La région est obligatoire',
                        'secteuractivite_id.required' => 'La branche d\'activité est obligatoire',
                        'statutentreprise_id.required' => 'Le statut de l\'entreprise est obligatoire',
                        'situationentreprise_id.required' => 'La situation actuelle de l\'entreprise est obligatoire',
                        'password.required' => "Le mot de passe est obligatoire",
                        'password.confirmed' => "La confirmation du mot de passe n'est pas conforme au mot de passe",
                        'password.min' => "Le mot de passe doit être au moins de 6 caractères",
                    ];
                    
                    $this->validate($request,$rules,$customMessages);

                    // Upload Image de Profile
                    if($request->hasFile('entreprise_logo')){

                        $EditEmployeurImageName = time().'.'.request()->entreprise_logo->getClientOriginalExtension();
                        request()->entreprise_logo->move(public_path('assets/img/entreprise'), $EditEmployeurImageName);

                    }
                    if($request->entreprise_logo !=null){
                        $user->entreprise_logo = $EditEmployeurImageName ?? NULL;
                    }

                    $user->profil_id                = 2;
                    $user->creerpar_id              = Auth::user()->id;
                    $user->name                     = htmlspecialchars($request->nom);
                    $user->region_id                = $request->region_id;
                    $user->nationalite_id           = $request->nationalite_id;
                    $user->secteuractivite_id       = $request->secteuractivite_id;
                    $user->statutentreprise_id      = $request->statutentreprise_id;
                    $user->situationentreprise_id   = $request->situationentreprise_id;
                    $user->raisonsociale            = Str::upper(Str::ascii($request->raisonsociale));
                    $user->ncnss                    = Str::upper(Str::ascii($request->ncnss));
                    $user->activite                 = Str::upper(Str::ascii($request->activite));
                    $user->adresse                  = Str::upper(Str::ascii($request->adresse));
                    $user->qualite                  = Str::upper(Str::ascii($request->qualite));
                    $user->nbrfemme                 = htmlspecialchars($request->nbrfemme);
                    $user->nbrehomme                = htmlspecialchars($request->nbrehomme);
                    $user->contact                  = htmlspecialchars($request->contact);
                    $user->contactinterlo           = htmlspecialchars($request->contactinterlo);
                    $user->effectiftotal            = $request->nbrfemme + $request->nbrehomme;
                    if($request->password !=null and $request->password !=""){
                        $user->password                 = Hash::make($request->password);
                    }
                    $user->exists                   = true;
                    $user->update();

                    return redirect()->route('admin.valider.entreprise')->with('info_succes',"Compte employeur mis à jour avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        } 
    }

    //Supprimer une employeur
    public function EntrepriseSupprimer($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_EMP")){

                $user = User::find($id);

                if($user){

                    $offres = Offre::where(['offre.user_id'=>$user->id])->get();
                    
                    foreach($offres as $offre){

                        $offre->delete();
                    }

                    $user->delete();

                    return back()->with('info_succes',"Employeur supprimé succès");
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Formulaire de validation d'un employeur
    public function EntrepriseValider($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")){
                
                $user = User::find($id);

                if($user){

                    $nationalite = Nationalite::where(['nationalite.nationalite_id'=>$user->nationalite_id])->first();

                    $secteuractivite = SecteurActivite::where(['secteuractivite.secteuractivite_id'=>$user->secteuractivite_id])->first();

                    $situationentreprise = SituationActivite::where(['situationentreprise_statut'=>"VALIDE"])->where(['situationentreprise.situationentreprise_id'=>$user->situationentreprise_id])->first();
                    
                    $statutentreprise = StatutEntreprise::where(['statutentreprise.statutentreprise_id'=>$user->statutentreprise_id])->first();
                    
                    $region = Region::where(['region.region_id'=>$user->region_id])->first();

                    //dd($nationalite);
                    return view('admin.entreprise.formvalidercompte',['user'=>$user, 'region'=>$region, 'nationalite'=>$nationalite, 'secteuractivite'=>$secteuractivite, 'situationentreprise'=>$situationentreprise, 'statutentreprise'=>$statutentreprise]);
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Save de validation de compte employeur
    public function SaveEntrepriseValider(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")){

                $user = User::find($id);

                if($user){
                    
                    $rules = [
                        'avis' => ['required'],
                        'observation' => ['required'],
                    ];
                    
                    $customMessages = [
                        'avis.required' => "L'avis est obligatoire",
                        'observation.required' => "L'observation est obligatoire",
                    ];
                    
                    $this->validate($request,$rules,$customMessages);

                    if($request->avis == "OUI"){

                        $user->observation = htmlentities($request->observation);
                        $user->user_statut = "VALIDE";
                        $user->creerpar_id = Auth::user()->id;
                        $user->date_validation = gmdate('Y-m-d H:i:s');
                        $user->exists = true;
                        $user->update();
                        
                        //Email data
                        $email_data = array(
                            'nom' => $user['name'],
                            'raisonsociale' => $user['raisonsociale'],
                            'email' => $user['email'],
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        //Envoie des paramètres du mail
                        Mail::send('emails.validatecompte', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'] ,$email_data['raisonsociale'])
                            ->subject("ANPE bonne nouvelle")
                            ->from('info@anpe-niger.ne' ,"ANPE");
                        });

                        return back()->with('info_succes',"Compte employeur validé avec succès !");
                    }else{

                        //Email data
                        $email_data = array(
                            'nom' => $user['name'],
                            'raisonsociale' => $user['raisonsociale'],
                            'raison'=>$request->observation,
                            'email' => $user['email'],
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        //Envoie des paramètres du mail
                        Mail::send('emails.novalidatecompte', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'] ,$email_data['raisonsociale'])
                            ->subject("ANPE notification")
                            ->from('info@anpe-niger.ne' ,"ANPE");
                        });

                        return back()->with('info_succes',"Compte employeur validé avec succès !");
                    }
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Save de validation de compte employeur
    public function EntrepriseValiderCompte(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")){
                
                $url = $request->root();

                $user = User::find($id);

                if($user){
                    
                    $rules = [
                        'avis' => ['required'],
                        'observation' => ['required'],
                    ];
                    
                    $customMessages = [
                        'avis.required' => "L'avis est obligatoire",
                        'observation.required' => "L'observation est obligatoire",
                    ];
                    
                    $this->validate($request,$rules,$customMessages);

                    if($request->avis == "OUI"){

                        $user->observation = htmlentities($request->observation);
                        $user->user_statut = "VALIDE";
                        $user->creerpar_id = Auth::user()->id;
                        $user->date_validation = gmdate('Y-m-d H:i:s');
                        $user->exists = true;
                        $user->update();
                        
                        //Email data
                        $email_data = array(
                            'nom' => $user['name'],
                            'raisonsociale' => $user['raisonsociale'],
                            'email' => $user['email'],
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        //Envoie des paramètres du mail
                        Mail::send('emails.validatecompte', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'] ,$email_data['raisonsociale'])
                            ->subject("ANPE bonne nouvelle")
                            ->from('info@anpe-niger.ne' ,"ANPE");
                        });

                        return back()->with('info_succes',"Compte employeur validé avec succès !");
                    }else{

                        //Email data
                        $email_data = array(
                            'nom' => $user['name'],
                            'raisonsociale' => $user['raisonsociale'],
                            'raison'=>$request->observation,
                            'email' => $user['email'],
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        //Envoie des paramètres du mail
                        Mail::send('emails.novalidatecompte', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'] ,$email_data['raisonsociale'])
                            ->subject("ANPE notification")
                            ->from('info@anpe-niger.ne' ,"ANPE");
                        });

                        return back()->with('info_succes',"Compte employeur validé avec succès !");
                    }
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Exportation de l'ensemble des employeurs
    public function EntrepriseExportExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
			
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP")){

                $data = Session::get('recherche_employeur');

    			$query = User::select('raisonsociale','adresse', 'contact', 'name', 'qualite', "contactinterlo", "email", "activite", "secteuractivitelib", "nbrehomme", "nbrfemme", "effectiftotal", "nationalite_lib", "statutentreprise_lib", "ncnss", "situationentreprise_lib", "date_validation")
    								->join('secteuractivite','secteuractivite.secteuractivite_id','users.secteuractivite_id')
                                    ->join('nationalite','nationalite.nationalite_id','users.nationalite_id')
    								->join('region','region.region_id','users.region_id')
    								->join('statutentreprise','statutentreprise.statutentreprise_id','users.statutentreprise_id')
    								->join('situationentreprise','situationentreprise.situationentreprise_id','users.situationentreprise_id')
    								->where(['users.profil_id'=>2])
                                    ->whereRaw('users.user_statut <> "BROUILLON"')
    								->orderby('users.id','DESC');

                if (isset($data['nationalite'])) {
                    $query->where('users.nationalite_id', '=', $data['nationalite']);
                }

                if (isset($data['region'])) {
                    $query->where('users.region_id', '=', $data['region']);
                }

                if (isset($data['statut'])) {
                    $query->where('users.statutentreprise_id', '=', $data['statut']);
                }

                if (isset($data['situation'])) {
                    $query->where('users.situationentreprise_id', '=', $data['situation']);
                }

                $entreprises = $query->get();

    			if($entreprises->count() > 0){ 
                    return Excel::download(new EntrepriseExport($entreprises), 'employeurs.xlsx');
                }else{
                    return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Exportation de l'ensemble des employeurs
    public function EntrepriseExportPDF(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
           
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP")){

                $data = Session::get('recherche_employeur');

                $query = User::join('secteuractivite','secteuractivite.secteuractivite_id','users.secteuractivite_id')
                                    ->join('nationalite','nationalite.nationalite_id','users.nationalite_id')
                                    ->join('statutentreprise','statutentreprise.statutentreprise_id','users.statutentreprise_id')
                                    ->join('situationentreprise','situationentreprise.situationentreprise_id','users.situationentreprise_id')
                                    ->where(['users.profil_id'=>2])
                                    ->whereRaw('users.user_statut <> "BROUILLON"')
                                    ->orderby('users.id','DESC');

                if (isset($data['nationalite'])) {
                    $query->where('users.nationalite_id', '=', $data['nationalite']);
                }

                if (isset($data['region'])) {
                    $query->where('users.region_id', '=', $data['region']);
                }

                if (isset($data['statut'])) {
                    $query->where('users.statutentreprise_id', '=', $data['statut']);
                }

                if (isset($data['situation'])) {
                    $query->where('users.situationentreprise_id', '=', $data['situation']);
                }

                $entreprises = $query->get();

                if($entreprises->count() > 0){ 
                    
                    $html = View::make('admin.exportation.entreprises', compact('entreprises'))->render();

                    $dompdf = new Dompdf();
                    $dompdf->loadHtml($html);
                    $dompdf->setPaper('A4', 'landscape');
                    $dompdf->render();

                    return $dompdf->stream("employeurs.pdf");
                    
                }else{
                    return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Exportation de l'ensemble des employeurs
    public function EntrepriseNonValiderExportExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
           
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")){

                $data = Session::get('recherche_employeur');

                $query = User::select("identifiant",'raisonsociale','adresse', 'contact', 'name', 'qualite', "contactinterlo", "email", "activite", "secteuractivitelib", "nbrehomme", "nbrfemme", "effectiftotal", "nationalite_lib", "statutentreprise_lib", "ncnss", "situationentreprise_lib", "date_validation")
                                    ->join('secteuractivite','secteuractivite.secteuractivite_id','users.secteuractivite_id')
                                    ->join('nationalite','nationalite.nationalite_id','users.nationalite_id')
                                    ->join('statutentreprise','statutentreprise.statutentreprise_id','users.statutentreprise_id')
                                    ->join('situationentreprise','situationentreprise.situationentreprise_id','users.situationentreprise_id')
                                    ->where(['users.profil_id'=>2, 'users.user_statut'=>"BROUILLON"])
                                    ->orderby('users.id','DESC');

                if (isset($data['nationalite'])) {
                    $query->where('users.nationalite_id', '=', $data['nationalite']);
                }

                if (isset($data['region'])) {
                    $query->where('users.region_id', '=', $data['region']);
                }

                if (isset($data['statut'])) {
                    $query->where('users.statutentreprise_id', '=', $data['statut']);
                }

                if (isset($data['situation'])) {
                    $query->where('users.situationentreprise_id', '=', $data['situation']);
                }

                $entreprises = $query->get();

                if($entreprises->count() > 0){ 
                    return Excel::download(new EntrepriseExport($entreprises), 'employeurs.xlsx');
                }else{
                    return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Exportation de l'ensemble des employeurs
    public function EntrepriseNonValiderExportPDF(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")){

                $data = Session::get('recherche_employeur');

                $query = User::join('secteuractivite','secteuractivite.secteuractivite_id','users.secteuractivite_id')
                                    ->join('nationalite','nationalite.nationalite_id','users.nationalite_id')
                                    ->join('statutentreprise','statutentreprise.statutentreprise_id','users.statutentreprise_id')
                                    ->join('situationentreprise','situationentreprise.situationentreprise_id','users.situationentreprise_id')
                                    ->where(['users.profil_id'=>2, 'users.user_statut'=>"BROUILLON"])
                                    ->orderby('users.id','DESC');

                if (isset($data['nationalite'])) {
                    $query->where('users.nationalite_id', '=', $data['nationalite']);
                }

                if (isset($data['region'])) {
                    $query->where('users.region_id', '=', $data['region']);
                }

                if (isset($data['statut'])) {
                    $query->where('users.statutentreprise_id', '=', $data['statut']);
                }

                if (isset($data['situation'])) {
                    $query->where('users.situationentreprise_id', '=', $data['situation']);
                }

                $entreprises = $query->get();

                if($entreprises->count() > 0){ 
                    
                    $html = View::make('admin.exportation.entreprises', compact('entreprises'))->render();

                    $dompdf = new Dompdf();
                    $dompdf->loadHtml($html);
                    $dompdf->setPaper('A4', 'landscape');
                    $dompdf->render();

                    return $dompdf->stream("employeurs.pdf");
                    
                }else{
                    return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Formulaire de validation d'un employeur
    public function MessageFinContrat(Request $request, $candidature_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP")){

                $url = $request->root();

                $contrat = Candidature::find($candidature_id);

                if($contrat){

                    $candidat = Candidature::join('users','users.id','candidature.user_id')
                                        ->where(['candidature.user_id'=>$contrat->user_id])
                                        ->first();

                    $entreprise = User::join('offre','offre.user_id','users.id')
                                        ->where(['offre.offre_id'=>$contrat->offre_id])
                                        ->first();

                    $titrecontrat = TypeContrat::where(['typecontrat.typecontrat_id'=>$contrat->typecontrat_id])->first();
                    dd($contrat->candidature_datefin);
                    // Email data
                    $email_data = array(
                        'raisonsociale' => $entreprise->raisonsociale,
                        'entreprise_email' => $entreprise->email,
                        'nom' => $candidat->name,
                        'prenoms' => $candidat->prenoms,
                        'contrat' => $titrecontrat->typecontratlib,
                        'datefin_contrat' => $contrat->candidature_datefin,
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.rappelle_contrat', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['entreprise_email'] ,$email_data['raisonsociale'])
                        ->subject("Rappelle de fin de contrat ".$email_data['raisonsociale'])
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    // Email data
                    $candidat_data = array(
                        'raisonsociale' => $entreprise->raisonsociale,
                        'email' => $candidat->email,
                        'nom' => $candidat->name,
                        'prenoms' => $candidat->prenoms,
                        'contrat' => $titrecontrat->typecontratlib,
                        'datefin_contrat' => $contrat->candidature_datefin,
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.rappelle_candidat', $candidat_data, function ($message) use ($candidat_data){
                    $message->to($candidat_data['email'], $candidat_data['nom'], $candidat_data['prenoms'])
                        ->subject("Rappelle de fin de contrat ".$candidat_data['nom'].' '.$candidat_data['prenoms'])
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    return back()->with('info_succes','Le message a bien été envoyé');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Fermer le compte
    public function FermerCompte(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_EMP")){
                
                $url = $request->root();

                $user = User::find($id);

                if($user){

                    $user->user_statut = "BROUILLON";
                    $user->exists = true;
                    $user->update();

                    //Email data
                    $email_data = array(
                        'nom' => $user->nom,
                        'raisonsociale' => $user->raisonsociale,
                        'email' => $user->email,
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.fermercompte', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'] ,$email_data['raisonsociale'])
                        ->subject("Votre compte vient d'être fermer")
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    return back()->with('info_succes',"Le compte a bien été fermé");
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Activer le compte
    public function ActiverCompte($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")){
            
                $user = User::find($id);

                if($user){

                    $user->user_statut = "VALIDE";
                    $user->exists = true;
                    $user->update();

                    //Email data
                    $email_data = array(
                        'nom' => $user->nom,
                        'raisonsociale' => $user->raisonsociale,
                        'email' => $user->email,
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.activercompte', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'] ,$email_data['raisonsociale'])
                        ->subject("Votre compte vient d'être fermer")
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    return back()->with('info_succes',"Le compte a bien été activé");
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Profils demandés
    public function ListeCVTheque(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CVTH") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CVTH")){
                
                $diplome = $request->d;
                $metier = $request->m;
                $experience = $request->a;

                $whereRaw = ' 1 ';
                
                if(!empty($diplome)){
                    $whereRaw.= " AND diplome.diplome_id = $diplome ";
                }
                if(!empty($metier)){
                    $whereRaw.= " AND metier.metier_id = $metier ";
                }
                if(!empty($experience)){
                    $whereRaw.= ' AND users.experience LIKE "%'.$experience.'%"';
                }

                $profil_recommandes = CvTheque::join('users','users.id','cvtheque.user_id')
                                                ->join('metier','metier.metier_id','users.metier_id')
                                                ->join('diplome','diplome.diplome_id','users.diplome_id')
                                                ->where(['profil_id'=>3, 'cvtheque_statut'=>"BROUILLON"])
                                                ->whereRaw($whereRaw)
                                                ->get();

                $diplomes = Diplome::get();

                $filieres = Metier::orderby('metier_libelle','ASC')->get();

                return view('admin.entreprise.profilsrecommandes',['profil_recommandes'=>$profil_recommandes, 'diplomes'=>$diplomes, 'filieres'=>$filieres, 'experience_selected'=>$experience, 'diplome_selected'=>$diplome, 'metier_selected'=>$metier]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Valider demande de CV
    public function ValiderCVTheque(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CVTH")){
                
                $cvtheque_ids = $request->input('cvtheque_id'); 

                if (!empty($cvtheque_ids)) {
                   
                    // Parcourir les identifiants des profils sélectionnés
                    foreach ($cvtheque_ids as $cvtheque_id) {

                        $cvtheque = CvTheque::where(['cvtheque_id'=>$cvtheque_id])->first();

                        $cvtheque->cvtheque_statut = "VALIDE";
                        $cvtheque->exists = true;
                        $cvtheque->update();
                    }

                    return back()->with('info_succes',"La demande a bien été validée avec succès");

                }else{

                    return back()->with('info_warning',"Vous n'avez pas coché de profil");
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }


    //******* GESTION DES LIENS SUR LES OFFRES ********//

    // Liste des offres publiées
    public function OffreListe(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_OFF")){ 
                
                $metier = $request->m;
                $diplome      = $request->d;
                $contrat  = $request->c;

                $whereRaw = ' 1 '; 
            
                if(!empty($metier)){
                    $whereRaw.= " AND offre.metier_id = $metier ";
                }
                if(!empty($diplome)){
                    $whereRaw.= " AND offre.diplome_id = $diplome ";
                }
                if(!empty($contrat)){
                    $whereRaw.= " AND offre.typecontrat_id = $contrat ";
                }

                $date_jours = gmdate("Y-m-d");
                    
                $offres = Offre::join('users','users.id','offre.user_id')
                                ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                ->join('metier','metier.metier_id','offre.metier_id')
                                ->join('diplome','diplome.diplome_id','offre.diplome_id')
                                ->where('offre.offre_statut','<>',"BROUILLON")
                                ->where('offre.offre_datefin','>=',$date_jours)
                                ->whereRaw($whereRaw)
                                ->orderby('offre_datepublic','DESC')
                                ->get();

                $contrats = TypeContrat::where(['typecontrat_statut'=>"VALIDE"])->get();
            
                $metiers = Metier::orderby('metier_libelle','ASC')->get();

                $diplomes = Diplome::orderby('diplomelib','ASC')->get();

                // Stocker les données de recherche en session
                Session::put('recherche_offre', [
                    'metier' => $metier,
                    'diplome' => $diplome,
                    'contrat' => $contrat,
                ]);

                return view('admin.offre.liste',['offres'=>$offres, 'contrats'=>$contrats, 'metiers'=>$metiers, 'diplomes'=>$diplomes, 'contrat_selected'=>$contrat, 'diplome_selected'=>$diplome, 'metier_selected'=>$metier]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Liste des offres à valider
    public function OffreaValider(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_OFF")){

                $date_jours = gmdate("Y-m-d");

                $metier = $request->m;
                $diplome      = $request->d;
                $contrat  = $request->c;

                $whereRaw = ' 1 '; 
            
                if(!empty($metier)){
                    $whereRaw.= " AND offre.metier_id = $metier ";
                }
                if(!empty($diplome)){
                    $whereRaw.= " AND offre.diplome_id = $diplome ";
                }
                if(!empty($contrat)){
                    $whereRaw.= " AND offre.typecontrat_id = $contrat ";
                }

                $offres = Offre::join('users','users.id','offre.user_id')
                                ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                ->join('metier','metier.metier_id','offre.metier_id')
                                ->join('diplome','diplome.diplome_id','offre.diplome_id')
                                ->where('offre.offre_datefin','>=',$date_jours)
                                ->whereRaw($whereRaw)
                                ->where(['offre.offre_statut'=>"BROUILLON"])
                                ->orderby('offre.offre_id','DESC')->get();

                $contrats = TypeContrat::where(['typecontrat_statut'=>"VALIDE"])->get();
            
                $metiers = Metier::orderby('metier_libelle','ASC')->get();

                $diplomes = Diplome::orderby('diplomelib','ASC')->get();

                // Stocker les données de recherche en session
                Session::put('recherche_offre', [
                    'metier' => $metier,
                    'diplome' => $diplome,
                    'contrat' => $contrat,
                ]);

                return view('admin.offre.avalider',['offres'=>$offres, 'contrats'=>$contrats, 'metiers'=>$metiers, 'diplomes'=>$diplomes, 'contrat_selected'=>$contrat, 'diplome_selected'=>$diplome, 'metier_selected'=>$metier]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Liste historique des offres
    public function OffreExpiree(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_OFF")){

                $metier = $request->m;
                $diplome      = $request->d;
                $contrat  = $request->c;

                $whereRaw = ' 1 '; 
            
                if(!empty($metier)){
                    $whereRaw.= " AND offre.metier_id = $metier ";
                }
                if(!empty($diplome)){
                    $whereRaw.= " AND offre.diplome_id = $diplome ";
                }
                if(!empty($contrat)){
                    $whereRaw.= " AND offre.typecontrat_id = $contrat ";
                }

                $date_jours = gmdate("Y-m-d");

                $offres = Offre::join('users','users.id','offre.user_id')
                                ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                ->join('metier','metier.metier_id','offre.metier_id')
                                ->join('diplome','diplome.diplome_id','offre.diplome_id')
                                ->where('offre.offre_datefin','<',$date_jours)
                                ->whereRaw($whereRaw)
                                ->orderby('offre_datepublic','DESC')
                                ->get();

                $contrats = TypeContrat::where(['typecontrat_statut'=>"VALIDE"])->get();
            
                $metiers = Metier::orderby('metier_libelle','ASC')->get();

                $diplomes = Diplome::orderby('diplomelib','ASC')->get();

                // Stocker les données de recherche en session
                Session::put('recherche_offre', [
                    'metier' => $metier,
                    'diplome' => $diplome,
                    'contrat' => $contrat,
                ]);

                return view('admin.offre.offresexpirees',['offres'=>$offres, 'contrats'=>$contrats, 'metiers'=>$metiers, 'diplomes'=>$diplomes, 'contrat_selected'=>$contrat, 'diplome_selected'=>$diplome, 'metier_selected'=>$metier]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Valider Publier une offre 
    public function ValiderPublierOffre($offre_id){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF")){

                $offre = Offre::join('users','users.id','offre.user_id')
                                ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                ->join('metier','metier.metier_id','offre.metier_id')
                                ->join('diplome','diplome.diplome_id','offre.diplome_id')
                                ->where(['offre_id'=>$offre_id])
                                ->first();

                $offre_lien = Stdfn::clean_url($offre->offretitre);
                
                if($offre){

                    //Récupération de l'id du diplôme de l'offre && Récupération de l'id du métier de l'offre
                    $diplome_id = $offre->diplome_id;
                    $metier_id = $offre->metier_id;
                    
                    $offre->offre_statut        = "PUBLIE";
                    $offre->offre_datepublic    = gmdate('Y-m-d H:i:s');
                    $offre->exists              = true;
                    $offre->save();
                    
                    //Récupérer les candidats qui on le profil de l'offre
                    $candidats = User::where(['users.profil_id'=>3])
                                    ->where('users.diplome_id','>=',$diplome_id)
                                    ->where('users.metier_id','=',$metier_id)
                                    ->get();

                    //Récupérer les abonnées à la newsletter
                    $newsletters = NewsLetter::get();

                    //Envoie de mail à la newsletter
                    foreach($newsletters as $newsletter){
                        $email_data = array(
                            'email' => $newsletter->email,
                            'anneencours'=>gmdate('Y'),
                            'offre'=>$offre,
                            'offre_lien'=>$offre_lien,
                        );

                        // Envoie des paramètres du mail au client
                        Mail::send('emails.newsalerte', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'])
                            ->subject("Vous avez une nouvelle offre d'emploi")
                            ->from('info@anpe-niger.ne', 'ANPE');
                        });
                    }

                    //Envoie de mail à la liste des demandeurs d'emploi
                    foreach($candidats as $candidat){
                        $email_data = array(
                            'nom' => $candidat->name,
                            'prenoms' => $candidat->prenoms,
                            'email' => $candidat->email,
                            'anneencours'=>gmdate('Y'),
                            'offre'=>$offre,
                            'offre_lien'=>$offre_lien,
                        );

                        // Envoie des paramètres du mail au client
                        Mail::send('emails.alerte', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'])
                            ->subject("Vous avez une nouvelle offre d'emploi")
                            ->from('info@anpe-niger.ne', 'ANPE');
                        });
                    }
                    
                    return back()->with('info_succes','Offre validée avec succès !');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }
    }

    // Valider Publier une offre 
    public function PublierValiderOffre(Request $request, $offre_id){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF")){

                $offre = Offre::join('users','users.id','offre.user_id')
                                ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                ->join('metier','metier.metier_id','offre.metier_id')
                                ->join('diplome','diplome.diplome_id','offre.diplome_id')
                                ->where(['offre_id'=>$offre_id])
                                ->first();

                $offre_lien = Stdfn::clean_url($offre->offretitre);
                
                if($offre){

                    $rules = [
                        'avis' => ['required'],
                        'observation' => ['required'],
                    ];
                    
                    $customMessages = [
                        'avis.required' => "L'avis est obligatoire",
                        'observation.required' => "L'observation est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages);

                    if($request->avis == "OUI"){

                        //Récupération de l'id du diplôme de l'offre && Récupération de l'id du métier de l'offre
                        $diplome_id = $offre->diplome_id;
                        $metier_id = $offre->metier_id;
                        
                        $offre->offre_statut        = "PUBLIE";
                        $offre->offre_datepublic    = gmdate('Y-m-d H:i:s');
                        $offre->exists              = true;
                        $offre->save();
                        
                        //Récupérer les candidats qui on le profil de l'offre
                        $candidats = User::where(['users.profil_id'=>3])
                                        ->where('users.diplome_id','>=',$diplome_id)
                                        ->where('users.metier_id','=',$metier_id)
                                        ->get();

                        //Récupérer les abonnées à la newsletter
                        $newsletters = NewsLetter::get();

                        //Envoie de mail à la newsletter
                        foreach($newsletters as $newsletter){
                            $email_data = array(
                                'email' => $newsletter->email,
                                'anneencours'=>gmdate('Y'),
                                'offre'=>$offre,
                                'offre_lien'=>$offre_lien,
                            );

                            // Envoie des paramètres du mail au client
                            Mail::send('emails.newsalerte', $email_data, function ($message) use ($email_data){
                            $message->to($email_data['email'])
                                ->subject("Vous avez une nouvelle offre d'emploi")
                                ->from('info@anpe-niger.ne', 'ANPE');
                            });
                        }

                        //Envoie de mail à la liste des demandeurs d'emploi
                        foreach($candidats as $candidat){
                            $email_data = array(
                                'nom' => $candidat->name,
                                'prenoms' => $candidat->prenoms,
                                'email' => $candidat->email,
                                'anneencours'=>gmdate('Y'),
                                'offre'=>$offre,
                                'offre_lien'=>$offre_lien,
                            );

                            // Envoie des paramètres du mail au client
                            Mail::send('emails.alerte', $email_data, function ($message) use ($email_data){
                            $message->to($email_data['email'])
                                ->subject("Vous avez une nouvelle offre d'emploi")
                                ->from('info@anpe-niger.ne', 'ANPE');
                            });
                        }
                        
                        return back()->with('info_succes','Offre validée avec succès !');

                    }else{

                        $email_data = array(
                            'email' => $newsletter->email,
                            'offre' => $offre->offretitre,
                            'observation' => $request->observation,
                            'offre_lien'=>$offre_lien,
                            'anneencours'=>gmdate('Y'),
                        );

                        // Envoie des paramètres du mail au client
                        Mail::send('emails.annulerpuboffre', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'])
                            ->subject("Publication de l'offre annulé")
                            ->from('info@anpe-niger.ne', 'ANPE');
                        });

                        return back()->with('info_succes','Annulation de publication d\'offre envoyé avec succès !');
                    }
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }
    }

    //Désactiver offre
    public function DesactiverOffre($offre_id){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF")){

                $offre = Offre::find($offre_id);
                
                if($offre){
                    
                    $offre->offre_statut = "SUPPRIME";
                    $offre->exists = true;
                    $offre->update();

                    return back()->with('info_succes','Offre désactivée avec succès !');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }
    }

    //Activer offre
    public function ActiverOffre($offre_id){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF")){

                $offre = Offre::find($offre_id);
                
                if($offre){
                    
                    $offre->offre_statut = "PUBLIE";
                    $offre->exists = true;
                    $offre->update();

                    return back()->with('info_succes','Offre activée avec succès !');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }
    }

    // Formulaire de publication d'offre
    public function PublierOffreEmploi(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_OFF")){

                $typecontrat = TypeContrat::orderby('typecontratlib','ASC')->get();

                $metiers = Metier::orderby('metier_libelle','ASC')->get();

                $diplomes = Diplome::orderby('diplomelib','ASC')->get();

                $regions = Region::orderby('region_nom','ASC')->get();

                return view('admin.offre.publieroffre',['typecontrat'=>$typecontrat, 'regions'=>$regions, 'metiers'=>$metiers, 'diplomes'=>$diplomes]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Save publier offre
    public function SavePublierOffreEmploi(Request $request){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_OFF")){

                $regions = array_filter($request->region_ids);

                $rules = [
                    'titre' => 'required',
                    'description' => 'required', 
                    'typecontrat_id' => 'required',
                    'diplome_id' => 'required',
                    'metier_id' => 'required',
                    'datefin' => 'required',
                    'nombreposte' => 'required|numeric',
                ];
                
                $customMessages = [
                    'titre.required' => 'Le titre est obligatoire',
                    'description.required' => 'La description est obligatoire',
                    'typecontrat_id.required' => 'Le type de contrat est obligatoire',
                    'diplome_id.required' => 'Le diplôme est obligatoire',
                    'metier_id.required' => 'Le métier est obligatoire',
                    'nombreposte.required' => 'Le nombre de poste est obligatoire',
                    'nombreposte.numeric' => 'Le nombre de poste est en numérique',
                    'datefin.required' => 'La date de clôture est obligatoire',
                ];
                
                $this->validate($request,$rules,$customMessages);

                $offre = new Offre();

                $offre->user_id                  = 1;
                $offre->suivipar_id              = Auth::user()->id;
                $offre->metier_id                = $request->metier_id;
                $offre->typecontrat_id           = $request->typecontrat_id;
                $offre->diplome_id               = $request->diplome_id;
                $offre->offretitre               = html_entity_decode($request->titre);
                $offre->offredescription         = htmlspecialchars($request->description);
                $offre->offrenombreposte         = htmlspecialchars($request->nombreposte);
                $offre->offre_anneeexperience    = html_entity_decode($request->annexperience);
                $offre->offre_mission            = htmlspecialchars($request->mission);
                $offre->offre_profil             = htmlspecialchars($request->profil);
                $offre->offre_dossier            = htmlspecialchars($request->dossier);
                $offre->offre_datefin            = htmlspecialchars($request->datefin);
                $offre->offre_datecrea           = gmdate('Y-m-d H:i:s');
                $offre->offre_origine            = "Locale";
                $offre->offre_statut             = "BROUILLON";
                $offre->save();

                foreach($regions as $region){

                    $offre_region = new OffreRegion();

                    $offre_region->offre_id                  = $offre->offre_id;
                    $offre_region->region_id                 = $region;
                    $offre_region->offre_region_datecreation = gmdate('Y-m-d H:i:s');
                    $offre_region->save();

                }

                return back()->with('info_succes','Offre publiée avec succès !');

            }else{
                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page !!!");
        }    
    }

    // Formulaire de publication d'offre pour employeur
    public function EmployeurPublierOffreEmploi(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_OFF")){
                $typecontrat = TypeContrat::orderby('typecontratlib','ASC')->get();

                $metiers = Metier::orderby('metier_libelle','ASC')->get();

                $diplomes = Diplome::orderby('diplomelib','ASC')->get();

                $regions = Region::orderby('region_nom','ASC')->get();

                $employeurs = User::where(['profil_id'=>2, 'user_statut'=>"VALIDE"])->orderby('raisonsociale','ASC')->get();

                return view('admin.offre.offreemployeur',['employeurs'=>$employeurs,'typecontrat'=>$typecontrat, 'regions'=>$regions, 'metiers'=>$metiers, 'diplomes'=>$diplomes]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Save publier offre pour employeur
    public function EmployeurSavePublierOffreEmploi(Request $request){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_OFF")){
                
                $regions = array_filter($request->region_ids);

                $rules = [
                    'titre' => 'required',
                    'description' => 'required', 
                    'user_id' => 'required',
                    'typecontrat_id' => 'required',
                    'diplome_id' => 'required',
                    'metier_id' => 'required',
                    'datefin' => 'required',
                    'nombreposte' => 'required|numeric',
                ];
                
                $customMessages = [
                    'titre.required' => 'Le titre est obligatoire',
                    'description.required' => 'La description est obligatoire',
                    'typecontrat_id.required' => 'Le type de contrat est obligatoire',
                    'diplome_id.required' => 'Le diplôme est obligatoire',
                    'metier_id.required' => 'Le métier est obligatoire',
                    'user_id.required' => 'L\'employeur est obligatoire',
                    'nombreposte.required' => 'Le nombre de poste est obligatoire',
                    'nombreposte.numeric' => 'Le nombre de poste est en numérique',
                    'datefin.required' => 'La date de fin est obligatoire',
                ];

                if($request->soumission == "PAR MAIL"){
                    $rules = [
                        'liensoumission' => 'required|email',
                    ];
                    
                    $customMessages = [
                        'liensoumission.required' => 'Le mail de soumission est obligatoire',
                        'liensoumission.email' => 'Le mail de soumission n\'est pas valide',
                    ];
                }
                if($request->soumission == "LIEN SITE WEB"){
                    $rules = [
                        'liensoumission' => 'required|url',
                    ];
                    
                    $customMessages = [
                        'liensoumission.required' => 'Le lien de soumission est obligatoire',
                        'liensoumission.url' => 'Le lien de soumission n\'est pas valide',
                    ];
                }
            
                $this->validate($request,$rules,$customMessages);

                $offre = new Offre();

                $offre->user_id                  = $request->user_id;
                $offre->suivipar_id              = Auth::user()->id;
                $offre->metier_id                = $request->metier_id;
                $offre->typecontrat_id           = $request->typecontrat_id;
                $offre->diplome_id               = $request->diplome_id;
                $offre->offretitre               = html_entity_decode($request->titre);
                $offre->offredescription         = htmlspecialchars($request->description);
                $offre->offrenombreposte         = htmlspecialchars($request->nombreposte);
                $offre->offre_anneeexperience    = html_entity_decode($request->annexperience);
                $offre->offre_mission            = htmlspecialchars($request->mission);
                $offre->offre_profil             = htmlspecialchars($request->profil);
                $offre->offre_dossier            = htmlspecialchars($request->dossier);
                $offre->offre_datefin            = htmlspecialchars($request->datefin);
                $offre->offre_soumission         = htmlspecialchars($request->soumission);
                $offre->offre_liensoumission     = htmlspecialchars($request->liensoumission);
                $offre->offre_datecrea           = gmdate('Y-m-d H:i:s');
                $offre->offre_statut             = "BROUILLON";
                $offre->offre_origine            = "Locale";
                $offre->save();

                foreach($regions as $region){

                    $offre_region = new OffreRegion();

                    $offre_region->offre_id                  = $offre->offre_id;
                    $offre_region->region_id                 = $region;
                    $offre_region->offre_region_datecreation = gmdate('Y-m-d H:i:s');
                    $offre_region->save();

                }

                return back()->with('info_succes','Offre publié avec succès !');

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page !!!");
        }    
    }

    // Formulaire de publication d'offre
    public function ModifierOffreEmploi($offre_id){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            $offre = Offre::find($offre_id);

            if($offre){

                $regions = Region::orderby('region_nom','ASC')->get();

                $typecontrat = TypeContrat::orderby('typecontratlib','ASC')->get();

                $metiers = Metier::orderby('metier_libelle','ASC')->get();

                $diplomes = Diplome::orderby('diplomelib','ASC')->get();

                $employeurs = User::where(['profil_id'=>2, 'user_statut'=>"VALIDE"])
                                    ->orderby('raisonsociale','ASC')
                                    ->get();

                $anpe = User::where(['profil_id'=>1])->first();

                return view('admin.offre.modifieroffre',['offre'=>$offre, 'anpe'=>$anpe, 'employeurs'=>$employeurs, 'regions'=>$regions,'typecontrat'=>$typecontrat, 'metiers'=>$metiers, 'diplomes'=>$diplomes]);
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Save modifier offre
    public function SaveModifierPublierOffreEmploi(Request $request, $offre_id){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            $offre = Offre::find($offre_id);
            
            if($offre){

                $regions = array_filter($request->region_ids);
                
                $rules = [
                    'titre' => 'required',
                    'description' => 'required',
                    'typecontrat_id' => 'required',
                    'diplome_id' => 'required',
                    'metier_id' => 'required',
                    'datefin' => 'required',
                    'nombreposte' => 'required|numeric',
                ];
                
                $customMessages = [
                    'titre.required' => 'Le titre est obligatoire',
                    'description.required' => 'La description est obligatoire',
                    'typecontrat_id.required' => 'Le type de contrat est obligatoire',
                    'diplome_id.required' => 'Le diplôme est obligatoire',
                    'metier_id.required' => 'Le métier est obligatoire',
                    'nombreposte.required' => 'Le nombre de poste est obligatoire',
                    'nombreposte.numeric' => 'Le nombre de poste est en numérique',
                    'datefin.required' => 'La date de fin est obligatoire',
                ];
                
                if($request->soumission == "PAR MAIL"){
                    $rules = [
                        'liensoumission' => 'required|email',
                    ];
                    
                    $customMessages = [
                        'liensoumission.required' => 'Le mail de soumission est obligatoire',
                        'liensoumission.email' => 'Le mail de soumission n\'est pas valide',
                    ];
                }
                if($request->soumission == "LIEN SITE WEB"){
                    $rules = [
                        'liensoumission' => 'required|url',
                    ];
                    
                    $customMessages = [
                        'liensoumission.required' => 'Le lien de soumission est obligatoire',
                        'liensoumission.url' => 'Le lien de soumission n\'est pas valide',
                    ];
                }

                $this->validate($request,$rules,$customMessages);

                $offre->metier_id                = $request->metier_id;
                $offre->typecontrat_id           = $request->typecontrat_id;
                $offre->diplome_id               = $request->diplome_id;
                $offre->offretitre               = html_entity_decode($request->titre);
                $offre->offredescription         = htmlspecialchars($request->description);
                $offre->offrenombreposte         = htmlspecialchars($request->nombreposte);
                $offre->offre_anneeexperience    = html_entity_decode($request->annexperience);
                $offre->offre_mission            = htmlspecialchars($request->mission);
                $offre->offre_profil             = htmlspecialchars($request->profil);
                $offre->offre_dossier            = htmlspecialchars($request->dossier);
                $offre->offre_datefin            = htmlspecialchars($request->datefin);
                if($request->user_id != 1){
                    $offre->user_id              = $request->user_id;
                    $offre->offre_soumission     = htmlspecialchars($request->soumission);
                    $offre->offre_liensoumission = htmlspecialchars($request->liensoumission);
                }
                $offre->exists                   = true;
                $offre->update();

                $offreregion = OffreRegion::where(['offre_id'=>$offre->offre_id])->get();

                foreach($offreregion as $region){

                    $region->delete();
                }

                foreach($regions as $region){

                    $offre_region = new OffreRegion();
                    
                    $offre_region->offre_id                  = $offre->offre_id;
                    $offre_region->region_id                 = $region;
                    $offre_region->offre_region_datecreation = gmdate('Y-m-d H:i:s');
                    $offre_region->save();

                } 

                return redirect()->route('admin.valider.offre')->with('info_succes','Offre modifiée mis à jour avec succès !');

            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }    
    }

    // Save relancer offre à une date de clôture
    public function RelancerOfre(Request $request, $offre_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            $offre = Offre::find($offre_id);
            
            if($offre){

                $offre->offre_datefin = htmlspecialchars($request->datefin);
                $offre->exists = true;
                $offre->update();

                //Récupérer les candidats qui on le profil de l'offre
                $candidats = User::where(['users.profil_id'=>3])
                                ->where('users.diplome_id','>=',$offre->diplome_id)
                                ->where('users.metier_id','=',$offre->metier_id)
                                ->get();

                //Récupérer les abonnées à la newsletter
                $newsletters = NewsLetter::get();

                //Envoie de mail à la newsletter
                foreach($newsletters as $newsletter){
                    $email_data = array(
                        'email' => $newsletter->email,
                        'offre' => $offre->offretitre,
                    );

                    // Envoie des paramètres du mail au client
                    Mail::send('emails.newsalerte', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'])
                        ->subject("Vous avez une nouvelle offre d'emploi")
                        ->from('info@anpe-niger.ne', 'ANPE');
                    });
                }

                //Envoie de mail à la liste des demandeurs d'emploi
                foreach($candidats as $candidat){
                    $email_data = array(
                        'nom' => $candidat->name,
                        'prenoms' => $candidat->prenoms,
                        'email' => $candidat->email,
                        'offre' => $offre->offretitre,
                    );

                    // Envoie des paramètres du mail au client
                    Mail::send('emails.alerte', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'])
                        ->subject("Vous avez une nouvelle offre d'emploi")
                        ->from('info@anpe-niger.ne', 'ANPE');
                    });
                }

                return back()->with('info_succes',"Offre relancée avec succès !");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }
    }

    // Détails de l'offre 
    public function DetailsdeOffre($offre_id){

        $offre = Offre::find($offre_id);
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if($offre){

                $user = User::where(['users.id'=>$offre->user_id])->first();

                $candidatures = Candidature::join('users','users.id','candidature.user_id')
                                            ->where(['candidature.offre_id'=>$offre->offre_id])
                                            ->get();

                return view('admin.offre.details',['offre'=>$offre, 'user'=>$user, 'candidatures'=>$candidatures]);

            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Détails de l'offre à valider
    public function DetailsOffreaValider($offre_id){

        $offre = Offre::find($offre_id);
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if($offre){

                $user = User::where(['users.id'=>$offre->user_id])->first();

                return view('admin.offre.detailsavalider',['offre'=>$offre, 'user'=>$user]);

            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    // Supprimer offre
    public function SupprimerAdminOffre($offre_id){

        $offre = Offre::find($offre_id);
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if($offre){

                $offre->delete();

                return back()->with('info_succes','Offre supprimée avec succès !');
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }
    }

    // Exporter les offres d'emploi en PDF
    public function ExportOffrePDF(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {

            $date_jours = gmdate("Y-m-d");
            
            $data = Session::get('recherche_offre');

            $query = Offre::join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where('offre.offre_datefin','>=',$date_jours)
                            ->where(['offre.offre_statut'=>"PUBLIE"])
                            ->orderby('offre.offre_id','DESC');

            if (isset($data['metier'])) {
                $query->where('offre.metier_id', '=', $data['metier']);
            }

            if (isset($data['diplome'])) {
                $query->where('offre.diplome_id', '=', $data['diplome']);
            }

            if (isset($data['contrat'])) {
                $query->where('offre.typecontrat_id', '=', $data['contrat']);
            }

            $offres = $query->get();
            
            //dd($offres);
            if($offres->count() > 0){
                $html = View::make('admin.exportation.offres', compact('offres'))->render();

                $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->setPaper('A4', 'landscape');
                $dompdf->render();

                return $dompdf->stream("offres.pdf");

            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");
        }
    }

    // Exporter les offres d'emploi en Excel
    public function ExportOffreExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {
            
            $date_jours = gmdate("Y-m-d");

            $data = Session::get('recherche_offre');

            $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                            ->join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')       
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where('offre.offre_datefin','>=',$date_jours)
                            ->where(['offre.offre_statut'=>"PUBLIE"])
                            ->orderby('offre.offre_id','DESC');

            if (isset($data['metier'])) {
                $query->where('offre.metier_id', '=', $data['metier']);
            }

            if (isset($data['diplome'])) {
                $query->where('offre.diplome_id', '=', $data['diplome']);
            }

            if (isset($data['contrat'])) {
                $query->where('offre.typecontrat_id', '=', $data['contrat']);
            }

            $offres = $query->get();

            //dd($offres);
            if($offres->count() > 0){ 
                return Excel::download(new OffreExport($offres), 'offres.xlsx');
            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");

        } 
    }

    // Exporter les offres d'emploi expirée en PDF
    public function ExportOffreExpireePDF(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {

            $date_jours = gmdate("Y-m-d");
            
            $data = Session::get('recherche_offre');

            $query = Offre::join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where('offre.offre_datefin','<',$date_jours)
                            ->where(['offre.offre_statut'=>"PUBLIE"])
                            ->orderby('offre.offre_id','DESC');

            if (isset($data['metier'])) {
                $query->where('offre.metier_id', '=', $data['metier']);
            }

            if (isset($data['diplome'])) {
                $query->where('offre.diplome_id', '=', $data['diplome']);
            }

            if (isset($data['contrat'])) {
                $query->where('offre.typecontrat_id', '=', $data['contrat']);
            }

            $offres = $query->get();
            
            //dd($offres);
            if($offres->count() > 0){
                $html = View::make('admin.exportation.offresexpirees', compact('offres'))->render();

                $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->setPaper('A4', 'landscape');
                $dompdf->render();

                return $dompdf->stream("offresexpirees.pdf");

            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");
        }
    }

    // Exporter les offres d'emploi expirée en Excel
    public function ExportOffreExpireeExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {
            
            $date_jours = gmdate("Y-m-d");

            $data = Session::get('recherche_offre');

            $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                            ->join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where('offre.offre_datefin','<',$date_jours)
                            ->where(['offre.offre_statut'=>"PUBLIE"])
                            ->orderby('offre.offre_id','DESC');

            if (isset($data['metier'])) {
                $query->where('offre.metier_id', '=', $data['metier']);
            }

            if (isset($data['diplome'])) {
                $query->where('offre.diplome_id', '=', $data['diplome']);
            }

            if (isset($data['contrat'])) {
                $query->where('offre.typecontrat_id', '=', $data['contrat']);
            }

            $offres = $query->get();

            //dd($offres);
            if($offres->count() > 0){ 
                return Excel::download(new OffreExport($offres), 'offresexpirees.xlsx');
            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");

        } 
    }

    // Exporter les offres d'emploi à valider en PDF
    public function ExportOffreaValiderPDF(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {

            $date_jours = gmdate("Y-m-d");
            
            $data = Session::get('recherche_offre');

            $query = Offre::join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where('offre.offre_datefin','>=',$date_jours)
                            ->where(['offre.offre_statut'=>"BROUILLON"])
                            ->orderby('offre.offre_id','DESC');

            if (isset($data['metier'])) {
                $query->where('offre.metier_id', '=', $data['metier']);
            }

            if (isset($data['diplome'])) {
                $query->where('offre.diplome_id', '=', $data['diplome']);
            }

            if (isset($data['contrat'])) {
                $query->where('offre.typecontrat_id', '=', $data['contrat']);
            }

            $offres = $query->get();
            
            //dd($offres);
            if($offres->count() > 0){
                $html = View::make('admin.exportation.offresavlider', compact('offres'))->render();

                $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->setPaper('A4', 'landscape');
                $dompdf->render();

                return $dompdf->stream("offresavlider.pdf");

            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");
        }
    }

    // Exporter les offres d'emploi à valider en Excel
    public function ExportOffreaValiderExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {
            
            $date_jours = gmdate("Y-m-d");

            $data = Session::get('recherche_offre');

            $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib','offre_statut','offre_datefin')
                            ->join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where('offre.offre_datefin','>=',$date_jours)
                            ->where(['offre.offre_statut'=>"BROUILLON"])
                            ->orderby('offre.offre_id','DESC');


            if (isset($data['metier'])) {
                $query->where('offre.metier_id', '=', $data['metier']);
            }

            if (isset($data['diplome'])) {
                $query->where('offre.diplome_id', '=', $data['diplome']);
            }

            if (isset($data['contrat'])) {
                $query->where('offre.typecontrat_id', '=', $data['contrat']);
            }

            $offres = $query->get();

            //dd($offres);
            if($offres->count() > 0){ 
                return Excel::download(new OffreExport($offres), 'offresavalider.xlsx');
            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");

        } 
    }

    //***** GESTION DES LIENS SUR LES DEMANDEURS D'EMPLOI ******//

    //Liste des demandeurs
    public function ListeDemandeurEmploi(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP")){
                
                $url = $request->root();

                $trancheage = $request->a;
                $genre      = $request->g;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($trancheage)){
                    $whereRaw.= " AND trancheage_id = $trancheage ";
                }
                if(!empty($genre)){
                    $whereRaw.= ' AND genre LIKE "%'.$genre.'%"';
                }
                if(!empty($situation)){
                    $whereRaw.= ' AND situationmatrimoniale LIKE "%'.$situation.'%"';
                }

                $demandeurs = User::where(['profil_id' => 3, 'user_carte_statut'=>"VALIDE", 'user_statut'=>"VALIDE"])
                                    ->join('pays','pays.pays_id','users.pays_id')
                                    ->whereRaw($whereRaw)
                                    ->orderBy('users.id', 'DESC')
                                    ->get();

                // Stocker les données de recherche en session
                Session::put('recherche_data', [
                    'trancheage' => $trancheage,
                    'genre' => $genre,
                    'situation' => $situation,
                ]);

                
                $trancheages = TrancheAge::get();            

                return view('admin.demandeur.listedemandeur',['demandeurs'=>$demandeurs, 'trancheages'=>$trancheages, 'trancheage_select'=>$trancheage, 'genre_select'=>$genre, 'situation_select'=>$situation, 'url'=>$url]);
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Liste des demandeurs sans carte à valider
    public function ListeDemandeuraValider(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")){

    			$nom        = $request->n;
                $telephone  = $request->t;
                $trancheage = $request->a;
                $genre      = $request->g;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($nom)){
                    $whereRaw.= ' AND name LIKE "%'.$nom.'%"';
                }
                if(!empty($telephone)){
                    $whereRaw.= ' AND telephone LIKE "%'.$telephone.'%"';
                }
                if(!empty($trancheage)){
                    $whereRaw.= " AND trancheage_id = $trancheage ";
                }
                if(!empty($genre)){
                    $whereRaw.= ' AND genre LIKE "%'.$genre.'%"';
                }
                if(!empty($situation)){
                    $whereRaw.= ' AND situationmatrimoniale LIKE "%'.$situation.'%"';
                }

                $demandeurs = User::where(['profil_id' => 3])
                                  ->where(function($query) {
                                      $query->where('user_statut', '<>', 'VALIDE')
                                            ->orWhere('user_carte_statut', '<>', 'VALIDE');
                                  })
                                  ->whereRaw($whereRaw)
                                  ->orderBy('users.id', 'DESC')
                                  ->get();
                
    			$trancheages = TrancheAge::get();

                // Stocker les données de recherche en session
                Session::put('recherche_data', [
                    'trancheage' => $trancheage,
                    'genre' => $genre,
                    'situation' => $situation,
                ]);            

                return view('admin.demandeur.listedemandeuravalider',['demandeurs'=>$demandeurs, 'trancheages'=>$trancheages, 'nom_select'=>$nom, 'telephone_select'=>$telephone, 'trancheage_select'=>$trancheage, 'genre_select'=>$genre, 'situation_select'=>$situation]);
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Formualire de compte demandeur d'emploi
    public function CreerCompteDemandeurEmploi(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_DEMP")){
                
                $paysliste = Pays::where(['pays_statut'=>"VALIDE"])->orderby('nom_fr','ASC')->get();

                $regions = Region::where(['region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();

                $region_agent = Region::where(['region.region_id'=>Auth::user()->region_id, 'region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();

                $trancheages = TrancheAge::where(['trancheage_statut'=>"VALIDE"])->get();

                $filieres = Metier::where(['metier_statut'=>"VALIDE"])->get();

                $langueinter = LangueInternationale::where(['langueinter_statut'=>"VALIDE"])->get();

                $categories = CategorieProfessionelle::where(['catepro_statut'=>"VALIDE"])->orderby('catepro_lib','ASC')->get();

                $niveaux = NiveauInstruction::where(['niveauinstruction_statut'=>"VALIDE"])->orderby('niveau_lib','ASC')->get();

                $typedemandeur = TypeDemandeur::where(['situation_statut'=>"VALIDE"])->orderby('situation_lib','ASC')->get();

                $diplomes = Diplome::where(['diplome_statut'=>"VALIDE"])->get();

                $languelocale = LangueLocale::where(['languelocal_statut'=>"VALIDE"])->get();
                
                $typeinscriptions = TypeInscription::where(['typeinscription_statut'=>"VALIDE"])->orderby('typeinscription_lib','ASC')->get();

                $datesources = Carbon::now()->subYears(18);

                return view('admin.demandeur.creercompte', ['paysliste'=>$paysliste, 'regions'=>$regions, 'region_agent'=>$region_agent, 'filieres'=>$filieres, 'typeinscriptions'=>$typeinscriptions, 'trancheages'=>$trancheages, 'langueinter'=>$langueinter, 'languelocale'=>$languelocale, 'diplomes'=>$diplomes, 'categories'=>$categories, 'niveaux'=>$niveaux, 'typedemandeur'=>$typedemandeur, 'datesources'=>$datesources]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Save création de compte demandeur d'emploi
    public function SaveCreerCompteDemandeurEmploi(Request $request){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_DEMP")){

                $rules = [
                    'password' => ['required', 'string', 'min:6', 'confirmed'],
                    'user_profil' => 'mimes:png,jpg,jpeg',                      
                    'niveau_id' => ['required'],
                    'languelocal_id' => ['required'],
                    'emploisouhaite' => ['required'],
                    'situation_id' => ['required'],
                    'catepro_id' => ['required'],
                    'diplome_id' => ['required'],
                    'metier_id' => ['required'],
                    'experience' => ['required'],
                    'region_id' => ['required'],
                    'pays_id' => ['required'],
                    'nombreenfant' => ['required'],
                    'handicap' => ['required'],
                    'stituationmatrimoniale' => ['required'],
                    'email'=>'required|email|unique:users,email',
                    'genre' => ['required'],
                    'telephone' => ['required'],
                    'lieunaissance' => ['required'],
                    'datenaissance' => ['required'],
                    'prenoms' => ['required'],
                    'nom' => ['required'],
                ];
                
                $customMessages = [
                    'email.unique' => "Cet adresse email est déjà utilisé",
                    'email.email' => "L'adresse email n'est pas valide",
                    'email.required' => "L'adresse email est obligatoire",
                    'experience.required' => "L'année d'expérience est obligatoire",
                    'password.min' => "Le mot de passe doit être moins 6 caractères",
                    'password.required' => "Le mot de passe est obligatoire",
                    'password.confirmed' => "La confirmation du mot de passe n'est conforme au mot de passe est obligatoire",
                    'user_profil.mimes' => "La photo choisie n'est pas valide il doit être de type png,jpg,jpeg",
                    'languelocal_id.required' => "Langue LangueInternationale est obligatoire",
                    'emploisouhaite.required' => "L'emploi souhaité est obligatoire",
                    'situation_id.required' => "Le type de demandeur est obligatoire",
                    'niveau_id.required' => "Le niveau d'insctruction est obligatoire",
                    'catepro_id.required' => "La catégorie professionelle est obligatoire",
                    'diplome_id.required' => "diplôme est obligatoire",
                    'metier_id.required' => "La filière est obligatoire",
                    'pays_id.required' => "La nationalité est obligatoire",
                    'region_id.required' => "La région est obligatoire",
                    'nombreenfant.required' => "Le nombre d'enfant est obligatoire",
                    'handicap.required' => "La réponse à la question de l'handicap est obligatoire",
                    'stituationmatrimoniale.required' => "La stituation matrimoniale est obligatoire",
                    'genre.required' => "Le genre est obligatoire",
                    'telephone.required' => "Le numéro de téléphone est obligatoire",
                    'lieunaissance.required' => "Le lieu de naissance est obligatoire",
                    'datenaissance.required' => "La date de naissance est obligatoire",
                    'prenoms.required' => "Le prénoms est obligatoire",
                    'nom.required' => "Le nom est obligatoire",
                ];
                
                $pays = Pays::where(['pays_id'=>$request->pays_id])->first();

                if($pays->pays_id == 127){
                    $rules = [                   
                        'pieceidentite' => 'mimes:png,jpg,jpeg,pdf', 
                    ];    
                    $customMessages = [
                        'pieceidentite.mimes' => "La pièce d'identité n'est pas valide il doit être de type png, jpg, jpeg, pdf",
                    ];
                }else{
                    $rules = [                   
                        'pieceetranger' => 'mimes:png,jpg,jpeg,pdf', 
                    ];    
                    $customMessages = [
                        'pieceetranger.mimes' => "La pièce étrangère n'est pas valide il doit être de type png, jpg, jpeg, pdf",
                    ];
                }
                if(User::where('email', $request->email)->exists()) {
            
                    $rules = [                   
                        'email' => 'unique:users', 
                    ];    
                    $customMessages = [
                        'email.unique' => "Cet adresse email est déjà utilisé",
                    ];
                }

                if(User::where('telephone', $request->telephone)->exists()) {
            
                    $rules = [                   
                        'telephone' => 'unique:users', 
                    ];    
                    $customMessages = [
                        'telephone.unique' => "Cet numéro de téléphone est déjà utilisé",
                    ];
                }

                $this->validate($request,$rules,$customMessages);

                $url = $request->root();
                
                $user = new User();

                // Upload CNI / Passport / Nationalité / Permis de séjours / Ressortissant CEDEAO / CV
                if($request->hasFile('user_profil'))
                {
                    $file = $request->file('user_profil');
                    $extension = $file->getClientOriginalExtension();
                    $filephoto = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/', $filephoto);
                    $user->profil_photo = $filephoto;
                }

                if($request->hasFile('pieceidentite'))
                {
                    $file = $request->file('pieceidentite');
                    $extension = $file->getClientOriginalExtension();
                    $filecni = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/documents/', $filecni);
                    $user->user_cni = $filecni;
                }

                if($request->hasFile('pieceetranger'))
                {
                    $file = $request->file('pieceetranger');
                    $extension = $file->getClientOriginalExtension();
                    $fileentranger = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/documents/', $fileentranger);
                    $user->user_dpc = $fileentranger;
                }

                $dateNaissance = \Carbon\Carbon::createFromFormat('Y-m-d', $request->datenaissance);
                $dateJours = \Carbon\Carbon::createFromFormat('Y-m-d', gmdate('Y-m-d'));
                $anneeNaissance = $dateNaissance->year;
                $anneeJours = $dateJours->year;
                $age = $anneeJours - $anneeNaissance;

                $trancheage = DB::table('trancheage')
                                ->where('trancheage_deb', '<=', $age)
                                ->where('trancheage_fin', '>=', $age)
                                ->first();

                $user->profil_id               = 3;;
                $user->creerpar_id             = Auth::user()->id;
                $user->metier_id               = $request->metier_id;
                $user->diplome_id              = $request->diplome_id;
                $user->catepro_id              = $request->catepro_id;
                $user->niveau_id               = $request->niveau_id;
                $user->situation_id            = $request->situation_id;
                $user->languelocal_id          = $request->languelocal_id;
                $user->langueinter_id          = $request->langueinter_id;
                $user->typeinscription_id      = $request->typeinscription_id;
                $user->trancheage_id           = $trancheage->trancheage_id;
                $user->region_id               = $request->region_id;
                $user->pays_id                 = $request->pays_id;
                $user->nombreenfant            = htmlspecialchars($request->nombreenfant);
                $user->handicap                = htmlspecialchars($request->handicap);
                $user->situationmatrimoniale   = htmlspecialchars($request->stituationmatrimoniale);
                $user->telephone               = htmlspecialchars($request->telephone);
                $user->email                   = htmlspecialchars($request->email);
                $user->genre                   = htmlspecialchars($request->genre);
                $user->lieunaissance           = Str::upper(Str::ascii($request->lieunaissance));
                $user->datenaissance           = htmlspecialchars($request->datenaissance);
                $user->prenoms                 = Str::upper(Str::ascii($request->prenoms));
                $user->name                    = Str::upper(Str::ascii($request->nom));
                $user->departement             = Str::upper(Str::ascii($request->departement));
                $user->commune                 = Str::upper(Str::ascii($request->commune));
                $user->village_quart           = Str::upper(Str::ascii($request->village_quart));
                $user->type_handicap           = Str::upper(Str::ascii($request->type_handicap));
                $user->new_diplome             = Str::upper(Str::ascii($request->new_diplome));
                $user->new_metier              = Str::upper(Str::ascii($request->new_metier));
                $user->new_languelocal         = Str::upper(Str::ascii($request->new_languelocal));
                $user->new_langueinter         = Str::upper(Str::ascii($request->new_langueinter));
                $user->emploisouhaite          = htmlspecialchars($request->emploisouhaite, ENT_QUOTES, 'UTF-8');
                $user->experience              = htmlspecialchars($request->experience, ENT_QUOTES, 'UTF-8');
                $user->password                = Hash::make($request->password);
                $user->user_origine            = "Locale";
                $user->user_statut             = "BROUILLON";
                $user->created_at              = gmdate('Y-m-d H:i:s');
                $user->save();

                $email_data = array(
                    'nom' => $request->nom,
                    'prenoms' => $request->prenoms,
                    'email' => $request->email,
                    'motdepasse' => $request->password,
                    'anneencours'=>gmdate('Y'),
                );

                // Envoie des paramètres du mail au client
                Mail::send('emails.register_cand', $email_data, function ($message) use ($email_data){
                $message->to($email_data['email'])
                    ->subject("Votre inscription à l'ANPE")
                    ->from('info@anpe-niger.ne', 'ANPE');
                });
                
                return back()->with('info_succes',"Compte demandeur d'emploi a bien été créé avec succès.");
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }  

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page.");
        }
    }

    //Modifier un compte demandeur d'emploi
    public function ModifierCompteDemandeurEmploi($id){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_DEMP")){

                $user = User::find($id);

                if($user){

                    $paysliste = Pays::where(['pays_statut'=>"VALIDE"])->orderby('nom_fr','ASC')->get();

                    $regions = Region::where(['region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();

                    $region_agent = Region::where(['region.region_id'=>Auth::user()->region_id, 'region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();

                    $trancheages = TrancheAge::where(['trancheage_statut'=>"VALIDE"])->get();

                    $filieres = Metier::where(['metier_statut'=>"VALIDE"])->get();

                    $langueinter = LangueInternationale::where(['langueinter_statut'=>"VALIDE"])->get();

                    $categories = CategorieProfessionelle::where(['catepro_statut'=>"VALIDE"])->orderby('catepro_lib','ASC')->get();

                    $niveaux = NiveauInstruction::where(['niveauinstruction_statut'=>"VALIDE"])->orderby('niveau_lib','ASC')->get();

                    $typedemandeur = TypeDemandeur::where(['situation_statut'=>"VALIDE"])->orderby('situation_lib','ASC')->get();

                    $diplomes = Diplome::where(['diplome_statut'=>"VALIDE"])->get();

                    $languelocale = LangueLocale::where(['languelocal_statut'=>"VALIDE"])->get();
                    
                    $typeinscriptions = TypeInscription::where(['typeinscription_statut'=>"VALIDE"])->orderby('typeinscription_lib','ASC')->get();

                    $datesources = Carbon::now()->subYears(18);

                    return view('admin.demandeur.modifier', ['user'=>$user, 'paysliste'=>$paysliste, 'regions'=>$regions, 'region_agent'=>$region_agent, 'filieres'=>$filieres, 'typeinscriptions'=>$typeinscriptions, 'trancheages'=>$trancheages, 'langueinter'=>$langueinter, 'languelocale'=>$languelocale, 'diplomes'=>$diplomes, 'categories'=>$categories, 'niveaux'=>$niveaux, 'typedemandeur'=>$typedemandeur, 'datesources'=>$datesources]);
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Save création de compte demandeur d'emploi
    public function SaveModifierCompteDemandeurEmploi(Request $request, $id){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_DEMP")){
            $user = User::find($id);
            
            if($user){

                $rules = [                     
                    'niveau_id' => ['required'],
                    'languelocal_id' => ['required'],
                    'emploisouhaite' => ['required'],
                    'situation_id' => ['required'],
                    'catepro_id' => ['required'],
                    'diplome_id' => ['required'],
                    'metier_id' => ['required'],
                    'experience' => ['required'],
                    'region_id' => ['required'],
                    'pays_id' => ['required'],
                    'nombreenfant' => ['required'],
                    'handicap' => ['required'],
                    'stituationmatrimoniale' => ['required'],
                    'genre' => ['required'],
                    'telephone' => ['required'],
                    'lieunaissance' => ['required'],
                    'datenaissance' => ['required'],
                    'prenoms' => ['required'],
                    'nom' => ['required'],
                ];
                
                $customMessages = [
                    'experience.required' => "L'année d'expérience est obligatoire",
                    'languelocal_id.required' => "Langue LangueInternationale est obligatoire",
                    'emploisouhaite.required' => "L'emploi souhaité est obligatoire",
                    'situation_id.required' => "Le type de demandeur est obligatoire",
                    'niveau_id.required' => "Le niveau d'insctruction est obligatoire",
                    'catepro_id.required' => "La catégorie professionelle est obligatoire",
                    'diplome_id.required' => "diplôme est obligatoire",
                    'metier_id.required' => "La filière est obligatoire",
                    'pays_id.required' => "La nationalité est obligatoire",
                    'region_id.required' => "La région est obligatoire",
                    'nombreenfant.required' => "Le nombre d'enfant est obligatoire",
                    'handicap.required' => "La réponse à la question de l'handicap est obligatoire",
                    'stituationmatrimoniale.required' => "La stituation matrimoniale est obligatoire",
                    'genre.required' => "Le genre est obligatoire",
                    'telephone.required' => "Le numéro de téléphone est obligatoire",
                    'lieunaissance.required' => "Le lieu de naissance est obligatoire",
                    'datenaissance.required' => "La date de naissance est obligatoire",
                    'prenoms.required' => "Le prénoms est obligatoire",
                    'nom.required' => "Le nom est obligatoire",
                ];
                
                $pays = Pays::where(['pays_id'=>$request->pays_id])->first();
                if($pays->pays_id == 127){
                    $rules = [                   
                        'pieceidentite' => 'mimes:png,jpg,jpeg,pdf', 
                    ];    
                    $customMessages = [
                        'pieceidentite.mimes' => "La pièce d'identité n'est pas valide il doit être de type png, jpg, jpeg, pdf",
                    ];
                }else{
                    $rules = [                   
                        'pieceetranger' => 'mimes:png,jpg,jpeg,pdf', 
                    ];    
                    $customMessages = [
                        'pieceetranger.mimes' => "La pièce étrangère n'est pas valide il doit être de type png, jpg, jpeg, pdf",
                    ];
                }

                $this->validate($request,$rules,$customMessages);

                // Upload CNI / Passport / Nationalité / Permis de séjours / Ressortissant CEDEAO / CV
                if($request->hasFile('user_profil'))
                {
                    $file = $request->file('user_profil');
                    $extension = $file->getClientOriginalExtension();
                    $filephoto = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/', $filephoto);
                    $user->profil_photo = $filephoto;
                }

                if($request->hasFile('pieceidentite'))
                {
                    $file = $request->file('pieceidentite');
                    $extension = $file->getClientOriginalExtension();
                    $filecni = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/documents/', $filecni);
                    $user->user_cni = $filecni;
                }

                if($request->hasFile('pieceetranger'))
                {
                    $file = $request->file('pieceetranger');
                    $extension = $file->getClientOriginalExtension();
                    $fileentranger = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/documents/', $fileentranger);
                    $user->user_dpc = $fileentranger;
                }

                $dateNaissance = \Carbon\Carbon::createFromFormat('Y-m-d', $request->datenaissance);
                $dateJours = \Carbon\Carbon::createFromFormat('Y-m-d', gmdate('Y-m-d'));
                $anneeNaissance = $dateNaissance->year;
                $anneeJours = $dateJours->year;
                $age = $anneeJours - $anneeNaissance;

                $trancheage = DB::table('trancheage')
                                ->where('trancheage_deb', '<=', $age)
                                ->where('trancheage_fin', '>=', $age)
                                ->first();

                $user->metier_id               = $request->metier_id;
                $user->diplome_id              = $request->diplome_id;
                $user->catepro_id              = $request->catepro_id;
                $user->niveau_id               = $request->niveau_id;
                $user->situation_id            = $request->situation_id;
                $user->languelocal_id          = $request->languelocal_id;
                $user->langueinter_id          = $request->langueinter_id;
                $user->typeinscription_id      = $request->typeinscription_id;
                $user->trancheage_id           = $trancheage->trancheage_id;
                $user->region_id               = $request->region_id;
                $user->pays_id                 = $request->pays_id;
                $user->nombreenfant            = htmlspecialchars($request->nombreenfant);
                $user->handicap                = htmlspecialchars($request->handicap);
                $user->situationmatrimoniale   = htmlspecialchars($request->stituationmatrimoniale);
                $user->genre                   = htmlspecialchars($request->genre);
                $user->lieunaissance           = Str::upper(Str::ascii($request->lieunaissance));
                $user->datenaissance           = htmlspecialchars($request->datenaissance);
                $user->prenoms                 = Str::upper(Str::ascii($request->prenoms));
                $user->name                    = Str::upper(Str::ascii($request->nom));
                $user->departement             = Str::upper(Str::ascii($request->departement));
                $user->commune                 = Str::upper(Str::ascii($request->commune));
                $user->village_quart           = Str::upper(Str::ascii($request->village_quart));
                $user->type_handicap           = Str::upper(Str::ascii($request->type_handicap));
                $user->new_diplome             = Str::upper(Str::ascii($request->new_diplome));
                $user->new_metier              = Str::upper(Str::ascii($request->new_metier));
                $user->new_languelocal         = Str::upper(Str::ascii($request->new_languelocal));
                $user->new_langueinter         = Str::upper(Str::ascii($request->new_langueinter));
                $user->emploisouhaite          = htmlspecialchars($request->emploisouhaite, ENT_QUOTES, 'UTF-8');
                $user->experience              = htmlspecialchars($request->experience, ENT_QUOTES, 'UTF-8');
                $user->exists                  = true;
                $user->update();
                
                return redirect()->route('admin.demandeur.sanscarte')->with('info_succes',"Compte demandeur d'emploi a bien été mis à jour avec succès."); 
            }

        }else{

            return back()->with('info_warning',"Vous n'avez pas d'accès");
        }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page.");
        }
    }

    //Générer la carte du demandeur d'emploi
    public function GenererCarteDemandeur(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CARTE_DEMP")){

                //Date de d'activité automatique
                $datejour   = gmdate('Y-m-d');

                $demandeur = User::find($id);

                if($demandeur){

                    $url = "http://www.anpe-niger.ne/";

                    $lien_logo = $url."/assets/img/logo-anpe.png";
                    
                    $demandeur_image = $url."/assets/img/profil/".$demandeur->profil_photo;
                    $avatar_femme = $url."/assets/img/profil/femme.png";
                    $avatar_homme = $url."/assets/img/profil/homme.jpg";
                    $nationalite = Pays::where(['pays.pays_id'=>$demandeur->pays_id])->first();
                    $region = Region::where(['region.region_id'=>$demandeur->region_id])->first();

                    //Création de l'identifiant unique du demandeur d'emploi
                    $identifiant = Auth::user()->code_agent.$region->region_id.$demandeur->identifiant;

                    $demandeur->date_validation = $datejour;
                    $demandeur->identifiant = $identifiant;
                    $demandeur->user_validitecarte = date('Y-m-d', strtotime($datejour . ' - 1 day'.' + 1 year'));
                     
                    // L'instance PDF avec la vue
                    $pdf = PDF::loadView('demandeur.carte', compact('demandeur', 'lien_logo', 'demandeur_image', 'nationalite' ,'avatar_femme', 'avatar_homme', 'url'));

                    // Lancement du téléchargement du fichier PDF 
                    $carte_name = time().$demandeur->id.\Str::slug($demandeur->name).".pdf";
                    $pdf->download($carte_name);

                    //pour enregistrer le fichier PDF
                    $pdf->save(public_path("carteanpe/".$carte_name));
                    
                    $data = [
                        'id' => $demandeur->id,
                        'identifiant' => $demandeur->identifiant,
                        'name' => $demandeur->name,
                        'prenoms' => $demandeur->prenoms,
                        'email' => $demandeur->email,
                        'telephone' => $demandeur->telephone
                    ];

                    $demandeur->user_carte_statut = "VALIDE";
                    $demandeur->user_carte = $carte_name;
                    $demandeur->date_ri_ni = gmdate('Y-m-d H:i:s');
                    $demandeur->exists = true;
                    $demandeur->update();
                    
                    //Email data
                    $email_data = array(
                        'nom' => $demandeur['name'],
                        'prenoms' => $demandeur['prenoms'],
                        'lien_carte' => $url."/carteanpe/".$carte_name,
                        'email' => $demandeur['email'],
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.cartevalider', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'] ,$email_data['prenoms'])
                        ->subject("Carte ANPE validé avec succès")
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    return back()->with('info_succes',"La carte ANPE a bien été validée.");
                }
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        } 
    }

    //Générer la carte du demandeur d'emploi
    public function GenererCarteActiverDemandeur(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CARTE_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")){

                //Date de d'activité automatique
                $datejour   = gmdate('Y-m-d');

                $url = $request->root();

                $demandeur = User::find($id);

                if($demandeur){

                    if($request->avis == "Non Favorable"){
                        
                        //Email data
                        $email_data = array(
                            'nom' => $demandeur['name'],
                            'prenoms' => $demandeur['prenoms'],
                            'observation' => $request->observation,
                            'email' => $demandeur['email'],
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        //Envoie des paramètres du mail
                        Mail::send('emails.echecvalidation', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'] ,$email_data['prenoms'])
                            ->subject("Carte ANPE validé avec succès")
                            ->from('info@anpe-niger.ne' ,"ANPE");
                        });

                        return back()->with('info_succes',"information envoyée au demandeur d'emploi avec succès !");

                    }else{

                        if($demandeur->user_carte_statut == "VALIDE"){

                            $demandeur->user_statut = "VALIDE";
                            $demandeur->date_ri_ni = gmdate('Y-m-d H:i:s');
                            $demandeur->exists = true;
                            $demandeur->update();
                            
                            //Email data
                            $email_data = array(
                                'nom' => $demandeur['name'],
                                'prenoms' => $demandeur['prenoms'],
                                'lien_carte' => $url."/carteanpe/".$demandeur->user_carte,
                                'email' => $demandeur['email'],
                                'anneencours'=>gmdate('Y'),
                            );
                            
                            //Envoie des paramètres du mail
                            Mail::send('emails.cartevalider', $email_data, function ($message) use ($email_data){
                            $message->to($email_data['email'] ,$email_data['prenoms'])
                                ->subject("Carte ANPE validé avec succès")
                                ->from('info@anpe-niger.ne' ,"ANPE");
                            });

                            return back()->with('info_succes',"Le compte a bien été validé.");

                        }else{

                            $url = $request->root();

                            $lien_logo = $url."/assets/img/logo-anpe.png";
                            
                            $demandeur_image = $url."/assets/img/profil/".$demandeur->profil_photo;
                            $avatar_femme = $url."/assets/img/profil/femme.png";
                            $avatar_homme = $url."/assets/img/profil/homme.jpg";
                            $nationalite = Pays::where(['pays.pays_id'=>$demandeur->pays_id])->first();
                            $region = Region::where(['region.region_id'=>$demandeur->region_id])->first();

                            //Création de l'identifiant unique du demandeur d'emploi
                            $identifiant = Auth::user()->code_agent.$region->region_id.$demandeur->identifiant;

                            $demandeur->date_validation = $datejour;
                            $demandeur->identifiant = $identifiant;
                            
                            //Attribution d'une date de validité de la carte                            
                            if($demandeur->user_validitecarte < $datejour){
                                $demandeur->user_validitecarte = date('Y-m-d', strtotime($datejour . ' - 1 day'.' + 1 year'));
                            }
                             
                            // L'instance PDF avec la vue
                            $pdf = PDF::loadView('demandeur.carte', compact('demandeur', 'lien_logo', 'demandeur_image', 'nationalite' ,'avatar_femme', 'avatar_homme'));

                            // Lancement du téléchargement du fichier PDF
                            $carte_name = time().$demandeur->id.\Str::slug($demandeur->name).".pdf";
                            $pdf->download($carte_name);

                            //pour enregistrer le fichier PDF
                            $pdf->save(public_path("carteanpe/".$carte_name));
                            
                            $data = [
                                'id' => $demandeur->id,
                                'identifiant' => $demandeur->identifiant,
                                'name' => $demandeur->name,
                                'prenoms' => $demandeur->prenoms,
                                'email' => $demandeur->email,
                                'telephone' => $demandeur->telephone
                            ];

                            $demandeur->user_carte_statut = "VALIDE";
                            $demandeur->user_statut = "VALIDE";
                            $demandeur->user_carte = $carte_name;
                            $demandeur->date_ri_ni = gmdate('Y-m-d H:i:s');
                            $demandeur->exists = true;
                            $demandeur->update();
                            
                            //Email data
                            $email_data = array(
                                'nom' => $demandeur['name'],
                                'prenoms' => $demandeur['prenoms'],
                                'lien_carte' => $url."/carteanpe/".$demandeur->user_carte,
                                'email' => $demandeur['email'],
                                'anneencours'=>gmdate('Y'),
                            );
                            
                            //Envoie des paramètres du mail
                            Mail::send('emails.cartevalider', $email_data, function ($message) use ($email_data){
                            $message->to($email_data['email'] ,$email_data['prenoms'])
                                ->subject("Carte ANPE validé avec succès")
                                ->from('info@anpe-niger.ne' ,"ANPE");
                            });

                            return back()->with('info_succes',"La carte ANPE a bien été validée et le compte validé.");
                        }
                    }
                }
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        } 
    }

    //Suppression du compte du demandeur d'emploi
    public function SupprimerDemandeurEmploi($id){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_DEMP")){
                
                $demandeur = User::find($id);

                if($demandeur){
                    
                    $demandeur->delete();

                    return back()->with('info_succes',"Compte demandeur d'emploi supprimé avec succès !!!");

                }
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Activer le compte du demandeur d'emploi
    public function ActiverCompteDemandeur($id){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")){

                $demandeur = User::find($id);

                if($demandeur){
                    
                    $demandeur->user_statut = "VALIDE";
                    $demandeur->exists      = true;
                    $demandeur->update();

                    //Email data
                    $email_data = array(
                        'nom' => $demandeur->name,
                        'prenoms' => $demandeur->prenoms,
                        'email' => $demandeur->email,
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.activer_cand', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'] ,$email_data['prenoms'])
                        ->subject("Votre compte activé par la direction de l'ANPE")
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    //dd($demandeur);
                    return back()->with('info_succes',"Compte demandeur d'emploi activé avec succès !!!");

                }
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Désactiver le compte du demandeur d'emploi
    public function DesactiverCompteDemandeur($id){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_DEMP")){

                $demandeur = User::find($id);

                if($demandeur){
                    
                    $demandeur->user_statut = "BROUILLON";
                    $demandeur->exists      = true;
                    $demandeur->update();

                    //Email data
                    $email_data = array(
                        'nom' => $demandeur->name,
                        'prenoms' => $demandeur->prenoms,
                        'email' => $demandeur->email,
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.desactiver_cand', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'] ,$email_data['prenoms'])
                        ->subject("Votre compte fermé par la direction de l'ANPE")
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    return back()->with('info_succes',"Compte demandeur d'emploi désactivé avec succès !!!");

                }
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Exporter les demandeur d'emploi en PDF
    public function ExportDemandeurEmploiPDF(Request $request){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {
            
            $data = Session::get('recherche_data');

            $query = User::join('pays', 'pays.pays_id', '=', 'users.pays_id')
                        ->join('niveauinstruction', 'niveauinstruction.niveau_id', '=', 'users.niveau_id')
                        ->join('diplome', 'diplome.diplome_id', '=', 'users.diplome_id')
                        ->join('metier', 'metier.metier_id', '=', 'users.metier_id')
                        ->where('users.profil_id', '=', 3)
                        ->orderBy('users.id', 'DESC');

            if (isset($data['trancheage'])) {
                $query->where('users.trancheage_id', '=', $data['trancheage']);
            }

            if (isset($data['genre'])) {
                $query->where('users.genre', '=', $data['genre']);
            }

            if (isset($data['situation'])) {
                $query->where('users.situationmatrimoniale', '=', $data['situation']);
            }

            $demandeurs = $query->get();

            if($demandeurs->count() > 0){ 
                $html = View::make('admin.exportation.listedemandeur', compact('demandeurs'))->render();

                $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->setPaper('landscape', 'A4');
                $dompdf->render();

                return $dompdf->stream("demandeurs.pdf");

            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");
        }
    }

    //Exporter les demandeur d'emploi en Excel
    public function ExportDemandeurEmploiExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {
            
            $data = Session::get('recherche_data');

            $query = User::select('identifiant','name','prenoms','datenaissance','lieunaissance','genre','nom_fr','niveau_lib','diplomelib','new_diplome','metier_libelle','new_metier','telephone','email')
                        ->join('pays', 'pays.pays_id', '=', 'users.pays_id')
                        ->join('niveauinstruction', 'niveauinstruction.niveau_id', '=', 'users.niveau_id')
                        ->join('diplome', 'diplome.diplome_id', '=', 'users.diplome_id')
                        ->join('metier', 'metier.metier_id', '=', 'users.metier_id')
                        ->where('users.profil_id', '=', 3)
                        ->orderBy('users.id', 'DESC');

            if (isset($data['trancheage'])) {
                $query->where('users.trancheage_id', '=', $data['trancheage']);
            }

            if (isset($data['genre'])) {
                $query->where('users.genre', '=', $data['genre']);
            }

            if (isset($data['situation'])) {
                $query->where('users.situationmatrimoniale', '=', $data['situation']);
            }

            $demandeurs = $query->get();

            //dd($demandeurs);
            if($demandeurs->count() > 0){ 
                return Excel::download(new DemandeurExport($demandeurs), 'demandeurs.xlsx');
            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");

        } 
    } 
	
    //Exporter les demandes d'emploi en PDF
    public function ExportCandidaturePDF(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {

            $data = Session::get('recherche_data');
                
            $query = User::join('candidature','candidature.user_id', '=', 'users.id')
                        ->join('offre','offre.offre_id', '=', 'candidature.offre_id')
                        ->join('typecontrat','offre.typecontrat_id', '=', 'typecontrat.typecontrat_id')
                        ->where('users.profil_id', '=', 3)
                        ->where('candidature.candidature_statut',"BROUILLON")
                        ->orderBy('candidature_id', 'DESC');
            
            if (isset($data['trancheage'])) {
                $query->where('users.trancheage_id', '=', $data['trancheage']);
            }

            if (isset($data['genre'])) {
                $query->where('users.genre', '=', $data['genre']);
            }

            if (isset($data['situation'])) {
                $query->where('users.situationmatrimoniale', '=', $data['situation']);
            }

            $demandeemploi = $query->get();

            //dd($demandeemploi);
            if($demandeemploi->count() > 0){
                $html = View::make('admin.exportation.demandeemploi', compact('demandeemploi'))->render();

                $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->setPaper('A4', 'landscape');
                $dompdf->render();

                return $dompdf->stream("demandeemploi.pdf"); 
            }else{

                return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");
            }
        }
    }

    //Exporter les demandes d'emploi en Excel
    public function ExportCandidatureExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {

            $data = Session::get('recherche_data');
                
            $query = User::select('name', 'prenoms', 'telephone', 'email', 'offretitre', 'typecontratlib','candidature_datecrea','candidature_statut')
                    ->join('candidature','candidature.user_id', '=', 'users.id')
                    ->join('offre','offre.offre_id', '=', 'candidature.offre_id')
                    ->join('typecontrat','offre.typecontrat_id', '=', 'typecontrat.typecontrat_id')
                    ->where('users.profil_id', '=', 3)
                    ->where('candidature.candidature_statut',"BROUILLON")
                    ->orderBy('candidature_id', 'DESC');
            
            if (isset($data['trancheage'])) {
                $query->where('users.trancheage_id', '=', $data['trancheage']);
            }

            if (isset($data['genre'])) {
                $query->where('users.genre', '=', $data['genre']);
            }

            if (isset($data['situation'])) {
                $query->where('users.situationmatrimoniale', '=', $data['situation']);
            }

            $demandeemploi = $query->get();

            //dd($demandeemploi);
            if($demandeemploi->count() > 0){ 

                return Excel::download(new DemandeExport($demandeemploi), 'demandeemploi.xlsx');
            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");

        } 
    }

	//Détails Demandeur d'emploi
    public function DetailsDemandeurEmploi($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP")){

                $demandeur = User::where(['users.id'=>$id])->first();

                $diplome = Diplome::where(['diplome_id'=>$demandeur->diplome_id])->first();

                $metier = Metier::where(['metier_id'=>$demandeur->metier_id])->first();

                $pays = Pays::where(['pays_id'=>$demandeur->pays_id])->first();

                $region = Region::where(['region_id'=>$demandeur->region_id])->first();

                $categoriepro = CategorieProfessionelle::where(['catepro_id'=>$demandeur->catepro_id])->first();

                $typedemandeur = TypeDemandeur::where(['situation_id'=>$demandeur->situation_id])->first();
                
                $niveauintruction = NiveauInstruction::where(['niveau_id'=>$demandeur->niveau_id])->first();

                $langueinter = LangueInternationale::where(['langueinter_id'=>$demandeur->langueinter_id])->first();

                $languelocale = LangueLocale::where(['languelocal_id'=>$demandeur->languelocal_id])->first();

                $typecontrats = TypeContrat::get();

                $candidatures = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->where(['candidature.user_id'=>$demandeur->id, 'candidature.candidature_statut'=>"VALIDE"])
                                            ->orderby('candidature_id','DESC')
                                            ->get();
                                            
                $contrats = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->where(['candidature.user_id'=>$demandeur->id, 'candidature.candidature_statut'=>"APPROUVE"])
                                            ->orderby('candidature_id','DESC')
                                            ->get();

                return view('admin.demandeur.details',['demandeur'=>$demandeur, 'diplome'=>$diplome, 'metier'=>$metier, 'candidatures'=>$candidatures, 'contrats'=>$contrats, 'typecontrats'=>$typecontrats, 'pays'=>$pays, 'region'=>$region, 'categoriepro'=>$categoriepro, 'typedemandeur'=>$typedemandeur, 'niveauintruction'=>$niveauintruction, 'langueinter'=>$langueinter, 'languelocale'=>$languelocale]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Détails Demandeur d'emploi
    public function FormulaireValiderDemandeur($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP")){

                $demandeur = User::where(['users.id'=>$id])->first();

                $diplome = Diplome::where(['diplome_id'=>$demandeur->diplome_id])->first();

                $metier = Metier::where(['metier_id'=>$demandeur->metier_id])->first();

                $pays = Pays::where(['pays_id'=>$demandeur->pays_id])->first();

                $region = Region::where(['region_id'=>$demandeur->region_id])->first();

                $categoriepro = CategorieProfessionelle::where(['catepro_id'=>$demandeur->catepro_id])->first();

                $typedemandeur = TypeDemandeur::where(['situation_id'=>$demandeur->situation_id])->first();
                
                $niveauintruction = NiveauInstruction::where(['niveau_id'=>$demandeur->niveau_id])->first();

                $langueinter = LangueInternationale::where(['langueinter_id'=>$demandeur->langueinter_id])->first();

                $languelocale = LangueLocale::where(['languelocal_id'=>$demandeur->languelocal_id])->first();

                return view('admin.demandeur.detailsvalidercompte',['demandeur'=>$demandeur, 'diplome'=>$diplome, 'metier'=>$metier, 'pays'=>$pays, 'region'=>$region, 'categoriepro'=>$categoriepro, 'typedemandeur'=>$typedemandeur, 'niveauintruction'=>$niveauintruction, 'langueinter'=>$langueinter, 'languelocale'=>$languelocale]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Liste des cartes demandeurs d'emploi expirées
    public function DemandeurCarteExpiree(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")){
            
                $trancheage = $request->a;
                $genre      = $request->g;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($trancheage)){
                    $whereRaw.= " AND trancheage_id = $trancheage ";
                }
                if(!empty($genre)){
                    $whereRaw.= ' AND genre LIKE "%'.$genre.'%"';
                }
                if(!empty($situation)){
                    $whereRaw.= ' AND situationmatrimoniale LIKE "%'.$situation.'%"';
                }            

                $users = User::where(['profil_id'=>3])
                            ->whereRaw('date(user_validitecarte) <"'.gmdate("Y-m-d").'" ')
                            ->whereRaw($whereRaw)
                            ->get();

                $trancheages = TrancheAge::get(); 

                return view('admin.demandeur.carteexpiree',['users'=>$users, 'trancheages'=>$trancheages, 'trancheage_select'=>$trancheage, 'genre_select'=>$genre, 'situation_select'=>$situation]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
                
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Détails Demandeur d'emploi carte expirée
    public function DetailsDemandeurCarteExpiree($id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP")){

                $demandeur = User::where(['users.id'=>$id])->first();

                $diplome = Diplome::where(['diplome_id'=>$demandeur->diplome_id])->first();

                $metier = Metier::where(['metier_id'=>$demandeur->metier_id])->first();

                $pays = Pays::where(['pays_id'=>$demandeur->pays_id])->first();

                $region = Region::where(['region_id'=>$demandeur->region_id])->first();

                $categoriepro = CategorieProfessionelle::where(['catepro_id'=>$demandeur->catepro_id])->first();

                $typedemandeur = TypeDemandeur::where(['situation_id'=>$demandeur->situation_id])->first();
                
                $niveauintruction = NiveauInstruction::where(['niveau_id'=>$demandeur->niveau_id])->first();

                $langueinter = LangueInternationale::where(['langueinter_id'=>$demandeur->langueinter_id])->first();

                $languelocale = LangueLocale::where(['languelocal_id'=>$demandeur->languelocal_id])->first();

                $typecontrats = TypeContrat::get();

                $candidatures = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->where(['candidature.user_id'=>$demandeur->id, 'candidature.candidature_statut'=>"VALIDE"])
                                            ->orderby('candidature_id','DESC')
                                            ->get();
                                            
                $contrats = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->where(['candidature.user_id'=>$demandeur->id, 'candidature.candidature_statut'=>"APPROUVE"])
                                            ->orderby('candidature_id','DESC')
                                            ->get();

                return view('admin.demandeur.detailscarteexpiree',['demandeur'=>$demandeur, 'diplome'=>$diplome, 'metier'=>$metier, 'candidatures'=>$candidatures, 'contrats'=>$contrats, 'typecontrats'=>$typecontrats, 'pays'=>$pays, 'region'=>$region, 'categoriepro'=>$categoriepro, 'typedemandeur'=>$typedemandeur, 'niveauintruction'=>$niveauintruction, 'langueinter'=>$langueinter, 'languelocale'=>$languelocale]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Renouveler la carte
    public function RenouvelerCarte(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")){
                
                $demandeur = User::find($id);

                if($demandeur){

                    $datejour = gmdate('Y-m-d');

                    $url = $request->root();

                    $lien_logo = $url."/assets/img/logo-anpe.png";
                    
                    $demandeur_image = $url."/assets/img/profil/".$demandeur->profil_photo;
                    $avatar_femme = $url."/assets/img/profil/femme.png";
                    $avatar_homme = $url."/assets/img/profil/homme.jpg";
                    $nationalite = Pays::where(['pays.pays_id'=>$demandeur->pays_id])->first();
                    $region = Region::where(['region.region_id'=>$demandeur->region_id])->first();
                    
                    $demandeur->user_validitecarte = date('Y-m-d', strtotime($datejour . ' - 1 day'.' + 1 year'));
                     
                    // L'instance PDF avec la vue
                    $pdf = PDF::loadView('demandeur.carte', compact('demandeur', 'lien_logo', 'demandeur_image', 'nationalite' ,'avatar_femme', 'avatar_homme'));

                    // Lancement du téléchargement du fichier PDF
                    $carte_name = time().$demandeur->id.\Str::slug($demandeur->name).".pdf";
                    $pdf->download($carte_name);

                    //pour enregistrer le fichier PDF
                    $pdf->save(public_path("carteanpe/".$carte_name));
                    
                    $data = [ 
                        'id' => $demandeur->id,
                        'identifiant' => $demandeur->identifiant,
                        'name' => $demandeur->name,
                        'prenoms' => $demandeur->prenoms,
                        'email' => $demandeur->email,
                        'telephone' => $demandeur->telephone
                    ];

                    $demandeur->user_statut = "VALIDE";
                    $demandeur->user_carte_statut = "VALIDE";
                    $demandeur->user_carte = $carte_name;
                    $demandeur->date_ri_ni = gmdate('Y-m-d H:i:s');
                    $demandeur->exists = true;
                    $demandeur->update();
                    
                    //Email data
                    $email_data = array(
                        'nom' => $demandeur['name'],
                        'prenoms' => $demandeur['prenoms'],
                        'lien_carte' => $url."/carteanpe/".$carte_name,
                        'email' => $demandeur['email'],
                        'anneencours'=>gmdate('Y'),
                    );
                    
                    //Envoie des paramètres du mail
                    Mail::send('emails.cartevalider', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'] ,$email_data['prenoms'])
                        ->subject("Carte ANPE renouvelée avec succès")
                        ->from('info@anpe-niger.ne' ,"ANPE");
                    });

                    return back()->with('info_succes',"La nouvelle carte a bien été renouvellée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        } 
    }

    //Renouveler la carte via post
    public function PostRenouvelerCarte(Request $request, $id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")){
                
                $demandeur = User::find($id);

                if($demandeur){

                    $datejour = gmdate('Y-m-d');

                    $url = "http://www.anpe-niger.ne/";

                    if($request->action == "Renouveler la carte"){
                        
                        $lien_logo = $url."/assets/img/logo-anpe.png";
                    
                        $demandeur_image = $url."/assets/img/profil/".$demandeur->profil_photo;
                        $avatar_femme = $url."/assets/img/profil/femme.png";
                        $avatar_homme = $url."/assets/img/profil/homme.jpg";
                        $nationalite = Pays::where(['pays.pays_id'=>$demandeur->pays_id])->first();
                        $region = Region::where(['region.region_id'=>$demandeur->region_id])->first();                        
                        $demandeur->user_validitecarte = date('Y-m-d', strtotime($datejour . ' - 1 day'.' + 1 year'));
                         
                        // L'instance PDF avec la vue
                        $pdf = PDF::loadView('demandeur.carte', compact('demandeur', 'lien_logo', 'demandeur_image', 'nationalite' ,'avatar_femme', 'avatar_homme'));

                        // Lancement du téléchargement du fichier PDF
                        $carte_name = time().$demandeur->id.\Str::slug($demandeur->name).".pdf";
                        $pdf->download($carte_name);

                        //pour enregistrer le fichier PDF
                        $pdf->save(public_path("carteanpe/".$carte_name));
                        
                        $data = [ 
                            'id' => $demandeur->id,
                            'identifiant' => $demandeur->identifiant,
                            'name' => $demandeur->name,
                            'prenoms' => $demandeur->prenoms,
                            'email' => $demandeur->email,
                            'telephone' => $demandeur->telephone
                        ];

                        $demandeur->user_statut = "VALIDE";
                        $demandeur->user_carte_statut = "VALIDE";
                        $demandeur->user_carte = $carte_name;
                        $demandeur->date_ri_ni = gmdate('Y-m-d H:i:s');
                        $demandeur->exists = true;
                        $demandeur->update();
                        
                        //Email data
                        $email_data = array(
                            'nom' => $demandeur['name'],
                            'prenoms' => $demandeur['prenoms'],
                            'lien_carte' => $url."/carteanpe/".$carte_name,
                            'email' => $demandeur['email'],
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        //Envoie des paramètres du mail
                        Mail::send('emails.cartevalider', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'] ,$email_data['prenoms'])
                            ->subject("Carte ANPE renouvelée avec succès")
                            ->from('info@anpe-niger.ne' ,"ANPE");
                        });

                        return redirect()->route('admin.demandeur.carte.expiree')->with('info_succes',"La nouvelle carte a bien été renouvellée avec succès");
                    }
                    if($request->action == "Fermeture du compte"){
                        
                        $demandeur->user_statut = "BROUILLON";
                        $demandeur->exists      = true;
                        $demandeur->update();

                        //Email data
                        $email_data = array(
                            'nom' => $demandeur->name,
                            'prenoms' => $demandeur->prenoms,
                            'observation' => $request->observation,
                            'email' => $demandeur->email,
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        //Envoie des paramètres du mail
                        Mail::send('emails.ferme_comptecand', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'] ,$email_data['prenoms'])
                            ->subject("Votre compte fermé par la direction de l'ANPE")
                            ->from('info@anpe-niger.ne' ,"ANPE");
                        });

                        return redirect()->route('admin.demandeur.carte.expiree')->with('info_succes',"Compte demandeur d'emploi fermé avec succès !!!");
                    }

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        } 
    }

    //Liste des profils candidature à extraire
    public function ListeProfilCandidature(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXTRAC_PROFIL")){
                
                $diplome = $request->d;
                $metier = $request->m;
                $experience = $request->a;
                $formation = $request->f;
                $experiencepro = $request->e; 
                $specialite = $request->s;
                $experience = $request->a;

                $whereRaw = ' 1 ';
                
                if(!empty($diplome)){
                    $whereRaw.= " AND diplome.diplome_id = $diplome ";
                }
                if(!empty($metier)){
                    $whereRaw.= " AND metier.metier_id = $metier ";
                }
                if(!empty($experience)){
                    $whereRaw.= ' AND users.experience LIKE "%'.$experience.'%"';
                }

                if(!empty($formation)){
                    $whereRaw.= ' AND formation.formation_diplome LIKE "%'.$formation.'%"';
                }
                if(!empty($experiencepro)){
                    $whereRaw.= ' AND experiencepro.experiencepro_titre LIKE "%'.$experiencepro.'%"';
                }
                if(!empty($specialite)){
                    $whereRaw.= ' AND specialite.specialite_intitule LIKE "%'.$specialite.'%"';
                }

                $profilcandidature = User::leftJoin('formation', 'formation.user_id', '=', 'users.id')
                                        ->leftJoin('experiencepro', 'experiencepro.user_id', '=', 'users.id')
                                        ->leftJoin('metier','metier.metier_id','users.metier_id')
                                        ->leftJoin('diplome','diplome.diplome_id','users.diplome_id')
                                        ->leftJoin('specialite', 'specialite.user_id', '=', 'users.id')
                                        ->whereRaw($whereRaw)
                                        ->where(['users.profil_id' => 3, 'users.user_statut' => 'VALIDE'])
                                        ->whereRaw('date(user_validitecarte) >= "'.gmdate("Y-m-d").'" ')
                                        ->whereIn('users.id', function ($query) {
                                            $query->select('users.id')
                                                ->from('users')
                                                ->leftJoin('formation', 'formation.user_id', '=', 'users.id')
                                                ->leftJoin('experiencepro', 'experiencepro.user_id', '=', 'users.id')
                                                ->leftJoin('specialite', 'specialite.user_id', '=', 'users.id')
                                                ->where(['users.profil_id' => 3, 'users.user_statut' => 'VALIDE'])
                                                ->groupBy('users.id');
                                        })
                                        ->select('users.*')
                                        ->groupBy('users.id')
                                        ->get();

                // Stocker les données de recherche en session
                Session::put('recherche_profilcandidature', [
                    'diplome' => $diplome,
                    'metier' => $metier,
                    'experience' => $experience,
                    'formation' => $formation,
                    'experiencepro' => $experiencepro,
                    'specialite' => $specialite,
                ]);

                $diplomes = Diplome::get();

                $filieres = Metier::orderby('metier_libelle','ASC')->get();
                
                return view('admin.demandeur.profilcandidature',['profilcandidature'=>$profilcandidature, 'diplomes'=>$diplomes, 'filieres'=>$filieres, 'experience_selected'=>$experience, 'diplome_selected'=>$diplome, 'metier_selected'=>$metier, 'formation_selected'=>$formation, 'experiencepro_selected'=>$experiencepro, 'specialite_selected'=>$specialite]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Exporter les candidature à extraire
    public function ExtrationDonnees(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {
            
            $data = Session::get('recherche_profilcandidature');

            
            $query = User::select('users.id as identifiant', 'name', 'prenoms', 'datenaissance', 'lieunaissance', 'genre', 'nom_fr', 'niveau_lib', 'diplomelib', 'new_diplome', 'metier_libelle', 'new_metier', 'telephone', 'experience', 'email',
                            \DB::raw('GROUP_CONCAT(DISTINCT formation.formation_diplome) as formation_diplome'),
                            \DB::raw('GROUP_CONCAT(DISTINCT experiencepro.experiencepro_titre) as experiencepro_titre'),
                            \DB::raw('GROUP_CONCAT(DISTINCT specialite.specialite_intitule) as specialite_intitule'))
                            ->leftJoin('pays', 'pays.pays_id', '=', 'users.pays_id')
                            ->leftJoin('niveauinstruction', 'niveauinstruction.niveau_id', '=', 'users.niveau_id')
                            ->leftJoin('diplome', 'diplome.diplome_id', '=', 'users.diplome_id')
                            ->leftJoin('metier', 'metier.metier_id', '=', 'users.metier_id')
                            ->leftJoin('formation', 'formation.user_id', '=', 'users.id')
                            ->leftJoin('experiencepro', 'experiencepro.user_id', '=', 'users.id')
                            ->leftJoin('specialite', 'specialite.user_id', '=', 'users.id')
                            ->where(['profil_id' => 3, 'user_statut' => "VALIDE", 'user_carte_statut' => "VALIDE"])
                            ->whereRaw('date(user_validitecarte) >= "' . gmdate("Y-m-d") . '"')
                            ->orderBy('users.id', 'DESC')
                            ->groupBy('users.id', 'identifiant', 'name', 'prenoms', 'datenaissance', 'lieunaissance', 'genre', 'nom_fr', 'niveau_lib', 'diplomelib', 'new_diplome', 'metier_libelle', 'new_metier', 'telephone', 'experience', 'email'); // Groupement par les champs uniques de l'utilisateur

            if (isset($data['diplome'])) {
                $query->where('users.diplome_id', '=', $data['diplome']);
            }

            if (isset($data['metier'])) {
                $query->where('users.metier_id', '=', $data['metier']);
            }

            if (isset($data['experience'])) {
                $query->where('users.experience', '=', $data['experience']);
            }

            if (isset($data['experiencepro'])) {
                $query->where('experiencepro.experiencepro_titre', '=', $data['experiencepro']);
            }

            if (isset($data['formation'])) {
                $query->where('formation.formation_diplome', '=', $data['formation']);
            }

            if (isset($data['specialite'])) {
                $query->where('specialite.specialite_intitule', '=', $data['specialite']);
            }

            $demandeurs = $query->get();

            //dd($demandeurs);
            if($demandeurs->count() > 0){ 
                return Excel::download(new DemandeurExtractExport($demandeurs), 'demandeurs.xlsx');
            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");

        } 
    } 
    //***** GESTION DES LIENS SUR LES CANDIDATURES ******//

    //Liste des Candidatures à valider
    public function CandidatureaValider(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND")  or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND")){
                
                $nom        = $request->n;
                $telephone  = $request->t;
                $trancheage = $request->a;
                $genre      = $request->g;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($nom)){
                    $whereRaw.= ' AND name LIKE "%'.$nom.'%"';
                }
                if(!empty($telephone)){
                    $whereRaw.= ' AND telephone LIKE "%'.$telephone.'%"';
                }
                if(!empty($trancheage)){
                    $whereRaw.= " AND trancheage_id = $trancheage ";
                }
                if(!empty($genre)){
                    $whereRaw.= ' AND genre LIKE "%'.$genre.'%"';
                }
                if(!empty($situation)){
                    $whereRaw.= ' AND situationmatrimoniale LIKE "%'.$situation.'%"';
                }

                $user_candidature = User::join('candidature','candidature.user_id','users.id')
                                        ->join('offre','offre.offre_id','candidature.offre_id')
                                        ->join('typecontrat','offre.typecontrat_id','typecontrat.typecontrat_id')
                                        ->where(['candidature_statut'=>"BROUILLON"])
                                        ->whereRaw($whereRaw)
                                        ->orderby('candidature_id','DESC')
                                        ->get();
                        
                $trancheages = TrancheAge::get();

                // Stocker les données de recherche en session
                Session::put('recherche_data', [
                    'trancheage' => $trancheage,
                    'genre' => $genre,
                    'situation' => $situation,
                ]);

                
                return view('admin.demandeur.candidatureavalider',['user_candidature'=>$user_candidature, 'trancheages'=>$trancheages, 'nom_select'=>$nom, 'telephone_select'=>$telephone, 'trancheage_select'=>$trancheage, 'genre_select'=>$genre, 'situation_select'=>$situation]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Détails Candidature
    public function ValiderCandidature($candidature_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            $candidature = Candidature::find($candidature_id);

            $demandeur = User::where(['users.id'=>$candidature->user_id]);

            $typecontrats = TypeContrat::orderby('typecontratlib','ASC')->get();

            return view('admin.demandeur.validercandidature',['candidature'=>$candidature, 'typecontrats'=>$typecontrats, 'demandeur'=>$demandeur]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }    
    }

    //Valider contrat
    public function AdminValiderCandidature(Request $request, $candidature_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND")){

                $candidature = Candidature::find($candidature_id);

                //Récupération de l'offre en rélation avec la candidature
                $offre = Offre::where(['offre.offre_id'=>$candidature->offre_id])->first();

                //Récupération du candidat
                $user = User::where(['users.id'=>$candidature->user_id])->first();

                $typecontrat = TypeContrat::where(['typecontrat.typecontrat_id'=>$request->typecontrat_id])->first();
                
                $nombre_decrement = 1;

                if($candidature){

                    $candidature->typecontrat_id            = $request->typecontrat_id;
                    $candidature->candidature_statut        = "APPROUVE";
                    $candidature->candidature_datecontrat   = gmdate('Y-m-d H:i:s');
                    if($request->datedebut != null and $request->datefin != null){
                        $candidature->candidature_datedebcrt    = htmlspecialchars($request->datedebut);
                        $candidature->candidature_datefincrt    = htmlspecialchars($request->datefin);
                    }                
                    $candidature->exists                    = true;
                    $candidature->update();

                    $email_data = array(
                        'nom' => $user->name,
                        'prenoms' => $user->prenoms,
                        'email' => $user->email,
                        'offretitre' => $offre->offretitre,
                        'typecontrat' => $typecontrat->typecontratlib,
                        'anneencours'=>gmdate('Y'),
                    );

                    //Envoie des paramètres du mail au client
                    Mail::send('emails.validercandidature', $email_data, function ($message) use ($email_data){
                    $message->to($email_data['email'])
                        ->subject("Merci de vous avoir abonné à notre newsletter")
                        ->from('info@anpe-niger.ne', 'ANPE');
                    });

                    //Actualisation du nombre de poste
                    if($offre){

                        $offre->offrenombreposte = $offre->offrenombreposte - $nombre_decrement;
                        $offre->exists = true;
                        $offre->update();
                    }  
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    } 
	
	//Liste des demandes d'emploi de l'ANPE
    public function DemandeEmploiANPE(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND")){

                $nom        = $request->n;
                $telephone  = $request->t;
                $trancheage = $request->a;
                $genre      = $request->g;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($nom)){
                    $whereRaw.= ' AND name LIKE "%'.$nom.'%"';
                }
                if(!empty($telephone)){
                    $whereRaw.= ' AND telephone LIKE "%'.$telephone.'%"';
                }
                if(!empty($trancheage)){
                    $whereRaw.= " AND trancheage_id = $trancheage ";
                }
                if(!empty($genre)){
                    $whereRaw.= ' AND genre LIKE "%'.$genre.'%"';
                }
                if(!empty($situation)){
                    $whereRaw.= ' AND situationmatrimoniale LIKE "%'.$situation.'%"';
                }

                $candidats = Offre::join('candidature','candidature.offre_id','offre.offre_id')
                                        ->join('users','users.id','candidature.user_id')
                                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                        ->where(['candidature_statut'=>"BROUILLON", 'offre.user_id'=>1])
                                        ->get();
                 
                $trancheages = TrancheAge::get();

                return view('admin.demandeur.listecandidature',['candidats'=>$candidats, 'trancheages'=>$trancheages, 'nom_select'=>$nom, 'telephone_select'=>$telephone, 'trancheage_select'=>$trancheage, 'genre_select'=>$genre, 'situation_select'=>$situation]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }
	
	//Liste des demandes d'emploi global
    public function ListeDemandeEmploi(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND")){

                $nom        = $request->n;
                $trancheage = $request->a;
                $genre      = $request->g;
                $situation  = $request->s;

                $whereRaw = ' 1 '; 
            
                if(!empty($nom)){
                    $whereRaw.= ' AND name LIKE "%'.$nom.'%"';
                }
                if(!empty($trancheage)){
                    $whereRaw.= " AND trancheage_id = $trancheage ";
                }
                if(!empty($genre)){
                    $whereRaw.= ' AND genre LIKE "%'.$genre.'%"';
                }
                if(!empty($situation)){
                    $whereRaw.= ' AND situationmatrimoniale LIKE "%'.$situation.'%"';
                }

                $candidats = Candidature::join('users', 'users.id', 'candidature.user_id')
                                        ->join('offre', 'offre.offre_id', 'candidature.offre_id')
                                        ->join('typecontrat', 'offre.typecontrat_id', 'typecontrat.typecontrat_id')
                                        ->where('candidature_statut', '<>', "BROUILLON")
                                        ->whereRaw($whereRaw)
                                        ->orderBy('candidature_id', 'DESC')
                                        ->selectRaw('candidature.*, users.*, offre.offretitre, typecontrat.*')
                                        ->get();
                //dd($candidats);
                $trancheages = TrancheAge::get(); 

                // Stocker les données de recherche en session
                Session::put('recherche_data', [
                    'trancheage' => $trancheage,
                    'genre' => $genre,
                    'situation' => $situation,
                ]);

                                    
                return view('admin.demandeur.listedemande',['candidats'=>$candidats, 'trancheages'=>$trancheages, 'nom_select'=>$nom, 'trancheage_select'=>$trancheage, 'genre_select'=>$genre, 'situation_select'=>$situation]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }
	
	//Valider la Candidature
    public function ValidationCandidature($candidature_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND")){
                
                $candidature = Candidature::find($candidature_id);

                if($candidature){

                    $candidature->candidature_statut = "VALIDE";
                    $candidature->exists = true;
                    $candidature->candidature_datevalid = gmdate('Y-m-d H:i:s');
                    $candidature->update();

                    return back()->with('info_succes',"La candidature a bien été validée");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }  
    }

    //Supprimer la Candidature
    public function SupprimerCandidature($candidature_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_CAND")){
                
                $candidature = Candidature::find($candidature_id);

                if($candidature){

                    $candidature->delete();

                    return back()->with('info_succes',"La candidature a bien été supprimée");
                }
            }else{
                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }  
    }
	
	//Formulaire de validation de la candidature
    public function SaveValidationduCandidat(Request $request, $candidature_id){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            $candidature = Candidature::find($candidature_id);

            //Récupération de l'offre en rélation avec la candidature
            $offre = Offre::where(['offre.offre_id'=>$candidature->offre_id])->first();

            //Récupération du candidat
            $user = User::where(['users.id'=>$candidature->user_id])->first();

            $typecontrat = TypeContrat::where(['typecontrat.typecontrat_id'=>$request->typecontrat_id])->first();
            
            //dd($user);
            
            $nombre_decrement = 1;
            if($candidature){

                $datedebut = $request->datedebut;
                $datefin = $request->datefin;

                $datejours = gmdate('Y-m-d');

                $rules = [
                    'typecontrat_id' => 'required',
                    'datedebut' => 'required',
                ];

                $customMessages = [
                    'typecontrat_id.required' => 'Le type de contrat est obligatoire',
                    'datedebut.required' => 'La date début est obligatoire',
                ];

                $this->validate($request,$rules,$customMessages);

                if($datejours < $datedebut){
                    if($datefin == null){
                        
                        $candidature->candidature_statut         = "APPROUVE";
                        $candidature->candidature_datecontrat    = gmdate('Y-m-d H:i:s');
                        $candidature->candidature_datedebcrt     = htmlspecialchars($request->datedebut);
                        $candidature->exists                     = true;
                        $candidature->update();

                        //Actualisation du nombre de poste
                        if($offre){

                            $offre->offrenombreposte = $offre->offrenombreposte - $nombre_decrement;
                            $offre->exists = true;
                            $offre->update();
                        }  

                        $email_data = array(
                            'nom' => $user->name,
                            'prenoms' => $user->prenoms,
                            'email' => $user->email,
                            'offretitre' => $offre->offretitre,
                            'typecontrat' => $typecontrat->typecontratlib,
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        // Envoie des paramètres du mail au client
                        Mail::send('emails.validercandidature', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'])
                            ->subject("Merci de vous avoir abonné à notre newsletter")
                            ->from('info@anpe-niger.ne', 'ANPE');
                        });

                        return redirect()->route('listecandidature')->with('info_succes', 'La validation du contrat à bien été fait avec succès');
                        
                    }
                    if($datefin !=null and $datedebut < $datefin){ 
                        
                        $candidature->candidature_statut         = "APPROUVE";
                        $candidature->candidature_datecontrat   = gmdate('Y-m-d H:i:s');
                        $candidature->candidature_datedebcrt    = htmlspecialchars($request->datedebut);
                        $candidature->candidature_datefincrt    = htmlspecialchars($request->datefin);
                        $candidature->exists                    = true;
                        $candidature->update();

                        //Actualisation du nombre de poste
                        if($offre){

                            $offre->offrenombreposte = $offre->offrenombreposte - $nombre_decrement;
                            $offre->exists = true;
                            $offre->update();
                        }  

                        $email_data = array(
                            'nom' => $user->name,
                            'prenoms' => $user->prenoms,
                            'email' => $user->email,
                            'offretitre' => $offre->offretitre,
                            'typecontrat' => $typecontrat->typecontratlib,
                            'anneencours'=>gmdate('Y'),
                        );
                        
                        // Envoie des paramètres du mail au client
                        Mail::send('emails.validercandidature', $email_data, function ($message) use ($email_data){
                        $message->to($email_data['email'])
                            ->subject("Merci de vous avoir abonné à notre newsletter")
                            ->from('info@anpe-niger.ne', 'ANPE');
                        });

                        return redirect()->route('listecandidature')->with('info_succes', 'La validation du contrat à bien été fait avec succès');  
                    }else{
                        return back()->with('info_erreur',"La date de fin doit être supérieur à la date de début du contrat");
                    } 
                }else{ 

                    return back()->with('info_erreur', 'La date de début du contrat doit être supérieur à la date sélectionnée');
                }        
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Exporter les demandes d'emploi en PDF
    public function ExportCandidatureValidePDF(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {

            $data = Session::get('recherche_data');
                
            $query = User::join('candidature','candidature.user_id', '=', 'users.id')
                        ->join('offre','offre.offre_id', '=', 'candidature.offre_id')
                        ->join('typecontrat','offre.typecontrat_id', '=', 'typecontrat.typecontrat_id')
                        ->where('users.profil_id', '=', 3)
                        ->whereRaw('candidature.candidature_statut <> "BROUILLON"')
                        ->orderBy('candidature_id', 'DESC');

            if (isset($data['trancheage'])) {
                $query->where('users.trancheage_id', '=', $data['trancheage']);
            }

            if (isset($data['genre'])) {
                $query->where('users.genre', '=', $data['genre']);
            }

            if (isset($data['situation'])) {
                $query->where('users.situationmatrimoniale', '=', $data['situation']);
            }

            $demandeemploi = $query->get();

            //dd($demandeemploi);
            if($demandeemploi->count() > 0){
                $html = View::make('admin.exportation.demandeemploi', compact('demandeemploi'))->render();

                $dompdf = new Dompdf();
                $dompdf->loadHtml($html);
                $dompdf->setPaper('A4', 'landscape');
                $dompdf->render();

                return $dompdf->stream("demandeemploi.pdf");
            }else{

                return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");
            }
        }
    }

    //Exporter les demandes d'emploi en Excel
    public function ExportCandidatureValideExcel(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE") {

            $data = Session::get('recherche_data');
                
            $query = User::select('name', 'prenoms', 'telephone', 'email', 'offretitre', 'typecontratlib','candidature_datecrea','candidature_statut')
                    ->join('candidature','candidature.user_id', '=', 'users.id')
                    ->join('offre','offre.offre_id', '=', 'candidature.offre_id')
                    ->join('typecontrat','offre.typecontrat_id', '=', 'typecontrat.typecontrat_id')
                    ->where('users.profil_id', '=', 3)
                    ->whereRaw('candidature.candidature_statut <> "BROUILLON"')
                    ->orderBy('candidature_id', 'DESC');
            
            if (isset($data['trancheage'])) {
                $query->where('users.trancheage_id', '=', $data['trancheage']);
            }

            if (isset($data['genre'])) {
                $query->where('users.genre', '=', $data['genre']);
            }

            if (isset($data['situation'])) {
                $query->where('users.situationmatrimoniale', '=', $data['situation']);
            }

            $demandeemploi = $query->get();

            //dd($demandeemploi);
            if($demandeemploi->count() > 0){ 

                return Excel::download(new DemandeExport($demandeemploi), 'demandeemploi.xlsx');
            }else{
                return back()->with('info_warning',"Il n'a pas de données à exporter de la base de données");
            }
           
        }else{

            return redirect()->route('welcome')->with('info_warning',"Vous n'avez pas d'accès à cette page");

        } 
    }

    //***** GESTION DES LIENS SUR LES UTILISATEURS ******//

    //Liste des utilisateurs
    public function ListeUtilisateur(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT")){
                
                $region  = $request->r;
                $profil  = $request->p;

                $whereRaw = ' 1 '; 
            
                if(!empty($region)){
                    $whereRaw.= " AND users.region_id = $region ";
                }
                if(!empty($profil)){
                    $whereRaw.= " AND users.profil_id = $profil ";
                }

                if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")){
                
                    $utilisateurs = User::join('region', 'region.region_id', '=', 'users.region_id')
                                        ->where('users.id', '<>', Auth::user()->id)
                                        ->where('users.profil_id', '<>', 2)
                                        ->where('users.profil_id', '<>', 3)
                                        ->whereRaw($whereRaw)
                                        ->orderBy('users.id', 'DESC')
                                        ->get();

                        $profils = Profil::where('profil_id','<>','2')
                                    ->where('profil_id','<>','3')
                                    ->orderby('profil.profil_libelle','ASC')
                                    ->get();

                    $regions = Region::orderby('region_nom','ASC')->get();

                    // Stocker les données de recherche en session
                    Session::put('recherche_utilisateur', [
                        'region' => $region,
                        'profil' => $profil,
                    ]);

                    return view('admin.utilisateur.liste',['utilisateurs'=>$utilisateurs, 'profils'=>$profils, 'regions'=>$regions, 'region_selected'=>$region, 'profil_selected'=>$profil]);
                
                }
                if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT")){
                
                    $utilisateurs = User::join('region', 'region.region_id', '=', 'users.region_id')
                                        ->where('users.id', '<>', Auth::user()->id)
                                        ->where('users.profil_id', '<>', 2)
                                        ->where('users.profil_id', '<>', 3)
                                        ->where(['users.creerpar_id'=>Auth::user()->id])
                                        ->whereRaw($whereRaw)
                                        ->orderBy('users.id', 'DESC')
                                        ->get();

                    $profils = Profil::where('profil_id','<>','2')
                                ->where('profil_id','<>','3')
                                ->orderby('profil.profil_libelle','ASC')
                                ->get();

                    $regions = Region::orderby('region_nom','ASC')->get();

                    // Stocker les données de recherche en session
                    Session::put('recherche_utilisateur', [
                        'region' => $region,
                        'profil' => $profil,
                    ]);

                    return view('admin.utilisateur.liste',['utilisateurs'=>$utilisateurs, 'profils'=>$profils, 'regions'=>$regions, 'region_selected'=>$region, 'profil_selected'=>$profil]);
                
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Formulaire de création de compte des utilisateurs
    public function CreerCompteUtilisateur(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_AGENT")){

                $profils = Profil::where('profil_id','<>','2')
                                ->where('profil_id','<>','3')
                                ->orderby('profil.profil_libelle','ASC')
                                ->get();

                $regions = Region::orderby('region_nom','ASC')->get();

                return view('admin.utilisateur.ajouter',['profils'=>$profils, 'regions'=>$regions]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Liste des actions par profil
    public function getActions($profil_id){

        $profil = Profil::find($profil_id);

        $actions = Action::where(['action.profil_id'=>$profil->profil_id])->get();

        return response()->json($actions);
    }

    //Save des utilisateurs
    public function SaveCompteUtilisateur(Request $request){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_AGENT")){

                $actions = $request->actions;

                if($actions !=null and $actions !=""){
                    
                    $rules = [
                        'password' => ['required', 'string', 'min:6', 'confirmed'],
                        'profil_photo' => 'mimes:png,jpg,jpeg',                     
                        'qualite' => ['required'],
                        'region_id' => ['required'],
                        'profil_id' => ['required'],
                        'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                        'civilite' => ['required'],
                        'prenoms' => ['required'],
                        'nom' => ['required'],
                    ];
                    
                    $customMessages = [
                        'email.unique' => "Cet adresse email est déjà utilisé",
                        'email.email' => "L'adresse email n'est pas valide",
                        'email.required' => "L'adresse email est obligatoire",
                        'qualite.required' => "Le type d'agent est obligatoire",
                        'password.min' => "Le mot de passe doit être moins 6 caractères",
                        'password.required' => "Le mot de passe est obligatoire",
                        'password.confirmed' => "La confirmation du mot de passe n'est conforme au mot de passe est obligatoire",
                        'profil_photo.mimes' => "La photo choisie n'est pas valide il doit être de type png,jpg,jpeg",
                        'region_id.required' => "La région est obligatoire",
                        'profil_id.required' => "Le niveau d'administration est obligatoire",
                        'datenaissance.required' => "La date de naissance est obligatoire",
                        'prenoms.required' => "Le prénoms est obligatoire",
                        'nom.required' => "Le nom est obligatoire",
                    ];

                    if(User::where('email', $request->email)->exists()) {
            
                        $rules = [                   
                            'email' => 'unique:users', 
                        ];    
                        $customMessages = [
                            'email.unique' => "Cet adresse email est déjà utilisé",
                        ];
                    }

                    if(User::where('telephone', $request->telephone)->exists()) {
                
                        $rules = [                   
                            'telephone' => 'unique:users', 
                        ];    
                        $customMessages = [
                            'telephone.unique' => "Cet numéro de téléphone est déjà utilisé",
                        ];
                    }
                    
                    $this->validate($request,$rules,$customMessages);

                    $utilisateur = new User();

                    if($request->hasFile('profil_photo')){

                        $file = $request->file('profil_photo');
                        $extension = $file->getClientOriginalExtension();
                        $fileperprofil = time().'.'.$extension;
                        $file->move('assets/img/profil/', $fileperprofil);
                        $utilisateur->profil_photo = $fileperprofil;
                    }

                    $utilisateur->profil_id         = htmlspecialchars($request->profil_id);
                    $utilisateur->role_id           = 1;
                    $utilisateur->creerpar_id       = Auth::user()->id;
                    $utilisateur->region_id         = $request->region_id;
                    $utilisateur->code_agent        = gmdate('i').rand(11,99);
                    $utilisateur->email             = htmlspecialchars($request->email);
                    $utilisateur->telephone         = htmlspecialchars($request->telephone);
                    $utilisateur->prenoms           = Str::upper(Str::ascii($request->prenoms));
                    $utilisateur->name              = Str::upper(Str::ascii($request->nom));
                    $utilisateur->civilite          = htmlspecialchars($request->civilite);
                    $utilisateur->qualite           = Str::upper(Str::ascii($request->qualite));
                    $utilisateur->password          = Hash::make($request->password);
                    $utilisateur->user_statut       = "BROUILLON";
                    $utilisateur->date_creation     = gmdate('Y-m-d');
                    $utilisateur->created_at        = gmdate('Y-m-d H:i:s');
                    $utilisateur->save();

                    //Renseigner les tâches des agents
                    foreach($actions as $action){

                        $action_autorisee = new ActionAutorisee();

                        $action_autorisee->action_id                      = $action;
                        $action_autorisee->user_id                        = $utilisateur->id;
                        $action_autorisee->action_autorisee_date_creation = gmdate('Y-m-d H:i:s');
                        $action_autorisee->action_autorisee_statut        = "VALIDE";
                        $action_autorisee->save();

                    }

                }else{

                    return back()->with('info_warning',"Vous n'avez choisi aucune tâche à accomplir pour cet agent.");
                }
                $url = $request->root();

                $email_data = array(
                    'nom' => $request->nom,
                    'prenoms' => $request->prenoms,
                    'email' => $request->email,
                    'motdepasse' => $request->password,
                    'anneencours'=>gmdate('Y'),
                );

                // Envoie des paramètres du mail à l'utilisateur
                Mail::send('emails.register_conseiller', $email_data, function ($message) use ($email_data){
                $message->to($email_data['email'])
                    ->subject("Votre compte a bien été créé avec succès")
                    ->from('info@anpe-niger.ne', 'ANPE');
                });
                
                return back()->with('info_succes',"Compte agent créé avec succès.");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Formulaire de modification du compte des utilisateurs
    public function ModifierCompteUtilisateur(Request $request, $id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_AGENT")){

                $utilisateur = User::find($id);

                if($utilisateur){
                    
                    $profils = Profil::where('profil_id','<>','2')
                                    ->where('profil_id','<>','3')
                                    ->orderby('profil.profil_libelle','ASC')
                                    ->get();

                    $regions = Region::orderby('region_nom','ASC')->get();

                    return view('admin.utilisateur.modifier',['utilisateur'=>$utilisateur,'profils'=>$profils, 'regions'=>$regions]);
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    } 

    //Save modifier des utilisateurs
    public function SaveModifierCompteUtilisateur(Request $request, $id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_AGENT")){

            $utilisateur = User::find($id);

            $actions = $request->actions;

            if($utilisateur){
                    
                $rules = [
                    'profil_photo' => 'mimes:png,jpg,jpeg',                     
                    'region_id' => ['required'],
                    'civilite' => ['required'],
                    'qualite' => ['required'],
                    'prenoms' => ['required'],
                    'nom' => ['required'],
                ];
                
                $customMessages = [
                    'region_id.required' => "La région est obligatoire",
                    'profil_photo.mimes' => "La photo choisie n'est pas valide il doit être de type png,jpg,jpeg",
                    'qualite.required' => "Le type d'agent est obligatoire",
                    'prenoms.required' => "Le prénoms est obligatoire",
                    'nom.required' => "Le nom est obligatoire",
                ];
                
                $this->validate($request,$rules,$customMessages);

                if($request->hasFile('profil_photo')){

                    $filecni = time().'.'.request()->profil_photo->getClientOriginalExtension();
                    request()->profil_photo->move(public_path('assets/img/profil/'), $filecni);

                }
                if($request->profil_photo !=null){
                    $utilisateur->profil_photo = $filecni ?? NULL;
                }

                $utilisateur->region_id     = $request->region_id;
                $utilisateur->prenoms       = Str::upper(Str::ascii($request->prenoms));
                $utilisateur->name          = Str::upper(Str::ascii($request->nom));
                $utilisateur->civilite      = htmlspecialchars($request->civilite);
                $utilisateur->qualite       = Str::upper(Str::ascii($request->qualite));
                $utilisateur->updated_at    = gmdate('Y-m-d H:i:s');
                $utilisateur->exists        = true;
                $utilisateur->update();
                
                //Vérification des actions cochées
                if($actions !=null and $actions != ""){

                    //Récupérer les ancienne actions autorisées
                    $actionautorisees = ActionAutorisee::where(['action_autorisee.user_id'=>$utilisateur->id])->get();
                    
                    //Supprimer
                    foreach($actionautorisees as $actionautorisee){

                        $actionautorisee->delete();
                    }

                    //Créer de nouvelle ligne
                    foreach($actions as $action){

                        $action_autorisee = new ActionAutorisee();

                        $action_autorisee->action_id                      = $action;
                        $action_autorisee->user_id                        = $utilisateur->id;
                        $action_autorisee->action_autorisee_date_creation = gmdate('Y-m-d H:i:s');
                        $action_autorisee->action_autorisee_statut        = "VALIDE";
                        $action_autorisee->save();

                    }
                }

                return redirect()->route('admin.liste.utilisateur')->with('info_succes',"Compte agent modifié avec succès.");
                
            }

        }else{

            return back()->with('info_warning',"Vous n'avez pas d'accès");
        }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Détails compte des utilisateurs
    public function DetailsCompteUtilisateur(Request $request, $id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_AGENT_ACT")){

                $utilisateur = User::find($id);

                if($utilisateur){
                    
                    $profil = Profil::where(['profil.profil_id'=>$utilisateur->profil_id])->first();

                    $region = Region::where(['region.region_id'=>$utilisateur->region_id])->first();

                    $offres = Offre::join('users','users.id','offre.user_id')
                                    ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                    ->join('metier','metier.metier_id','offre.metier_id')
                                    ->join('diplome','diplome.diplome_id','offre.diplome_id')
                                    ->where(['offre.offre_statut'=>"PUBLIE", 'offre.suivipar_id'=>$utilisateur->id])
                                    ->orderby('offre.offre_id','DESC')
                                    ->get();

                    $articles  = Actualite::join('categorie','categorie.categorie_id','actualite.categorie_id')
                                            ->where(['actualite.creerpar_id'=>$utilisateur->id])
                                            ->where(['actualite.actualite_statut'=>"PUBLIE"])
                                            ->orderby('actualite.actualite_id','DESC')
                                            ->get();

                    $employeurs = User::where(['users.profil_id'=>2,'users.creerpar_id'=>$utilisateur->id])
                                        ->orderby('users.id','DESC')
                                        ->get();

                    $demandeurs = User::where(['users.profil_id'=>3,'users.creerpar_id'=>$utilisateur->id])
                                        ->orderby('users.id','DESC')
                                        ->get();

                    $agents = User::join('profil','profil.profil_id','users.profil_id')
                                    ->join('region','region.region_id','users.region_id')
                                    ->where(['users.profil_id'=>4,'users.creerpar_id'=>$utilisateur->id])
                                    ->orderby('users.id','DESC')
                                    ->get();

                    $publications = Publication::where(['publication_part'=>$utilisateur->id])->get();

                    $action_autorisees = ActionAutorisee::join('action','action.action_id', 'action_autorisee.action_id')
                                                        ->where(['action_autorisee.user_id'=>$utilisateur->id])
                                                        ->get();
                    //dd($publications);
                    return view('admin.utilisateur.details',['utilisateur'=>$utilisateur,'profil'=>$profil, 'region'=>$region, 'offres'=>$offres, 'articles'=>$articles, 'employeurs'=>$employeurs, 'demandeurs'=>$demandeurs, 'action_autorisees'=>$action_autorisees, 'agents'=>$agents, 'publications'=>$publications]);
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Supprimer compte des utilisateurs
    public function ActiverUtilisateur(Request $request, $id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT")){

                $utilisateur = User::find($id);

                if($utilisateur){

                    $utilisateur->user_statut = "VALIDE";
                    $utilisateur->exists = true;
                    $utilisateur->update();

                    return back()->with('info_succes','Compte activé avec succès');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Supprimer compte des utilisateurs
    public function DesctiverUtilisateur(Request $request, $id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT")){

                $utilisateur = User::find($id);

                if($utilisateur){

                    $utilisateur->user_statut = "BROUILLON";
                    $utilisateur->exists = true;
                    $utilisateur->update();

                    return back()->with('info_succes','Compte désactivé avec succès');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Supprimer compte des utilisateurs
    public function SupprimerUtilisateur(Request $request, $id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_AGENT")){

                $utilisateur = User::find($id);

                if($utilisateur){

                    $utilisateur->delete();

                    return back()->with('info_succes','Compte agent supprimé avec succès');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Activé action autorisée
    public function ActiverActionAutorisee(Request $request, $id, $action_autorisee_id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT")){

                $utilisateur = User::find($id);

                if($utilisateur){

                    $action_autorisee = ActionAutorisee::find($action_autorisee_id);
                    
                    if($action_autorisee){
                        
                        $action_autorisee->action_autorisee_statut = "VALIDE";
                        $action_autorisee->exists = true;
                        $action_autorisee->update();

                        return back()->with('info_succes','Action autoisée activée avec succès');
                    }
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //Désactivé action autorisée
    public function DesactiverActionAutorisee(Request $request, $id, $action_autorisee_id){
        if(Auth::user()->role_id == 1){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT")){

                $utilisateur = User::find($id);

                if($utilisateur){

                    $action_autorisee = ActionAutorisee::find($action_autorisee_id);
                    
                    if($action_autorisee){
                        
                        $action_autorisee->action_autorisee_statut = "SUPPRIME";
                        $action_autorisee->exists = true;
                        $action_autorisee->update();

                        return back()->with('info_succes','Action autoisée désactivée avec succès');
                    }
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !");
        }
    }

    //** GESTION DES LIENS SUR LES ARTICLES **//
    
    //Liste des articles
    public function ListeArticle(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_ART")){
                
                $date        = $request->d;
                $categorie = $request->c;

                $whereRaw = ' 1 '; 
            
                if(!empty($date)){
                    $whereRaw.= ' AND actualite.actualite_datefin LIKE "%'.$date.'%"';
                }
                if(!empty($categorie)){
                    $whereRaw.= " AND actualite.categorie_id = $categorie ";
                }

                $articles = Actualite::join('users','users.id','actualite.creerpar_id')
                                        ->join('categorie','categorie.categorie_id','actualite.categorie_id')
                                        ->whereRaw('date(actualite_datefin) >= "'.gmdate("Y-m-d").'" ')
                                        ->whereRaw($whereRaw)
                                        ->orderby('actualite_id','DESC')
                                        ->get();

                $categories = Categorie::where(['categorie_statut'=>"VALIDE"])->orderby('categorielib','ASC')->get();

                return view('admin.article.liste',['articles'=>$articles, 'categories'=>$categories, 'date_selected'=>$date, 'categorie_selected'=>$categorie]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Détails d'article
    public function DetailsArticle($actualite_id){

        $article = Actualite::find($actualite_id);

        if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT")){

            if($article){
                
                if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")){
                    $commentaires = Commentaire::join('actualite','actualite.actualite_id','commentaire.actualite_id')
                                                ->join('users','users.id','commentaire.commentaire_gererpar')
                                                ->where(['commentaire_statut'=>"VALIDE", 'commentaire.actualite_id'=>$article->actualite_id])
                                                ->orderby('commentaire.commentaire_datevalid','DESC')
                                                ->get();
                }
                if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT")){

                    $commentaires = Commentaire::join('actualite','actualite.actualite_id','commentaire.actualite_id')
                                                ->join('users','users.id','commentaire.commentaire_gererpar')
                                                ->where(['commentaire_statut'=>"VALIDE", 'commentaire.actualite_id'=>$article->actualite_id, 'commentaire.commentaire_gererpar'=>Auth::user()->id])
                                                ->orderby('commentaire.commentaire_datevalid','DESC')
                                                ->get();
                }

                $categorie = Categorie::where(['categorie.categorie_id'=>$article->categorie_id])->first();

                return view('admin.article.details',['article'=>$article, 'commentaires'=>$commentaires, 'categorie'=>$categorie]);

            }

        }else{

            return back()->with('info_warning',"Vous n'avez pas d'accès");
        }
    }

    // Créer un article
    public function PublierArticle(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART")){
                
                $categories = Categorie::where(['categorie_statut'=>"VALIDE"])->orderby('categorielib','ASC')->get();

                return view('admin.article.creerarticle',['categories'=>$categories]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Save Actualité
    public function SaveArticle(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART")){
                
                $datedebut = gmdate('Y-m-d');
                
                $rules = [
                    'titre' => 'required',
                    'description' => 'required',
                    'publierpar' => 'required',
                    'categorie_id' => 'required',
                    'image' => 'required|mimes:png,jpg,jpeg|max:2048',
                ];
                
                $customMessages = [
                    'titre.required' => 'Le titre est obligatoire',
                    'description.required' => 'Le premier paragraphe est obligatoire',
                    'publierpar.required' => 'Le nom du publicateur est obligatoire',
                    'categorie_id.required' => 'La catégorie est obligatoire',
                    'image.required' => 'L\'image est obligatoire',
                    'image.max' => 'La taille minimum de l\'image est de 2048 Mo',
                    'image.mimes' => 'Le type d\'image choisie doit être png, jpg, jpeg',
                ];

                $this->validate($request,$rules,$customMessages);            

                if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART")){
                 
                    $article = new Actualite();

                    if ($request->hasFile('image')) {

                        $ActuImageName = time().'.'.$request->image->getClientOriginalExtension();

                        // Définir le chemin de destination pour l'image originale
                        $destinationPath = public_path('assets/img');
                        
                        // Enregistrer l'image originale
                        $request->image->move($destinationPath, $ActuImageName);

                        // Chemin de destination pour l'image redimensionnée
                        $resizedImagePath = public_path('assets/img/actualite');
                        $resizedImageName = 'resized_'.$ActuImageName;

                        // Redimensionner l'image avec les dimensions spécifiées
                        $resizedImage = Image::make($destinationPath.'/'.$ActuImageName)->fit(720, 482);

                        // Enregistrer l'image redimensionnée
                        $resizedImage->save($resizedImagePath.'/'.$resizedImageName);

                        // Enregistrer le nom de l'image redimensionnée dans la base de données
                        $article->actualite_image = $resizedImageName;
                    }

                    $article->creerpar_id         = Auth::user()->id;
                    $article->categorie_id        = htmlspecialchars($request->categorie_id);
                    $article->actualite_titre     = htmlspecialchars($request->titre);
                    $article->actualite_soustitre = htmlspecialchars($request->soustitre);
                    $article->actualite_descrip   = htmlspecialchars($request->description);
                    $article->actualite_autre     = htmlspecialchars($request->information);
                    $article->actualite_temoign   = htmlspecialchars($request->temoignage);
                    $article->actualite_publiepar = htmlspecialchars($request->publierpar);
                    $article->actualite_datefin   = date("Y-m-d", strtotime($datedebut."+".'3'."days"));
                    $article->actualite_datecrea  = gmdate('Y-m-d H:i:s');
                    $article->save();

                    return back()->with('info_succes', 'Actualité enregistrée avec succès');  
                }
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }  
    }

    //Formulaire de modification d'article
    public function ModifierArticle($actualite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART")){

                $article = Actualite::find($actualite_id);

                if($article){

                    $categories = Categorie::where(['categorie_statut'=>"VALIDE"])->orderby('categorielib','ASC')->get();

                    return view('admin.article.modifierarticle',['article'=>$article, 'categories'=>$categories]);

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Save Modifier article  
    public function SaveModifierArticle(Request $request, $actualite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART")){

                $article = Actualite::find($actualite_id);

                $data = $request->all();

                if($article){
                    
                    $datedebut = gmdate('Y-m-d');

                    $rules = [
                        'titre' => 'required',
                        'description' => 'required',
                        'publierpar' => 'required',
                        'categorie_id' => 'required',
                        'image' => 'mimes:png,jpg,jpeg|max:2048',
                    ];
                    
                    $customMessages = [
                        'titre.required' => 'Le titre est obligatoire',
                        'description.required' => 'Le premier paragraphe est obligatoire',
                        'publierpar.required' => 'Le nom du publicateur est obligatoire',
                        'categorie_id.required' => 'La catégorie est obligatoire',
                        'image.max' => 'La taille minimum de l\'image est de 2048 Mo',
                        'image.mimes' => 'Le type d\'image choisie doit être png, jpg, jpeg',
                    ];

                    $this->validate($request,$rules,$customMessages);            

                    if ($request->hasFile('image')) {

                        $ActuImageName = time().'.'.$request->image->getClientOriginalExtension();

                        // Définir le chemin de destination pour l'image originale
                        $destinationPath = public_path('assets/img');
                        
                        // Enregistrer l'image originale
                        $request->image->move($destinationPath, $ActuImageName);

                        // Chemin de destination pour l'image redimensionnée
                        $resizedImagePath = public_path('assets/img/actualite');
                        $resizedImageName = 'resized_'.$ActuImageName;

                        // Redimensionner l'image avec les dimensions spécifiées
                        $resizedImage = Image::make($destinationPath.'/'.$ActuImageName)->fit(720, 482);

                        // Enregistrer l'image redimensionnée
                        $resizedImage->save($resizedImagePath.'/'.$resizedImageName);

                        // Enregistrer le nom de l'image redimensionnée dans la base de données
                        $article->actualite_image = $resizedImageName;
                    }

                    if($request->image !=null){                    
                        $article->actualite_image     = $resizedImageName;
                    }

                    $article->categorie_id        = htmlspecialchars($request->categorie_id);
                    $article->actualite_titre     = htmlspecialchars($request->titre);
                    $article->actualite_soustitre = htmlspecialchars($request->soustitre);
                    $article->actualite_descrip   = htmlspecialchars($request->description);
                    $article->actualite_autre     = htmlspecialchars($request->information);
                    $article->actualite_temoign   = htmlspecialchars($request->temoignage);
                    $article->actualite_publiepar = htmlspecialchars($request->publierpar);
                    $article->actualite_datemodif = gmdate('Y-m-d H:i:s');
                    $article->exists              = true;
                    $article->save();

                    return redirect()->route('admin.liste.article')->with('info_succes', 'Article modifié avec succès');  
                }
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Supprimer un article
    public function SupprimerArticle($actualite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_ART")){
                
                $article = Actualite::find($actualite_id);

                if($article){

                    $article->delete();

                    return back()->with('info_succes',"Article supprimé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }
    }

    //Activer un article
    public function ActiveArticle($actualite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")  or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART")){
                
                $article = Actualite::find($actualite_id);

                if($article){

                    $article->actualite_statut = "PUBLIE";
                    $article->exists              = true;
                    $article->save();

                    return back()->with('info_succes',"Article activé avec succès");
                }
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Désactiver un article
    public function DesactiveArticle($actualite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            $article = Actualite::find($actualite_id);

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")  or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART")){
                
                if($article){

                    $article->actualite_statut = "BROUILLON";
                    $article->exists              = true;
                    $article->save();

                    return back()->with('info_succes',"Article désactivé avec succès");
                }
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Liste des articles
    public function ListeArticleExpire(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_ART")){
                
                $date        = $request->d;
                $categorie = $request->c;

                $whereRaw = ' 1 '; 
            
                if(!empty($date)){
                    $whereRaw.= ' AND actualite.actualite_datefin LIKE "%'.$date.'%"';
                }
                if(!empty($categorie)){
                    $whereRaw.= " AND actualite.categorie_id = $categorie ";
                }

                $articles = Actualite::join('users','users.id','actualite.creerpar_id')
                                        ->join('categorie','categorie.categorie_id','actualite.categorie_id')
                                        ->whereRaw('date(actualite_datefin) < "'.gmdate("Y-m-d").'" ')
                                        ->whereRaw($whereRaw)
                                        ->orderby('actualite_id','DESC')
                                        ->get();

                $categories = Categorie::where(['categorie_statut'=>"VALIDE"])->orderby('categorielib','ASC')->get();

                return view('admin.article.listeexpire',['articles'=>$articles, 'categories'=>$categories, 'date_selected'=>$date, 'categorie_selected'=>$categorie]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Relancer l'article
    public function RelancerArticleExpire(Request $request, $actualite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")  or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART")){
                
                $article = Actualite::find($actualite_id);

                if($article){

                    $article->actualite_datefin = htmlspecialchars($request->datefin);
                    $article->exists              = true;
                    $article->save();

                    return back()->with('info_succes',"Article relancé avec succès");
                }
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Liste des commentaires à valider
    public function CommentaireaValider(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT")){
                
                $commentaires = Commentaire::join('actualite','actualite.actualite_id','commentaire.actualite_id')
                                            ->where(['commentaire_statut'=>"BROUILLON"])
                                            ->orderby('commentaire_id','DESC')
                                            ->get();

                return view('admin.article.commentaireavalider',['commentaires'=>$commentaires]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Valider commentaire
    public function ValiderCommentaire($commentaire_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_CMT")){

                $commentaire = Commentaire::find($commentaire_id);

                if($commentaire){

                    $commentaire->commentaire_statut = "VALIDE";
                    $commentaire->commentaire_datevalid = gmdate('Y-m-d H:i:s');
                    $commentaire->exists = true;
                    $commentaire->save();

                    return back()->with('info_succes', 'Commentaire validé avec succès');
                }
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Supprimer un commentaire
    public function SupprimerCommentaire($commentaire_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_CMT")){
                
                $commentaire = Commentaire::find($commentaire_id);

                if($commentaire){

                    $commentaire->delete();

                    return back()->with('info_succes', 'Commentaire supprimé avec succès');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Activer un commentaire
    public function ActiverCommentaire($commentaire_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_CMT")){
                
                $commentaire = Commentaire::find($commentaire_id);

                if($commentaire){

                    $commentaire->commentaire_statut = "VALIDE";
                    $commentaire->exists = true;
                    $commentaire->save();

                    return back()->with('info_succes', 'Commentaire activé avec succès');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Désactiver un commentaire
    public function DesactiverCommentaire($commentaire_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_CMT")){
                
                $commentaire = Commentaire::find($commentaire_id);

                if($commentaire){

                    $commentaire->commentaire_statut = "BROUILLON";
                    $commentaire->exists = true;
                    $commentaire->save();

                    return back()->with('info_succes', 'Commentaire désactivé avec succès');
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }


        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Liste des commantaire
    public function ListeCommentaire(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT")){
                
                if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")){
                    
                    $commentaires = Commentaire::join('actualite','actualite.actualite_id','commentaire.actualite_id')
                                                ->join('users','users.id','commentaire.commentaire_gererpar')
                                                ->where(['commentaire_statut'=>"VALIDE"])
                                                ->orderby('commentaire.commentaire_datevalid','DESC')
                                                ->get();
                }
                if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT")){

                    $commentaires = Commentaire::join('actualite','actualite.actualite_id','commentaire.actualite_id')
                                                ->join('users','users.id','commentaire.commentaire_gererpar')
                                                ->where(['commentaire_statut'=>"VALIDE", 'commentaire.commentaire_gererpar'=>Auth::user()->id])
                                                ->orderby('commentaire.commentaire_datevalid','DESC')
                                                ->get();
                }

                return view('admin.article.listecommentaire',['commentaires'=>$commentaires]);
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }


    //** GESTION DES LIENS SUR LES STATISTIQUE **//

    //Statitistiques journalieres
    public function StatistiqueJournalieres(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_START")){
                
                $datejour = gmdate('Y-m-d');

                $employeurCount = User::where(['profil_id'=>2])
                                  ->whereDate('created_at', Carbon::today())
                                  ->count();

                $demandeurCount = User::where(['profil_id'=>3])
                                      ->whereDate('created_at', Carbon::today())
                                      ->count();

                $offrepublier = Offre::where('offre_statut', 'PUBLIE')
                                        ->whereDate('offre_datepublic', Carbon::today())->count();

                $offrebrouillon = Offre::where('offre_statut', 'BROUILLON')
                                    ->whereDate('offre_datecrea', Carbon::today())->count();

                //Afficher le graphique
                return view('admin.statistique.statistiquejournaliere', compact('datejour', 'employeurCount','demandeurCount', 'offrepublier', 'offrebrouillon'));

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
            
        }        
    }

    //Statitistiques mensuelles
    public function StatistiqueMensuelles(){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_START")){

                //Récupérer les demandeurs d'emploi de la base de données
                $users = DB::table('users')
                    ->select(DB::raw('COUNT(*) as count'), DB::raw('MONTH(created_at) as month'))
                    ->where(DB::raw('YEAR(created_at)'), '=', date('Y'))
                    ->groupBy(DB::raw('MONTH(created_at)'))
                    ->where(['profil_id'=>3, 'user_statut'=>"VALIDE"])
                    ->get();

                //Récupérer les demandeurs d'emploi de la base de données
                $user_brouillon = DB::table('users')
                    ->select(DB::raw('COUNT(*) as count'), DB::raw('MONTH(created_at) as month'))
                    ->where(DB::raw('YEAR(created_at)'), '=', date('Y'))
                    ->groupBy(DB::raw('MONTH(created_at)'))
                    ->where(['profil_id'=>3, 'user_statut'=>"BROUILLON"])
                    ->get();

                //Récupérer les employeurs de la base de données
                $employeursvalide = DB::table('users')
                    ->select(DB::raw('COUNT(*) as count'), DB::raw('MONTH(created_at) as month'))
                    ->where(DB::raw('YEAR(created_at)'), '=', date('Y'))
                    ->groupBy(DB::raw('MONTH(created_at)'))
                    ->where(['profil_id'=>2, 'user_statut'=>"VALIDE"])
                    ->get();

                //Récupérer les employeurs de la base de données
                $employeurbrouillon = DB::table('users')
                    ->select(DB::raw('COUNT(*) as count'), DB::raw('MONTH(created_at) as month'))
                    ->where(DB::raw('YEAR(created_at)'), '=', date('Y'))
                    ->groupBy(DB::raw('MONTH(created_at)'))
                    ->where(['profil_id'=>2, 'user_statut'=>"BROUILLON"])
                    ->get();

                // Récupérer les offres publiées de la base de données
                $offrespubliees = DB::table('offre')
                            ->select(DB::raw('COUNT(*) as count'), DB::raw('MONTH(offre_datepublic) as month'))
                            ->where(DB::raw('YEAR(offre_datepublic)'), '=', date('Y'))
                            ->where(['offre_statut' => "PUBLIE"])
                            ->groupBy(DB::raw('MONTH(offre_datepublic)'))
                            ->get();

                // Récupérer les offres en brouillon de la base de données
                $offresbrouillons = DB::table('offre')
                            ->select(DB::raw('COUNT(*) as count'), DB::raw('MONTH(offre_datecrea) as month'))
                            ->where(DB::raw('YEAR(offre_datecrea)'), '=', date('Y'))
                            ->where(['offre_statut' => "BROUILLON"])
                            ->groupBy(DB::raw('MONTH(offre_datecrea)'))
                            ->get();

                // Traiter les données pour les rendre utilisables pour le graphique
                $labels = [];
                $data_users = [];
                $data_employeur = [];
                $data_user_brouillons = [];
                $data_employeurbroui = [];
                $data_offrespubliees = [];
                $data_offresbrouillon = [];

                for ($i = 1; $i <= 12; $i++) {
                    $labels[] = date('F', mktime(0, 0, 0, $i, 1));
                    $data_users[] = 0;
                    $data_employeur[] = 0;
                    $data_user_brouillons[] = 0;
                    $data_employeurbroui[] = 0; 
                    $data_offrespubliees[] = 0; 
                    $data_offresbrouillon[] = 0; 
                }

                foreach ($users as $user) {
                    $data_users[$user->month - 1] = $user->count;
                }

                foreach ($employeursvalide as $employeur) {
                    $data_employeur[$employeur->month - 1] = $employeur->count;
                }

                foreach ($user_brouillon as $user_brouil) {
                    $data_user_brouillons[$user_brouil->month - 1] = $user_brouil->count;
                }

                foreach ($employeurbrouillon as $empbrouillon) {
                    $data_employeurbroui[$empbrouillon->month - 1] = $empbrouillon->count;
                }

                foreach ($offrespubliees as $offrepub) {
                    $data_offrespubliees[$offrepub->month - 1] = $offrepub->count;
                }

                foreach ($offresbrouillons as $offrebroui) {
                    $data_offresbrouillon[$offrebroui->month - 1] = $offrebroui->count;
                }

                // Afficher la vue avec le graphique
                return view('admin.statistique.statistiquemensuelle', [
                    'labels' => $labels,
                    'data_users' => $data_users,
                    'data_employeur' => $data_employeur,
                    'data_user_brouillons'=>$data_user_brouillons,
                    'data_employeurbroui'=>$data_employeurbroui,
                    'data_offrespubliees'=>$data_offrespubliees,
                    'data_offresbrouillon'=>$data_offresbrouillon,
                ]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }  
    } 

    //Statistique annuelle
    public function Statistiques(){

        $annees = range(date('Y') - 9, date('Y'));
        $employeursBrouillon = $this->getStatistiques('employeur', 'BROUILLON', $annees);
        $employeursValide = $this->getStatistiques('employeur', 'VALIDE', $annees);
        $demandeursBrouillon = $this->getStatistiques('demandeur', 'BROUILLON', $annees);
        $demandeursValide = $this->getStatistiques('demandeur', 'VALIDE', $annees);

        $offreBrouillon = $this->getStatistiquesOffreBrouillon('BROUILLON', $annees);
        $offreValide = $this->getStatistiquesOffre('PUBLIE', $annees);

        return view('admin.statistique.statistique', compact('annees', 'employeursBrouillon', 'employeursValide', 'demandeursBrouillon', 'demandeursValide', 'offreBrouillon', 'offreValide'));
    }

    private function getStatistiques($type, $statut, $annees){

        $statistiques = [];

        foreach ($annees as $annee) {
            $query = User::where('profil_id', ($type == 'employeur') ? 2 : 3)
                        ->where('user_statut', $statut)
                        ->whereYear('created_at', $annee)
                        ->count();

            $statistiques[] = $query;
        }

        return $statistiques;
    }

    private function getStatistiquesOffreBrouillon($statut, $annees){

        $statistiques = [];

        foreach ($annees as $annee) {
            $query = Offre::where('offre_statut', $statut)
                        ->whereYear('offre_datecrea', $annee)
                        ->count();

            $statistiques[] = $query;
        }

        return $statistiques;
    }

    private function getStatistiquesOffre($statut, $annees){

        $statistiques = [];

        foreach ($annees as $annee) {
            $query = Offre::where('offre_statut', $statut)
                        ->whereYear('offre_datepublic', $annee)
                        ->count();

            $statistiques[] = $query;
        }

        return $statistiques;
    }

    //Exportation des données en pdf de la statistique journalière en Excel
    public function ExcelStatistiqueJournalieresEmp(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){

                $query = User::select('raisonsociale','adresse', 'contact', 'name', 'qualite', "contactinterlo", "email", "activite", "secteuractivitelib", "nbrehomme", "nbrfemme", "effectiftotal", "nationalite_lib", "statutentreprise_lib", "ncnss", "situationentreprise_lib", "date_validation")
                                    ->join('secteuractivite','secteuractivite.secteuractivite_id','users.secteuractivite_id')
                                    ->join('nationalite','nationalite.nationalite_id','users.nationalite_id')
                                    ->join('region','region.region_id','users.region_id')
                                    ->join('statutentreprise','statutentreprise.statutentreprise_id','users.statutentreprise_id')
                                    ->join('situationentreprise','situationentreprise.situationentreprise_id','users.situationentreprise_id')
                                    ->where(['users.profil_id'=>2])
                                    ->whereDate('users.created_at', Carbon::today())
                                    ->orderby('users.id','DESC');

                $employeurs = $query->get();

                if($employeurs->count() > 0){

                    return Excel::download(new EntrepriseExport($employeurs), 'employeurs.xlsx');

                }else{

                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueJournalieresDemp(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){

                $query = User::select('identifiant','name','prenoms','datenaissance','lieunaissance','genre','nom_fr','niveau_lib','diplomelib','new_diplome','metier_libelle','new_metier','telephone','email')
                        ->join('pays', 'pays.pays_id', '=', 'users.pays_id')
                        ->join('niveauinstruction', 'niveauinstruction.niveau_id', '=', 'users.niveau_id')
                        ->join('diplome', 'diplome.diplome_id', '=', 'users.diplome_id')
                        ->join('metier', 'metier.metier_id', '=', 'users.metier_id')
                        ->where('users.profil_id', '=', 3)
                        ->whereDate('users.created_at', Carbon::today())
                        ->orderBy('users.id', 'DESC');

                $demandeurs = $query->get();

                if($demandeurs->count() > 0){

                    return Excel::download(new DemandeurExport($demandeurs), 'demandeurs.xlsx');

                }else{

                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueJournalieresOffrePub(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){

                $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                            ->join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')       
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where(['offre.offre_statut'=>"PUBLIE"])
                            ->whereDate('users.created_at', Carbon::today())
                            ->orderby('offre.offre_id','DESC');

                $offres = $query->get();

                if($offres->count() > 0){

                    return Excel::download(new OffreExport($offres), 'offrespubliees.xlsx');

                }else{

                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueJournalieresOffreBroui(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){

                $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                            ->join('users','users.id','offre.user_id')
                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                            ->join('metier','metier.metier_id','offre.metier_id')       
                            ->join('diplome','diplome.diplome_id','offre.diplome_id')
                            ->where(['offre.offre_statut'=>"BROUILLON"])
                            ->whereDate('users.created_at', Carbon::today())
                            ->orderby('offre.offre_id','DESC');

                $offres = $query->get();

                if($offres->count() > 0){

                    return Excel::download(new OffreExport($offres), 'offresbrouillons.xlsx');

                }else{

                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    //Exportation des données en pdf de la statistique mensuelles en Excel
    public function ExcelStatistiqueMensuellesEmp(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = User::select('raisonsociale', 'adresse', 'contact', 'name', 'qualite', "contactinterlo", "email", "activite", "secteuractivitelib", "nbrehomme", "nbrfemme", "effectiftotal", "nationalite_lib", "statutentreprise_lib", "ncnss", "situationentreprise_lib", "date_validation")
                    ->join('secteuractivite', 'secteuractivite.secteuractivite_id', '=', 'users.secteuractivite_id')
                    ->join('nationalite', 'nationalite.nationalite_id', '=', 'users.nationalite_id')
                    ->join('region', 'region.region_id', '=', 'users.region_id')
                    ->join('statutentreprise', 'statutentreprise.statutentreprise_id', '=', 'users.statutentreprise_id')
                    ->join('situationentreprise', 'situationentreprise.situationentreprise_id', '=', 'users.situationentreprise_id')
                    ->whereYear('created_at', '=', date('Y'))
                    ->where(['users.profil_id' => 2])
                    ->orderBy('users.id', 'DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new EntrepriseExport($results), 'employeurs.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueMensuellesDemp(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = User::select('identifiant','name','prenoms','datenaissance','lieunaissance','genre','nom_fr','niveau_lib','diplomelib','new_diplome','metier_libelle','new_metier','telephone','email')
                        ->join('pays', 'pays.pays_id', '=', 'users.pays_id')
                        ->join('niveauinstruction', 'niveauinstruction.niveau_id', '=', 'users.niveau_id')
                        ->join('diplome', 'diplome.diplome_id', '=', 'users.diplome_id')
                        ->join('metier', 'metier.metier_id', '=', 'users.metier_id')
                        ->whereYear('created_at', '=', date('Y'))
                        ->where(['users.profil_id' => 3])
                        ->orderBy('users.id', 'DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new DemandeurExport($results), 'demandeurs.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueMensuellesOffrePub(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                        ->join('users','users.id','offre.user_id')
                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                        ->join('metier','metier.metier_id','offre.metier_id')       
                        ->join('diplome','diplome.diplome_id','offre.diplome_id')
                        ->where(['offre.offre_statut'=>"PUBLIE"])
                        ->whereYear('offre_datecrea', '=', date('Y'))
                        ->orderby('offre.offre_id','DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new OffreExport($results), 'offrespubliees.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueMensuellesOffreBroui(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                        ->join('users','users.id','offre.user_id')
                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                        ->join('metier','metier.metier_id','offre.metier_id')       
                        ->join('diplome','diplome.diplome_id','offre.diplome_id')
                        ->where(['offre.offre_statut'=>"BROUILLON"])
                        ->whereYear('offre_datecrea', '=', date('Y'))
                        ->orderby('offre.offre_id','DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new OffreExport($results), 'offresbrouillons.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    //Exportation des données en pdf de la statistique annuelles en Excel
    public function ExcelStatistiqueAnnuellesEmp(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = User::select('raisonsociale', 'adresse', 'contact', 'name', 'qualite', "contactinterlo", "email", "activite", "secteuractivitelib", "nbrehomme", "nbrfemme", "effectiftotal", "nationalite_lib", "statutentreprise_lib", "ncnss", "situationentreprise_lib", "date_validation")
                    ->join('secteuractivite', 'secteuractivite.secteuractivite_id', '=', 'users.secteuractivite_id')
                    ->join('nationalite', 'nationalite.nationalite_id', '=', 'users.nationalite_id')
                    ->join('region', 'region.region_id', '=', 'users.region_id')
                    ->join('statutentreprise', 'statutentreprise.statutentreprise_id', '=', 'users.statutentreprise_id')
                    ->join('situationentreprise', 'situationentreprise.situationentreprise_id', '=', 'users.situationentreprise_id')
                    ->where(['users.profil_id' => 2])
                    ->orderBy('users.id', 'DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new EntrepriseExport($results), 'employeurs.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueAnnuellesDemp(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = User::select('identifiant','name','prenoms','datenaissance','lieunaissance','genre','nom_fr','niveau_lib','diplomelib','new_diplome','metier_libelle','new_metier','telephone','email')
                        ->join('pays', 'pays.pays_id', '=', 'users.pays_id')
                        ->join('niveauinstruction', 'niveauinstruction.niveau_id', '=', 'users.niveau_id')
                        ->join('diplome', 'diplome.diplome_id', '=', 'users.diplome_id')
                        ->join('metier', 'metier.metier_id', '=', 'users.metier_id')
                        ->where(['users.profil_id' => 3])
                        ->orderBy('users.id', 'DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new DemandeurExport($results), 'demandeurs.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueAnnuellesOffrepub(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                        ->join('users','users.id','offre.user_id')
                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                        ->join('metier','metier.metier_id','offre.metier_id')       
                        ->join('diplome','diplome.diplome_id','offre.diplome_id')
                        ->where(['offre.offre_statut'=>"PUBLIE"])
                        ->orderby('offre.offre_id','DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new OffreExport($results), 'offrespubliees.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    public function ExcelStatistiqueAnnuellesOffrebroui(){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")){
                
                $query = Offre::select('raisonsociale','offretitre','metier_libelle','diplomelib','typecontratlib', 'offrenombreposte', 'offre_statut','offre_datefin')
                        ->join('users','users.id','offre.user_id')
                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                        ->join('metier','metier.metier_id','offre.metier_id')       
                        ->join('diplome','diplome.diplome_id','offre.diplome_id')
                        ->where(['offre.offre_statut'=>"BROUILLON"])
                        ->orderby('offre.offre_id','DESC');

                $results = $query->get();

                if ($results->count() > 0) {
                    return Excel::download(new OffreExport($results), 'offresbrouillons.xlsx');
                } else {
                    return back()->with('info_warning', "Il n'y a pas de données à exporter de la base de données");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }    
    }

    //***** GESTION DES LIENS SUR LES PUBLICATION DES FICHIERS ******//

    //Liste des publications de fichiers
    public function ListePublication(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_FICH")){
                
                $libelle        = $request->l;
                $date  = $request->d;

                $whereRaw = ' 1 '; 
            
                if(!empty($libelle)){
                    $whereRaw.= ' AND publication_libelle LIKE "%'.$libelle.'%"';
                }
                if(!empty($date)){
                    $whereRaw.= ' AND publication_datecreation LIKE "%'.$date.'%"';
                }

                $publications = Publication::orderby('publication_id','DESC')->whereRaw($whereRaw)->get();  

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }            

            return view('admin.publication.liste',['publications'=>$publications, 'selected_libelle'=>$libelle, 'selected_date'=>$date]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        } 
    }

    //Save publication de fichiers
    public function SavePublication(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            $rules = [
                'file' => 'required|mimes:docx,pdf,xlsx,xlsm,doc',
                'libelle' => ['required'],
            ];
            
            $customMessages = [
                'file.required' => "Le fichiers est obligatoire",
                'file.mimes' => "La fichier choisi n'est pas valide il doit être de type docx, pdf ou excel",
                'libelle.required' => "Le libellé est obligatoire",
            ];
            
            $this->validate($request,$rules,$customMessages);

            //Authorisation de publication
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PUB_FICH")){
                $publication = new Publication();
                
                $file = $request->file('file');
                $extension = $file->getClientOriginalExtension();
                $filename = time().'.'.$extension;
                $size = $file->getSize();
                $file->move('assets/fichiers/', $filename);   

                $publication->publication_libelle   = ucfirst($request->libelle);
                $publication->publication_fichier   = $filename;
                $publication->publication_extension = $extension;
                $publication->publication_part      = Auth::user()->id;
                $publication->publication_taille    = $size / 1024 / 1024; // Conversion de la taille en Mo
                $publication->publication_datecreation = gmdate('Y-m-d H:i:s');
                $publication->publication_statut    = "VALIDE";
                $publication->save();

                return back()->with('info_succes',"Fichier publié avec succès");
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        } 
    }

    //Save modifier publication de fichiers
    public function ModifierPublication(Request $request, $publication_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PUB_FICH")){

                $publication = Publication::find($publication_id);
                
                if ($publication){

                    $rules = [
                        'file' => 'mimes:docx,pdf,xlsx,xlsm,doc',
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'file.mimes' => "La fichier choisi n'est pas valide il doit être de type docx, pdf ou excel",
                        'libelle.required' => "Le libellé est obligatoire",
                    ];
                    
                    $this->validate($request,$rules,$customMessages);

                    if($request->hasFile('file')){

                        $file = $request->file('file');
                        $extension = $file->getClientOriginalExtension();
                        $filename = Auth::user()->id.time().'.'.$extension;
                        $file->move('assets/fichiers/', $filename);
                        $size = $file->getSize();
                        $publication->publication_fichier = $filename;
                        $publication->publication_extension = $extension;
                        $publication->publication_taille = $size / 1024 / 1024; // Conversion de la taille en Mo
                    }

                    $publication->publication_libelle = ucfirst($request->libelle);
                    $publication->exists = true;
                    $publication->update();

                    return back()->with('info_succes',"Fichier modifié avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        } 
    }

    //supprimer publication de fichiers
    public function SupprimerPublication(Request $request, $publication_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PUB_FICH")){
                
                $publication = Publication::find($publication_id);

                if ($publication){

                    $publication->delete();                
                   
                    return back()->with('info_succes',"Fichier supprimé avec succès");
                }
            
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        } 
    }

    //Activer publication de fichiers
    public function ActiverPublication($publication_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_FICH")){
                
                $publication = Publication::find($publication_id);

                if ($publication){

                    $publication->publication_statut  = "VALIDE";              
                    $publication->exists              = true;
                    $publication->update();                
                   
                    return back()->with('info_succes',"Fichier activé avec succès");
                }
            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        } 
    }

    //Désactiver publication de fichiers
    public function DesactiverPublication($publication_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_FICH")){
                
                $publication = Publication::find($publication_id);

                if ($publication){

                    $publication->publication_statut  = "BROUILLON";              
                    $publication->exists              = true;
                    $publication->update();                
                   
                    return back()->with('info_succes',"Fichier activé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        } 
    }


    //** GESTION DES LIENS SUR LES PARAMETRES DE BASE **//

    //Catégorie Article
    public function CategorieArticle(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $categories = Categorie::orderby('categorie_id','DESC')->get();

                return view('admin.parametrebase.categories',['categories'=>$categories]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Activer une catégorie
    public function ActiverCategorieArticle($categorie_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $categorie = Categorie::find($categorie_id);

                if($categorie){

                    $categorie->categorie_statut = "VALIDE";
                    $categorie->exists = true;
                    $categorie->update();

                    return back()->with('info_succes',"catégorie article activée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver une catégorie
    public function DesactiverCategorieArticle($categorie_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $categorie = Categorie::find($categorie_id);

                if($categorie){
                    
                    $categorie->categorie_statut = "BROUILLON";
                    $categorie->exists = true;
                    $categorie->update();

                    return back()->with('info_succes',"catégorie article desactivée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save catégorie article
    public function SaveCategorieArticle(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé de la catégorie est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $categorie = new Categorie();

                $categorie->categorielib        = ucfirst($request->libelle);
                $categorie->categorie_datecrea  = gmdate('Y-m-d H:i:s');
                $categorie->categorie_statut    = "VALIDE";
                $categorie->save();

                return back()->with('info_succes',"catégorie article ajoutée avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier catégorie article
    public function ModifierCategorieArticle(Request $request, $categorie_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $categorie = Categorie::find($categorie_id);

                if($categorie){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé de la catégorie est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $categorie->categorielib        = ucfirst($request->libelle);
                    $categorie->categorie_datemodif = gmdate('Y-m-d H:i:s');
                    $categorie->save();

                    return back()->with('info_succes',"catégorie article modifiée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier catégorie article
    public function SupprimerCategorieArticle($categorie_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $categorie = Categorie::find($categorie_id);

                if($categorie){
                    
                    $categorie->delete();

                    return back()->with('info_succes',"catégorie article supprimée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Diplôme
    public function Diplomes(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $diplomes = Diplome::orderby('diplome_id','DESC')->get();

                return view('admin.parametrebase.diplomes',['diplomes'=>$diplomes]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save diplôme
    public function SaveDiplome(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé du diplôme est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $diplome = new Diplome();

                $diplome->diplomelib        = ucfirst($request->libelle);
                $diplome->diplome_datecrea  = gmdate('Y-m-d H:i:s');
                $diplome->diplome_statut    = "VALIDE";
                $diplome->save();

                return back()->with('info_succes',"diplôme ajouté avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier diplôme
    public function ModifierDiplome(Request $request, $diplome_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $diplome = Diplome::find($diplome_id);

                if($diplome){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé du diplôme est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $diplome->diplomelib        = ucfirst($request->libelle);
                    $diplome->save();

                    return back()->with('info_succes',"diplôme modifié avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un diplôme
    public function ActiverDiplome($diplome_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $diplome = Diplome::find($diplome_id);

                if($diplome){

                    $diplome->diplome_statut = "VALIDE";
                    $diplome->exists = true;
                    $diplome->update();

                    return back()->with('info_succes',"Diplôme activé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un diplôme
    public function DesactiverDiplome($diplome_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $diplome = Diplome::find($diplome_id);

                if($diplome){
                    
                    $diplome->diplome_statut = "BROUILLON";
                    $diplome->exists = true;
                    $diplome->update();

                    return back()->with('info_succes',"Diplôme desactivé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier diplôme
    public function SupprimerDiplome($diplome_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $diplome = Diplome::find($diplome_id);

                if($diplome){
                    
                    $diplome->delete();

                    return back()->with('info_succes',"Diplôme supprimé avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Secteur d'activité
    public function SecteurActivite(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $secteuractivites = SecteurActivite::orderby('secteuractivite_id','DESC')->get();

                return view('admin.parametrebase.secteuractivite',['secteuractivites'=>$secteuractivites]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save secteur d'activité
    public function SaveSecteurActivite(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé du secteur d'activité est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $secteuractivite = new SecteurActivite();

                $secteuractivite->secteuractivitelib        = Str::upper(Str::ascii($request->libelle));
                $secteuractivite->secteuractivite_datecrea  = gmdate('Y-m-d H:i:s');
                $secteuractivite->secteuractivite_statut    = "VALIDE";
                $secteuractivite->save();

                return back()->with('info_succes',"Secteur d'activité ajouté avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier secteur d'activité
    public function ModifierSecteurActivite(Request $request, $secteuractivite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $secteuractivite = SecteurActivite::find($secteuractivite_id);

                if($secteuractivite){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé du secteur d'activité est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $secteuractivite->secteuractivitelib  = Str::upper(Str::ascii($request->libelle));
                    $secteuractivite->save();

                    return back()->with('info_succes',"Secteur d'activité modifié avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un secteur d'activité
    public function ActiverSecteurActivite($secteuractivite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $secteuractivite = SecteurActivite::find($secteuractivite_id);

                if($secteuractivite){

                    $secteuractivite->secteuractivite_statut = "VALIDE";
                    $secteuractivite->exists = true;
                    $secteuractivite->update();

                    return back()->with('info_succes',"Secteur d'activité activé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un secteur d'activité
    public function DesactiverSecteurActivite($secteuractivite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $secteuractivite = SecteurActivite::find($secteuractivite_id);

                if($secteuractivite){
                    
                    $secteuractivite->secteuractivite_statut = "BROUILLON";
                    $secteuractivite->exists = true;
                    $secteuractivite->update();

                    return back()->with('info_succes',"Secteur d'activité desactivé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier secteur d'activité
    public function SupprimerSecteurActivite($secteuractivite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $secteuractivite = SecteurActivite::find($secteuractivite_id);

                if($secteuractivite){
                    
                    $secteuractivite->delete();

                    return back()->with('info_succes',"Secteur d'activité supprimé avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }   

    //Filières
    public function Filiere(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $metiers = Metier::orderby('metier_id','DESC')->get();

                return view('admin.parametrebase.filiere',['metiers'=>$metiers]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Filières
    public function SaveFiliere(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé de la filière est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $metier = new Metier();

                $metier->metier_libelle        = ucfirst($request->libelle);
                $metier->metier_datecrea  = gmdate('Y-m-d H:i:s');
                $metier->metier_statut    = "VALIDE";
                $metier->save();

                return back()->with('info_succes',"Filière ajoutée avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Filières
    public function ModifierFiliere(Request $request, $metier_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $metier = Metier::find($metier_id);

                if($metier){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé de la filière est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $metier->metier_libelle  = ucfirst($request->libelle);
                    $metier->save();

                    return back()->with('info_succes',"Filière modifiée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Filières
    public function ActiverFiliere($metier_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $metier = Metier::find($metier_id);

                if($metier){

                    $metier->metier_statut = "VALIDE";
                    $metier->exists = true;
                    $metier->update();

                    return back()->with('info_succes',"Filière activée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Filières
    public function DesactiverFiliere($metier_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $metier = Metier::find($metier_id);

                if($metier){
                    
                    $metier->metier_statut = "BROUILLON";
                    $metier->exists = true;
                    $metier->update();

                    return back()->with('info_succes',"Filière desactivée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Filières
    public function SupprimerFiliere($metier_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $metier = Metier::find($metier_id);

                if($metier){
                    
                    $metier->delete();

                    return back()->with('info_succes',"Filière supprimée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Situation Entreprise
    public function SituationActivite(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $situationactivites = SituationActivite::orderby('situationentreprise_id','DESC')->get();

                return view('admin.parametrebase.situationactivite',['situationactivites'=>$situationactivites]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Situation Entreprise
    public function SaveSituationActivite(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé de la situation d'activite est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $situationentreprise = new SituationActivite();

                $situationentreprise->situationentreprise_lib        = Str::upper(Str::ascii($request->libelle));
                $situationentreprise->situationentreprise_datecrea  = gmdate('Y-m-d H:i:s');
                $situationentreprise->situationentreprise_statut    = "VALIDE";
                $situationentreprise->save();

                return back()->with('info_succes',"Situation entreprise ajoutée avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Situation Entreprise
    public function ModifierSituationActivite(Request $request, $situationentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $situationentreprise = SituationActivite::find($situationentreprise_id);

                if($situationentreprise){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé de la situation d'activite est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $situationentreprise->situationentreprise_lib  = Str::upper(Str::ascii($request->libelle));
                    $situationentreprise->save();

                    return back()->with('info_succes',"Situation d'activité modifiée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Situation Entreprise
    public function ActiverSituationActivite($situationentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $situationentreprise = SituationActivite::find($situationentreprise_id);

                if($situationentreprise){

                    $situationentreprise->situationentreprise_statut = "VALIDE";
                    $situationentreprise->exists = true;
                    $situationentreprise->update();

                    return back()->with('info_succes',"Situation d'activité activée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Situation Entreprise
    public function DesactiverSituationActivite($situationentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $situationentreprise = SituationActivite::find($situationentreprise_id);

                if($situationentreprise){
                    
                    $situationentreprise->situationentreprise_statut = "BROUILLON";
                    $situationentreprise->exists = true;
                    $situationentreprise->update();

                    return back()->with('info_succes',"Situation d'activité desactivée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Situation Entreprise
    public function SupprimerSituationActivite($situationentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $situationentreprise = SituationActivite::find($situationentreprise_id);

                if($situationentreprise){
                    
                    $situationentreprise->delete();

                    return back()->with('info_succes',"Situation d'activité supprimée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    } 

    //Statut Entreprise
    public function StatutEntreprise(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $statutentreprises = StatutEntreprise::orderby('statutentreprise_id','DESC')->get();

                return view('admin.parametrebase.statutentreprise',['statutentreprises'=>$statutentreprises]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Statut Entreprise
    public function SaveStatutEntreprise(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé de la situation d'activite est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $statutentreprise = new StatutEntreprise();

                $statutentreprise->statutentreprise_lib        = Str::upper(Str::ascii($request->libelle));
                $statutentreprise->statutentreprise_datecrea  = gmdate('Y-m-d H:i:s');
                $statutentreprise->statutentreprise_statut    = "VALIDE";
                $statutentreprise->save();

                return back()->with('info_succes',"Filière ajouté avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Statut Entreprise
    public function ModifierStatutEntreprise(Request $request, $statutentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $statutentreprise = StatutEntreprise::find($statutentreprise_id);

                if($statutentreprise){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé de la situation d'activite est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $statutentreprise->statutentreprise_lib  = Str::upper(Str::ascii($request->libelle));
                    $statutentreprise->save();

                    return back()->with('info_succes',"Statut entreprise modifié avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Statut Eanuttreprise
    public function ActiverStatutEntreprise($statutentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $statutentreprise = StatutEntreprise::find($statutentreprise_id);

                if($statutentreprise){

                    $statutentreprise->statutentreprise_statut = "VALIDE";
                    $statutentreprise->exists = true;
                    $statutentreprise->update();

                    return back()->with('info_succes',"Statut entreprise activé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Statut utEntreprise
    public function DesactiverStatutEntreprise($statutentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $statutentreprise = StatutEntreprise::find($statutentreprise_id);

                if($statutentreprise){
                    
                    $statutentreprise->statutentreprise_statut = "BROUILLON";
                    $statutentreprise->exists = true;
                    $statutentreprise->update();

                    return back()->with('info_succes',"Statut entreprise desactivé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Statut Entreprise
    public function SupprimerStatutEntreprise($statutentreprise_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $statutentreprise = StatutEntreprise::find($statutentreprise_id);

                if($statutentreprise){
                    
                    $statutentreprise->delete();

                    return back()->with('info_succes',"Statut entreprise supprimé avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }    

    //Statut Entreprise
    public function TypeContrat(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $typecontrats = TypeContrat::orderby('typecontrat_id','DESC')->get();

                return view('admin.parametrebase.typecontrat',['typecontrats'=>$typecontrats]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Statut Entreprise
    public function SaveTypeContrat(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé du type de contrat est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $typecontrat = new TypeContrat();

                $typecontrat->typecontratlib        = ucfirst($request->libelle);
                $typecontrat->typecontrat_datecrea  = gmdate('Y-m-d H:i:s');
                $typecontrat->typecontrat_statut    = "VALIDE";
                $typecontrat->save();

                return back()->with('info_succes',"Type de contrat ajouté avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Statut Entreprise
    public function ModifierTypeContrat(Request $request, $typecontrat_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $typecontrat = TypeContrat::find($typecontrat_id);

                if($typecontrat){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé du type de contrat est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $typecontrat->typecontratlib  = ucfirst($request->libelle);
                    $typecontrat->save();

                    return back()->with('info_succes',"Type de contrat modifié avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Statut Eanuttreprise
    public function ActiverTypeContrat($typecontrat_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $typecontrat = TypeContrat::find($typecontrat_id);

                if($typecontrat){

                    $typecontrat->TypeContrat_statut = "VALIDE";
                    $typecontrat->exists = true;
                    $typecontrat->update();

                    return back()->with('info_succes',"Type de contrat activé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Statut utEntreprise
    public function DesactiverTypeContrat($typecontrat_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $typecontrat = TypeContrat::find($typecontrat_id);

                if($typecontrat){
                    
                    $typecontrat->TypeContrat_statut = "BROUILLON";
                    $typecontrat->exists = true;
                    $typecontrat->update();

                    return back()->with('info_succes',"Type de contrat desactivé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Statut Entreprise
    public function SupprimerTypeContrat($typecontrat_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $typecontrat = TypeContrat::find($typecontrat_id);

                if($typecontrat){
                    
                    $typecontrat->delete();

                    return back()->with('info_succes',"Type de contrat supprimé avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    } 

    //Nationalité Entreprise
    public function Nationalite(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $nationaliteentreprises = Nationalite::orderby('nationalite_id','DESC')->get();

                return view('admin.parametrebase.nationaliteentreprise',['nationaliteentreprises'=>$nationaliteentreprises]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Statut Entreprise
    public function SaveNationalite(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé du type de contrat est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $nationalite = new Nationalite();

                $nationalite->nationalite_lib        = Str::upper(Str::ascii($request->libelle));
                $nationalite->nationalite_datecrea  = gmdate('Y-m-d H:i:s');
                $nationalite->nationalite_statut    = "VALIDE";
                $nationalite->save();

                return back()->with('info_succes',"Filière ajoutée avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Nationalité Entreprise
    public function ModifierNationalite(Request $request, $nationalite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $nationalite = Nationalite::find($nationalite_id);

                if($nationalite){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé du type de contrat est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $nationalite->nationalite_lib  = Str::upper(Str::ascii($request->libelle));
                    $nationalite->save();

                    return back()->with('info_succes',"Nationalité entreprise modifiée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Statut Entreprise
    public function ActiverNationalite($nationalite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $nationalite = Nationalite::find($nationalite_id);

                if($nationalite){

                    $nationalite->nationalite_statut = "VALIDE";
                    $nationalite->exists = true;
                    $nationalite->update();

                    return back()->with('info_succes',"Nationalité entreprise activée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Statut Entreprise
    public function DesactiverNationalite($nationalite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $nationalite = Nationalite::find($nationalite_id);

                if($nationalite){
                    
                    $nationalite->nationalite_statut = "BROUILLON";
                    $nationalite->exists = true;
                    $nationalite->update();

                    return back()->with('info_succes',"Nationalité entreprise desactivée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Nationalité Entreprise
    public function SupprimerNationalite($nationalite_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $nationalite = Nationalite::find($nationalite_id);

                if($nationalite){
                    
                    $nationalite->delete();

                    return back()->with('info_succes',"Nationalité entreprise supprimée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Pays
    public function Pays(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $listepays = Pays::orderby('nom_fr','ASC')->get();

                return view('admin.parametrebase.pays',['listepays'=>$listepays]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Pays
    public function SavePays(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [
                    'libelle' => 'required',
                    'indicatif' => 'required|numeric',
                ];

                $customMessages = [
                    'libelle.required' => "Le libellé du pays est obligatoire",
                    'indicatif.required' => "L'indicatif téléphonique est obligatoire",
                    'indicatif.numeric' => "L'indicatif téléphonique doit être numérique",
                ];


                $this->validate($request,$rules,$customMessages); 

                $pays = new Pays();

                $pays->nom_fr         = ucfirst($request->libelle);
                $pays->indicatif      = htmlspecialchars($request->indicatif);
                $pays->pays_datecrea  = gmdate('Y-m-d H:i:s');
                $pays->pays_statut    = "VALIDE";
                $pays->save();

                return back()->with('info_succes',"Filière ajouté avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Pays
    public function ModifierPays(Request $request, $pays_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $pays = Pays::find($pays_id);

                if($pays){
                    
                    $rules = [
                        'libelle' => 'required',
                        'indicatif' => 'required|numeric',
                    ];

                    $customMessages = [
                        'libelle.required' => "Le libellé du pays est obligatoire",
                        'indicatif.required' => "L'indicatif téléphonique est obligatoire",
                        'indicatif.numeric' => "L'indicatif téléphonique doit être numérique",
                    ];


                    $this->validate($request,$rules,$customMessages); 

                    $pays->nom_fr         = ucfirst($request->libelle);
                    $pays->indicatif      = htmlspecialchars($request->indicatif);
                    $pays->exists         = true;
                    $pays->save();

                    return back()->with('info_succes',"Pays modifié avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Pays
    public function ActiverPays($pays_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $pays = Pays::find($pays_id);

                if($pays){

                    $pays->pays_statut = "VALIDE";
                    $pays->exists = true;
                    $pays->update();

                    return back()->with('info_succes',"Pays activé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Pays
    public function DesactiverPays($pays_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $pays = Pays::find($pays_id);

                if($pays){
                    
                    $pays->pays_statut = "BROUILLON";
                    $pays->exists = true;
                    $pays->update();

                    return back()->with('info_succes',"Pays desactivé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Pays
    public function SupprimerPays($pays_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $pays = Pays::find($pays_id);

                if($pays){
                    
                    $pays->delete();

                    return back()->with('info_succes',"Pays supprimé avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }  

    //Region
    public function Region(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $regions = Region::orderby('region_id','DESC')->get();

                return view('admin.parametrebase.region',['regions'=>$regions]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Region
    public function SaveRegion(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'couleur' => ['required'],
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'couleur.required' => "La couleur de fond est obligatoire",
                    'libelle.required' => "Le libellé du type de contrat est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $region = new Region();

                $region->region_nom        = Str::upper(Str::ascii($request->libelle));
                $region->region_couleur = htmlspecialchars($request->couleur);
                $region->region_datecrea  = gmdate('Y-m-d H:i:s');
                $region->region_statut    = "VALIDE";
                $region->save();

                return back()->with('info_succes',"Filière ajouté avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Region
    public function ModifierRegion(Request $request, $region_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $region = Region::find($region_id);

                if($region){
                    
                    $rules = [                   
                        'couleur' => ['required'],
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'couleur.required' => "La couleur de fond est obligatoire",
                        'libelle.required' => "Le libellé du type de contrat est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $region->region_nom  = Str::upper(Str::ascii($request->libelle));
                    $region->region_couleur = htmlspecialchars($request->couleur);
                    $region->save();

                    return back()->with('info_succes',"Region modifié avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer une Region
    public function ActiverRegion($region_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $region = Region::find($region_id);

                if($region){

                    $region->region_statut = "VALIDE";
                    $region->exists = true;
                    $region->update();

                    return back()->with('info_succes',"Region activé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver une Region
    public function DesactiverRegion($region_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $region = Region::find($region_id);

                if($region){
                    
                    $region->region_statut = "BROUILLON";
                    $region->exists = true;
                    $region->update();

                    return back()->with('info_succes',"Region desactivé avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Region
    public function SupprimerRegion($region_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $region = Region::find($region_id);

                if($region){
                    
                    $region->delete();

                    return back()->with('info_succes',"Region supprimé avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }  

    //Langue Locale
    public function LangueLocale(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $languelocales = LangueLocale::orderby('languelocal_id','DESC')->get();

                return view('admin.parametrebase.languelocale',['languelocales'=>$languelocales]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Statut Langue Locale
    public function SaveLangueLocale(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé du type de contrat est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $languelocale = new LangueLocale();

                $languelocale->languelocal_lib        = ucfirst($request->libelle);
                $languelocale->languelocal_datecrea  = gmdate('Y-m-d H:i:s');
                $languelocale->languelocal_statut    = "VALIDE";
                $languelocale->save();

                return back()->with('info_succes',"Filière ajoutée avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Langue Locale
    public function ModifierLangueLocale(Request $request, $languelocal_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $languelocale = LangueLocale::find($languelocal_id);

                if($languelocale){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé du type de contrat est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $languelocale->languelocal_lib  = ucfirst($request->libelle);
                    $languelocale->save();

                    return back()->with('info_succes',"Langue locale modifiée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Statut Langue Locale
    public function ActiverLangueLocale($languelocal_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $languelocale = LangueLocale::find($languelocal_id);

                if($languelocale){

                    $languelocale->languelocal_statut = "VALIDE";
                    $languelocale->exists = true;
                    $languelocale->update();

                    return back()->with('info_succes',"Langue locale activée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Statut Langue Locale
    public function DesactiverLangueLocale($languelocal_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $languelocale = LangueLocale::find($languelocal_id);

                if($languelocale){
                    
                    $languelocale->languelocal_statut = "BROUILLON";
                    $languelocale->exists = true;
                    $languelocale->update();

                    return back()->with('info_succes',"Langue locale desactivée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Langue Locale
    public function SupprimerLangueLocale($languelocal_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $languelocale = LangueLocale::find($languelocal_id);

                if($languelocale){
                    
                    $languelocale->delete();

                    return back()->with('info_succes',"Langue locale supprimée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }   

    //Langue internationale
    public function LangueInternationale(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $langueinters = LangueInternationale::orderby('langueinter_id','DESC')->get();

                return view('admin.parametrebase.langueinter',['langueinters'=>$langueinters]);

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }  
    }

    //Save Statut Langue internationale
    public function SaveLangueInternationale(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $rules = [                   
                    'libelle' => ['required'],
                ];
                
                $customMessages = [
                    'libelle.required' => "Le libellé du type de contrat est obligatoire",
                ];

                $this->validate($request,$rules,$customMessages); 

                $langueinter = new LangueInternationale();

                $langueinter->langueinter_lib        = ucfirst($request->libelle);
                $langueinter->langueinter_datecrea  = gmdate('Y-m-d H:i:s');
                $langueinter->langueinter_statut    = "VALIDE";
                $langueinter->save();

                return back()->with('info_succes',"Filière ajoutée avec succès");

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Modifier Langue internationale
    public function ModifierLangueInternationale(Request $request, $langueinter_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $langueinter = LangueInternationale::find($langueinter_id);

                if($langueinter){
                    
                    $rules = [                   
                        'libelle' => ['required'],
                    ];
                    
                    $customMessages = [
                        'libelle.required' => "Le libellé du type de contrat est obligatoire",
                    ];

                    $this->validate($request,$rules,$customMessages); 

                    $langueinter->langueinter_lib  = ucfirst($request->libelle);
                    $langueinter->save();

                    return back()->with('info_succes',"Langue internationale modifiée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Activer un Statut Langue internationale
    public function ActiverLangueInternationale($langueinter_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $langueinter = LangueInternationale::find($langueinter_id);

                if($langueinter){

                    $langueinter->langueinter_statut = "VALIDE";
                    $langueinter->exists = true;
                    $langueinter->update();

                    return back()->with('info_succes',"Langue internationale activée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Désctiver un Statut Langue internationale
    public function DesactiverLangueInternationale($langueinter_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){

                $langueinter = LangueInternationale::find($langueinter_id);

                if($langueinter){
                    
                    $langueinter->langueinter_statut = "BROUILLON";
                    $langueinter->exists = true;
                    $langueinter->update();

                    return back()->with('info_succes',"Langue internationale desactivée avec succès");
                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }        
    }

    //Save Modifier Langue internationale
    public function SupprimerLangueInternationale($langueinter_id){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")){
                
                $langueinter = LangueInternationale::find($langueinter_id);

                if($langueinter){
                    
                    $langueinter->delete();

                    return back()->with('info_succes',"Langue internationale supprimée avec succès");

                }

            }else{

                return back()->with('info_warning',"Vous n'avez pas d'accès");
            }
        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }  

    //** GESTION DES LIENS SUR LE MON COMPTE **//

    //Mon compte 
    public function CompteAdmin(){

        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            $utilisateur = User::where(['users.id'=>Auth::user()->id])->first();

            $regions = Region::where(['region.region_id'=>Auth::user()->region_id])->get();

            $region = Region::where(['region.region_id'=>Auth::user()->region_id])->first();

            $action_autorisees = ActionAutorisee::join('action','action.action_id','action_autorisee.action_id')->where(['action_autorisee.user_id'=>$utilisateur->id, 'action_autorisee_statut'=>"VALIDE"])->get();

            return view('admin.moncompte',['utilisateur'=>$utilisateur, 'regions'=>$regions, 'region'=>$region, 'action_autorisees'=>$action_autorisees]);
        }  
    }

    //Modifier compte admin/agent
    public function SaveAdminModifierCompte(Request $request){
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){

            $utilisateur = User::where(['users.id'=>Auth::user()->id])->first();

            if($utilisateur->profil_id == 4){
                $rules = [                   
                    'profil_photo' => ['mimes:png,jpg,jpeg'],
                    'region_id' => ['required'],
                    'qualite' => ['required'],
                    'civilite' => ['required'],
                    'prenoms' => ['required'],
                    'nom' => ['required'],
                ];
                
                $customMessages = [
                    'profil_photo.mimes' => "La photo de profil doit être de type : png, jpg, jpeg",
                    'region_id.required' => "La région est obligatoire",
                    'qualite.required' => "Le type d'agent est obligatoire",
                    'civilite.required' => "La civilité est obligatoire",
                    'prenoms.required' => "Le prénoms est obligatoire",
                    'nom.required' => "Le nom est obligatoire",
                ];
            }

            if($utilisateur->profil_id == 1){
                $rules = [                   
                    'profil_photo' => ['mimes:png,jpg,jpeg'],
                    'qualite' => ['required'],
                    'civilite' => ['required'],
                    'prenoms' => ['required'],
                    'nom' => ['required'],
                ];
                
                $customMessages = [
                    'profil_photo.mimes' => "La photo de profil doit être de type : png, jpg, jpeg",
                    'qualite.required' => "Le type d'agent est obligatoire",
                    'civilite.required' => "La civilité est obligatoire",
                    'prenoms.required' => "Le prénoms est obligatoire",
                    'nom.required' => "Le nom est obligatoire",
                ];
            }
        
            $this->validate($request,$rules,$customMessages);            
            
            if($utilisateur->profil_id == 4){  

                // Upload Image de Profile
                if($request->hasFile('profil_photo')){

                    $FileNamePhoto = time().'.'.request()->profil_photo->getClientOriginalExtension();
                    request()->profil_photo->move(public_path('assets/img/profil'), $FileNamePhoto);

                }
                if($request->profil_photo !=null){

                    $utilisateur->profil_photo = $FileNamePhoto ?? NULL;
                }             

                $utilisateur->region_id   = $request->region_id;
                $utilisateur->name        = Str::upper(Str::ascii($request->nom));
                $utilisateur->prenoms     = Str::upper(Str::ascii($request->prenoms));
                $utilisateur->civilite    = htmlspecialchars($request->civilite);
                $utilisateur->qualite     = Str::upper(Str::ascii($request->qualite));
                $utilisateur->exists      = true;
                $utilisateur->update();

                return back()->with('info_succes',"Compte mis à jours avec succès");
            }

            if($utilisateur->profil_id == 1){  

                // Upload Image de Profile
                if($request->hasFile('profil_photo')){

                    $FileNamePhoto = time().'.'.request()->profil_photo->getClientOriginalExtension();
                    request()->profil_photo->move(public_path('assets/img/profil'), $FileNamePhoto);

                }
                if($request->profil_photo !=null){

                    $utilisateur->profil_photo = $FileNamePhoto ?? NULL;
                }             

                $utilisateur->name        = Str::upper(Str::ascii($request->nom));
                $utilisateur->prenoms     = Str::upper(Str::ascii($request->prenoms));
                $utilisateur->civilite    = htmlspecialchars($request->civilite);
                $utilisateur->qualite     = Str::upper(Str::ascii($request->qualite));
                $utilisateur->exists      = true;
                $utilisateur->update();

                return back()->with('info_succes',"Compte mis à jours avec succès");
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save modifier mot de passe
    public function SaveAdminModifierMotePasse(Request $request){
        
        if(Auth::user()->role_id == 1 && Auth::user()->user_statut =="VALIDE"){
            
            $rules = [
                'new_password' => 'required|confirmed|min:6|string',
                'current_password' => 'required|string',
            ];
            
            $customMessages = [   
                'new_password.required' => "Le nouveau mot de passe est obligatoire",            
                'new_password.confirmed' => "La confirmation du mot de passe n'est pas conforme au nouveau mot de passe", 
                'new_password.min' =>"Veuillez saisir un mot de passe de plus de 5 caratères",             
                'current_password.required'=>"Le mot de passe actuel est obligatoire",
            ];
            
            $this->validate($request,$rules,$customMessages);
            
            $auth = Auth::user();

            // Les mots de passe correspondent
            if (!Hash::check($request->get('current_password'), $auth->password)) 
            {
                return back()->with('error', "Le mot de passe actuel n'est pas correct");
            }

            // Mot de passe actuel et nouveau mot de passe identiques
            if (strcmp($request->get('current_password'), $request->new_password) == 0) 
            {
                return redirect()->back()->with("error", "Le nouveau mot de passe n'est pas le même que votre mot de passe actuel.");
            }

            $utilisateur =  User::find($auth->id);
            
            $utilisateur->password = Hash::make($request->new_password);
            $utilisateur->save();
            
            return back()->with('success', "Le mot de passe a été changé avec succès");
            
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }
    }
}
