<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use App\Models\TrancheAge;
use App\Models\EmployeurActivite;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;
use Illuminate\Http\RedirectResponse;
use Twilio\Rest\Client;
use Auth;
use DB;
use Mail; 

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */ 

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        $profil_id = $data['code'];

        $messages = [
            'required' => 'Le champ :attribute est obligatoire.',
            'string' => 'Le champ :attribute doit être une chaîne de caractères.',
            'max' => [
                'string' => 'Le champ :attribute ne doit pas dépasser :max caractères.',
            ],
            'email' => 'Le champ :attribute doit être une adresse e-mail valide.',
            'unique' => 'La valeur du champ :attribute est déjà utilisée.',
            'min' => [
                'string' => 'Le champ :attribute doit contenir au moins :min caractères.',
            ],
            'confirmed' => 'Le champ :attribute ne correspond pas à sa confirmation.',
        ];
        
        if($profil_id == 3){
            return Validator::make($data, [
                'nom' => ['required', 'string', 'max:255'],
                'genre' => ['required', 'string', 'max:255'],
                'telephone' => 'required|string|max:20|unique:users',
                'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                'password' => ['required', 'string'],
            ], $messages);
        }

        if($profil_id == 2){

            return Validator::make($data, [
                'nom' => ['required', 'string', 'max:255'],
                'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                'contactinterlo' => 'required|string|max:20|unique:users',
                'raisonsociale' => ['required', 'string'],
                'adresse' => ['required', 'string', 'max:255'],
                'contact' => ['required', 'numeric'],
                'qualite' => ['required', 'string'],
                'password' => ['required', 'string'],
            ], $messages);
        }
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
    protected function create(array $data)
    {   
        //Récupération de l'ID du profil
        $profil_id = $data['code'];

        if($profil_id == 3){

            $dateNaissance = \Carbon\Carbon::createFromFormat('Y-m-d', $data['datenaissance']);
            $dateJours = \Carbon\Carbon::createFromFormat('Y-m-d', gmdate('Y-m-d'));
            $anneeNaissance = $dateNaissance->year;
            $anneeJours = $dateJours->year;
            $age = $anneeJours - $anneeNaissance;

            $trancheage = DB::table('trancheage')
                            ->where('trancheage_deb', '<=', $age)
                            ->where('trancheage_fin', '>=', $age)
                            ->first();

            // Email data
            $email_data = array(
                'nom' => $data['nom'],
                'prenoms' => $data['prenoms'],
                'email' => $data['email'],
                'motdepasse' => $data['password'],
                'anneencours'=>gmdate('Y'),

            );
            
            //Envoie des paramètres du mail
            Mail::send('emails.register_cand', $email_data, function ($message) use ($email_data){
            $message->to($email_data['email'] ,$email_data['nom'] ,$email_data['prenoms'])
                ->subject("Votre inscription à l'ANPE")
                ->from('fabrice.koffi@cjdgroupe.com' ,"ANPE");
            });

            if(request()->hasFile('profil_photo')){

                $PhotoName = time().'.'.request()->profil_photo->getClientOriginalExtension();
                $destinationPath = public_path('assets/img');
                request()->profil_photo->move($destinationPath, $PhotoName);
                $resizedImagePath = public_path('assets/img/profil');
                $resizedPhotoName = 'resized_'.$PhotoName;
                $resizedImage = Image::make($destinationPath.'/'.$PhotoName)->fit(110, 110);
                $resizedImage->save($resizedImagePath.'/'.$resizedPhotoName);
            }

            if(request()->hasfile('pieceidentite')){
                $PieceCNIName = time().'.'.request()->pieceidentite->getClientOriginalExtension();
                request()->pieceidentite->move(public_path('assets/img/profil/documents/'), $PieceCNIName);
            }

            if(request()->hasfile('pieceetranger')){
                $PieceEtrangerName = time().'.'.request()->pieceetranger->getClientOriginalExtension();
                request()->pieceetranger->move(public_path('assets/img/profil/documents/'), $PieceEtrangerName);
            }
            
			
            return User::create([
                'profil_id' => $profil_id,
                'name' => $data['nom'],
                'genre' => $data['genre'],
                'prenoms' => $data['prenoms'],
                'email' => $data['email'],
                'telephone' => $data['telephone'],
                'metier_id'=> $data['metier_id'],
                'diplome_id'=> $data['diplome_id'],                
                'pays_id'=> $data['pays_id'],
                'region_id'=> $data['region_id'],
                'catepro_id'=> $data['catepro_id'],
                'situation_id'=> $data['situation_id'],
                'niveau_id'=> $data['niveau_id'],
                'langueinter_id'=> $data['langueinter_id'],
                'languelocal_id'=> $data['languelocal_id'],                           
                'trancheage_id'=> $trancheage->trancheage_id,
                'datenaissance'=> $data['datenaissance'],
                'lieunaissance'=> $data['lieunaissance'],
                'departement'=> $data['departement'],
                'situationmatrimoniale'=> $data['stituationmatrimoniale'],
                'handicap'=> $data['handicap'],
                'nombreenfant'=> $data['nombreenfant'],
                'emploisouhaite'=>$data['emploisouhaite'],
                'new_diplome'=> $data['new_diplome'],
                'new_metier'=> $data['new_metier'],
                'new_languelocal'=> $data['new_languelocal'],
                'new_langueinter'=> $data['new_langueinter'],
                'type_handicap'=> $data['type_handicap'],
                'experience'=>$data['experience'],
                'user_origine'=>'En ligne',
                'profil_photo' => $resizedPhotoName ?? NULL,
                'user_cni' => $PieceCNIName ?? NULL,
                'user_dpc' => $PieceEtrangerName ?? NULL,
                'password' => Hash::make($data['password']),
            ]);
        }

        if($profil_id == 2){

            //Email data 
            $email_data = array(
                'raisonsociale' => $data['raisonsociale'],
                'email' => $data['email'],
                'motdepasse' => $data['password'],
                'anneencours'=>gmdate('Y'),
            );
            
            //Envoie des paramètres du mail
            Mail::send('emails.register_emp', $email_data, function ($message) use ($email_data){
            $message->to($email_data['email'] ,$email_data['raisonsociale'])
                ->subject("Votre inscription à l'ANPE")
                ->from('fabrice.koffi@cjdgroupe.com' ,"ANPE");
            });

            if(request()->hasFile('entreprise_logo')){

                $LogoName = time().'.'.request()->entreprise_logo->getClientOriginalExtension();
                $destinationPath = public_path('assets/img');
                request()->entreprise_logo->move($destinationPath, $LogoName);
                $resizedImagePath = public_path('assets/img/entreprise');
                $resizedLogoName = 'resized_'.$LogoName;
                $resizedImage = Image::make($destinationPath.'/'.$LogoName)->fit(100, 100);
                $resizedImage->save($resizedImagePath.'/'.$resizedLogoName);
            }
            return User::create([
                'profil_id'=> $profil_id,
                'name'=> $data['nom'],
                'email'=> $data['email'],
                'raisonsociale'=> html_entity_decode($data['raisonsociale'], ENT_QUOTES, 'UTF-8'),
                'adresse'=> html_entity_decode($data['adresse'], ENT_QUOTES, 'UTF-8'),
                'user_origine'=>'En ligne',
                'contact'=> $data['contact'],
                'contactinterlo'=> $data['contactinterlo'],
                'qualite'=> $data['qualite'],
                'contact'=> $data['contact'],
                'nbrehomme'=> $data['nbrehomme'],
                'nbrfemme'=> $data['nbrfemme'],
                'activite'=> $data['activite'],
                'adresse'=> $data['adresse'],
                'region_id'=> $data['region_id'],
                'nationalite_id'=> $data['nationalite_id'],
                'secteuractivite_id'=> $data['secteuractivite_id'],
                'statutentreprise_id'=> $data['statutentreprise_id'],
                'situationentreprise_id'=> $data['situationentreprise_id'],   
                'ncnss'=> $data['ncnss'],
                'effectiftotal'=>$data['nbrehomme'] + $data['nbrfemme'],
                'entreprise_logo' => $resizedLogoName ?? NULL,
                'password' => Hash::make($data['password']),
            ]);

        }
        
    }
}