<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use Password;
use Auth;
use Hash;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords; 

    /**
     * Where to redirect users after resetting their password.
     *
     * @var string
     */

    public function reset(Request $request)
    {
        /*$request->validate([
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:6',
        ]);*/

        $rules = [
            'token' => 'required',
            'email' => 'required|email',
            'password' => 'required|confirmed|min:6',
        ];
        
        $customMessages = [   
            'token.required' => "Le jeton est obligatoire",                   
            'email.required' => "L'adresse email est obligatoire",                   
            'email.email' => "L'adresse email fournit n'est pas valide",                   
            'password.required'=>"Le mot de passe est obligatoire",
            'password.confirmed'=>"La confirmation du mot de passe n'est pas conforme au mot de passe",
        ];

        $this->validate($request,$rules,$customMessages);

        $credentials = $request->only(
            'email', 'password', 'password_confirmation', 'token'
        );

        $response = $this->broker()->reset(
            $credentials, function ($user, $password) {
                $this->resetPassword($user, $password);
            }
        );

        if ($response == Password::PASSWORD_RESET) {
            return redirect($this->redirectPath())
                ->with('status', trans($response));
        }

        return back()->withErrors(
            ['email' => [trans($response)]]
        );
    }

    protected function resetPassword($user, $password)
    {
        $user->password = Hash::make($password);

        $user->save();

        Auth::login($user);
    }

    protected function broker()
    {
        return Password::broker('users');
    }

    //protected $redirectTo = RouteServiceProvider::HOME;
}

