<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\NewsLetter;
use App\Mail\ContactMail;
use Mail;

class ContactController extends Controller
{
    //Page de contact
    public function Contact(){
        return view('contact');
    }

    //Save NewsLetter
    public function SendContact(Request $request){

        $rules = [
            'message' => ['required'],
            'email' => ['required', 'string', 'email'],
            'nomprenoms' => ['required',],
        ];
        
        $customMessages = [
            'email.required' => "L'adresse email est obligatoire",
            'email.email' => "L'adresse email n'est pas valide",
            'nomprenoms.required' => "Le nom et prénoms est obligatoire",
            'message.required' => "Le message est obligatoire",
        ];

        $this->validate($request,$rules,$customMessages);

        // Récupération des paramètres du mail du client
        $email_data = array(
            'email' => $request->email,
            'name' => $request->nomprenoms,
            'anneencours'=>gmdate('Y'),
        );

        // Envoie des paramètres du mail au client
        Mail::send('emails.contact-email', $email_data, function ($message) use ($email_data){
        $message->to($email_data['email'])
            ->subject("Merci de vous avoir contacté")
            ->from('info@anpe-niger.ne', "AGENCE NATIONALE POUR LA PROMOTION DE L'EMPLOI");
        });

        $contact_data = [
            'email' => $request->email, 
            'name' => $request->nomprenoms,
            'message' => $request->message,
            'adresse_ip'=> $_SERVER['REMOTE_ADDR'],
            'anneencours'=>gmdate('Y'),
        ];
        Mail::to('info@anpe-niger.ne')->send(new ContactMail($contact_data));

        return back()->with('info_succes',"Message envoyé avec succès !");

    }
}
