<?php

namespace App\Http\Controllers\DemandeurEmploi;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\Region;
use App\Models\SecteurActivite;
use App\Models\Nationalite;
use App\Models\SituationActivite;
use App\Models\StatutEntreprise;
use App\Models\User;
use App\Models\Offre;
use App\Models\Diplome;
use App\Models\TypeContrat;
use App\Models\TempsTravail;
use App\Models\Candidature;
use App\Models\TypeInscription;
use App\Models\Metier;
use App\Models\TrancheAge;
use App\Models\LangueInternationale;
use App\Models\LangueLocale;
use App\Models\CategorieProfessionelle;
use App\Models\NiveauInstruction;
use App\Models\TypeDemandeur;
use App\Models\Pays;
use App\Models\CentreInteretLangue;
use App\Models\ExperienceProfessionnelle;
use App\Models\Formation;
use App\Models\Specialite;
use App\Mail\ReinitialiserCarteMail;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Auth;
use DB;
use Mail;  
use PDF;

class DemandeurEmploiController extends Controller
{

    public function __construct(){

        $this->middleware('auth');
    }

    //Liste des candidatures en attente
    public function MesCandidatureAttente(){
        if(Auth::user()->profil_id == 3 && Auth::user()->user_statut =="VALIDE"){
            
            $offres = Offre::join('candidature','candidature.offre_id','offre.offre_id')
                            ->join('users','users.id','offre.user_id')
                            ->where(['candidature.user_id'=>Auth::user()->id, 'candidature_statut'=>"BROUILLON"])
                            ->orderby('candidature_id','DESC')
                            ->get();

            return view('demandeur.candidature.candidaturesattente',['offres'=>$offres]);

        }else{
            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        }        
    }

    //Liste des candidatures validées
    public function MesCandidatureValide(){
        if(Auth::user()->profil_id == 3 && Auth::user()->user_statut =="VALIDE"){
            
            $offres = Offre::join('candidature','candidature.offre_id','offre.offre_id')
                            ->join('users','users.id','offre.user_id')
                            ->where(['candidature.user_id'=>Auth::user()->id, 'candidature_statut'=>"VALIDE"])
                            ->orderby('candidature_id','DESC')
                            ->get();

            return view('demandeur.candidature.candidaturesvalidees',['offres'=>$offres]);

        }else{
            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        }        
    }

    //Liste des candidatures approuvées
    public function MesCandidatureApprouve(){
        if(Auth::user()->profil_id == 3 && Auth::user()->user_statut =="VALIDE"){
            
            $offres = Offre::join('candidature','candidature.offre_id','offre.offre_id')
                            ->join('users','users.id','offre.user_id')
                            ->where(['candidature.user_id'=>Auth::user()->id, 'candidature_statut'=>"APPROUVE"])
                            ->orderby('candidature_id','DESC')
                            ->get();

            return view('demandeur.candidature.candidaturesapprouvees',['offres'=>$offres]);

        }else{
            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        }        
    }

    //Mon CV
    public function MonCV(){
        if(Auth::user()->profil_id == 3){

            return view('demandeur.moncv.moncv');

        }else{
            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Formulaire de nouveau cv
    public function CreerNouveauCV(){
        if(Auth::user()->profil_id == 3){

            $formations = Formation::where(['formation.user_id'=>Auth::user()->id])->orderby('formation_id','DESC')->get(); 

            $experiencepro = ExperienceProfessionnelle::where(['experiencepro.user_id'=>Auth::user()->id])->orderby('experiencepro_id','DESC')->get();            
            
            $specialites = Specialite::where(['specialite.user_id'=>Auth::user()->id])->orderby('specialite_id','DESC')->get();            
            
            $centreinterets = CentreInteretLangue::where(['centreint_langue.user_id'=>Auth::user()->id])->orderby('centreint_langue_id','DESC')->get();            

            return view('demandeur.moncv.nouveaucv',['formations'=>$formations, 'experiencepro'=>$experiencepro, 'specialites'=>$specialites, 'centreinterets'=>$centreinterets]);

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save des formations
    public function SaveFormation(Request $request){
        if(Auth::user()->profil_id == 3){

            // Récupérer les données envoyées par le formulaire
            $diplomes       = array_filter($request->diplomes);
            $institutions   = array_filter($request->institutions);
            $annescolaires  = array_filter($request->annescolaires);

            //dd($diplomes, $request->diplomes);

            // Boucler à travers les données pour les insérer dans la table "formation"
            for ($i = 0; $i < count($diplomes); $i++) {

                $formation = new Formation(); // Créer une nouvelle instance de modèle "Formation"

                $formation->user_id = Auth::user()->id;
                $formation->formation_diplome = $diplomes[$i];
                $formation->formation_institution = $institutions[$i];
                $formation->formation_annescolaire = $annescolaires[$i];
                $formation->formation_datecreation = now(); // Ajouter la date de création actuelle
                $formation->save();
            }

            return back()->with('info_succes', 'Formations enregistrées avec succès !');

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save modification de la formation
    public function SaveModifierFormation(Request $request, $formation_id){
        if(Auth::user()->profil_id == 3){

            $formation = Formation::find($formation_id);

            if($formation){

                $formation->formation_diplome      = html_entity_decode($request->diplome);
                $formation->formation_institution  = html_entity_decode($request->institution);
                $formation->formation_annescolaire = html_entity_decode($request->annescolaire);
                $formation->exists                 = true;
                $formation->update();

                return back()->with('info_succes', 'Formation modifiée avec succès !');
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Supprimer une formation
    public function SupprimerFormation($formation_id){
        if(Auth::user()->profil_id == 3){

            $formation = Formation::find($formation_id);

            if($formation){

                $formation->delete();

                return back()->with('info_succes',"Formation supprimée avec succès !");
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save des expériences professionnelles
    public function SaveExperienceProfessionnelle(Request $request){
        if(Auth::user()->profil_id == 3){

            // Récupérer les données envoyées par le formulaire
            $titres       = array_filter($request->titres);
            $durees   = array_filter($request->durees);
            $entreprises  = array_filter($request->entreprises);
            $competences  = array_filter($request->competences);

            //dd($titres, $durees, $entreprises, $competences);

            // Boucler à travers les données pour les insérer dans la table "expérience professionnelle"
            for ($i = 0; $i < count($titres); $i++) {

                $experiencepro = new ExperienceProfessionnelle(); // Créer une nouvelle instance de modèle "ExperienceProfessionnelle"

                $experiencepro->user_id = Auth::user()->id;
                $experiencepro->experiencepro_titre = $titres[$i];
                $experiencepro->experiencepro_duree = $durees[$i];
                $experiencepro->experiencepro_entreprise = $entreprises[$i];
                $experiencepro->experiencepro_competence = $competences[$i];
                $experiencepro->experiencepro_datecreation = now(); // Ajouter la date de création actuelle
                $experiencepro->save();
            }

            return back()->with('info_succes', 'Expériences Professionnelles enregistrées avec succès !');

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save modification d'expérience professionnelle
    public function SaveModifierExperienceProfessionnelle(Request $request, $experiencepro_id){
        if(Auth::user()->profil_id == 3){

            $experiencepro = ExperienceProfessionnelle::find($experiencepro_id);

            if($experiencepro){

                $experiencepro->experiencepro_titre      = html_entity_decode($request->titre);
                $experiencepro->experiencepro_duree  = html_entity_decode($request->duree);
                $experiencepro->experiencepro_entreprise = html_entity_decode($request->entreprise);
                $experiencepro->experiencepro_competence = html_entity_decode($request->competence);
                $experiencepro->exists                 = true;
                $experiencepro->update();

                return back()->with('info_succes', 'Expérience Professionnelle modifiée avec succès !');
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Supprimer une expérience professionnelle
    public function SupprimerExperienceProfessionnelle($experiencepro_id){
        if(Auth::user()->profil_id == 3){

            $experiencepro = ExperienceProfessionnelle::find($experiencepro_id);

            if($experiencepro){

                $experiencepro->delete();

                return back()->with('info_succes',"Expérience Professionnelle supprimée avec succès !");
            }

        }else{ 

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save des spécialités
    public function SaveSpecialite(Request $request){
        if(Auth::user()->profil_id == 3){

            // Récupérer les données envoyées par le formulaire
            $intitules = array_filter($request->intitules);

            //dd($intitules);

            // Boucler à travers les données pour les insérer dans la table "spécialité"
            for ($i = 0; $i < count($intitules); $i++) {

                $specialte = new Specialite(); // Créer une nouvelle instance de modèle "Specialite"

                $specialte->user_id = Auth::user()->id;
                $specialte->specialite_intitule = $intitules[$i];
                $specialte->specialite_datecreation = now(); // Ajouter la date de création actuelle
                $specialte->save();
            }

            return back()->with('info_succes', 'Spécialités enregistrées avec succès !');

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save modification de la spécialité
    public function SaveModifierSpecialite(Request $request, $specialite_id){
        if(Auth::user()->profil_id == 3){

            $specialte = Specialite::find($specialite_id);

            if($specialte){

                $specialte->specialite_intitule    = html_entity_decode($request->intitule);
                $specialte->exists                 = true;
                $specialte->update();

                return back()->with('info_succes', 'Spécialité modifiée avec succès !');
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Supprimer une spécialité
    public function SupprimerSpecialite($specialite_id){
        if(Auth::user()->profil_id == 3){

            $specialte = Specialite::find($specialite_id);

            if($specialte){

                $specialte->delete();

                return back()->with('info_succes',"Spécialité supprimée avec succès !");
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save des centres d'intérêts
    public function SaveCentreInteret(Request $request){
        if(Auth::user()->profil_id == 3){

            // Récupérer les données envoyées par le formulaire
            $centreinterets = array_filter($request->centreinterets);

            //dd($centreinterets);

            // Boucler à travers les données pour les insérer dans la table "centre d'intérêt"
            for ($i = 0; $i < count($centreinterets); $i++) {

                $centreinteret = new CentreInteretLangue(); // Créer une nouvelle instance de modèle "CentreInteretLangue"

                $centreinteret->user_id = Auth::user()->id;
                $centreinteret->centreint_langue_intitule = $centreinterets[$i];
                $centreinteret->centreint_langue_datecreation = now(); // Ajouter la date de création actuelle
                $centreinteret->save();
            }

            return back()->with('info_succes', "Centre d'intérêt enregistrés avec succès !");

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Save modification de la centre d'intérêt
    public function SaveModifierCentreInteret(Request $request, $centreint_langue_id){
        if(Auth::user()->profil_id == 3){

            $centreinteret = CentreInteretLangue::find($centreint_langue_id);

            if($centreinteret){
                
                $centreinteret->centreint_langue_intitule    = html_entity_decode($request->centreinteret);
                $centreinteret->exists                 = true;
                $centreinteret->update();

                return back()->with('info_succes', "Centre d'intérêt modifié avec succès !");
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Supprimer une centre d'intérêt
    public function SupprimerCentreInteret($centreint_langue_id){
        if(Auth::user()->profil_id == 3){

            $centreinteret = CentreInteretLangue::find($centreint_langue_id);

            if($centreinteret){

                $centreinteret->delete();

                return back()->with('info_succes',"Centre d'intérêt supprimé avec succès !");
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Générer son CV en PDF
    public function GenererCV(Request $request){        
        if(Auth::user()->profil_id == 3){

            $user = User::where(['id'=>Auth::user()->id])->first();

            if($user){              

                $telephone2  = $request->telephone2;
                $age         = $request->age;
                $fonction    = $request->fonction;
                $situation   = $request->situation;

                if($request->hasFile('file')){
                    //Upload de la photo pour le CV
                    $file = $request->file('file');   
                    $ext = $file->getClientOriginalExtension();
                    $filename = time().'.'.$ext;
                    $file->move('assets/img/profil/',$filename);
                    $user->photo_cv = $filename;

                    $user->exists           = true;
                    $user->update();
                }

                $formations = Formation::where(['formation.user_id'=>Auth::user()->id])->orderby('formation_id','DESC')->get(); 

                $experiencepro = ExperienceProfessionnelle::where(['experiencepro.user_id'=>Auth::user()->id])->orderby('experiencepro_id','DESC')->get();            
                
                $specialites = Specialite::where(['specialite.user_id'=>Auth::user()->id])->orderby('specialite_id','DESC')->get();            
                
                $centreinterets = CentreInteretLangue::where(['centreint_langue.user_id'=>Auth::user()->id])->orderby('centreint_langue_id','DESC')->get(); 
                
                $url = $request->root();

                $image_cv = $url."/assets/img/profil/".Auth::user()->profil_photo;
                $photo_cv = $url."/assets/img/profil/".Auth::user()->photo_cv;

                // L'instance PDF avec la vue
                $pdf = PDF::loadView('demandeur.moncv.imprimercv',compact('user', 'formations', 'experiencepro', 'specialites', 'centreinterets', 'image_cv','photo_cv','situation','fonction','telephone2', 'age'));

                // Lancement du téléchargement du fichier PDF
                $cv_name = time().$user->id.\Str::slug($user->name).".pdf";
                $pdf->download($cv_name);

                $user->user_cv = $cv_name;
                $user->exists   = true;
                $user->update();

                //pour enregistrer le fichier PDF
                $pdf->save(public_path("assets/img/profil/documents/".$cv_name));

                return redirect()->route('demandeur.moncv')->with('info_succes',"CV généré avec succès !");
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Mes candidatures
    public function MonCompteCandidate(){

        if(Auth::user()->profil_id == 3){

            $user = User::where(['users.id'=>Auth::user()->id])->first();

            $paysliste = Pays::orderby('nom_fr','ASC')->get();

            $regions = Region::orderby('region_nom','ASC')->get();

            $filieres = Metier::get();

            $langueinter = LangueInternationale::get();

            $categories = CategorieProfessionelle::orderby('catepro_lib','ASC')->get();

            $niveaux = NiveauInstruction::orderby('niveau_lib','ASC')->get();

            $typedemandeurs = TypeDemandeur::orderby('situation_lib','ASC')->get();

            $diplomes = Diplome::get();

            $languelocale = LangueLocale::get();

            $diplome = Diplome::where(['diplome_id'=>$user->diplome_id])->first();

            $metier = Metier::where(['metier_id'=>$user->metier_id])->first();

            $pays = Pays::where(['pays_id'=>$user->pays_id])->first();

            $region = Region::where(['region_id'=>$user->region_id])->first();

            $categoriepro = CategorieProfessionelle::where(['catepro_id'=>$user->catepro_id])->first();

            $typedemandeur = TypeDemandeur::where(['situation_id'=>$user->situation_id])->first();
            
            $niveauintruction = NiveauInstruction::where(['niveau_id'=>$user->niveau_id])->first();

            $langueinterp = LangueInternationale::where(['langueinter_id'=>$user->langueinter_id])->first();

            $languelocalep = LangueLocale::where(['languelocal_id'=>$user->languelocal_id])->first();

            $datesources = Carbon::now()->subYears(10);
    
            return view('demandeur.moncompte',['user'=>$user, 'diplome'=>$diplome, 'pays'=>$pays, 'metier'=>$metier, 'paysliste'=>$paysliste, 'regions'=>$regions, 'filieres'=>$filieres, 'datesources'=>$datesources, 'langueinter'=>$langueinter, 'languelocale'=>$languelocale, 'diplomes'=>$diplomes, 'categories'=>$categories, 'niveaux'=>$niveaux, 'typedemandeur'=>$typedemandeur, 'typedemandeurs'=>$typedemandeurs, 'region'=>$region, 'categoriepro'=>$categoriepro, 'typedemandeur'=>$typedemandeur, 'niveauintruction'=>$niveauintruction, 'langueinterp'=>$langueinterp, 'languelocalep'=>$languelocalep]);

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Modifier le compte demandeur
    public function SaveModifierCompteCandidate(Request $request, $id){
        if(Auth::user()->profil_id == 3){

            $user = User::find($id);
            
            if($user){

                $rules = [                   
                    'niveau_id' => ['required'],
                    'languelocal_id' => ['required'],
                    'emploisouhaite' => ['required'],
                    'situation_id' => ['required'],
                    'catepro_id' => ['required'],
                    'diplome_id' => ['required'],
                    'metier_id' => ['required'],
                    'region_id' => ['required'],
                    'experience' => ['required'],
                    'pays_id' => ['required'],
                    'nombreenfant' => ['required'],
                    'handicap' => ['required'],
                    'stituationmatrimoniale' => ['required'],
                    'genre' => ['required'],
                    'lieunaissance' => ['required'],
                    'datenaissance' => ['required'],
                    'prenoms' => ['required'],
                    'nom' => ['required'],
                ];
                
                $customMessages = [
                    'languelocal_id.required' => "Langue LangueInternationale est obligatoire",
                    'emploisouhaite.required' => "L'emploi souhaité est obligatoire",
                    'situation_id.required' => "Le type de demandeur est obligatoire",
                    'experience.required' => "L'année d'expérience est obligatoire",
                    'niveau_id.required' => "Le niveau d'insctruction est obligatoire",
                    'catepro_id.required' => "La catégorie professionelle est obligatoire",
                    'diplome_id.required' => "diplôme est obligatoire",
                    'metier_id.required' => "La filière est obligatoire",
                    'pays_id.required' => "La nationalité est obligatoire",
                    'region_id.required' => "La région est obligatoire",
                    'nombreenfant.required' => "Le nombre d'enfant est obligatoire",
                    'handicap.required' => "La réponse à la question de l'handicap est obligatoire",
                    'stituationmatrimoniale.required' => "La stituation matrimoniale est obligatoire",
                    'genre.required' => "Le genre est obligatoire",
                    'lieunaissance.required' => "Le lieu de naissance est obligatoire",
                    'datenaissance.required' => "La date de naissance est obligatoire",
                    'prenoms.required' => "Le prénoms est obligatoire",
                    'nom.required' => "Le nom est obligatoire",
                ];  

                $pays = Pays::where(['pays_id'=>$request->pays_id])->first();
                if($pays->pays_id == 127){
                    $rules = [                   
                        'pieceidentite' => 'mimes:png,jpg,jpeg,pdf', 
                    ];    
                    $customMessages = [
                        'pieceidentite.mimes' => "La pièce d'identité n'est pas valide il doit être de type png, jpg, jpeg, pdf",
                    ];
                }else{
                    $rules = [                   
                        'pieceetranger' => 'mimes:png,jpg,jpeg,pdf', 
                    ];    
                    $customMessages = [
                        'pieceetranger.mimes' => "La pièce étrangère n'est pas valide il doit être de type png, jpg, jpeg, pdf",
                    ];
                }

                $this->validate($request,$rules,$customMessages);

                 // Upload CNI / Passport / Nationalité / Permis de séjours / Ressortissant CEDEAO / CV
                if($request->hasFile('user_profil'))
                {
                    $file = $request->file('user_profil');
                    $extension = $file->getClientOriginalExtension();
                    $filephoto = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/', $filephoto);
                    $user->profil_photo = $filephoto;
                }

                if($request->hasFile('pieceidentite'))
                {
                    $file = $request->file('pieceidentite');
                    $extension = $file->getClientOriginalExtension();
                    $filecni = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/documents/', $filecni);
                    $user->user_cni = $filecni;
                }

                if($request->hasFile('pieceetranger'))
                {
                    $file = $request->file('pieceetranger');
                    $extension = $file->getClientOriginalExtension();
                    $fileentranger = Auth::user()->id.time().'.'.$extension;
                    $file->move('assets/img/profil/documents/', $fileentranger);
                    $user->user_dpc = $fileentranger;
                }

                $dateNaissance = \Carbon\Carbon::createFromFormat('Y-m-d', $request->datenaissance);
                $dateJours = \Carbon\Carbon::createFromFormat('Y-m-d', gmdate('Y-m-d'));
                $anneeNaissance = $dateNaissance->year;
                $anneeJours = $dateJours->year;
                $age = $anneeJours - $anneeNaissance;

                $trancheage = DB::table('trancheage')
                                ->where('trancheage_deb', '<=', $age)
                                ->where('trancheage_fin', '>=', $age)
                                ->first();                
            
                $user->metier_id               = $request->metier_id;
                $user->diplome_id              = $request->diplome_id;
                $user->catepro_id              = $request->catepro_id;
                $user->niveau_id               = $request->niveau_id;
                $user->situation_id            = $request->situation_id;
                $user->languelocal_id          = $request->languelocal_id;
                $user->langueinter_id          = $request->langueinter_id;
                $user->typeinscription_id      = $request->typeinscription_id;
                $user->trancheage_id           = $request->trancheage_id;
                $user->region_id               = $request->region_id;
                $user->pays_id                 = $request->pays_id;
                $user->nombreenfant            = htmlspecialchars($request->nombreenfant);
                $user->handicap                = htmlspecialchars($request->handicap);
                $user->situationmatrimoniale   = htmlspecialchars($request->stituationmatrimoniale);
                $user->genre                   = htmlspecialchars($request->genre);
                $user->lieunaissance           = Str::upper(Str::ascii($request->lieunaissance));
                $user->datenaissance           = htmlspecialchars($request->datenaissance);
                $user->prenoms                 = Str::upper(Str::ascii($request->prenoms));
                $user->name                    = Str::upper(Str::ascii($request->nom));
                $user->departement             = Str::upper(Str::ascii($request->departement));
                $user->commune                 = Str::upper(Str::ascii($request->commune));
                $user->village_quart           = Str::upper(Str::ascii($request->village_quart));
                $user->type_handicap           = Str::upper(Str::ascii($request->type_handicap));
                $user->new_diplome             = Str::upper(Str::ascii($request->new_diplome));
                $user->new_metier              = Str::upper(Str::ascii($request->new_metier));
                $user->new_languelocal         = Str::upper(Str::ascii($request->new_languelocal));
                $user->new_langueinter         = Str::upper(Str::ascii($request->new_langueinter));
                $user->emploisouhaite          = htmlspecialchars($request->emploisouhaite, ENT_QUOTES, 'UTF-8');
                $user->experience              = htmlspecialchars($request->experience, ENT_QUOTES, 'UTF-8');
                $user->exists                  = true;
                $user->update();

                return back()->with('info_succes',"Compte mis à jours avec succès");
            }

        }else{

            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        }
    }

    //Save modifier mot de passe
    public function SaveModifierMotePasse(Request $request){
        
        if(Auth::user()->profil_id == 3){
            
            $rules = [
                'new_password' => 'required|confirmed|min:6|string',
                'current_password' => 'required|string',
            ];
            
            $customMessages = [   
                'new_password.required' => "Le nouveau mot de passe est obligatoire",            
                'new_password.confirmed' => "La confirmation du mot de passe n'est pas conforme au nouveau mot de passe", 
                'new_password.min' =>"Veuillez saisir un mot de passe de plus de 5 caratères",             
                'current_password.required'=>"Le mot de passe actuel est obligatoire",
            ];
            
            $this->validate($request,$rules,$customMessages);
            
            $auth = Auth::user();

            // Les mots de passe correspondent
            if (!Hash::check($request->get('current_password'), $auth->password)) 
            {
                return back()->with('error', "Le mot de passe actuel n'est pas correct");
            }

            // Mot de passe actuel et nouveau mot de passe identiques
            if (strcmp($request->get('current_password'), $request->new_password) == 0) 
            {
                return redirect()->back()->with("error", "Le nouveau mot de passe n'est pas le même que votre mot de passe actuel.");
            }

            $user = User::find($auth->id);
            
            $user->password = Hash::make($request->new_password);
            $user->save();
            
            return back()->with('success', "Le mot de passe a été changé avec succès");
            
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");

        }
    }

    //Demande de réinitialisation de la carte
    public function DemandeReinitialisationCarte($id){
        if(Auth::user()->profil_id == 3 && Auth::user()->user_statut =="VALIDE"){

            $user = User::find($id);

            $url = $request->root();

            if($user){

                $user->user_statut = "BROUILLON";
                $user->user_carte_statut = "BROUILLON";
                $user->user_carte = NULL;
                $user->exists = true;
                $user->update();

                // Email data
                $email_data = array(
                    'nom' => $user->name,
                    'prenoms' => $user->prenoms,
                    'email' => $user->email,
                    'anneencours'=>gmdate('Y'),
                );
                
                //Envoie des paramètres du mail
                Mail::send('emails.reinitialisercarteanpe', $email_data, function ($message) use ($email_data){
                $message->to($email_data['email'] ,$email_data['nom'])
                    ->subject("Votre demande de renouvellement de la carte en cours de traitement")
                    ->from('fabrice.koffi@cjdgroupe.com' ,"AGENCE NATIONALE POUR LA PROMOTION DE L'EMPLOI");
                });

                $contact_data = [
                    'email' => $user->email,
                    'name' => $user->name,
                    'prenoms' => $user->prenoms,
                    'datevalidationcarte' => $user->date_validation,
                    'anneencours'=>gmdate('Y'),
                ];

                Mail::to('fabrice.koffi@cjdgroupe.com')->send(new ReinitialiserCarteMail($contact_data));

                return redirect()->route('home')->with('info_succes',"Votre demande de renouvellement de la carte en cours de traitement");
            }

        }else{
            return back()->with('info_error',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        } 
    }

    //Détails du compte
    public function DetailsDemandeur($id){

        if(Auth::user()->profil_id == 3){
        
            $user = User::find($id); 

            if($user){

                $diplome = Diplome::where(['diplome_id'=>$user->diplome_id])->first();

                $metier = Metier::where(['metier_id'=>$user->metier_id])->first();

                $candidatures = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->where(['candidature.user_id'=>$user->id, 'candidature.candidature_statut'=>"VALIDE"])
                                            ->orderby('candidature_id','DESC')
                                            ->get();
                                            
                $contrats = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->where(['candidature.user_id'=>$user->id, 'candidature.candidature_statut'=>"APPROUVE"])
                                            ->orderby('candidature_id','DESC')
                                            ->get();

                return view('demandeur.details',['user'=>$user, 'diplome'=>$diplome,'metier'=>$metier, 'candidatures'=>$candidatures, 'contrats'=>$contrats]);
            }
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        }
    }

    //Qrcode lien
    public function QrCodeLien(Request $request, $id){

        if(Auth::user()->profil_id == 1 or Auth::user()->profil_id == 2 or Auth::user()->profil_id == 3 or Auth::user()->profil_id == 4 && Auth::user()->user_statut =="VALIDE"){
            
            $demandeur = User::find($id);

            if($demandeur){

                $diplome = Diplome::where(['diplome_id'=>$demandeur->diplome_id])->first();
                $metier = Metier::where(['metier_id'=>$demandeur->metier_id])->first();
                $pays = Pays::where(['pays_id'=>$demandeur->pays_id])->first();
                $region = Region::where(['region_id'=>$demandeur->region_id])->first();
                $categoriepro = CategorieProfessionelle::where(['catepro_id'=>$demandeur->catepro_id])->first();
                $typedemandeur = TypeDemandeur::where(['situation_id'=>$demandeur->situation_id])->first();                
                $niveauintruction = NiveauInstruction::where(['niveau_id'=>$demandeur->niveau_id])->first();
                $langueinter = LangueInternationale::where(['langueinter_id'=>$demandeur->langueinter_id])->first();
                $languelocale = LangueLocale::where(['languelocal_id'=>$demandeur->languelocal_id])->first();
                $formations = Formation::where(['formation.user_id'=>$demandeur->id])->orderby('formation_id','DESC')->get();
                $experiencepro = ExperienceProfessionnelle::where(['experiencepro.user_id'=>$demandeur->id])->orderby('experiencepro_id','DESC')->get();
                $specialites = Specialite::where(['specialite.user_id'=>$demandeur->id])->orderby('specialite_id','DESC')->get();
                $centreint_langue = CentreInteretLangue::where(['centreint_langue.user_id'=>$demandeur->id])->orderby('centreint_langue_id','DESC')->get();

                $candidatures = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                            ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                                            ->join('users','users.id','candidature.user_id')
                                            ->where(['candidature.user_id'=>$demandeur->id, 'candidature.candidature_statut'=>"VALIDE"])
                                            ->orderby('candidature_id','DESC')
                                            ->get();

                return view('demandeur.qrcodelien',['demandeur'=>$demandeur, 'candidatures'=>$candidatures, 'formations'=>$formations, 'experiencepro'=>$experiencepro, 'specialites'=>$specialites, 'centreint_langue'=>$centreint_langue, 'diplome'=>$diplome, 'metier'=>$metier, 'pays'=>$pays, 'region'=>$region, 'categoriepro'=>$categoriepro, 'typedemandeur'=>$typedemandeur, 'niveauintruction'=>$niveauintruction, 'langueinter'=>$langueinter, 'languelocale'=>$languelocale]);
            }

        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        }
    }

    //Consulter ma carte
    public function MaCarte(Request $request){

        if(Auth::user()->profil_id == 3){
        
            return view('demandeur.macarte');
        
        }else{

            return back()->with('info_warning',"Vous n'avez pas de droit d'accès à cette page pour compte non activé !!!");
        }
    }
}
