<?php

namespace App\Http\Controllers\Entreprise;

use App\Http\Controllers\Controller; 
use Illuminate\Http\Request;
use Auth;
use Mail;
use App\Models\Region;
use App\Models\SecteurActivite;
use App\Models\Nationalite;
use App\Models\SituationActivite;
use App\Models\StatutEntreprise;
use App\Models\User;
use App\Models\Offre;
use App\Models\OffreRegion;
use App\Models\Diplome;
use App\Models\CentreInteretLangue;
use App\Models\ExperienceProfessionnelle;
use App\Models\Formation;
use App\Models\Specialite;
use App\Models\TypeContrat;
use App\Models\Candidature;
use App\Models\Metier; 
use App\Models\CvTheque;
use DB;

class EntrepriseController extends Controller
{
    public function __construct(){

        $this->middleware('auth');
    } 

	// Liste des offres publiées
    public function GestionOffre(){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $offres = Offre::where(['user_id'=>Auth::user()->id])
                            ->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')
                            ->orderby('offre_id','DESC')
                            ->get();

            $nombreoffre = $offres->count();

            return view('entreprise.offre.gestionoffre',['offres'=>$offres, 'nombreoffre'=>$nombreoffre]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }    
    }

    // Liste des offres expirées
    public function GestionOffreExpiree(){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $offres = Offre::where(['user_id'=>Auth::user()->id])
                            ->whereRaw('date(offre_datefin) <= "'.gmdate("Y-m-d").'" ')
                            ->orderby('offre_id','DESC')
                            ->get();

            $nombreoffre = $offres->count();

            return view('entreprise.offre.gestionoffreexpire',['offres'=>$offres, 'nombreoffre'=>$nombreoffre]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }    
    }

    // Formulaire de publication d'offre
    public function PublierOffre(){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $regions = Region::orderby('region_nom','ASC')->get();

            $typecontrat = TypeContrat::orderby('typecontratlib','ASC')->get();

            $diplomes = Diplome::orderby('diplomelib','ASC')->get();

            $metiers = Metier::orderby('metier_libelle','ASC')->get();

            return view('entreprise.offre.publieroffre',['regions'=>$regions, 'typecontrat'=>$typecontrat, 'diplomes'=>$diplomes, 'metiers'=>$metiers]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }    
    }

    // Save publier offre
    public function SavePublierOffre(Request $request){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            if(Auth::user()->user_statut == "VALIDE"){                

                $rules = [
                    'titre' => 'required',
                    'description' => 'required',
                    'typecontrat_id' => 'required',
                    'diplome_id' => 'required',
                    'metier_id' => 'required',
                    'datefin' => 'required',
                    'nombreposte' => 'required|numeric',
                ];
                
                $customMessages = [
                    'titre.required' => 'Le titre est obligatoire',
                    'description.required' => 'La description est obligatoire',
                    'typecontrat_id.required' => 'Le type de contrat est obligatoire',
                    'diplome_id.required' => 'Le diplôme est obligatoire',
                    'metier_id.required' => 'Le métier est obligatoire',
                    'nombreposte.required' => 'Le nombre de poste est obligatoire',
                    'nombreposte.numeric' => 'Le nombre de poste est en numérique',
                    'datefin.required' => 'La date de fin est obligatoire',
                ];

                if($request->soumission == "PAR MAIL"){
                    $rules = [
                        'liensoumission' => 'required|email',
                    ];
                    
                    $customMessages = [
                        'liensoumission.required' => 'Le mail de soumission est obligatoire',
                        'liensoumission.email' => 'Le mail de soumission n\'est pas valide',
                    ];
                }
                if($request->soumission == "LIEN SITE WEB"){
                    $rules = [
                        'liensoumission' => 'required|url',
                    ];
                    
                    $customMessages = [
                        'liensoumission.required' => 'Le lien de soumission est obligatoire',
                        'liensoumission.url' => 'Le lien de soumission n\'est pas valide',
                    ];
                }
                
                $this->validate($request,$rules,$customMessages);

                $regions = array_filter($request->region_ids);

                $offre = new Offre();   

                $offre->user_id                  = Auth::user()->id;
                $offre->metier_id                = $request->metier_id;
                $offre->typecontrat_id           = $request->typecontrat_id;
                $offre->diplome_id               = $request->diplome_id;
                $offre->offretitre               = html_entity_decode($request->titre);
                $offre->offredescription         = htmlspecialchars($request->description);
                $offre->offrenombreposte         = htmlspecialchars($request->nombreposte);
                $offre->offre_anneeexperience    = html_entity_decode($request->annexperience);
                $offre->offre_mission            = htmlspecialchars($request->mission);
                $offre->offre_profil             = htmlspecialchars($request->profil);
                $offre->offre_dossier            = htmlspecialchars($request->dossier);
                $offre->offre_datefin            = htmlspecialchars($request->datefin);
                $offre->offre_soumission         = htmlspecialchars($request->soumission);
                $offre->offre_liensoumission     = htmlspecialchars($request->liensoumission);
                $offre->offre_datecrea           = gmdate('Y-m-d H:i:s');
                $offre->save();

                foreach($regions as $region){

                    $offre_region = new OffreRegion();

                    $offre_region->offre_id                  = $offre->offre_id;
                    $offre_region->region_id                 = $region;
                    $offre_region->offre_region_datecreation = gmdate('Y-m-d H:i:s');
                    $offre_region->save();

                }

                return back()->with('info_succes','Offre publié avec succès !');

            }else{

                return back()->with('info_error',"Vous ne pouvez pas publier d'offre pour l'instant car l'ANPE n'a pas encore validé votre compte");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès  à cette page!!!");
        }     
    }

    // Modifier une offre 
    public function ModifierOffre($offre_id){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $offre = Offre::where(['offre_id'=>$offre_id])->first();

            $regions = Region::orderby('region_nom','ASC')->get();

            $typecontrat = TypeContrat::orderby('typecontratlib','ASC')->get();

            $diplomes = Diplome::orderby('diplomelib','ASC')->get();

            $metiers = Metier::orderby('metier_libelle','ASC')->get();
                
            return view('entreprise.offre.modifieroffre',['offre'=>$offre, 'regions'=>$regions, 'typecontrat'=>$typecontrat, 'diplomes'=>$diplomes, 'metiers'=>$metiers]);
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save modifier offre
    public function SaveModifierOffre(Request $request, $offre_id){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $offre = Offre::find($offre_id);
            
            if($offre){

                $regions = array_filter($request->region_ids);
                
                $rules = [
                    'titre' => 'required',
                    'description' => 'required',
                    'typecontrat_id' => 'required',
                    'diplome_id' => 'required',
                    'metier_id' => 'required',
                    'datefin' => 'required',
                    'nombreposte' => 'required|numeric',
                ];
                
                $customMessages = [
                    'titre.required' => 'Le titre est obligatoire',
                    'description.required' => 'La description est obligatoire',
                    'typecontrat_id.required' => 'Le type de contrat est obligatoire',
                    'diplome_id.required' => 'Le diplôme est obligatoire',
                    'metier_id.required' => 'Le métier est obligatoire',
                    'nombreposte.required' => 'Le nombre de poste est obligatoire',
                    'nombreposte.numeric' => 'Le nombre de poste est en numérique',
                    'datefin.required' => 'La date de fin est obligatoire',
                ];

                if($request->soumission == "PAR MAIL"){
                    $rules = [
                        'liensoumission' => 'email',
                    ];
                    
                    $customMessages = [
                        'liensoumission.email' => 'Le mail de soumission n\'est pas valide',
                    ];
                }
                if($request->soumission == "LIEN SITE WEB"){
                    $rules = [
                        'liensoumission' => 'url',
                    ];
                    
                    $customMessages = [
                        'liensoumission.url' => 'Le lien de soumission n\'est pas valide',
                    ];
                }
                
                $this->validate($request,$rules,$customMessages);

                $offre->metier_id                = $request->metier_id;
                $offre->typecontrat_id           = $request->typecontrat_id;
                $offre->diplome_id               = $request->diplome_id;                
                $offre->offretitre               = html_entity_decode($request->titre);
                $offre->offredescription         = htmlspecialchars($request->description);
                $offre->offrenombreposte         = htmlspecialchars($request->nombreposte);
                $offre->offre_anneeexperience    = html_entity_decode($request->annexperience);
                $offre->offre_mission            = htmlspecialchars($request->mission);
                $offre->offre_profil             = htmlspecialchars($request->profil);
                $offre->offre_dossier            = htmlspecialchars($request->dossier);
                $offre->offre_datefin            = htmlspecialchars($request->datefin);
                $offre->offre_soumission         = htmlspecialchars($request->soumission);
                if($request->liensoumission !=null and $request->liensoumission !=""){
                    $offre->offre_liensoumission     = htmlspecialchars($request->liensoumission);
                }
                $offre->offre_datecrea           = gmdate('Y-m-d H:i:s');
                $offre->exists                   = true;
                $offre->update();

                return back()->with('info_succes','Offre modifiée avec succès !');
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }  
    }

    //Détails de l'offre
    public function DetailsdesOffre($offre_id){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){
            $offre = Offre::find($offre_id);

            if($offre){                

                $candidatures = Candidature::join('users','users.id','candidature.user_id')
                                            ->where(['candidature.offre_id'=>$offre->offre_id,'candidature_statut'=>"VALIDE"])
                                            ->get();

                return view('entreprise.offre.detailsoffre',['offre'=>$offre, 'candidatures'=>$candidatures]);
                
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Détails de l'offre expirée
    public function DetailsdesOffreExpiree($offre_id){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){
            $offre = Offre::find($offre_id);

            if($offre){                

                $candidatures = Candidature::join('users','users.id','candidature.user_id')
                                            ->where(['candidature.offre_id'=>$offre->offre_id])
                                            ->get();

                return view('entreprise.offre.detailsoffreexpiree',['offre'=>$offre, 'candidatures'=>$candidatures]);
                
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    // Save relancer offre à une date de clôture
    public function RelancerOffreNouveau(Request $request, $offre_id){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $offre = Offre::find($offre_id);
            
            if($offre){

                $offre->offre_datefin = htmlspecialchars($request->datefin);
                $offre->offre_statut = "BROUILLON";
                $offre->exists = true;
                $offre->update();

                return back()->with('info_succes',"Offre relancée avec succès !");
            }

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas d'accès à cette page !!!");
        }
    }
    
    // Supprimer une offre 
    public function SupprimerOffre($offre_id){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){    
            $offre = Offre::find($offre_id);
            
            if($offre){
                
                $offre->delete();
            
                return back()->with('info_succes','Offre supprimée avec succès !');
            }

        }else{
            
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Liste des demandes d'emploi 
    public function ListeCandidature(){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $candidats = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                ->join('users','users.id','candidature.user_id')
                                ->where(['offre.user_id'=>Auth::user()->id])
                                ->orderby('candidature_id','DESC')
                                ->get();
                                
            return view('entreprise.candidature.listecandidature',['candidats'=>$candidats]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Liste des demandes d'emploi 
    public function ListeCandidatureaValider(){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $candidats = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                ->join('users','users.id','candidature.user_id')
                                ->where(['offre.user_id'=>Auth::user()->id, 'candidature_statut'=>"VALIDE"])
                                ->orderby('candidature_id','DESC')
                                ->get();
                                
            return view('entreprise.candidature.candidatureavalider',['candidats'=>$candidats]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez d'accès à cette page");
        }
    }

    //Liste des candidatures approuveés
    public function ListeCandidatureApprouvee(){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $candidats = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                ->join('users','users.id','candidature.user_id')
                                ->where(['offre.user_id'=>Auth::user()->id, 'candidature_statut'=>"APPROUVE"])
                                ->orderby('candidature_id','DESC')
                                ->get();

            return view('entreprise.candidature.listecandidatureapprouvee',['candidats'=>$candidats]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Formulaire de validation de la candidature
    public function ValiderCandidature($candidature_id){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){ 

            $candidature = Candidature::find($candidature_id);

            if($candidature){
                
                $typecontrats = TypeContrat::orderby('typecontratlib','ASC')->get();

                return view('entreprise.candidature.validercandidature',['candidature'=>$candidature, 'typecontrats'=>$typecontrats]);
                
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Formulaire de validation de la candidature
    public function SaveValiderCandidature(Request $request, $candidature_id){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $candidature = Candidature::find($candidature_id);

            //Récupération de l'offre en rélation avec la candidature
            $offre = Offre::where(['offre.offre_id'=>$candidature->offre_id])->first();

            //Récupération du candidat
            $user = User::where(['users.id'=>$candidature->user_id])->first();

            $typecontrat = TypeContrat::where(['typecontrat.typecontrat_id'=>$request->typecontrat_id])->first();

            $typecontrat_cand = TypeContrat::where(['typecontrat.typecontrat_id'=>$candidature->typecontrat_id])->first();

            $nombre_decrement = 1;

            if($candidature){

                if($request->typecontrat_id == null){
                    $candidature->typecontrat_id            = $typecontrat_cand->typecontrat_id;
                }else{
                    $candidature->typecontrat_id            = $request->typecontrat_id;
                }
                $candidature->candidature_statut        = "APPROUVE";
                $candidature->candidature_datecontrat   = gmdate('Y-m-d H:i:s');
                if($request->datedebut != null and $request->datefin != null){
                    $candidature->candidature_datedebcrt    = htmlspecialchars($request->datedebut);
                    $candidature->candidature_datefincrt    = htmlspecialchars($request->datefin);
                }                
                $candidature->exists                    = true;
                $candidature->update();

                if($typecontrat == null){

                    $email_data = array(
                        'nom' => $user->name,
                        'prenoms' => $user->prenoms,
                        'email' => $user->email,
                        'offretitre' => $offre->offretitre,
                        'typecontrat' => $typecontrat_cand->typecontratlib,
                    );

                }else{

                    $email_data = array(
                        'nom' => $user->name,
                        'prenoms' => $user->prenoms,
                        'email' => $user->email,
                        'offretitre' => $offre->offretitre,
                        'typecontrat' => $typecontrat->typecontratlib,
                    );
                }

                // Envoie des paramètres du mail au client
                Mail::send('emails.validercandidature', $email_data, function ($message) use ($email_data){
                $message->to($email_data['email'])
                    ->subject("Merci de vous avoir abonné à notre newsletter")
                    ->from('fabrice.koffi@cjdgroupe.com', "AGENCE NATIONALE POUR LA PROMOTION DE L'EMPLOI");
                });

                //Actualisation du nombre de poste
                if($offre){

                    $offre->offrenombreposte = $offre->offrenombreposte - $nombre_decrement;
                    $offre->exists = true;
                    $offre->update();
                }  
            }
        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Détails candidat
    public function DetailsCandidat($candidature_id){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $candidature = Candidature::find($candidature_id);

            $user = User::where(['users.id'=>$candidature->user_id])->first();

            $typecontrats = TypeContrat::orderby('typecontratlib','ASC')->get();

            return view('entreprise.candidature.detailscandidat',['candidature'=>$candidature, 'user'=>$user, 'typecontrats'=>$typecontrats]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Détails candidat approuvé
    public function DetailsCandidatApprouve($candidature_id){
        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $candidature = Candidature::find($candidature_id);

            $user = User::where(['users.id'=>$candidature->user_id])->first();

            $diplome = Diplome::where(['diplome_id'=>$user->diplome_id])->first();

            $metier = Metier::where(['metier_id'=>$user->metier_id])->first();

            return view('entreprise.candidature.detailscandidatapprouvee',['candidature'=>$candidature, 'user'=>$user, 'diplome'=>$diplome, 'metier'=>$metier]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        } 
    }

    //Compte Employeur
    public function CompteEntreprise(){
        if(Auth::user()->profil_id == 2){

            $user = User::where(['users.id'=>Auth::user()->id])->first();

            $regions = Region::orderby('region_nom','ASC')->get();

            $statuts = StatutEntreprise::get();

            $activites = SecteurActivite::orderby('secteuractivitelib','ASC')->get();

            $situations = SituationActivite::get();

            $nationalites = Nationalite::get();

            $nationalite = Nationalite::where(['nationalite.nationalite_id'=>$user->nationalite_id])->first();

            $secteuractivite = SecteurActivite::where(['secteuractivite.secteuractivite_id'=>$user->secteuractivite_id])->first();

            $situationentreprise = SituationActivite::where(['situationentreprise.situationentreprise_id'=>$user->situationentreprise_id])->first();
            
            $statutentreprise = StatutEntreprise::where(['statutentreprise.statutentreprise_id'=>$user->statutentreprise_id])->first();
            
            $region = Region::where(['region.region_id'=>$user->region_id])->first();

            return view('entreprise.moncompte',['user'=>$user,'regions'=>$regions, 'statuts'=>$statuts, 'activites'=>$activites, 'nationalites'=>$nationalites, 'situations'=>$situations, 'nationalite'=>$nationalite, 'secteuractivite'=>$secteuractivite, 'situationentreprise'=>$situationentreprise, 'statutentreprise'=>$statutentreprise, 'region'=>$region]);

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save modifier compte    
    public function EditComptEntreprise(Request $request){
        if(Auth::user()->profil_id == 2){

            $rules = [
                'situationentreprise_id' => ['required'],
                'ncnss' => ['required'],
                'statutentreprise_id' => ['required'],
                'secteuractivite_id' => ['required'],
                'region_id' => ['required'],
                'nationalite_id' => ['required'],
                'activite' => ['required'],
                'nbrfemme' => ['required'],
                'nbrehomme' => ['required'],
                'qualite' => ['required', 'string', 'max:255'],
                'contact' => ['required'],
                'adresse' => ['required', 'string', 'max:255'],
                'raisonsociale' => ['required'],
                'nom' => ['required', 'string', 'max:255'],
            ];
            
            $customMessages = [
                'raisonsociale.required' => 'La raison sociale est obligatoire',
                'nbrfemme.required' => 'Le nombre de femme est obligatoire',
                'nbrehomme.required' => 'Le nombre d\'homme est obligatoire',
                'qualite.required' => 'La qualité est obligatoire',
                'adresse.required' => "L'adresse est obligatoire",
                'contact.required' => 'Le contact est obligatoire',
                'nom.required' => 'Le nom et prénoms est obligatoire',
                'activite.required' => 'L\'activité est obligatoire',
                'nationalite_id.required' => 'La nationalité est obligatoire',
                'region_id.required' => 'La région est obligatoire',
                'secteuractivite_id.required' => 'La branche d\'activité est obligatoire',
                'statutentreprise_id.required' => 'Le statut de l\'entreprise est obligatoire',
                'ncnss.required' => 'Le numéro de sécurité social est obligatoire',
                'situationentreprise_id.required' => 'La situation actuelle de l\'entreprise est obligatoire',
            ];
            
            $this->validate($request,$rules,$customMessages);

            $user = User::where(['users.id'=>Auth::user()->id])->first();
            
            if($user){

                // Upload Entreprise Logo
                if($request->hasFile('entreprise_logo')){

                    $EntrepriseImageName = time().'.'.request()->entreprise_logo->getClientOriginalExtension();
                    request()->entreprise_logo->move(public_path('assets/img/entreprise'), $EntrepriseImageName);

                }
                if($request->entreprise_logo !=null){
                    $user->entreprise_logo = $EntrepriseImageName ?? NULL;
                }
                
                $user->region_id                = $request->region_id;
                $user->nationalite_id           = $request->nationalite_id;
                $user->secteuractivite_id       = $request->secteuractivite_id;
                $user->statutentreprise_id      = $request->statutentreprise_id;
                $user->situationentreprise_id   = $request->situationentreprise_id;
                $user->raisonsociale            = htmlspecialchars($request->raisonsociale);
                $user->ncnss                    = htmlspecialchars($request->ncnss);
                $user->activite                 = htmlspecialchars($request->activite);
                $user->nbrfemme                 = htmlspecialchars($request->nbrfemme);
                $user->nbrehomme                = htmlspecialchars($request->nbrehomme);
                $user->qualite                  = htmlspecialchars($request->qualite);
                $user->contact                  = htmlspecialchars($request->contact);
                $user->adresse                  = htmlspecialchars($request->adresse);
                $user->effectiftotal            = $request->nbrfemme + $request->nbrehomme;
                $user->exists                   = true;
                $user->update();

                return back()->with('info_succes',"Compte mis à jours avec succès");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save modifier mot de passe
    public function EditPasswordComptEntreprise(Request $request){
        
        if(Auth::user()->profil_id == 2) {
            
            $rules = [
                'new_password' => 'required|confirmed|min:6|string',
                'current_password' => 'required|string',
            ];
            
            $customMessages = [   
                'new_password.required' => "Le nouveau mot de passe est obligatoire",            
                'new_password.confirmed' => "La confirmation du mot de passe n'est pas conforme au nouveau mot de passe", 
                'new_password.min' =>"Veuillez saisir un mot de passe de plus de 5 caratères",             
                'current_password.required'=>"Le mot de passe actuel est obligatoire",
            ];
            
            $this->validate($request,$rules,$customMessages);
            
            $auth = Auth::user();

            // Les mots de passe correspondent
            if (!Hash::check($request->get('current_password'), $auth->password)) 
            {
                return back()->with('error', "Le mot de passe actuel n'est pas correct");
            }

            // Mot de passe actuel et nouveau mot de passe identiques
            if (strcmp($request->get('current_password'), $request->new_password) == 0) 
            {
                return redirect()->back()->with("error", "Le nouveau mot de passe n'est pas le même que votre mot de passe actuel.");
            }

            $user =  User::find($auth->id);
            
            $user->password =  Hash::make($request->new_password);
            $user->save();
            
            return back()->with('success', "Le mot de passe a été changé avec succès");
            
        }else{

            return redirect()->route('home')->with('info_warning',"Vous n'avez pas de droit d'accès à cette page !!!");

        }
    }

    //Recherche de profils
    public function RechercherunProfil(){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            return view('entreprise.cvtheque.rechercherprofil');

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Résultat de recherche de profils
    public function ResultatRechercherProfile(Request $request){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $formation = $request->f;
            $experiencepro = $request->e; 
            $specialite = $request->s;
            $experience = $request->a;

            $whereRaw = ' 1 ';
            
            if(!empty($formation)){
                $whereRaw.= ' AND formation.formation_diplome LIKE "%'.$formation.'%"';
            }
            if(!empty($experiencepro)){
                $whereRaw.= ' AND experiencepro.experiencepro_titre LIKE "%'.$experiencepro.'%"';
            }
            if(!empty($specialite)){
                $whereRaw.= ' AND specialite.specialite_intitule LIKE "%'.$specialite.'%"';
            }
            if(!empty($experience)){
                $whereRaw.= ' AND users.experience LIKE "%'.$experience.'%"';
            }

            $profil_recommandes = User::leftJoin('formation', 'formation.user_id', '=', 'users.id')
                                        ->leftJoin('experiencepro', 'experiencepro.user_id', '=', 'users.id')
                                        ->leftJoin('specialite', 'specialite.user_id', '=', 'users.id')
                                        ->whereRaw($whereRaw)
                                        ->where(['users.profil_id' => 3, 'users.user_statut' => 'VALIDE'])
                                        ->whereIn('users.id', function ($query) {
                                            $query->select('users.id')
                                                ->from('users')
                                                ->leftJoin('formation', 'formation.user_id', '=', 'users.id')
                                                ->leftJoin('experiencepro', 'experiencepro.user_id', '=', 'users.id')
                                                ->leftJoin('specialite', 'specialite.user_id', '=', 'users.id')
                                                ->where(['users.profil_id' => 3, 'users.user_statut' => 'VALIDE'])
                                                ->groupBy('users.id');
                                        })
                                        ->select('users.*')
                                        ->groupBy('users.id')
                                        ->get();

            return view('entreprise.cvtheque.resultat',['profil_recommandes'=>$profil_recommandes, 'formation_selected'=>$formation, 'experiencepro_selected'=>$experiencepro, 'specialite_selected'=>$specialite, 'experience_selected'=>$experience]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Save Demander le profil
    public function DemanderProfil(Request $request){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $demandeur_ids = $request->input('demandeur_id'); 
            
            if (!empty($demandeur_ids)) {

                // Parcourir les identifiants des profils sélectionnés
                foreach ($demandeur_ids as $demandeur_id) {

                    $cvtheque_existe = CvTheque::where(['user_id'=>$demandeur_id, 'employeur_id'=>Auth::user()->id])->first();

                    if(empty($cvtheque_existe)){

                        // Créer une nouvelle demande de profil et l'enregistrer dans la base de données
                        $cvtheque = new CvTheque();

                        $cvtheque->user_id = $demandeur_id;
                        $cvtheque->employeur_id = Auth::user()->id;
                        $cvtheque->cvtheque_datecreation = gmdate('Y-m-d H:i:s');
                        $cvtheque->cvtheque_statut = "BROUILLON";
                        $cvtheque->save();
                    } 
                }

                return redirect()->route('entreprise.profil.recommande')->with('info_succes',"La demande a bien été envoyée avec succès");
            
            }else{

                return back()->with('info_warning',"Vous n'avez coché aucun profil !!!");
            }

        }else{

            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }

    //Recherche de profils
    public function ProfilRecommandes(Request $request){

        if(Auth::user()->profil_id == 2 and Auth::user()->user_statut == "VALIDE"){

            $diplome = $request->d;
            $metier = $request->m;
            $experience = $request->a;

            $whereRaw = ' 1 ';
            
            if(!empty($diplome)){
                $whereRaw.= " AND diplome.diplome_id = $diplome ";
            }
            if(!empty($metier)){
                $whereRaw.= " AND metier.metier_id = $metier ";
            }
            if(!empty($experience)){
                $whereRaw.= ' AND users.experience LIKE "%'.$experience.'%"';
            }

            $profil_recommandes = User::join('metier','metier.metier_id','users.metier_id')
                                        ->join('diplome','diplome.diplome_id','users.diplome_id')
                                        ->join('cvtheque','cvtheque.user_id','users.id')
                                        ->where(['profil_id'=>3, 'cvtheque.employeur_id'=>Auth::user()->id])
                                        ->whereRaw($whereRaw)
                                        ->get();

            $diplomes = Diplome::get();

            $filieres = Metier::orderby('metier_libelle','ASC')->get();

            return view('entreprise.cvtheque.profilsrecommandes',['profil_recommandes'=>$profil_recommandes, 'diplomes'=>$diplomes, 'filieres'=>$filieres, 'experience_selected'=>$experience, 'diplome_selected'=>$diplome, 'metier_selected'=>$metier]);

        }else{
            return redirect()->route('home')->with('info_error',"Vous n'avez pas de droit d'accès à cette page !!!");
        }
    }
}
