<?php
 
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Offre;
use App\Models\Candidature;
use App\Models\Commentaire;
use App\Models\Actualite;
use App\Models\CvTheque;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Session;
use Auth;
use Stdfn;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */ 
    public function index(Request $request)
    {

        $offre_id = Session('offre_id');

        //créer la réservation
        if(!empty($offre_id)){

            $offre = Offre::find($offre_id);
            
            //Si le candidat ne s'est pas déjà abonné à l'offre
            $candidature = Candidature::where(['candidature.user_id'=>Auth::user()->id,'candidature.offre_id'=>$offre_id])->first();

            if(Auth::user()->profil_id == 3 and Auth::user()->user_statut == "VALIDE"){                
                
                //Création de la candidature
                if(empty($candidature)){

                    //inserer une ligne dans la table candidature
                    $candidature = new Candidature();
                    $candidature->offre_id = $offre->offre_id;
                    $candidature->typecontrat_id = $offre->typecontrat_id;
                    $candidature->user_id = Auth::user()->id;
                    $candidature->candidature_datecrea = gmdate('Y-m-d H:i:s');
                    $candidature->save();

                    //dd($candidature->user_id, Auth::user()->id);

                    return redirect()->route('home')->with('info_succes',"Votre candidature a bien été éffectuée avec succès");
                }

            }
            
            session(['offre_id'=>'']);

        }

        if(Auth::user()->role_id == 1){

            $demandeurs_avalider = User::where(['profil_id'=>3, 'user_statut'=>"BROUILLON"])->count();
            $entreprise_avalider = User::where(['profil_id'=>2, 'user_statut'=>"BROUILLON"])->count();
            $homme_inscrit = User::where(['profil_id'=>3, 'genre'=>"H", 'user_statut'=>"VALIDE"])->count();
            $femme_inscrit = User::where(['profil_id'=>3, 'genre'=>"F", 'user_statut'=>"VALIDE"])->count();
            $offre_avalider = Offre::where(['offre_statut'=>"BROUILLON"])->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')->count();
            $demandeemploi_avalider = Offre::join('candidature','candidature.offre_id','offre.offre_id')->join('users','users.id','candidature.user_id')->where(['candidature_statut'=>"BROUILLON"])->count();
            $commentaire = Commentaire::where(['commentairelib'=>"BROUILLON"])->count();
            $carte_expiree = User::where('profil_id', 3)->whereRaw('DATE(user_validitecarte) < "'.date("Y-m-d").'"')->count();
            $cvtheques = CvTheque::where(['cvtheque_statut'=>"BROUILLON"])->count();

            return view('admin.home',[
                'demandeurs_avalider'=>$demandeurs_avalider,
                'entreprise_avalider'=>$entreprise_avalider,
                'homme_inscrit'=>$homme_inscrit,
                'femme_inscrit'=>$femme_inscrit,
                'offre_avalider'=>$offre_avalider,
                'demandeemploi_avalider'=>$demandeemploi_avalider,
                'commentaire'=>$commentaire,
                'carte_expiree'=>$carte_expiree,
                'cvtheques'=>$cvtheques
            ]);
        }
        elseif(Auth::user()->profil_id == 2){

            $abonne_nombre = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                ->join('users','users.id','offre.user_id')
                                ->where(['candidature_statut'=>"VALIDE", 'offre.user_id'=>Auth::user()->id])
                                ->count();

            $offre_nombre = Offre::where(['user_id'=>Auth::user()->id])
                                ->count();

            $offre_recentes = Offre::where(['user_id'=>Auth::user()->id])
                                    ->orderby('offre_id','DESC')
                                    ->paginate(2);

            $offres = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                ->join('users','users.id','offre.user_id')
                                ->where(['candidature_statut'=>"VALIDE", 'offre.user_id'=>Auth::user()->id])
                                ->orderby('candidature_id','DESC')
                                ->get();

            $cvtheques = CvTheque::where(['cvtheque_statut'=>"VALIDE", 'employeur_id'=>Auth::user()->id])->count();

            return view('entreprise.home',['abonne_nombre'=>$abonne_nombre, 'offre_nombre'=>$offre_nombre, 'offre_recentes'=>$offre_recentes, 'offres'=>$offres, 'cvtheques'=>$cvtheques]);
        }
        elseif(Auth::user()->profil_id == 3){
			
			$url = $request->root();
			
			$demandeur = User::where(['users.id'=>Auth::user()->id])->first(); 
			
			$lien_demandeur = $url."/gestion-des-demandeurs/details/".$demandeur->id.'-'.Stdfn::clean_url($demandeur->prenoms);

			$qrcode = Qrcode::encoding("UTF-8")
						->color(8, 114, 145)
						->size(80)
						->generate($lien_demandeur);
						
			$demandeur->qr_code = $qrcode;
			$demandeur->exists = true;
			$demandeur->update();

            $mes_candidature_valide = Candidature::where(['candidature.user_id'=>Auth::user()->id, 'candidature.candidature_statut'=>"VALIDE"])
                                                    ->count();

            $mes_candidature_attente = Candidature::where(['candidature.user_id'=>Auth::user()->id, 'candidature.candidature_statut'=>"BROUILLON"])
                                                ->count();

            $mes_candidature_approuve = Candidature::where(['candidature.user_id'=>Auth::user()->id, 'candidature.candidature_statut'=>"APPROUVE"])
                                                ->count();

            $offres = Candidature::join('offre','offre.offre_id','candidature.offre_id')
                                ->join('users','users.id','offre.user_id')
                                ->where(['candidature_statut'=>"VALIDE", 'offre.user_id'=>Auth::user()->id])
                                ->orderby('candidature_id','DESC')
                                ->get();

            $offre_publie = Offre::join('diplome','diplome.diplome_id','offre.diplome_id')
                                    ->join('users','users.id','offre.user_id')->where(['offre_statut'=>"PUBLIE"])
                                    ->where('offre.diplome_id','>=',Auth::user()->diplome_id)
                                    ->where('offre.metier_id','=',Auth::user()->metier_id)
                                    ->get();
            //dd($offre_publie);
            return view('demandeur.home',['mes_candidature_valide'=>$mes_candidature_valide, 'mes_candidature_attente'=>$mes_candidature_attente, 'mes_candidature_approuve'=>$mes_candidature_approuve, 'offres'=>$offres, 'offre_publie'=>$offre_publie]);
        }
    }
}
