<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use App\Models\User;
use App\Models\Offre;
use App\Models\Candidature;
use App\Models\Produit;
use App\Models\Client;
use App\Models\Photo;
use App\Models\Commande;
use App\Models\ProduitCommande;
use App\Models\Diplome;
use App\Models\Metier;
use App\Models\Pays;
use App\Models\Region;
use App\Models\TrancheAge;
use App\Models\LangueInternationale;
use App\Models\CategorieProfessionelle;
use App\Models\NiveauInstruction;
use App\Models\TypeDemandeur;
use App\Models\LangueLocale;
use App\Models\TypeInscription;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Stdfn;
use Intervention\Image\Facades\Image;

class MobileController extends Controller
{
	public function __construct()
	{
		//$this->middleware('auth');
	}
	
	public function get_datas_listes(){
    	
        $metiers = Metier::where(['metier_statut'=>"VALIDE"])->get();
    
        $paysliste = Pays::where(['pays_statut'=>"VALIDE"])->orderby('nom_fr','ASC')->get();
    
        $regions = Region::where(['region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();
        
        $trancheages = TrancheAge::where(['trancheage_statut'=>"VALIDE"])->get();
    
        $filieres = Metier::where(['metier_statut'=>"VALIDE"])->orderby('metier_libelle','ASC')->get();
    
        $langueinter = LangueInternationale::where(['langueinter_statut'=>"VALIDE"])->get();
    
        $categories = CategorieProfessionelle::where(['catepro_statut'=>"VALIDE"])->orderby('catepro_lib','ASC')->get();
    
        $niveaux = NiveauInstruction::where(['niveauinstruction_statut'=>"VALIDE"])->orderby('niveau_lib','ASC')->get();
    
        $typedemandeur = TypeDemandeur::where(['situation_statut'=>"VALIDE"])->orderby('situation_lib','ASC')->get();
    
        $diplomes = Diplome::where(['diplome_statut'=>"VALIDE"])->get();
    
        $languelocale = LangueLocale::where(['languelocal_statut'=>"VALIDE"])->get();
        
        $typeinscriptions = TypeInscription::where(['typeinscription_statut'=>"VALIDE"])->orderby('typeinscription_lib','ASC')->get();
    
        $datesources = Carbon::now()->subYears(10);
    
        return ['metiers'=>$metiers, 'diplomes'=>$diplomes, 'paysliste'=>$paysliste, 'regions'=>$regions, 'langueinter'=>$langueinter, 'trancheages'=>$trancheages, 'typedemandeur'=>$typedemandeur, 'languelocale'=>$languelocale, 'typeinscriptions'=>$typeinscriptions, 'categories'=>$categories, 'niveaux'=>$niveaux, 'datesources'=>$datesources];
    }

	public function alert_emploi(Request $request)
	{

		$user = auth('api')->user();
		return response()->json(['success' => 'Successfull', 'user' => $user], 200);
	}

	public function register(Request $request)
	{

		$validation = $request->validate([
			'email' => 'required|unique:users|max:255',
			'telephone' => 'required|unique:users,telephone|max:255',
			'password' => 'required'
		]);


		$user = new User();
		$user->profil_id = 3;
		$user->situation_id = $request->situation_id;
		$user->prenoms = $request->prenoms;
		$user->name = $request->nom;
		$user->email = $request->email;
		$user->diplome_id = $request->diplome;
		$user->experience = $request->experience;


		$user->user_dpc = $request->user_dpc;
		$user->user_cv = $request->user_cv;
		$user->user_att = $request->user_att;
		$user->password = bcrypt($request->password);

		if ($request->hasFile('cni')) {

			$fichier = $request->file('cni');

			$filename_cni = 'cni_' . md5($request->email) . '.' . $fichier->extension();

			$fichier->move(public_path('assets/img/profil/documents'), $filename_cni);

			$user->user_cni = $filename_cni;
		}
		if ($request->hasFile('dpc')) {

			$fichier = $request->file('dpc');

			$filename_dpc = 'dpc_' . md5($request->email) . '.' . $fichier->extension();

			$fichier->move(public_path('assets/img/profil/documents'), $filename_dpc);

			$user->user_dpc = $filename_dpc;
		}
		if ($request->hasFile('cv')) {

			$fichier = $request->file('cv');

			$filename_cv = 'cv_' . md5($request->email) . '.' . $fichier->extension();

			$fichier->move(public_path('assets/img/profil/documents'), $filename_cv);

			$user->user_cv = $filename_cv;
		}
		if ($request->hasFile('att')) {

			$fichier = $request->file('att');

			$filename_att = 'att_' . md5($request->email) . '.' . $fichier->extension();

			$fichier->move(public_path('assets/img/profil/documents'), $filename_att);

			$user->user_att = $filename_att;
		}
		
		if(request()->hasFile('profil_photo')){

			$PhotoName = time().'.'.request()->profil_photo->getClientOriginalExtension();
			$destinationPath = public_path('assets/img');
			request()->profil_photo->move($destinationPath, $PhotoName);
			$resizedImagePath = public_path('assets/img/profil');
			$resizedPhotoName = 'resized_'.$PhotoName;
			$resizedImage = Image::make($destinationPath.'/'.$PhotoName)->fit(110, 110);
			$resizedImage->save($resizedImagePath.'/'.$resizedPhotoName);
		}

		// $otp = Stdfn::genererOTP();
		// $user->otp = $otp;
		$user->save();

		$data = $request->all();
		
		$dateNaissance = \Carbon\Carbon::createFromFormat('Y-m-d', $data['datenaissance']);
		$dateJours = \Carbon\Carbon::createFromFormat('Y-m-d', gmdate('Y-m-d'));
		$anneeNaissance = $dateNaissance->year;
		$anneeJours = $dateJours->year;
		$age = $anneeJours - $anneeNaissance;
		
		$trancheage = DB::table('trancheage')
		->where('trancheage_deb', '<=', $age)
		->where('trancheage_fin', '>=', $age)
		->first();

		$user->update([
			'profil_id' => 3,
                'telephone' => $data['telephone'],
                'metier_id'=> $data['metier_id'],
                'pays_id'=> $data['pays_id'],
                'region_id'=> $data['region_id'],
                'catepro_id'=> $data['catepro_id'],
                'situation_id'=> $data['situation_id'],
                'niveau_id'=> $data['niveau_id'],
                'langueinter_id'=> $data['langueinter_id'],
                'languelocal_id'=> $data['languelocal_id'],                           
                'trancheage_id'=> $trancheage->trancheage_id,
                'datenaissance'=> $data['datenaissance'],
                'lieunaissance'=> $data['lieunaissance'],
                'departement'=> $data['departement'],
                'situationmatrimoniale'=> $data['stituationmatrimoniale'],
                'handicap'=> $data['handicap'],
                'nombreenfant'=> $data['nombreenfant'],
                'emploisouhaite'=>$data['emploisouhaite'],
                // 'new_diplome'=> $data['new_diplome'],
                // 'new_metier'=> $data['new_metier'],
                // 'new_languelocal'=> $data['new_languelocal'],
                // 'new_langueinter'=> $data['new_langueinter'],
                // 'type_handicap'=	> $data['type_handicap'],
                'experience'=>$data['experience'],
                'user_origine'=>'Mobile',
                'profil_photo' => $resizedPhotoName ?? NULL,
		]);

		/*
		//send otp via mail
        $email_data = array(
            'email' => $user->email,
            'nom' => $user->name,
            'prenoms' => $user->prenoms,
            'otp' => $user->otp,
        );
        Mail::send('emails.email_otp', $email_data, function ($message) use ($email_data){
			$message->to($email_data['email'])
				->subject("Code de connexion")
				->from('noreply@anpe.com', 'ANPE');
        });
        */

		// return $this->responseWithToken(null, $user);

		//connecter l'utilisateur
		if (!$token = Auth()->attempt(['email' => $request->email, 'password' => $request->password])) {
			return response()->json(['error' => 'Unauthorized'], 401);
		}

		$user = Auth()->user();
		$token = $user->createToken('ANPE')->accessToken;

		return $this->responseWithToken($token, $user);
	}

	public function metiers(){
		return Metier::all();
	}

	public function pays(){
		return Pays::all();
	}

	public function regions(){
		return Region::all();
	}

	public function categoriePro(){
		return CategorieProfessionelle::all();
	}

	public function niveaux(){
		return NiveauInstruction::all();
	}

	public function langeInter(){
		return LangueInternationale::all();
	}

	public function langueLocal(){
		return LangueLocale::all();
	}

	public function registerFormData(){
		return [
			'metiers' => Metier::all(),
			'regions' => Region::all(),
			'categories_professionelle' => CategorieProfessionelle::all(),
			'niveaux_instruction' => NiveauInstruction::all(),
			'langues_internationnale' => LangueInternationale::all(),
			'langues_locale' => LangueLocale::all(),
			'situations' => DB::table('situation')->where('situation_statut', 'VALIDE')->get(),
			'pays' => Pays::all()
		];
	}


	public function resend_otp($user_id)
	{
		$user = User::find($user_id);

		//send otp via mail
		$email_data = array(
			'email' => $user->email,
			'nom' => $user->name,
			'prenoms' => $user->prenoms,
			'otp' => $user->otp,
		);

		Mail::send('emails.email_otp', $email_data, function ($message) use ($email_data) {
			$message->to($email_data['email'])
				->subject("Code de connexion")
				->from('noreply@anpe.com', 'ANPE');
		});
	}

	public function updateCV(Request $request)
	{

		$request->validate([
			'cv' => 'required|file'
		]);

		$user = auth('api')->user();



		$fichier = $request->file('cv');

		$filename_cv = 'cv_' . md5($request->email) . '.' . $fichier->extension();

		$fichier->move(public_path('assets/img/profil/documents'), $filename_cv);

		$user->user_cv = $filename_cv;
		$user->save();

		return [
			'user' => $user,
			'id' => $user->id . "",
			'firstname' => $user->prenoms,
			'lastname' => $user->name,
			'email' => $user->email,
			'telephone' => $user->telephone,
			'adresse' => $user->adresse,
			'genre' => $user->genre,
			'photo' => !empty($user->profil_photo) ? "http://139.99.121.83/assets/img/profil/" . $user->profil_photo : "",
			'cni' => !empty($user->cni) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->cni : "",
			'dpc' => !empty($user->dpc) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->dpc : "",
			'cv' => !empty($user->cv) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->cv : "",
			'att' => !empty($user->att) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->att : "",
			'experience' => $user->experience,
			'domaine' => $user->domaine_id,
			'otp' => $user->otp
		];
	}


	public function update_profile(Request $request)
	{

		// $validation = $request->validate([
		// 'email' => 'required|max:255',
		// 'password' => 'required',
		// 'nom' => 'required',
		// 'prenoms' => 'required',
		// ]);

		$user = auth('api')->user();
		//$user = User::where(['email'=>$request->email])->first();
		$user->prenoms = $request->prenoms;
		$user->name = $request->nom;
		$user->telephone = $request->telephone;
		$user->genre = $request->genre;
		$user->adresse = $request->adresse;
		$user->diplome_id = $request->diplome;
		$user->experience = $request->experience;



		if ($request->hasFile('photo')) {

			$fichier 		= $request->file('photo');

			$filename = 'user_' . $user->id . '.' . $fichier->extension();

			$fichier->move(public_path('assets/img/profil'), $filename);

			$user->profil_photo = $filename;
		}

		$user->exists = true;
		$user->save();

		//connecter l'utilisateur

		//$token = $user->createToken('ANPE')->plainTextToken;
		$token = $user->createToken('ANPE')->accessToken;

		return $this->responseWithToken($token, $user);
	}

	public function login(Request $request)
	{

		$validation = Validator::make($request->all(), [
			'email' => 'required',
			'password' => 'required',
		]);

		if ($validation->fails()) {
			return response()->json(['message' => "Identifiant requis", 'error' => $validation->errors()], 400);
		}


		if (!$token = Auth()->attempt(['email' => $request->email, 'password' => $request->password])) {

			return response()->json(['error' => 'Unauthorized'], 401);
		}

		$user = auth()->user();
		$token = $user->createToken('ANPE')->accessToken;
		// $token = null;


		return $this->responseWithToken($token, $user);
	}

	public function unauthorize()
	{
		return response()->json(['error' => "Unauthorize"], 401);
	}

	public function logout()
	{
		auth()->logout();

		return response()->json(['message' => 'Déconnexion réussie']);
	}

	public function user(Request $request)
	{
		return response()->json(auth()->user());
	}

	protected function responseWithToken($token, $user)
	{
		return response()->json([
			'access_token' => $token,
			'user' => $user,
			'id' => $user->id . "",
			'firstname' => $user->prenoms,
			'lastname' => $user->name,
			'email' => $user->email,
			'telephone' => $user->telephone,
			'adresse' => $user->adresse,
			'genre' => $user->genre,
			'photo' => !empty($user->profil_photo) ? "http://139.99.121.83/assets/img/profil/" . $user->profil_photo : "",
			'cni' => !empty($user->cni) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->cni : "",
			'dpc' => !empty($user->dpc) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->dpc : "",
			'cv' => !empty($user->cv) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->cv : "",
			'att' => !empty($user->att) ? "http://139.99.121.83/assets/img/profil/documents/" . $user->att : "",
			'experience' => $user->experience,
			'domaine' => $user->domaine_id,
			'otp' => $user->otp,
			'token_type' => 'Bearer'
		]);
	}


	/**
	 * @OA\Post(
	 * path="/api/candidats",
	 * operationId="authLogin",
	 * tags={"Login"},
	 * summary="User Login",
	 * description="Login User Here",
	 *     @OA\RequestBody(
	 *         @OA\JsonContent(),
	 *         @OA\MediaType(
	 *            mediaType="multipart/form-data",
	 *            @OA\Schema(
	 *               type="object",
	 *               required={"email", "password"},
	 *               @OA\Property(property="email", type="email"),
	 *               @OA\Property(property="password", type="password")
	 *            ),
	 *        ),
	 *    ),
	 *      @OA\Response(
	 *          response=201,
	 *          description="Login Successfully",
	 *          @OA\JsonContent()
	 *       ),
	 *      @OA\Response(
	 *          response=200,
	 *          description="Login Successfully",
	 *          @OA\JsonContent()
	 *       ),
	 *      @OA\Response(
	 *          response=422,
	 *          description="Unprocessable Entity",
	 *          @OA\JsonContent()
	 *       ),
	 *      @OA\Response(response=400, description="Bad request"),
	 *      @OA\Response(response=404, description="Resource Not Found"),
	 * )
	 */

	public function candidats(Request $request)
	{
		if (auth('api')->user()->profil_id == 1 or auth('api')->user()->profil_id == 2 or auth('api')->user()->profil_id == 4) {

			$diplome = $request->input('diplome_id');
			$metier = $request->input('metier_id');
			$region = $request->input('region_id');

			$query = User::select('identifiant', 'name', 'prenoms', 'email', 'diplomelib', 'metier_libelle', 'trancheage_lib', 'region_nom', 'cv_joint')
				->join('diplome', 'diplome.diplome_id', 'users.diplome_id')
				->join('metier', 'metier.metier_id', 'users.metier_id')
				->join('trancheage', 'trancheage.trancheage_id', 'users.trancheage_id')
				->join('region', 'region.region_id', 'users.region_id');

			if ($diplome) {
				$query->where('users.diplome_id', '=', $diplome);
			}

			if ($metier) {
				$query->where('users.metier_id', '=', $metier);
			}

			if ($region) {
				$query->where('users.region_id', '=', $region);
			}

			$candidats = $query->get();

			//Récupérer l'url
			$url = $request->root();

			if ($candidats->isEmpty()) {
				return response()->json(['No data' => 'Il n\'y a pas de données'], 201);
			}

			foreach ($candidats as $candidat) {
				$candidat->cv_joint = $url . "/cv/" . $candidat->cv_joint;
			}
			return $candidats;
		} else {

			return response()->json(['Unauthorized' => 'Vous n\'êtes pas autorisé.'], 401);
		}
	}

	//récupère toutes les offres pour y faire des recherches
	public function offres_all(Request $request)
	{

		$offres = Offre::join('users', 'users.id', 'offre.user_id')->orderByDesc('offre.offre_id')->paginate();

		$url = $request->root();

		foreach ($offres as &$offre) {

			$offre->offretitre = $offre->offretitre;
			$offre->pays = $offre->pays_id;
			$offre->empactivite = $offre->empactivite_id;
			$offre->tempstravail = $offre->tempstravail_id;
			$offre->modereception = $offre->modereception_id;
			$offre->experience = $offre->experience_id;
			$offre->typetravail = $offre->typecontrat_id;

			$offre->offre_image = $url . "/assets/img/entreprise/" . $offre->entreprise_logo;
			$offre->offre_partage = 2;
			$offre->offre_like = 10;
			$offre->postulable = 1;
		}

		return $offres;
	}
	
	public function diplomes_liste(Request $request)
	{
		$diplomes_liste = Diplome::where(['diplome_statut' => 'VALIDE'])->get();
		return $diplomes_liste;
	}

	public function getSituations(){
		return DB::table('situation')->where('situation_statut', 'VALIDE')->get();
	}


	public function offres(Request $request, $user, $type = 0)
	{

		$user = auth('api')->user();
		$diplome_id = intval($user->diplome_id);

		$type = intval($type);

		$offres_deja_postule = Offre::join('users', 'users.id', 'offre.user_id')
			->join('metier', 'metier.metier_id', 'offre.metier_id')
			->join('diplome', 'diplome.diplome_id', 'offre.diplome_id')
			->join('typecontrat', 'typecontrat.typecontrat_id', 'offre.typecontrat_id')
			->join('candidature', 'candidature.offre_id', 'offre.offre_id')
			->where(['candidature.user_id' => $user->id])
			->orderByDesc('offre.offre_id')
			->paginate();

		if ($type == 1) { //selon profil

			$offres = Offre::join('users', 'users.id', 'offre.user_id')
				->join('metier', 'metier.metier_id', 'offre.metier_id')
				->join('diplome', 'diplome.diplome_id', 'offre.diplome_id')
				->join('typecontrat', 'typecontrat.typecontrat_id', 'offre.typecontrat_id')
				->whereRaw('offre.diplome_id <= ' . $diplome_id)
				->orderByDesc('offre.offre_id')
				->paginate();
		} elseif ($type == 2) {
			//les autres offres
			$offres = Offre::join('users', 'users.id', 'offre.user_id')
				->join('metier', 'metier.metier_id', 'offre.metier_id')
				->join('diplome', 'diplome.diplome_id', 'offre.diplome_id')
				->join('typecontrat', 'typecontrat.typecontrat_id', 'offre.typecontrat_id')
				->whereRaw('offre.diplome_id > ' . $diplome_id)
				->orderByDesc('offre.offre_id')
				->paginate();
		} elseif ($type == 3) {

			$offres = Offre::join('users', 'users.id', 'offre.user_id')
				->join('metier', 'metier.metier_id', 'offre.metier_id')
				->join('diplome', 'diplome.diplome_id', 'offre.diplome_id')
				->join('typecontrat', 'typecontrat.typecontrat_id', 'offre.typecontrat_id')
				->whereRaw('offre.diplome_id <= ' . $diplome_id)
				->orderByDesc('offre.offre_id')
				->paginate();
		} else {

			//deja postule
			$offres = $offres_deja_postule;
		}

		$url = $request->root();

		foreach ($offres as &$offre) {

			$offre->offredescription = html_entity_decode($offre->offredescription);
			$offre->pays = $offre->pays_id;
			$offre->offre_datepublic = Stdfn::dateFromDB($offre->offre_datepublic);
			$offre->offre_datefin = Stdfn::dateFromDB($offre->offre_datefin);

			$offre->offre_image = $url . "/assets/img/entreprise/" . $offre->entreprise_logo;
			$offre->offre_partage = 2;
			$offre->offre_like = 10;
			$offre->postulable = $type > 2 ? 0 : 1;
		}

		return $offres;
	}

	public function postuler(Request $request)
	{
		$user_id = auth('api')->user()->id;
		$offre_id = $request->offre_id;

		$candidature = new Candidature();
		$candidature->user_id = $user_id;
		$candidature->offre_id = $offre_id;
		$candidature->candidature_datecrea = gmdate('Y-m-d H:i:s');
		$candidature->candidature_statut = 'BROUILLON';
		$candidature->save();


		return ['status' => 1, 'message' => 'POSTULE OK', 'user' => $user_id, 'offre' => $offre_id];
	}


	//
	public function clients(Request $request)
	{

		$clients = Client::where(['client_statut' => 'VALIDE'])->get();

		foreach ($clients as $client) {
			$client->client_photo = $client->client_photo;
		}

		return $clients;
	}


	//
	public function produits(Request $request)
	{

		$produits = Produit::join('categoriedeproduit', 'categoriedeproduit.categorie_id', 'produit.categorie_id')->where(['produit_statut' => 'VALIDE'])->get()->sortByDesc('produit_id');

		$listeProduits = [];

		foreach ($produits as $produit) {

			$produit->produit_photo_principale = $produit->produit_photo_principale;

			$photos = Photo::where(['produit_id' => $produit->produit_id, 'photo_statut' => 'VALIDE'])->get();
			foreach ($photos as $photo) {
				$photo->photo_src = $photo->photo_src;
			}
			$produit->photo = $photos;

			$listeProduits[] = $produit;
		}

		return $listeProduits;
	}


	//
	public function commandes(Request $request)
	{

		$produits = Commande::join('produit_commande', 'produit_commande.commande_id', 'commande.commande_id')
			->join('produit', 'produit.produit_id', 'produit_commande.produit_id')
			->where(['commande_statut' => 'VALIDE'])->get()->sortByDesc('commande.commande_id');

		$listeProduits = [];

		$commandes = Commande::where(['commande_statut' => 'VALIDE'])->get()->sortByDesc('commande_id');

		foreach ($commandes as $commande) {
			$pc = ProduitCommande::join('produit', 'produit.produit_id', 'produit_commande.produit_id')->where(['commande_id' => $commande->commande_id])->get();
			$client = Client::where(['client_id' => $commande->client_id])->first();

			$commande->client = $client;
			$commande->produit_commande = $pc;

			$listeProduits[] = $commande;
		}

		return $listeProduits;
	}

	public function add_client(Request $request)
	{
		$client = new Client();
		$client->client_nom = $request->nom;
		$client->client_prenoms = $request->prenoms;
		$client->client_telephone = $request->telephone;
		$client->client_email = $request->email;
		$client->client_adresse = $request->adresse;

		if ($request->hasFile('client_photo')) {

			$file  = $request->file('client_photo');

			$filename = Stdfn::guidv4() . '.' . $file->extension();

			$file->move(public_path('photos/clients'), $filename);

			$client->client_photo = $filename;
		}

		$client->client_date_creation = gmdate('Y-m-d H:i:s');
		$client->save();

		return ['status' => 1, 'message' => 'OK'];
	}

	public function add_produit(Request $request)
	{
		$files = $request->file();

		$produit = new Produit();
		$produit->produit_nom = $request->nom;
		$produit->categorie_id = $request->categorie;
		$produit->produit_prix = $request->prix;
		$produit->produit_quantite_total = $request->stock;
		$produit->produit_quantite_achete = 0;
		$produit->produit_quantite_restante = $request->stock;
		$produit->produit_date_creation = gmdate('Y-m-d H:i:s');

		$produit->save();

		$produit_id = $produit->produit_id;

		//enregistrer les autres images
		$i = 0;
		if (count($files) > 0) {
			foreach ($files as $file) {

				$filename = Stdfn::guidv4() . '.' . $file->extension();
				$file->move(public_path('photos/produits'), $filename);

				if ($i == 0) {
					//l'image principale
					$produit->update(['produit_photo_principale' => $filename]);
				} else {
					//les autres images
					$photo = new Photo();
					$photo->produit_id = $produit_id;
					$photo->photo_src = $filename;
					$photo->photo_date_creation = gmdate('Y-m-d H:i:s');
					$photo->save();
				}

				$i++;
			}
		}

		return ['status' => 1, 'message' => 'OK'];
	}


	public function update_produit(Request $request)
	{
		$files = $request->file();
		$produit_id = $request->produit_id;

		$produit = Produit::find($produit_id);
		$produit->produit_nom = $request->nom;
		$produit->categorie_id = $request->categorie;
		$produit->produit_prix = $request->prix;
		$produit->produit_quantite_total = $request->stock;
		$produit->produit_quantite_achete = 0;
		$produit->produit_quantite_restante = $request->stock;
		$produit->produit_date_modification = gmdate('Y-m-d H:i:s');

		$produit->exists = true;
		$produit->save();

		//enregistrer les autres images
		$i = 0;
		if (count($files) > 0) {
			foreach ($files as $file) {

				$filename = Stdfn::guidv4() . '.' . $file->extension();
				$file->move(public_path('photos/produits'), $filename);

				if ($i == 0) {
					//l'image principale
					if ($produit->produit_photo_principale == "" || !file_exists('http://jobboard.target-ci.com/photos/produits/' . $produit->produit_photo_principale)) {
						$produit->update(['produit_photo_principale' => $filename]);
					}
				}

				//les autres images
				$photo = new Photo();
				$photo->produit_id = $produit_id;
				$photo->photo_src = $filename;
				$photo->photo_date_creation = gmdate('Y-m-d H:i:s');
				$photo->save();


				$i++;
			}
		}

		return ['status' => 1, 'message' => 'OK'];
	}


	public function delete_photo(Request $request)
	{
		$files = $request->file();
		$photo_id = $request->photo_id;

		$photo = Photo::find($photo_id);
		$photo->photo_statut = 'SUPPRIME';
		$photo->photo_date_suppression = gmdate('Y-m-d H:i:s');

		$photo->exists = true;
		$photo->save();


		return ['status' => 1, 'message' => 'OK'];
	}


	public function add_commande(Request $request)
	{

		$commande = new Commande();
		$commande->client_id = $request->client_id;
		$commande->details = $request->produit_quantite;
		$commande->commande_date_creation = gmdate('Y-m-d H:i:s');
		$commande->save();

		$commande_id = $commande->commande_id;

		$produits_commandes = $request->produit_quantite;

		$tab = explode(',', $produits_commandes);

		$total = 0;
		foreach ($tab as $t) {

			$d = explode(':', $t);
			$produit_id = $d[0];
			$quantite = $d[1];

			$produit = Produit::find($produit_id);

			$pc = new ProduitCommande();
			$pc->commande_id = $commande_id;
			$pc->produit_id = $produit_id;
			$pc->prix_unitaire = $produit->produit_prix;
			$pc->quantite = $quantite;
			$pc->total = $quantite * $produit->produit_prix;
			$pc->save();

			$total = $total + $quantite * $produit->produit_prix;
		}

		$commande->commande_montant_total = $total;
		$commande->exists = true;
		$commande->save();

		return ['status' => 1, 'message' => 'OK'];
	}


	public function update_statut_commande(Request $request)
	{
		$files = $request->file();
		$commande_id = $request->commande_id;
		$statut = $request->statut;

		$commande = Commande::find($commande_id);
		if ($statut == "ANNULEE") {
			$commande->commande_statut = $statut;
		} else {
			$commande->commande_statut_livraison = $statut;
		}
		//$commande->commande_date_modification = gmdate('Y-m-d H:i:s');

		$commande->exists = true;
		$commande->save();


		return ['status' => 1, 'message' => 'OK'];
	}
}
