<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\NewsLetter;
use App\Models\Offre;
use Stdfn;
use Mail;

class NewsLetterController extends Controller
{
    //Save NewsLetter
    public function SaveNewsletter(Request $request){

        $rules = [
            'email' => ['required', 'string', 'email', 'max:255', 'unique:newsletter'],
        ];
        
        $customMessages = [
            'email.required' => "L'adresse email est obligatoire",
            'email.email' => "L'adresse email n'est pas valide",
            'email.unique' => "Cet adresse email est déjà utilisé",
        ];

        $this->validate($request,$rules,$customMessages);

        $newsletter = new NewsLetter();

        $newsletter->email = htmlspecialchars($request->email);
        $newsletter->newsletter_datecrea = gmdate('Y-m-d H:i:s');
        //$newsletter->save();
        
        // Récupération des paramètres du mail du client
        $email_data = array(
            'email' => $request->input('email'),
            'anneencours'=>gmdate('Y'),
        );
        // Envoie des paramètres du mail au client
        Mail::send('emails.newsletter', $email_data, function ($message) use ($email_data){
        $message->to($email_data['email'])
            ->subject("Merci de vous être abonné(e) à notre newsletter.")
            ->from('info@anpe-niger.ne', "AGENCE NATIONALE POUR LA PROMOTION DE L'EMPLOI");
        });

        return back()->with('info_succes',"Abonnment à la newsletter effectué avec succès !");

    }
}
