<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Auth;
use App\Models\Offre;
use App\Models\Metier;
use App\Models\Diplome;
use App\Models\Region;
use App\Models\TypeContrat;
use App\Models\Candidature;
use App\Models\Pays;
use App\Models\StatutEntreprise;
use App\Models\SituationActivite;
use App\Models\Nationalite;
use App\Models\TypeInscription;
use App\Models\TrancheAge;
use App\Models\LangueInternationale;
use App\Models\LangueLocale;
use App\Models\CategorieProfessionelle;
use App\Models\NiveauInstruction;
use App\Models\TypeDemandeur;
use Session;
use Carbon\Carbon;

class PostulerOffreController extends Controller
{
    public function PostuleraOffre($offre_id){

        $offre = Offre::find($offre_id);

        //conserver l'identifiant de l'offre choisie
        session(['offre_id'=>$offre_id]);

        if(! Auth::user() > 0){

            $metiers = Metier::orderby('metier_libelle','ASC')->get();

            $diplomes = Diplome::orderby('diplomelib','ASC')->get();
            
            $paysliste = Pays::orderby('nom_fr','ASC')->get();

            $regions = Region::orderby('region_nom','ASC')->get();

            $langueinter = LangueInternationale::orderby('langueinter_lib','ASC')->get();

            $niveaux = NiveauInstruction::orderby('niveau_lib','ASC')->get();

            $typedemandeur = TypeDemandeur::orderby('situation_lib','ASC')->get();

            $languelocale = LangueLocale::orderby('languelocal_lib','ASC')->get();

            $categories = CategorieProfessionelle::orderby('catepro_lib','ASC')->get();
			
			$datesources = Carbon::now()->subYears(10);

            return view('demandeur.postuleroffre', ['offre'=>$offre, 'metiers'=>$metiers, 'diplomes'=>$diplomes, 'paysliste'=>$paysliste, 'regions'=>$regions, 'langueinter'=>$langueinter, 'datesources'=>$datesources, 'typedemandeur'=>$typedemandeur, 'languelocale'=>$languelocale, 'categories'=>$categories, 'niveaux'=>$niveaux]);

        }else{

            return redirect()->route('home');

        }
    }
    
}
