<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Region;
use App\Models\Offre;
use App\Models\User; 
use App\Models\Metier;
use App\Models\TypeContrat;
use App\Models\Candidature;
use App\Models\Diplome;
use App\Models\Actualite;
use App\Models\Pays;
use App\Models\Sliders;
use App\Models\StatutEntreprise; 
use App\Models\SituationActivite;
use App\Models\SecteurActivite;
use App\Models\Nationalite;
use App\Models\TypeInscription;
use App\Models\TrancheAge;
use App\Models\LangueInternationale;
use App\Models\LangueLocale;
use App\Models\CategorieProfessionelle;
use App\Models\NiveauInstruction;
use App\Models\TypeDemandeur;
use App\Models\Publication;
use App\Models\OffreRegion;
use Illuminate\Support\Facades\Auth;
use Session;
use DB; 
use Carbon\Carbon;

class WelcomeController extends Controller
{
    //Menu accueil 1
    public function welcome(Request $request){

        $offre_nombre = Offre::where(['offre_statut'=>"PUBLIE"])->count();

        $user_nombre = User::where(['user_statut'=>"VALIDE", 'profil_id'=>2])->count();
        						
        
        $candidats = DB::table('candidature')->select('user_id')->distinct()->get();
         
        $nombre_candidat = count($candidats);
        
        $sliders_images = Sliders::select('sliders_id','sliders_image_accueil','sliders_libelle_accueil')->where(['sliders_statut'=>"ACTIVE"])->orderby('sliders_datecrea','ASC')->get();
        
        $offres = Offre::join('users','users.id','offre.user_id')->where(['offre_statut'=>"PUBLIE"])
                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                        ->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')
                        ->orderby('offre_datepublic','DESC')
                        ->paginate(12);

        $actualites  = Actualite::join('categorie','categorie.categorie_id','actualite.categorie_id')
        						->whereRaw('date(actualite_datefin) > "'.gmdate("Y-m-d").'" ')
        						->where(['actualite_statut'=>"PUBLIE"])
        						->orderby('actualite_id','DESC')
        						->paginate(6);

        return view('accueil',['offres'=>$offres, 'offre_nombre'=>$offre_nombre, 'user_nombre'=>$user_nombre, 'actualites'=>$actualites, 'nombre_candidat'=>$nombre_candidat, 'sliders_images'=>$sliders_images]);
    }

    //Menu accueil 2
    public function Accueil(Request $request){

        $offre_nombre = Offre::where(['offre_statut'=>"PUBLIE"])->count();

        $user_nombre = User::where(['user_statut'=>"VALIDE", 'profil_id'=>2])->count();

        $candidats = DB::table('candidature')->select('user_id')->distinct()->get();
        
        $nombre_candidat = count($candidats);
        
        $sliders_images = Sliders::select('sliders_id','sliders_image_accueil','sliders_libelle_accueil')->where(['sliders_statut'=>"ACTIVE"])->orderby('sliders_datecrea','ASC')->get();

        $offres = Offre::join('users','users.id','offre.user_id')->where(['offre_statut'=>"PUBLIE"])
                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
                        ->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')
                        ->orderby('offre_datepublic','DESC')
                        ->paginate(12);

        $actualites  = Actualite::join('categorie','categorie.categorie_id','actualite.categorie_id')
        						->whereRaw('date(actualite_datefin) > "'.gmdate("Y-m-d").'" ')
        						->where(['actualite_statut'=>"PUBLIE"])
        						->orderby('actualite_id','DESC')
        						->paginate(6);

        return view('accueil',['offres'=>$offres, 'offre_nombre'=>$offre_nombre, 'user_nombre'=>$user_nombre, 'actualites'=>$actualites, 'nombre_candidat'=>$nombre_candidat, 'sliders_images'=>$sliders_images]);
    }

	//Liste des offres & Résultat recherche des offres
	public function Offres(){
		
		$offres = Offre::join('users','users.id','offre.user_id')
						->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
						->where(['offre.offre_statut'=>"PUBLIE"])
                        ->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')
                        ->orderby('offre_datepublic','DESC')
                        ->paginate(50);
		
		$contrats = TypeContrat::where(['typecontrat_statut'=>"VALIDE"])->get();
		
		$metiers = Metier::orderby('metier_libelle','ASC')->get();

		$regions = Region::orderby('region_nom','ASC')->get();
		
		return view('offres',['offres'=>$offres, 'contrats'=>$contrats, 'metiers'=>$metiers, 'regions'=>$regions]);
	}

	//Résultat de recherche
	public function Recherche(Request $request){
		
		$titre = $request->t;
		$metier = $request->m;
		$region = $request->r;

		$whereRaw = ' 1 ';

		if(!empty($titre)){
            $whereRaw.= ' AND offre.offretitre LIKE "%'.$titre.'%"';
        }
        if(!empty($metier)){
            $whereRaw.= " AND metier.metier_id = $metier ";
        } 
        if(!empty($region)){
			$whereRaw.= " AND offre_region.region_id = $region ";
		}

        $offres = Offre::join('users','users.id','offre.user_id')
                        ->join('metier','metier.metier_id','offre.metier_id')
                        ->join('offre_region','offre_region.offre_id','offre.offre_id')
                        ->whereRaw($whereRaw)
        				->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')
        				->paginate(50);

		//dd($offres);   
		             
		$contrats = TypeContrat::where(['typecontrat_statut'=>"VALIDE"])->get();

		$metiers = Metier::orderby('metier_libelle','ASC')->get();

		$regions = Region::orderby('region_nom','ASC')->get();
		
		return view('recherche', ['offres'=>$offres, 'contrats'=>$contrats, 'metiers'=>$metiers, 'regions'=>$regions, 'offre_titre_selected'=>$titre, 'metier_selected'=>$metier, 'region_selected'=>$region]);
	}

    //Résultat de recherche Offre par contrat
	public function OffreParContrat($typecontrat_id){
		
		$typecontrat = TypeContrat::find($typecontrat_id);
		
		if($typecontrat){

			$offres = Offre::join('users','users.id','offre.user_id')
						->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
						->where(['offre_statut'=>"PUBLIE", 'offre.typecontrat_id'=>$typecontrat->typecontrat_id])
						->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')
                        ->orderby('offre_datepublic','DESC')
                        ->paginate(50);

			$contrats = TypeContrat::where(['typecontrat_statut'=>"VALIDE"])->get();
			
			$metiers = Metier::orderby('metier_libelle','ASC')->get();

			$regions = Region::orderby('region_nom','ASC')->get();
		
			return view('offreparcontrat', ['typecontrat'=>$typecontrat,'offres'=>$offres, 'contrats'=>$contrats, 'metiers'=>$metiers, 'regions'=>$regions]);	
		}
	}
	
	//Résultat de recherche Offre par secteur d'activité
	public function OffreparMetier($metier_id){
		
		$metier_id = Metier::find($metier_id);
		
		$offres = Offre::join('users','users.id','offre.user_id')->where(['offre_statut'=>"PUBLIE"])
                        ->join('typecontrat','typecontrat.typecontrat_id','offre.typecontrat_id')
						->where(['offre.metier_id'=>$metier_id->metier_id])
						->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'" ')
						->orderby('offre_datepublic','DESC')
                        ->paginate(50);
						
		$contrats = TypeContrat::where(['typecontrat_statut'=>"VALIDE"])->get();
		
		$metiers = Metier::orderby('metier_libelle','ASC')->get();

		$regions = Region::orderby('region_nom','ASC')->get();
						
		return view('offreparsecteur',['metier_id'=>$metier_id, 'offres'=>$offres, 'contrats'=>$contrats, 'metiers'=>$metiers, 'regions'=>$regions]);
	}
		
    //Détails offre
    public function DetailsuneOffre($offre_id){
    	
        $offre = Offre::find($offre_id);
        
        if(!empty($offre)){

        	$user = User::where(['users.id'=>$offre->user_id])
                        ->first();

            $typecontrat = TypeContrat::where(['typecontrat.typecontrat_id'=>$offre->typecontrat_id])
                                        ->first();

            $metier = Metier::where(['metier.metier_id'=>$offre->metier_id])->first();
            
            $region = Region::where(['region.region_id'=>$offre->region_id])->first();

        	$offre_similaires = Offre::where('offre.metier_id', $offre->metier_id)
				                        ->where('offre.offre_id', '<>', $offre->offre_id)
				                        ->whereRaw('date(offre_datefin) >= "'.gmdate("Y-m-d").'"')
				                        ->join('users', 'users.id', '=', 'offre.user_id')
				                        ->orderBy('offre_datepublic', 'DESC')
				                        ->paginate(10);

			$metiers = Metier::orderby('metier_libelle','ASC')->get();

			$regions = Region::orderby('region_nom','ASC')->get();

            //dd($offre_similaires);
            return view('detailsoffre',['offre'=>$offre, 'user'=>$user, 'typecontrat'=>$typecontrat, 'metier'=>$metier, 'offres'=>$offre_similaires, 'metiers'=>$metiers, 'regions'=>$regions]);
        }          
    }

    //Formulaire de création de compte demandeur
    public function DemandeurEmploiCompteCreate(){
    	
    	$metiers = Metier::where(['metier_statut'=>"VALIDE"])->get();

    	$paysliste = Pays::where(['pays_statut'=>"VALIDE"])->orderby('nom_fr','ASC')->get();

        $regions = Region::where(['region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();
        
        $trancheages = TrancheAge::where(['trancheage_statut'=>"VALIDE"])->get();

        $filieres = Metier::where(['metier_statut'=>"VALIDE"])->orderby('metier_libelle','ASC')->get();

        $langueinter = LangueInternationale::where(['langueinter_statut'=>"VALIDE"])->get();

        $categories = CategorieProfessionelle::where(['catepro_statut'=>"VALIDE"])->orderby('catepro_lib','ASC')->get();

        $niveaux = NiveauInstruction::where(['niveauinstruction_statut'=>"VALIDE"])->orderby('niveau_lib','ASC')->get();

        $typedemandeur = TypeDemandeur::where(['situation_statut'=>"VALIDE"])->orderby('situation_lib','ASC')->get();

        $diplomes = Diplome::where(['diplome_statut'=>"VALIDE"])->get();

        $languelocale = LangueLocale::where(['languelocal_statut'=>"VALIDE"])->get();
        
        $typeinscriptions = TypeInscription::where(['typeinscription_statut'=>"VALIDE"])->orderby('typeinscription_lib','ASC')->get();

        $datesources = Carbon::now()->subYears(10);

        return view('demandeur.register', ['metiers'=>$metiers, 'diplomes'=>$diplomes, 'paysliste'=>$paysliste, 'regions'=>$regions, 'langueinter'=>$langueinter, 'trancheages'=>$trancheages, 'typedemandeur'=>$typedemandeur, 'languelocale'=>$languelocale, 'typeinscriptions'=>$typeinscriptions, 'categories'=>$categories, 'niveaux'=>$niveaux, 'datesources'=>$datesources]);
    }

    //Formulaire de création de compte entreprise
    public function EntrepriseCompteCreate(){

        $regions = Region::where(['region_statut'=>"VALIDE"])->orderby('region_nom','ASC')->get();

        $statuts = StatutEntreprise::where(['statutentreprise_statut'=>"VALIDE"])->get();

        $activites = SecteurActivite::where(['secteuractivite_statut'=>"VALIDE"])->orderby('secteuractivitelib','ASC')->get();

        $situations = SituationActivite::where(['situationentreprise_statut'=>"VALIDE"])->get();

        $nationalites = Nationalite::where(['nationalite_statut'=>"VALIDE"])->get();

        return view('entreprise.register',['regions'=>$regions, 'statuts'=>$statuts, 'activites'=>$activites, 'nationalites'=>$nationalites, 'situations'=>$situations]);
    }

    //Formualire de postulation à une offre d'emploi
    public function FormPostulerOffre($offre_id){

        $offre = Offre::where(['offre_id'=>$offre_id, 'offre_statut'=>'PUBLIE'])->first();

        //conserver l'identifiant de l'offre choisie
        session(['offre_id'=>$offre_id]);

        if(! Auth::user() > 0){

			return view('demandeur.postuleroffre', ['offre'=>$offre]);

		}else{

			return redirect()->route('home');

		}
	}
	
    //Notre mission
    public function NotreMission(){

    	return view('notremission');
    }

    //Conseil pour rediger un CV
    public function RedigerUnCV(){

    	return view('redigeruncv');
    }
	
	//Conseil pour rediger une lettre de motivation
	public function RedigerLettreMotivation(){

    	return view('redigerlettremotivation');
    }
	
	//Conseil pour faire un entretien d'embauche
	public function EntretienEmbauche(){

    	return view('entretienembauche');
    }
	
	//Affichage de la page d'inscription
    public function Inscription(){

    	return view('inscription');
    }

    //Affichage du formulaire de connexion
    public function SeConnecter(){

    	return view('seconnecter');
    }

    //Page de service
    public function Services(){

        return view('services');
    }
	
	//Page de PAIJ
    public function PAIJ(){

        return view('paij');
    }

    //Page de TRE
    public function TRE(){

        return view('tre');
    }

    //Page de COSIVIP
    public function COSIVIP(){

        return view('cosivip');
    }

    //Page de CRP
    public function CRP(){

        return view('crp');
    }

    //Page de PACE
    public function PACE(){

        return view('pace');
    }

    //Page de Carte Anpe
    public function CARTEANPE(){

        return view('carteanpe');
    }

    //Page de présentation
    public function Presentation(){

        return view('presentation');
    }  

    //Page de nos antennes
    public function NosAntennes(){

        return view('nosantennes');
    } 

    //Page de publication
    public function Publications(){

    	$publications = Publication::where('publication_statut','VALIDE')->orderby('publication_id','DESC')->paginate(16);

        return view('publications', compact('publications'));
    } 

    //Page de Politique de Confidentialite
    public function PolitiqueConfidentialite(){

        return view('politiqueconfidentialite');
    } 

    //Checker l'existence du numéro de téléphone dans la base de données.
    public function checkPhoneNumber(Request $request){

        $telephone = $request->input('telephone');

        // Vérifier si le numéro de téléphone existe dans la base de données
        $user = User::where('telephone', $telephone)->first();

        // Retourner une réponse JSON
        return response()->json(['exists' => !is_null($user)]);
    } 
}
