<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactMail extends Mailable
{
    use Queueable, SerializesModels;
    public $contact_data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($contact_data)
    {
        $this->contact_data = $contact_data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        // return $this->view('view.name');

        $from_name = "AGENCE NATIONALE POUR LA PROMOTION DE L'EMPLOI";
        $from_email = "info@anpe-niger.ne";
        $subject = "Nouveau message";
        return $this->from($from_email, $from_name)
            ->view('emails.contact')
            ->subject($subject)
        ;
    }
}
