<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Offre extends Model
{
    use HasFactory;

    protected $table            = "offre";
    protected $primaryKey       = "offre_id";
    public $timestamps          = false;

    public function contrat(){
        
        return $this->belongsTo(TypeContrat::class, 'typecontrat_id');
    }

    public function entreprise(){
        
        return $this->belongsTo(User::class, 'user_id');
    }

    public function region(){

        return $this->belongsTo(Region::class, 'region_id');
    }

    public function user() {
        return $this->belongsTo(User::class,'user_id')->where(['profil_id'=>2]);
    }

    public function regions()
    {
        return $this->belongsToMany(Region::class, 'offre_region', 'offre_id', 'region_id');
    }

    public function region_offre()
    {
        return $this->belongsToMany(Region::class, 'offre_region', 'offre_id', 'region_id')->limit(4);
    }

    public function diplome(){
        
        return $this->belongsTo(Diplome::class, 'diplome_id');
    }

    public function metier(){
        
        return $this->belongsTo(Metier::class, 'metier_id');
    }
}
