<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use BaconQrCode\Encoder\QrCode;
use App\Models\Diplome;
use App\Models\Metier;
use App\Models\Profil;
use App\Models\Formation;
use App\Models\ExperienceProfessionnelle;
use App\Models\Specialite;
use App\Models\CentreInteretLangue;
use App\Models\Pays;
use App\Models\Region;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'profil_id',
        'region_id',
        'pays_id',
        'role_id',
        'creerpar_id',
        'secteuractivite_id',
        'metier_id',
        'statutentreprise_id',
        'situationentreprise_id',
        'diplome_id',
        'nationalite_id',
        'trancheage_id',
        'typeinscription_id',
        'situation_id',
        'catepro_id',
        'niveau_id',
        'languelocal_id',
        'langueinter_id',
        'identifiant',
        'designation',
        'cv_joint',
        'situationmatrimoniale',
        'nationalite',
        'user_validitecarte',
        'datenaissance',
        'lieunaissance',
        'emploisouhaite',
        'nombreenfant',
        'departement',
        'user_cedeao',
        'user_nationalite',
        'user_passport',
        'user_permissejours',
        'commune',
        'village_quart',
        'handicap',
        'name',
        'prenoms',
        'qr_code',
        'email',
        'raisonsociale',
        'adresse',
        'contact',
		'date_ri_ni',
        'qualite',
        'nbrehomme',
        'nbrfemme',
		'effectiftotal',
        'telephone',
        'contactinterlo',
        'activite',
        'ncnss',
        'user_carte_statut',
        'user_carte',
        'genre',
        'entreprise_logo',
        'date_validation',
        'profil_photo',
        'user_cni',
        'user_dpc',
        'civilite',
        'user_cv',
        'user_att',
        'otp',
        'experience',
        'password',
        'lieu_inscription',
        'date_creation',
        'date_reinscription',
        'user_origine',
        'code_agent',
        'photo_cv',
        'type_handicap',
        'new_diplome',
        'new_metier',
        'new_languelocal',
        'new_langueinter',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
	
	public static function boot(){
        parent::boot();

        static::creating(function ($user) {
            $lastUser = static::where(['profil_id'=>3])->orderBy('created_at', 'desc')->first();
            $year = date('y');
            $count = $lastUser ? (int) substr($lastUser->identifiant, -4) + 1 : 1;
            $identifiant = $year . str_pad($count, 4, '0', STR_PAD_LEFT);
            $user->identifiant = $identifiant;
        });
    }

    public function diplome()
    {
        return $this->belongsTo(Diplome::class, 'diplome_id');
    }


    public function metier(){

        return $this->belongsTo(Metier::class, 'metier_id');
    }

    public function profil(){

        return $this->belongsTo(Profil::class, 'profil_id');
    }

    public function formations(){

        return $this->hasMany(Formation::class);
    }

    public function experiencepro(){

        return $this->hasMany(ExperienceProfessionnelle::class);
    }

    public function specialites(){

        return $this->hasMany(Specialite::class);
    }

    public function centreinterets(){

        return $this->hasMany(CentreInteretLangue::class);
    }

    public function pays(){

        return $this->belongsTo(Pays::class);
    }

    public function region(){

        return $this->belongsTo(Region::class);
    }
}