<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Region;
use App\Models\Diplome;
use App\Models\Metier;

class Utilisateur extends Model
{
    use HasFactory;
	
	protected $fillable = [
        'nom',
        'diplome_id',
        'region_id',
        'metier_id',

    ];
	
	public function metier()
	{
		return $this->belongsTo(Metier::class);
	}

	public function diplome()
	{
		return $this->belongsTo(Diplome::class);
	}

	public function region()
	{
		return $this->belongsTo(Region::class);
	}

}
