<?php
    use Carbon\Carbon;
?>
@extends('layouts.app')
@section('title')
    Accueil
@endsection

@section('content')
<style>
    .actualite-image{
        height: 300px !important;
    }
    .slider-text{
        color: #fff;
        margin-top: -155px !important;
    }
</style>

@if($sliders_images->count() > 0)
<div id="carouselExampleCaptions" class="carousel slide" data-ride="carousel">
  <ol class="carousel-indicators">
    @foreach($sliders_images as $key => $images_slider)
        <li data-target="#carouselExampleCaptions" data-slide-to="{{ $key }}" class="{{ $key === 0 ? 'active' : '' }}"></li>
    @endforeach
  </ol>
  <div class="carousel-inner">
    @foreach($sliders_images as $key => $images_slider)
        <div class="carousel-item {{ $key === 0 ? 'active' : '' }}">
            <img src="{{ asset('assets/img/sliders/'.$images_slider->sliders_image_accueil) }}" style="height:600px !important" class="d-block w-100" alt="...">
            <div class="carousel-caption d-none d-md-block">
                <h1 class="slider-text">{{ $images_slider->sliders_libelle_accueil }}</h1>
            </div>
        </div>
    @endforeach
  </div>
  <a class="carousel-control-prev" href="#carouselExampleCaptions" role="button" data-slide="prev">
    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
    <span class="sr-only"></span>
  </a>
  <a class="carousel-control-next" href="#carouselExampleCaptions" role="button" data-slide="next">
    <span class="carousel-control-next-icon" aria-hidden="true"></span>
    <span class="sr-only"></span>
  </a>
</div>
@else
<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
  <ol class="carousel-indicators">
    <li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>
    <li data-target="#carouselExampleIndicators" data-slide-to="1"></li>
  </ol>
  <div class="carousel-inner">
    <div class="carousel-item active">
      <img src="{{ asset('assets/img/sliders/slider_1.jpeg') }}" class="d-block w-100" alt="...">
    </div>
    <div class="carousel-item">
      <img src="{{ asset('assets/img/sliders/slider_2.jpeg') }}" class="d-block w-100" alt="...">
    </div>
  </div>
</div>
@endif


<!-- ================================ Statistiques ================================ -->
<section class="p-0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="crp_box fl_color ovr_top">
                    <div class="row align-items-center">
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
                            <div class="dro_140">
                                <div class="dro_141 de"><i class="lni lni-gallery"></i></div>
                                <div class="dro_142">
                                    @if($offre_nombre > 1000)
                                        <?php
                                            $offre_nombre_premiers_caracteres = substr($offre_nombre, 0, 2);
                                            echo $offre_nombre_premiers_caracteres.'K';
                                        ?>
                                    @else   
                                        {{ $offre_nombre }} 
                                    @endif
                                    Offres d'Emplois publiées
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
                            <div class="dro_140">
                                <div class="dro_141 de"><i class="lni lni-briefcase"></i></div>
                                <div class="dro_142">
                                    <h6>
                                        @if($user_nombre > 1000)
                                            <?php
                                                $user_nombre_premiers_caracteres = substr($user_nombre, 0, 2);
                                                echo $user_nombre_premiers_caracteres.'K';
                                            ?>
                                        @else   
                                            {{ $user_nombre }} 
                                        @endif
                                        Employeurs
                                    </h6>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
                            <div class="dro_140">
                                <div class="dro_141 de"><i class="lni lni-graduation"></i></div>
                                <div class="dro_142">
                                    <h6> 
                                        @if($nombre_candidat > 1000)
                                            <?php
                                                $nombre_candidat_premiers_caracteres = substr($nombre_candidat, 0, 2);
                                                echo $nombre_candidat_premiers_caracteres.'K';
                                            ?>
                                        @else   
                                            {{ $nombre_candidat }} 
                                        @endif
                                        Demandeur d'emploi
                                    </h6>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    
    </div>
</section>
<!-- ================================ Statistiques ================================ -->

<!-- ======================= Liste des emplois ======================== -->
@if($offres->count() > 0)
<section class="middle">
    <div class="container">
    
        <div class="row justify-content-center">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                <div class="sec_title position-relative text-center mb-5">
                    <h2 class="ft-bold">Dernières offres d´emploi</h2>
                </div>
            </div>
        </div>
        
        <div class="row align-items-center">
            @foreach($offres as $offre)
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="jbr-wrap text-left border rounded">
                        <div class="cats-box mlb-res rounded bg-white d-flex align-items-center justify-content-between px-3 py-3">
                            <div class="cats-box rounded bg-white d-flex align-items-center">
                                <div class="text-center"><img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
                                <div class="cats-box-caption px-2">
                                    <h5 class="ft-medium mb-1" style="font-size:16px">
                                        <a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}">
                                            <?php echo html_entity_decode($offre->offretitre) ?>
                                        </a>
                                    </h5>
                                    <div class="d-block mb-2 position-relative">
                                        <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i>
                                            @foreach($offre->region_offre as $region)
                                                <span class="mr-2 mb-2 d-inline-flex px-2 py-1 rounded {{ $region->region_couleur }} text-capitalize">{{ $region->region_nom }}</span>
                                            @endforeach 
                                        </span>
                                        <span class="text-muted mr-2"><i class="lni lni-briefcase mr-1"></i>{{ $offre->contrat->typecontratlib }}</span>
                                        <span class="text-success ml-2 theme-cl"><i class="fa fa-clock mr-1"></i>
                                            @php
                                                $datejour = \Carbon\Carbon::today();
                                                $datefin = \Carbon\Carbon::createFromFormat('Y-m-d', $offre->offre_datefin);
                                                $joursrestant = $datejour->diffInDays($datefin);
                                                if($joursrestant < 1){
                                                    echo('Expire dans quelques heures');
                                                }
                                                if($joursrestant >= 1){
                                                    echo('Expire dans '.$joursrestant. ' jours');
                                                }                                                        
                                            @endphp   
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center mlb-last"><a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="btn btn-md theme-bg ft-medium text-light apply-btn fs-sm rounded">Détails<i class="lni lni-arrow-right-circle ml-1"></i></a></div>
                        </div>
                    </div>
                </div>
            @endforeach 
        </div>
        
        <div class="row justify-content-center">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                <div class="position-relative text-center">
                    <a href="{{ route('offres') }}" class="btn btn-md theme-bg rounded text-light hover-theme">Explorer plus d'emplois<i class="lni lni-arrow-right-circle ml-2"></i></a>
                </div>
            </div>
        </div>
    </div>
</section>
@endif 
<!-- ======================= Liste des emplois ======================== -->

<!-- ======================= Liste des actualités ======================== -->
@if($actualites->count() > 0)
<section class="space gray min">
    <div class="container">
        
        <div class="row justify-content-center">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                <div class="sec_title position-relative text-center mb-4">
                    <h2 class="ft-bold">Actualités de l'emploi</h2>
                </div>
            </div>
        </div>
        
        <div class="row justify-content-center">
            
            @foreach($actualites as $actualite)  
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12">
                    <div class="blg_grid_box" style="height: 510px !important;">
                        <div class="blg_grid_thumb">
                            <a href="{{ route('detailsactualite',[$actualite->actualite_id, Stdfn::clean_url($actualite->actualite_titre)]) }}"><img src="{{ asset('assets/img/actualite/'.$actualite->actualite_image) }}" class="img-fluid actualite-image" alt=""></a>
                        </div>
                        <div class="blg_grid_caption">
                            <div class="blg_tag"><span>{{ $actualite->categorielib }}</span></div>
                            <div class="blg_title"><h4><br>
                                <a href="{{ route('detailsactualite',[$actualite->actualite_id, Stdfn::clean_url($actualite->actualite_titre)]) }}">                                    
                                    @php
                                        $titre = $actualite->actualite_titre;
                                        $titre_affiche = substr($titre, 0, 100);
                                        if($titre_affiche < $actualite->actualite_titre){
                                            
                                            echo html_entity_decode($titre_affiche).'...';
                                        }
                                        else{      
                                            echo html_entity_decode($actualite->actualite_titre);
                                        }
                                    @endphp
                                </a>
                            </h4></div>
                            <div class="blg_desc"><p>
                                
                            </p></div>
                        </div>
                        <div class="crs_grid_foot">
                            <div class="crs_flex d-flex align-items-center justify-content-between br-top px-3 py-2">
                                <div class="elsio_ic"><a href="{{ route('detailsactualite',[$actualite->actualite_id, Stdfn::clean_url($actualite->actualite_titre)]) }}"><i class="fa fa-eye text-success"></i> Détails</a></div>
                                <div class="crs_fl_last">
                                    <div class="foot_list_info">
                                        <ul>
                                            <li><div class="elsio_ic"><i class="fa fa-clock text-warning"></i></div><div class="elsio_tx">
                                                @php                                        
                                                    $date_publication = $actualite->actualite_datecrea;

                                                    $date = Carbon::parse($date_publication)->locale('fr_FR')->translatedFormat('d F Y');

                                                    echo $date;
                                                @endphp
                                            </div></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
    </div>
</section>
@endif
<!-- ======================= Liste des actualités ======================== -->

<!-- ======================= Liste de nos partenaires ======================== -->
<section class="middle @if($actualites->count() == 0) gray @endif">
    <div class="container">
    
        <div class="row justify-content-center">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                <div class="sec_title position-relative text-center mb-5">
                    <h2 class="ft-bold">Nos Partenaires</h2>
                </div>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-xl-9 col-lg-10 col-md-12 col-sm-12">
                <div class="reviews-slide px-3">
                    
                    <div class="single_review">
                        <div class="sng_rev_thumb"><figure><img src="{{ asset('assets/img/partenaires/cropped-LOGO-PEJIP-REPRISE-1-300x298.png') }}" class="img-fluid" alt="" style="width:200px !important"></figure></div>
                    </div>

                    <div class="single_review">
                        <div class="sng_rev_thumb"><figure><img src="{{ asset('assets/img/partenaires/IOM-Logo-IOM-OIM-IOM-Blue-278x300.png') }}" class="img-fluid" alt="" style="width:200px !important"></figure></div>
                    </div>

                    <div class="single_review">
                        <div class="sng_rev_thumb"><figure><img src="{{ asset('assets/img/partenaires/logo-cnss-300x287.png') }}" class="img-fluid" alt="" style="width:200px !important"></figure></div>
                    </div>

                    <div class="single_review">
                        <div class="sng_rev_thumb"><figure><img src="{{ asset('assets/img/partenaires/LOGO-FAFPA-NIGER-270x300.png') }}" class="img-fluid" alt="" style="width:200px !important"></figure></div>
                    </div>

                    <div class="single_review">
                        <div class="sng_rev_thumb"><figure><img src="{{ asset('assets/img/partenaires/PRODEC-LOGO-1-300x300.png') }}" class="img-fluid" alt="" style="width:200px !important"></figure></div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ======================= Liste de nos partenaires ======================== -->

<!-- ======================= Abonnement à la Newsletter ======================== -->
<section class="space bg-cover" style="background:#28b661 url({{ asset('assets/img/landing-bg.png') }}) no-repeat;">
    <div class="container py-5">
        
        <div class="row justify-content-center">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                <div class="sec_title position-relative text-center mb-5">
                    <h2 class="ft-bold text-light">Recevez toutes les nouvelles notifications d'emploi</h2>
                </div>
            </div>
        </div>
        
        <div class="row align-items-center justify-content-center">
            <div class="col-xl-7 col-lg-10 col-md-12 col-sm-12 col-12">
                <form method="POST" action="{{ route('save.newsletter') }}" class="bg-white rounded p-1">
                    @csrf
                    <div class="row no-gutters">
                        <div class="col-xl-9 col-lg-9 col-md-8 col-sm-8 col-8">
                            <div class="form-group mb-0 position-relative">
                                <input type="email" class="form-control lg left-ico" name="email" placeholder="Entrez votre adresse email">
                                <i class="bnc-ico lni lni-envelope"></i>
                                @if($errors->any())
                                    @foreach($errors->all() as $error)
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $error }}</strong>
                                        </span>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                        <div class="col-xl-3 col-lg-3 col-md-4 col-sm-4 col-4">
                            <div class="form-group mb-0 position-relative">
                                <button class="btn full-width custom-height-lg bg-dark text-white fs-md" type="submit">S'abonner</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
<!-- ======================= Abonnement à la Newsletter ======================== -->

<script>
    @if($errors->any())
        @foreach($errors->all() as $error)
            toastr.error("{{ $error }}", "MESSAGE D'ERREUR")
        @endforeach
    @endif
</script>

<script>
$(document).ready(function() {
    // Initialiser le carrousel Bootstrap
    $('#carouselExampleCaptions').carousel();

    // Définir l'intervalle de défilement automatique à 10 secondes
    var interval = 20000; // 10 secondes

    // Fonction pour déclencher le défilement automatique
    function startCarousel() {
        setInterval(function() {
            $('#carouselExampleCaptions').carousel('next');
        }, interval);
    }

    // Démarrer le défilement automatique
    startCarousel();
});
</script>
@endsection