<?php
    use Carbon\Carbon;
?>
@extends('layouts.app')
@section('title')
    Liste des actualité
@endsection

@section('content')
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Toutes les actualités</h1>
                </div>
            </div>
        </div>
    </div>
</div>
<section class="bg-light">
	<div class="container">
		<div class="row">
			<div class="col-lg-4 col-md-12 col-sm-12">
				<div class="bg-white rounded mb-4">	
					<div class="sidebar_header d-flex align-items-center justify-content-between px-4 py-3 br-bottom">
						<h4 class="ft-medium fs-lg mb-0">Rechercher par catégories</h4>
					</div>
					<div class="sidebar-widgets collapse miz_show" id="search_open" data-parent="#search_open">
						<div class="search-inner">
							<div class="filter-search-box px-4 pt-3 pb-0">
								@foreach($categories as $categorie)
									<p style="font-size:16px;"><i class="fa fa-check-circle"></i> <a href="{{ route('detailscategorie',$categorie->categorie_id) }}">{{ $categorie->categorielib }}</a></p>
								@endforeach
							</div><br>
						</div>							
					</div>
				</div>
			</div>
			<div class="col-lg-8 col-md-12 col-sm-12">
				<div class="row align-items-center">
					@forelse($actualites as $actualite)
						<div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
							<div class="blg_grid_box" style="height:460px">
								<div class="blg_grid_thumb">
									<a href="{{ route('detailsactualite',[$actualite->actualite_id, Stdfn::clean_url($actualite->actualite_titre)]) }}"><img src="{{ asset('assets/img/actualite/'.$actualite->actualite_image) }}" class="img-fluid" alt=""></a>
								</div>
								<div class="blg_grid_caption">
									<div class="blg_tag"><span>{{ $actualite->categorielib }}</span></div>
									<div class="blg_title"><h4><a href="{{ route('detailsactualite',[$actualite->actualite_id, Stdfn::clean_url($actualite->actualite_titre)]) }}">
										@php
	                                        $titre = $actualite->actualite_titre;
	                                        $titre_affiche = substr($titre, 0, 100);
	                                        if($titre_affiche < $actualite->actualite_titre){
	                                            
	                                            echo html_entity_decode($titre_affiche).'...';
	                                        }
	                                        else{      
	                                            echo html_entity_decode($actualite->actualite_titre);
	                                        }
	                                    @endphp
									</a></h4></div>
								</div>
								<div class="crs_grid_foot">
									<div class="crs_flex d-flex align-items-center justify-content-between br-top px-3 py-2">
										<div class="crs_fl_last">
											<div class="foot_list_info">
												<ul>
													<li><a href="{{ route('detailsactualite',[$actualite->actualite_id, Stdfn::clean_url($actualite->actualite_titre)]) }}">Détails</a></li>
													<li><div class="elsio_ic"><i class="fa fa-eye text-success"></i></div><div class="elsio_tx">{{ $actualite->commentaires->count() }} Commentaires</div></li>
													<li><div class="elsio_ic"><i class="fa fa-clock text-warning"></i></div><div class="elsio_tx">														
														@php		                                
			                                                $date_publication = $actualite->actualite_datecrea;

			                                                $date = Carbon::parse($date_publication)->locale('fr_FR')->translatedFormat('d F Y');

			                                                echo $date;
			                                            @endphp
													</div></li>
												</ul>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					@empty
						<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
							<div class="alert alert-primary text-center" style="font-size:22px; font-weight:bold">
								Il n'y a aucune actualité publiée pour l'instant
							</div>
						</div>
					@endforelse
				</div>
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12">
						<ul class="pagination">
							<li class="">{{ $actualites->links() }}</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
@endsection