@extends('layouts.appp')

@section('title')
    Liste des commentaires à valider
@endsection

@section('titre')
    Liste des commentaires à valider
@endsection

@section('content') 
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion articles</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">commentaires à valider</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Liste des commentaires à valider</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT"))
                        <table id="example3" class="display min-w850">
                            <thead>
                                <tr>
                                    <th>Libellé</th>
                                    <th>Nom Commentateur</th>
                                    <th>Date</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($commentaires as $commentaire)
                                    <tr>
                                        <td>{{ $commentaire->commentairelib }}</td>
                                        <td>{{ $commentaire->commentairename }}</td>
                                        <td>{{ \Carbon\Carbon::parse($commentaire->commentaire_datecrea)->format('d/m/Y') }}</td>                                            
                                        <td class="text-center">
                                            @if($commentaire->commentaire_statut == "BROUILLON")
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART"))                                            
                                                    <span class="validercommentaire" data-url="{{ route('admin.valider.commentaire',$commentaire->commentaire_id) }}" title="VALIDER LE COMMENTAIRE" data-id="{{ $commentaire->commentaire_id }}" data-name="{{ $commentaire->commentairename }}"><img src="{{ asset('assets/img/icons/validercone.png') }}" class="img-fluid" width="27" alt=""></span>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_CMT"))
                                                    <span data-toggle="modal" data-target="#supprimercommentaire{{$commentaire->commentaire_id}}" title="SUPPRIMER"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>
                                                @endif
                                            @else
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_CMT"))
                                                    <span data-toggle="modal" data-target="#supprimercommentaire{{$commentaire->commentaire_id}}" title="SUPPRIMER"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>                                    
                                                @endif
                                            @endif
                                        </td>                                             
                                    </tr>
                                    <div class="modal fade" id="supprimercommentaire{{$commentaire->commentaire_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Vous êtes sur le point de supprimer le commentaire de : {{$commentaire->commentairename}}
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                    <a href="{{ route('admin.supprimer.commentaire',$commentaire->commentaire_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection