@extends('layouts.appp')

@section('title')
    Publier un article
@endsection

@section('titre')
    Publier un article
@endsection

@section('content')
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion articles</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Publier un article</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Publier un article</h4>
                </div>
                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART"))
                    <div class="card-body">
                        <div class="basic-form">
                            <form method="POST" action="{{ route('admin.save.article') }}" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>Titre <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('titre') is-invalid @enderror" name="titre" placeholder="Titre de l'actualité" value="{{ old('titre') }}">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label>Sous-Titre</label>
                                        <textarea class="form-control" rows="4" name="soustitre">{{ old('soustitre') }}</textarea>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Publier par <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('publierpar') is-invalid @enderror" name="publierpar" value="{{ old('publierpar') }}" placeholder="Publier par">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Catégorie article <span class="text-danger">*</span></label>
                                        <select class="form-control" id="single-select" name="categorie_id">
                                            <option value="">Choisissez un catégorie</option>
                                            @foreach($categories as $categorie) 
                                                <option value="{{ $categorie->categorie_id }}" {{ old('categorie_id') == $categorie->categorie_id ? 'selected' : '' }}>{{ $categorie->categorielib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Image Principale  <span class="text-danger">*</span><small>(Extension autorisé : png,jpg,jpeg)</small></label>
                                        <input type="file" name="image" class="form-control @error('image') is-invalid @enderror">
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label>Description <span class="text-danger">*</span></label>
                                        <textarea id="summernote" class="form-control @error('description') is-invalid @enderror" name="description" placeholder="Description...">{{ old('description') }}</textarea>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label>Autre Information <span class="text-danger">*</span></label>
                                        <textarea id="AutreInfo" class="form-control" name="information" placeholder="Autre Information...">{{ old('information') }}</textarea>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label>Témoignage</label>
                                        <textarea id="temoignage" class="form-control" name="temoignage" placeholder="Témoignage...">{{ old('temoignage') }}</textarea>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary">Publier l'article</button>
                            </form>
                        </div>
                    </div>
                @else
                    <center><br><br>
                        Vous n'avez pas d'accès pour publier un article
                    </center><br><br>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection