@extends('layouts.appp')

@section('title')
    Détails
@endsection 

@section('titre')
    Détails
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion articles</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.liste.article') }}">Liste des articles</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Détails de l'article</a></li>
            </ol>
        </div>
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Détails de l'article</h4>
                </div>
                <div class="card-body">
                    <!-- Nav tabs -->
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Informations générale</a>
                            </li>
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT"))
                                @if($commentaires->count() > 0)
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#commentaire"><i class="flaticon-381-notepad mr-2"></i> Commentaire sur l'article</a>
                                    </li>
                                @endif
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                            <div class="tab-content">
                                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                    <img class="img-fluid" src="{{ asset('assets/img/actualite/'.$article->actualite_image) }}" alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                            <div class="product-detail-content">
                                                                <div class="new-arrival-content pr">
                                                                    <p class="text-couleur"><span style="color: #000;">Titre :</span> <?php echo html_entity_decode($article->actualite_titre) ?></p>
                                                                    <p class="text-couleur"><span style="color: #000;">Sous-Titre :</span> <?php echo html_entity_decode($article->actualite_soustitre) ?></p>
                                                                    <p class="text-couleur"><span style="color: #000;">Catégorie :</span> <span class="badge badge-success light">{{ $categorie->categorielib }}</span></p>
                                                                    <p class="text-couleur"><span style="color: #000;">Publier Par :</span> {{ $article->actualite_publiepar }}</p>
                                                                    <p class="text-couleur"><span style="color: #000;">Date fin :</span> {{ \Carbon\Carbon::parse($article->actualite_datefin)->format('d/m/Y') }}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <br><hr>
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <h2 class="post-title">Description</h2>
                                                            <?php echo html_entity_decode($article->actualite_descrip) ?>
                                                            <hr>                                                            
                                                        </div>
                                                        <div class="col-md-12">
                                                            <h2 class="post-title">Autre Détails</h2>
                                                            <?php echo html_entity_decode($article->actualite_autre) ?>
                                                            <hr>                                                           
                                                        </div>
                                                        <div class="col-md-12">
                                                            @if($article->actualite_temoign != null)
                                                                <h2 class="post-title">Témoignage</h2>                               
                                                                <?php echo html_entity_decode($article->actualite_temoign) ?>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="commentaire">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th>Libellé</th>
                                                    <th>Nom Commentateur</th>
                                                    <th>Valider Par</th>
                                                    <th>Date</th>
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_CMT"))
                                                    <th>Statut</th>
                                                    @endif
                                                    <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($commentaires as $commentaire)
                                                    <tr>
                                                        <td>
                                                            <img src="{{ asset('assets/img/actualite/'.$commentaire->actualite_image) }}" class="img-fluid" width="55" alt="">
                                                        </td>
                                                        <td>{{ $commentaire->commentairelib }}</td>
                                                        <td>{{ $commentaire->commentairename }}</td>
                                                        <td>{{ $commentaire->name }} {{ $commentaire->prenoms }}</td>
                                                        <td>{{ \Carbon\Carbon::parse($commentaire->commentaire_datecrea)->format('d/m/Y') }}</td>                                            
                                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_CMT"))
                                                        <td>
                                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                                @if($commentaire->commentaire_statut == "VALIDE")
                                                                    <a href="{{ route('admin.desactiver.commentaire',$commentaire->commentaire_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                                @else
                                                                    <a href="{{ route('admin.activer.commentaire',$commentaire->commentaire_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                                @endif
                                                            @endif
                                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART"))
                                                                @if($commentaire->commentaire_statut == "VALIDE")
                                                                    <a href="{{ route('admin.desactiver.commentaire',$commentaire->commentaire_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                                @endif
                                                            @endif
                                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_CMT"))
                                                                @if($commentaire->commentaire_statut == "BROUILLON")
                                                                    <a href="{{ route('admin.activer.commentaire',$commentaire->commentaire_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                                @endif
                                                            @endif
                                                        </td>
                                                        @endif
                                                        <td class="text-center">
                                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_CMT"))
                                                                <span class="supprimercommentaire" data-url="{{ route('admin.supprimer.commentaire',$commentaire->commentaire_id) }}" data-name="{{ $commentaire->commentairename }}"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>                                         
                                                            @endif
                                                        </td>                                             
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection