@extends('layouts.appp')

@section('title')
    Liste des articles
@endsection

@section('titre')
    Liste des articles
@endsection

@section('content') 
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion articles</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des articles</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des articles publiés</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.liste.article') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-5">
                                    <label>Catégorie Article</label>
                                    <select id="single-select" name="c">
                                        <option value="">Choissisez une catégorie</option>
                                        @foreach($categories as $categorie)
                                            <option @if($categorie_selected == $categorie->categorie_id) selected @endif value="{{ $categorie->categorie_id }}">{{ $categorie->categorielib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-5">
                                    <label>Date de clôture</label>
                                    <input type="date" value="{{ $date_selected }}" name="d" class="form-control">
                                </div>
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_ART"))
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Titre de l'actualite</th>
                                        <th>Cartégorie</th>
                                        <th>Publier par</th>
                                        <th>Enregistrer par</th>
                                        <th>Date de clôture</th>
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART"))
                                        <th>Statut</th>
                                        @endif
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($articles as $article)
                                        <tr>
                                            <td class="d-none"></td>
                                            <td>
                                                @php
                                                    $titre = $article->actualite_titre;
                                                    $titre_affiche = substr($titre, 0, 56);
                                                    if($titre_affiche < $article->actualite_titre){
                                                        echo($titre_affiche).'...';
                                                    }
                                                    else{                                            
                                                        echo($article->actualite_titre);
                                                    }
                                                @endphp
                                            </td>
                                            <td><span class="badge badge-success light">{{ $article->categorielib }}</span></td>
                                            <td>{{ $article->actualite_publiepar }}</td>
                                            <td>{{ $article->name }} {{ $article->prenoms }}</td>
                                            <td>{{ \Carbon\Carbon::parse($article->actualite_datefin)->format('d/m/Y') }}</td>
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART"))
                                            <td>
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    @if($article->actualite_statut == "PUBLIE")
                                                        <a href="{{ route('admin.desactiver.article',$article->actualite_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a>  
                                                    @else
                                                        <a href="{{ route('admin.activer.article',$article->actualite_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                    @endif
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART"))
                                                    @if($article->actualite_statut == "PUBLIE")
                                                        <a href="{{ route('admin.desactiver.article',$article->actualite_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                    @else
                                                        <span class="badge badge-warning">Non actif</span>
                                                    @endif
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART"))
                                                    @if($article->actualite_statut == "BROUILLON")
                                                        <a href="{{ route('admin.activer.article',$article->actualite_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                    @else
                                                        <span class="badge badge-success">Actif</span>
                                                    @endif
                                                @endif
                                            </td>
                                            @endif 
                                            <td class="text-center">
                                                <a href="{{ route('admin.details.article',[$article->actualite_id, Stdfn::clean_url(html_entity_decode($article->actualite_titre))]) }}" style="cursor: pointer;" title="DETAILS DE L'ARTICLE"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-fluid" width="23"></a>
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART"))
                                                    <a href="{{ route('admin.modifier.article',[$article->actualite_id, Stdfn::clean_url(html_entity_decode($article->actualite_titre))]) }}" title="MODIFIER L'ARTICLE" style="cursor:pointer"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_ART"))
                                                    <span data-toggle="modal" data-target="#supprimeractualite{{$article->actualite_id}}" title="SUPPRIMER L'ARTICLE" data-id="{{ $article->actualite_id }}" data-name="{{ $article->actualite_titre }}"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>
                                                @endif
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="supprimeractualite{{$article->actualite_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer l'article : {{$article->actualite_titre}}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.article',$article->actualite_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection