@extends('layouts.appp')

@section('title')
    Modification de l'article
@endsection

@section('titre')
    Modification de l'article
@endsection

@section('content')
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion articles</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Liste des articles</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Modifier</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Modification de l'article : <?php echo html_entity_decode($article->actualite_titre) ?></h4>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form method="POST" action="{{ route('admin.save-modifier.article',$article->actualite_id) }}" enctype="multipart/form-data">
                            @csrf
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <label>Titre <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('titre') is-invalid @enderror" name="titre" value="{{  html_entity_decode($article->actualite_titre) }}" placeholder="Titre de l'actualité">
                                </div>
                                <div class="form-group col-md-12">
                                    <label>Sous-Titre</label>
                                    <textarea class="form-control" rows="4" name="soustitre"><?php echo html_entity_decode($article->actualite_soustitre) ?></textarea>
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Publier par <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('publierpar') is-invalid @enderror" name="publierpar" placeholder="Publier par" value="{{ $article->actualite_publiepar }}">
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Catégorie <span class="text-danger">*</span></label>
                                    <select class="form-control" name="categorie_id">
                                        <option value="">Choisissez un catégorie</option>
                                        @foreach($categories as $categorie) 
                                            <option @if($article->categorie_id == $categorie->categorie_id) selected @endif value="{{ $categorie->categorie_id }}">{{ $categorie->categorielib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-md-6">
                                    <label>Image <small>(Extension autorisé : png,jpg,jpeg)</small></label>
                                    <input type="file" name="image" class="form-control @error('image') is-invalid @enderror">
                                    @if(!empty($article->actualite_image))
                                        <a href="{{ asset('assets/img/actualite/'.$article->actualite_image) }}" target="_blank">Voir l'image</a>
                                        <input type="hidden" name="ancien_image" value="{{ $article->actualite_image }}">
                                    @endif
                                </div>
                                <div class="form-group col-md-12">
                                    <label>Description <span class="text-danger">*</span></label>
                                    <textarea id="summernote" class="form-control @error('description') is-invalid @enderror" name="description" placeholder="Description..."><?php echo html_entity_decode($article->actualite_descrip) ?></textarea>
                                </div>
                                <div class="form-group col-md-12">
                                    <label>Autre Information <span class="text-danger">*</span></label>
                                    <textarea id="AutreInfo" class="form-control" name="information" placeholder="Autre Information..."><?php echo html_entity_decode($article->actualite_autre) ?></textarea>
                                </div>
                                <div class="form-group col-md-12">
                                    <label>Témoignage</label>
                                    <textarea id="temoignage" class="form-control" name="temoignage" placeholder="Témoignage..."><?php echo html_entity_decode($article->actualite_temoign) ?></textarea>
                                </div>                                
                            </div>
                            <button type="submit" class="btn btn-primary">Enregistrer</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection