@extends('layouts.appp')

@section('title')
    Liste des candidatures à valider
@endsection

@section('titre')
    Liste des candidatures à valider
@endsection

@section('content')
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Gestions Demandeurs</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des candidatures à valider</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND")  or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND"))
                <div class="card-header">
                    <h4 class="card-title">Liste des candidatures à valider</h4>
                    <div class="float-end">
                        @if($user_candidature->count() > 0)
                            <a href="{{ route('admin.candidature-export.pdf') }}" class="badge badge-primary">Export PDF</a>
                            <a href="{{ route('admin.candidature-export.excel') }}" class="badge badge-success">Export Excel</a>
                        @endif
                    </div>
                </div>
                <div class="card-body">                    
                    <form action="{{ route('admin.candidature.avalider') }}" class="mb-10">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="">Région</label>
                                    <select id="metier_select" name="r">
                                        <option value="">Choisissez une region</option>
                                        @foreach($regions as $region)
                                            <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label>Tranche d'âge</label>
                                <select id="single-select" name="a">
                                    <option value="">Choissisez un tranche d'âge</option>
                                    @foreach($trancheages as $trancheage)
                                        <option @if($trancheage_select == $trancheage->trancheage_id) selected @endif value="{{ $trancheage->trancheage_id}}">{{ $trancheage->trancheage_lib }}</option>
                                    @endforeach
                                </select>
                            </div>                            
                            <div class="col-md-6">
                                <label>Genre</label>
                                <select name="g" class="form-control">
                                    <option value="">Choissisez un genre</option>
                                    <option @if($genre_select == "F") selected @endif value="F">Femme</option>
                                    <option @if($genre_select == "H") selected @endif value="H">Homme</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label>Situation matrimoniale</label>
                                <select class="form-control" name="s">
                                    <option value="">Choisissez une situation</option>
                                    <option @if($situation_select == "CELIBATAIRE") selected @endif value="CELIBATAIRE">CELIBATAIRE</option>
                                    <option @if($situation_select == "MARIE(E)") selected @endif value="MARIE(E)">MARIE(E)</option>
                                    <option @if($situation_select == "DIVORCE(E)") selected @endif value="DIVORCE(E)">DIVORCE(E)</option>
                                    <option @if($situation_select == "VEUF(E)") selected @endif value="VEUF(E)">VEUF(E)</option>
                                </select>
                            </div>
                        </div>
                        <div class="row mt-3">                            
                            <div class="col-md-2">
                                <label class="mt-3"></label>
                                <button class="btn btn-info btn-block">Rechercher</button>
                            </div>
                        </div>
                    </form><hr>
                    <div class="table-responsive">
                        <table id="example3" class="display min-w850">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Titre offre</th>
                                    <th>Candidat</th>
                                    <th>Date</th>
                                    <th>Statut</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($user_candidature as $candidature)
                                    <tr>
                                        <td>
                                            @if($candidature->profil_photo != null)
                                                <img src="{{ asset('assets/img/profil/'.$candidature->profil_photo) }}" class="img-fluid" width="45" alt="">
                                            @else
                                                <img src="{{ asset('assets/img/profil/avatar.png') }}" class="img-fluid" width="45" alt="">
                                            @endif
                                        </td>
                                        <td>
                                            <div class="cats-box rounded bg-white d-flex align-items-center">
                                                <div class="cats-box-caption px-2">
                                                    <h4 class="fs-md mb-0 ft-medium" style="font-size:16px !important">{{ $candidature->offretitre }}</h4>
                                                    <div class="d-block mb-2 position-relative">
                                                        <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>{{ $candidature->typecontratlib }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ $candidature->name }} {{ $candidature->prenoms }}</td>
                                        <td>{{ \Carbon\Carbon::parse($candidature->abonnement_datecrea)->format('d/m/Y') }}</td>
                                        <td>
                                            @if($candidature->candidature_statut == "BROUILLON")
                                                <span class="badge badge-danger">Brouillon</span>
                                            @elseif($candidature->candidature_statut == "VALIDE")
                                                <span class="badge badge-warning">Active</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                <span class="mr-1" data-toggle="modal" data-target="#validationcandidature{{$candidature->candidature_id}}" title="VALIDER LA CANDIDATURE"><img src="{{ asset('assets/img/icons/validercone.png') }}" class="img-fluid" width="25" alt=""></span>                                           
                                                <span data-toggle="modal" data-target="#annulercandidature{{$candidature->candidature_id}}" title="SUPPRIMER LA CANDIDATURE"><img src="{{ asset('assets/img/icons/delete.png') }}" width="25"></span>
                                            @endif
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND") and $candidature->region_id == Auth::user()->id)
                                                <span class="mr-1" data-toggle="modal" data-target="#validationcandidature{{$candidature->candidature_id}}" title="VALIDER LA CANDIDATURE"><img src="{{ asset('assets/img/icons/validercone.png') }}" class="img-fluid" width="25" alt=""></span>                                           
                                            @endif
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "DEL_CAND") and $candidature->region_id == Auth::user()->id)
                                                <span data-toggle="modal" data-target="#annulercandidature{{$candidature->candidature_id}}" title="SUPPRIMER LA CANDIDATURE"><img src="{{ asset('assets/img/icons/delete.png') }}" width="25"></span>                                           
                                            @endif
                                        </td>                                               
                                    </tr>

                                    <div class="modal fade" id="validationcandidature{{$candidature->candidature_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE VALIDATION</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Vous êtes sur le point de validater la candidature de : {{ $candidature->name }} {{ $candidature->prenoms }}
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                    <a href="{{ route('admin.candidature.valider',$candidature->candidature_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="annulercandidature{{$candidature->candidature_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    Vous êtes sur le point de supprimer la candidature de : {{ $candidature->name }} {{ $candidature->prenoms }}
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                    <a href="{{ route('admin.candidature.supprimer',$candidature->candidature_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>                    
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection