<!DOCTYPE html>
<html>
<title>CARTE D'INSCRIPTION DE : {{$demandeur->name}} {{$demandeur->prenoms}}</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
	.clear{
		clear: both;
	}
	p{
		font-size: 5px;
		margin: 2px;
	}
	.id-card-holder{
		width: 550px;
		margin: 0 auto;
		font-family:'Tomorrow';
		border:3px solid orange;
	}
	.id-card{
		background-color: #fff;
		padding: 0px;
		text-align: center;
		box-shadow: 0 0 1.5px 0px #b9b9b9;
		display: block;
		/*border-radius: 12px;*/
		overflow: hidden;
	}
	.header{
		background-color: green;
	}

	.header img{
		width: 150px;
		margin-top: 0px;
		display: inline;
		float: left;
		padding: 13px 10px;
		box-sizing: border-box;
	}
	.id{
		display: inline-block;
		float: left;
		font-size: 15px;
		text-transform: uppercase;
		color: #fff;
		text-align: center;
		margin-left: 20px;
		margin-top: 10px;
	}
	.head-info{
		display: inline-block;
		float: left;
		padding: 10px 0px 0;
		width: calc(100% - 160px);
		box-sizing: border-box;
		/*text-align: left;*/
		color: #fff;
	}
	.head-info p{
		font-size: 9px;
	}
	.b-border{
		height: 2px;
		display: block;
		background-color: #c84391;
		margin-top: 1px;
	}
	.card-detail{
		width: 100%;
		display: block;
		padding: 10px;
		box-sizing: border-box;
	}
	.stu-photo{
		float: left;
		width: 100px;
	}
	.stu-photo img{
		width: 85%;
		border: 1px solid #4a0a2c;
		box-sizing: border-box;
	}
	.stu-info{
		float: left;
		width: calc(100% - 100px);
		padding: 0px 5px 0 15px;
		box-sizing: border-box;
		text-align: left;
		text-transform: capitalize;
	}
	.session{
		font-size: 13px;
		font-weight: 600;
		/*margin: 0 0 7px;*/
	}
	.stu-info h3{
	font-size: 15px;
		color: #000;
	}
	.stu-info p{
		font-size: 11px;
		margin: 0 0 3px 0;
		line-height: 17px;
	}
	.stu-info p span{
		font-weight: 600;
		text-transform: uppercase;
	}
	footer{
		padding: 5px 0;
		border-top: 1px solid #000;
	}
	footer p{
		font-size: 7px;
		margin: 0 0 2px 0;
	}
	@font-face {
	  font-family: 'Tomorrow';
	  font-style: normal;
	  font-weight: 400;
	  font-display: swap;
	  src: url(https://fonts.gstatic.com/s/tomorrow/v15/WBLmrETNbFtZCeGqgRXSe2A.woff2) format('woff2');
	  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
	}
</style>
<body>
	<div class="id-card-holder">
		<div class="id-card">			
			<div class="header" style="background-color: green;">				
				<img src="{{ $lien_logo }}" style="width:105px !important; height:95px">
				<div class="head-info" style="text-align:center !important; margin-left:35px !important">
					<p style="font-size:12px">République du Niger</p>
					<p style="font-size:12px; font-weight: 400;">AGENCE NATIONALE POUR LA PROMOTION DE L'EMPLOI (ANPE)</p>				
					<p style="font-size:10px; margin-top:10px !important; margin-bottom:10px !important">ETABLISSEMENT PUBLIC À CARACTÈRE ADMINISTRATIF</p>
					<p>BP: 13222 Niamey - Tel : +227 20 73 33 84 - Tél/Fax: +227 20 73 70 31</p>
					<p>Email: anpe.niger16@gmail.com - http//www.anpe-niger.ne</p>
				</div>
				<div class="clear"></div>
			</div>
			<span class="b-border"></span>
      
			<div class="card-detail">
				<div class="stu-photo">
					<p style="font-size: 11px; margin-left:10px">N°{{$demandeur->identifiant}}/ANPE</p>
					<img src="{{ $demandeur_image }}" style="width:110px !important; height:110px">
				</div>
				<div class="stu-info" style="">					
					<h3 style="text-align:center !important;">CARTE D'INSCRIPTION</h3>
					<p>Nom : <span> <strong>{{$demandeur->name}}</strong> </span> Prénoms : <strong>{{$demandeur->prenoms}}</strong></p>
					<p>Sexe : <strong>@if($demandeur->genre == "F") F @else M @endif</strong></p>
					<p>Nationalité : <strong>{{ $nationalite->nom_fr }}</strong></p>
					<p>Emploi (s) souhaité (s) : <strong> <?php echo html_entity_decode($demandeur->emploisouhaite) ?></strong></p>
					<p>Date d'inscription : <strong>{{ \Carbon\Carbon::parse($demandeur->date_validation)->format('d/m/Y') }}</strong></p>
				</div>        
				<div class="clear"></div>
			</div>
      
			<footer>
				<p><strong>DATE DE VALIDITE DE LA CARTE</strong> </p>
				<p style="font-size:11px !important">cette carte est valide pour toute opération à l´ANPE, jusqu’à la date du <strong>{{ \Carbon\Carbon::parse($demandeur->user_validitecarte)->format('d/m/Y') }}</strong></p>
				<p style="margin-top:12px"><img src="data:image/png;base64,{{ base64_encode(QrCode::size(50)->generate($url.'/demandeur-d-emploi/details/'.$demandeur->id.'-'.Stdfn::clean_url($demandeur->prenoms))) }}"></p>
			</footer>
		</div>
	</div>
</body>
</html> 