@extends('layouts.appp')

@section('title')
    Liste des demandeurs carte expirée
@endsection

@section('titre')
    Liste des demandeurs carte expirée
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion demandeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des demandeurs carte expirée</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des demandeurs carte expirée</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.demandeur.carte.expiree') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="">Région</label>
                                        <select id="metier_select" name="r">
                                            <option value="">Choisissez une region</option>
                                            @foreach($regions as $region)
                                                <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label>Tranche d'âge</label>
                                    <select id="single-select" name="a">
                                        <option value="">Choissisez un tranche d'âge</option>
                                        @foreach($trancheages as $trancheage)
                                            <option @if($trancheage_select == $trancheage->trancheage_id) selected @endif value="{{ $trancheage->trancheage_id}}">{{ $trancheage->trancheage_lib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Genre</label>
                                    <select name="g" class="form-control">
                                        <option value="">Choissisez un genre</option>
                                        <option @if($genre_select == "F") selected @endif value="F">Femme</option>
                                        <option @if($genre_select == "H") selected @endif value="H">Homme</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Situation matrimoniale</label>
                                    <select class="form-control" name="s">
                                        <option value="">Choisissez une situation</option>
                                        <option @if($situation_select == "CELIBATAIRE") selected @endif value="CELIBATAIRE">CELIBATAIRE</option>
                                        <option @if($situation_select == "MARIE(E)") selected @endif value="MARIE(E)">MARIE(E)</option>
                                        <option @if($situation_select == "DIVORCE(E)") selected @endif value="DIVORCE(E)">DIVORCE(E)</option>
                                        <option @if($situation_select == "VEUF(E)") selected @endif value="VEUF(E)">VEUF(E)</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr> 
                                        <th></th>
                                        <th>Nom & Prénoms</th>
                                        <th>Email</th>
                                        <th>Téléphone</th>
                                        <th class="text-center">Date Expiration</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody> 
									@foreach($users as $user)
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
    										<tr>
                                                <td>
                                                    @if(!empty($user->profil_photo))
                                                        <img src="{{ asset('assets/img/profil/'.$user->profil_photo) }}" width="30" alt="">
                                                    @else
                                                        <img src="{{ asset('assets/img/profil/avatar.png') }}" width="30" alt="">
                                                    @endif
                                                </td>
    											<td>{{ $user->name }} {{ $user->prenoms }}</td>
    											<td>{{ $user->email }}</td>
                                                <td>{{ $user->telephone }}</td>
    											<td class="text-center" style="font-weight:bold">{{ \Carbon\Carbon::parse($user->user_validitecarte)->format('d/m/Y') }}</td>
    											<td class="text-center">
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP"))
                                                        <a href="{{ route('admin.details.carte.expiree', [$user->id, Stdfn::clean_url($user->prenoms)]) }}" title="DETAILS" style="cursor: pointer;"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-flui" style="margin-top:1px" width="24" alt=""></a>
                                                    @endif
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP"))
                                                        <span data-toggle="modal" data-target="#renouvelercarte{{$user->id}}" title="RENOUVELER LA CARTE"><img src="{{ asset('assets/img/icons/relancer.png') }}" class="img-fluid" width="26" alt=""></span>
                                                    @endif                                                
                                                    <a href="{{ asset('carteanpe/'.$user->user_carte) }}" target="_blank" title="VOIR LA CARTE" style="cursor: pointer;"><img src="{{ asset('assets/img/icons/voircarte.png') }}" class="img-fluid" width="23" alt=""></a>
    											    <span data-toggle="modal" data-target="#supprimerdemandeur{{$user->id}}" title="SUPPRIMER"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>
                                                </td>
    										</tr>
                                        @endif
                                        @if($user->region_id == Auth::user()->region_id)
                                            <tr>
                                                <td>
                                                    @if(!empty($user->profil_photo))
                                                        <img src="{{ asset('assets/img/profil/'.$user->profil_photo) }}" width="30" alt="">
                                                    @else
                                                        <img src="{{ asset('assets/img/profil/avatar.png') }}" width="30" alt="">
                                                    @endif
                                                </td>
                                                <td>{{ $user->name }} {{ $user->prenoms }}</td>
                                                <td>{{ $user->email }}</td>
                                                <td>{{ $user->telephone }}</td>
                                                <td class="text-center" style="font-weight:bold">{{ \Carbon\Carbon::parse($user->user_validitecarte)->format('d/m/Y') }}</td>
                                                <td class="text-center">
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP"))
                                                        <a href="{{ route('admin.details.carte.expiree', [$user->id, Stdfn::clean_url($user->prenoms)]) }}" title="DETAILS" style="cursor: pointer;"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-flui" style="margin-top:1px" width="24" alt=""></a>
                                                    @endif
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP"))
                                                        <span data-toggle="modal" data-target="#renouvelercarte{{$user->id}}" title="RENOUVELER LA CARTE"><img src="{{ asset('assets/img/icons/relancer.png') }}" class="img-fluid" width="26" alt=""></span>
                                                    @endif                                                
                                                    <a href="{{ asset('carteanpe/'.$user->user_carte) }}" target="_blank" title="VOIR LA CARTE" style="cursor: pointer;"><img src="{{ asset('assets/img/icons/voircarte.png') }}" class="img-fluid" width="23" alt=""></a>
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "DEL_DEMP") and $user->region_id == Auth::user()->region_id)
                                                        <span data-toggle="modal" data-target="#supprimerdemandeur{{$user->id}}" title="SUPPRIMER"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endif
                                        <div class="modal fade" id="renouvelercarte{{$user->id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de renouveler la carte : {{ $user->name }} {{ $user->prenoms }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.renouveler.carte.expiree',$user->id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                       
                                        <div class="modal fade" id="supprimerdemandeur{{$user->id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer le demandeur d'emploi : {{ $user->name }} {{ $user->prenoms }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.demandeur.supprimer',$user->id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
									@endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection