@extends('layouts.appp')

@section('title')
    Créer un compte demandeur d'emploi
@endsection

@section('titre')
    Créer un compte demandeur d'emploi
@endsection

@section('content')
    <style>
        .hidden{
            display: none;
        }
        #user_profil-error, #pieceidentite-error, #pieceetranger-error{
            display: none;
        }
        .fichier_hidden {
            display: none;
        }
    </style>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.liste.demandeur') }}">Gestion demandeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Créer un compte demandeur d'emploi</a></li>
            </ol>
        </div>
        <div class="row"> 
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-xxl-12">
                                <h2><i class="fa fa-cogs mr-2" aria-hidden="true"></i>Informations Générales</h2><hr>
                                <form method="POST" action="{{ route('admin.demandeur.savecreercompte') }}" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Nom <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('nom') is-invalid @enderror"  name="nom" value="{{ old('nom') }}" placeholder="Entrer le nom" onkeyup="this.value=this.value.toUpperCase()">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Prénoms <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('prenoms') is-invalid @enderror"  name="prenoms" value="{{ old('prenoms') }}" placeholder="Entrer le prénoms" onkeyup="this.value=this.value.toUpperCase()">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Date de naissance <span style="color:red">*</span></label>
                                                <input type="date" required class="form-control rounded @error('datenaissance') is-invalid @enderror"  name="datenaissance" max="{{$datesources->format('Y-m-d')}}" value="{{ old('datenaissance') }}">
                                            </div>
                                        </div>
                                        <div class="col-md-6"> 
                                            <div class="form-group">
                                                <label>Lieu de naissance <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('lieunaissance') is-invalid @enderror"  name="lieunaissance" value="{{ old('lieunaissance') }}" placeholder="Lieu de naissance">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Téléphone <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('telephone') is-invalid @enderror" name="telephone" value="{{ old('telephone') }}" placeholder="+22720733384" onkeypress="isInputNumber(event)">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Genre <span style="color:red">*</span></label>
                                                <select class="form-control" required name="genre" >
                                                  <option value="">De quel genre êtes-vous ?</option>
                                                  <option value="F" {{ old('genre') == 'F' ? 'selected' : '' }}>Femme</option>
                                                  <option value="H" {{ old('genre') == 'H' ? 'selected' : '' }}>Homme</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Handicap <span style="color:red">*</span></label>
                                                <select class="form-control" required name="handicap" id="handicap">
                                                    <option value="">Avez-vous un handicap ?</option>
                                                    <option value="OUI" {{ old('handicap') == 'OUI' ? 'selected' : '' }}>OUI</option>
                                                    <option value="NON" {{ old('handicap') == 'NON' ? 'selected' : '' }}>NON</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden" id="typehandicap">
                                            <div class="form-group">
                                                <label>Type d'handicap <span style="color:red">*</span></label>
                                                <input type="" name="type_handicap" id="type_handicap" class="form-control" placeholder="Entrer le nom de votre type d'handicap">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Situation matrimoniale <span style="color:red">*</span></label>
                                                <select class="form-control" required name="stituationmatrimoniale" >
                                                  <option value="">Quelle est votre situation ?</option>
                                                  <option value="CELIBATAIRE" {{ old('stituationmatrimoniale') == 'CELIBATAIRE' ? 'selected' : '' }}>CELIBATAIRE</option>
                                                  <option value="MARIE(E)" {{ old('stituationmatrimoniale') == 'MARIE(E)' ? 'selected' : '' }}>MARIE(E)</option>
                                                  <option value="DIVORCE(E)" {{ old('stituationmatrimoniale') == 'DIVORCE(E)' ? 'selected' : '' }}>DIVORCE(E)</option>
                                                  <option value="VEUF(E)" {{ old('stituationmatrimoniale') == 'VEUF(E)' ? 'selected' : '' }}>VEUF(E)</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Nombre d'enfant <span style="color:red">*</span></label>
                                                <input type="text" class="form-control rounded @error('nombreenfant') is-invalid @enderror" required name="nombreenfant" value="{{ old('nombreenfant') }}" placeholder="Nombre d'enfant" onkeypress="isInputNumber(event)">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Photo profil</label>
                                                <input type="file" class="form-control rounded @error('user_profil') is-invalid @enderror" name="user_profil" value="{{ old('user_profil') }}" id="user_profil">
                                                <span id="user_profil-error" class="invalid-feedback"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <h2><i class="fa fa-map-marker mr-2" aria-hidden="true"></i>Adresse</h2><hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Nationalité <span style="color:red">*</span></label>
                                                <select id="nationalite_select" required name="pays_id">
                                                    <option value="">Choisissez une nationalité</option>
                                                    @foreach($paysliste as $pays)
                                                        <option value="{{ $pays->pays_id }}" {{ old('pays_id') == $pays->pays_id ? 'selected' : '' }}>{{ $pays->nom_fr }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Région <span style="color:red">*</span></label>
                                                <select class="select2-with-label-single js-states d-block" required name="region_id" id="id_label_single" >
                                                    <option value="">Cloisissez une région<option>
                                                    @if(Auth::user()->profil_id == 4)
                                                        @foreach($region_agent as $region)
                                                            <option value="{{ $region->region_id }}" {{ old('region_id') == $region->region_id ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                                        @endforeach
                                                    @endif
                                                    @if(Auth::user()->profil_id == 1)
                                                        @foreach($regions as $region)
                                                            <option value="{{ $region->region_id }}" {{ old('region_id') == $region->region_id ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Département</label>
                                                <input type="text" class="form-control rounded @error('departement') is-invalid @enderror" name="departement" value="{{ old('departement') }}" placeholder="Département" >
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Commune</label>
                                                <input type="text" class="form-control rounded @error('commune') is-invalid @enderror" name="commune" value="{{ old('commune') }}" placeholder="Commune" >
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Quartier / Village</label>
                                                <input type="text" class="form-control rounded @error('village_quart') is-invalid @enderror" name="village_quart" value="{{ old('village_quart') }}" placeholder="Quartier / Village" >
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <h2><i class="fa fa-graduation-cap mr-2" aria-hidden="true"></i>Informations Professionnelles</h2><hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Filière <span style="color:red">*</span></label>
                                                <select class="form-control" required name="metier_id" id="metier_select" >
                                                  <option value="">Choisissez une filière</option>
                                                  @foreach($filieres as $filiere)
                                                    <option value="{{ $filiere->metier_id }}" {{ old('metier_id') == $filiere->metier_id ? 'selected' : '' }}>{{ $filiere->metier_libelle }}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden" id="typefiliere">
                                            <div class="form-group">
                                                <label>Votre filière <span style="color:red">*</span></label>
                                                <input type="" name="new_metier" id="new_metier" class="form-control" placeholder="Entrer le nom de votre filière">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Type de diplôme <span style="color:red">*</span></label>
                                                <select id="diplome_select" required name="diplome_id" >
                                                    <option value="">Choisissez un type de diplôme</option>
                                                    @foreach($diplomes as $diplome)
                                                        <option value="{{ $diplome->diplome_id }}" {{ old('diplome_id') == $diplome->diplome_id ? 'selected' : '' }}>{{ $diplome->diplomelib }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden" id="typediplome">
                                            <div class="form-group">
                                                <label>Votre diplôme <span style="color:red">*</span></label>
                                                <input type="" name="new_diplome" id="new_diplome" class="form-control" placeholder="Entrer le nom de votre diplôme">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Catégorie Professionnelle <span style="color:red">*</span></label>
                                                <select class="form-control" required name="catepro_id" >
                                                  <option value="">Choisissez une catégorie professionnelle</option>
                                                  @foreach($categories as $categorie)
                                                    <option value="{{ $categorie->catepro_id }}" {{ old('catepro_id') == $categorie->catepro_id ? 'selected' : '' }}>{{ $categorie->catepro_lib }}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Type de demandeur <span style="color:red">*</span></label>
                                                <select class="form-control" required name="situation_id" >
                                                  <option value="">Choisissez un type de demandeur</option>
                                                  @foreach($typedemandeur as $demandeur)
                                                    <option value="{{ $demandeur->situation_id }}" {{ old('situation_id') == $demandeur->situation_id ? 'selected' : '' }}>{{ $demandeur->situation_lib }}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Niveau d'instruction <span style="color:red">*</span></label>
                                                <select class="form-control" required name="niveau_id" >
                                                  <option value="">Choisissez un niveau d'instruction</option>
                                                  @foreach($niveaux as $niveau)
                                                    <option value="{{ $niveau->niveau_id }}" {{ old('niveau_id') == $niveau->niveau_id ? 'selected' : '' }}>{{ $niveau->niveau_lib }}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Emploi souhaité <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('emploisouhaite') is-invalid @enderror"  name="emploisouhaite" value="{{ old('emploisouhaite') }}" placeholder="Entrer l'emploi souhaité" >
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Année d'expérience</label>
                                                <input type="text" required class="form-control" id="experience" minlength="1" name="experience" value="{{ old('experience') }}" placeholder="Votre année d'expérience" onkeypress="isInputNumber(event)">
                                                <span id="experience-error" class="text-danger"></span>
                                            </div>                            
                                        </div> 
                                    </div><hr>
                                    <h2><i class="fa fa-graduation-cap mr-2" aria-hidden="true"></i>Connaissances Lingustiques</h2><hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Langue internationale</label>
                                                <select class="form-control" required name="langueinter_id" id="langueinter_select">
                                                  <option value="">Choisissez une langue internationale</option>
                                                  @foreach($langueinter as $inter)
                                                    <option value="{{ $inter->langueinter_id }}" {{ old('langueinter_id') == $inter->langueinter_id ? 'selected' : '' }}>{{ $inter->langueinter_lib }}</option>
                                                  @endforeach                                             
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden" id="typelangueinter">
                                            <div class="form-group">
                                                <label>Langue internationale parlée <span style="color:red">*</span></label>
                                                <input type="" name="new_langueinter" id="new_langueinter" class="form-control" placeholder="Entrer le nom de votre langue internationale parlée">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Langue locale <span style="color:red">*</span></label>
                                                <select class="form-control" required name="languelocal_id" id="lanquelocal_select" >
                                                  <option value="">Choisissez une langue locale</option>
                                                  @foreach($languelocale as $locale)
                                                    <option value="{{ $locale->languelocal_id }}" {{ old('languelocal_id') == $locale->languelocal_id ? 'selected' : '' }}>{{ $locale->languelocal_lib }}</option>
                                                  @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 hidden" id="typelanguelocale">
                                            <div class="form-group">
                                                <label>Langue locale parlée <span style="color:red">*</span></label>
                                                <input type="" name="new_languelocal" id="new_languelocal" class="form-control" placeholder="Entrer le nom de votre langue locale parlée">
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                    <h2><i class="fa fa-file mr-2" aria-hidden="true"></i>Document à joindre</h2><hr>
                                    <div class="row">
                                        <div class="col-md-6" id="cni">
                                            <div class="form-group">
                                                <label>Pièce d'identité (CIN ou passeport ou nationalité)</label>
                                                <input type="file" class="form-control rounded @error('pieceidentite') is-invalid @enderror" name="pieceidentite" value="{{ old('pieceidentite') }}" id="pieceidentite">
                                                <span id="pieceidentite-error" class="invalid-feedback"></span>
                                            </div>
                                        </div>

                                        <div class="col-md-6" id="etranger">
                                            <div class="form-group">
                                                <label>Pour les étrangers (Permis de séjour, carte...)</label>
                                                <input type="file" class="form-control rounded @error('pieceetranger') is-invalid @enderror" name="pieceetranger" value="{{ old('pieceetranger') }}" id="pieceetranger">
                                                <span id="pieceetranger-error" class="invalid-feedback"></span>
                                            </div>
                                        </div>
                                    </div><hr>
                                    <h2><i class="fa fa-unlock-alt mr-2" aria-hidden="true"></i>Mot de passe</h2><hr>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Adresse Email <span style="color:red">*</span></label>
                                                <input type="email" required class="form-control rounded @error('email') is-invalid @enderror"  name="email" value="{{ old('email') }}" placeholder="Entrer l'adresse email" >
                                            </div>
                                        </div>
                                        <div class="col-md-4">                            
                                            <div class="form-group">
                                                <label>Mot de passe <span style="color:red">*</span></label>
                                                <input type="password" required class="form-control @error('password') is-invalid @enderror" name="password"  placeholder="********">
                                            </div>  
                                        </div>
                                        <div class="col-md-4">                               
                                            <div class="form-group">
                                                <label>Confirmer mot de passe <span style="color:red">*</span></label>
                                                <input type="password" required id="password_confirmation" class="form-control" name="password_confirmation" placeholder="********" >
                                            </div>
                                        </div> 
                                    </div>
                                    <hr>
                                    <button class="btn btn-primary">Créer le compte</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function isInputNumber(evt){
            
            var ch = String.fromCharCode(evt.which);
            
            if(!(/[0-9]/.test(ch))){
                evt.preventDefault();
            }        
        }

        // Récupération de l'élément HTML input
        const telephoneInput = document.getElementById("numero");

        // Définition de la limite de saisie à une caractère
        telephoneInput.maxLength = 8;
    </script>
    <script>
        document.getElementById('experience').addEventListener('input', function() {
            var experienceInput = this.value;
            var errorSpan = document.getElementById('experience-error');

            if (experienceInput.length < 1 || parseInt(experienceInput) <= 1) {
                errorSpan.textContent = 'Veuillez saisir une valeur supérieure à 1.';
            } else {
                errorSpan.textContent = '';
            }
        });

        document.getElementById('user_profil').addEventListener('change', function() {
            var fileInput = this;
            var errorSpan = document.getElementById('user_profil-error');
            var allowedExtensions = /(\.png|\.jpg|\.jpeg)$/i;

            if (!allowedExtensions.exec(fileInput.value)) {
                errorSpan.textContent = 'Veuillez sélectionner un fichier de type PNG, JPG ou JPEG.';
                errorSpan.style.display = 'block';
            } else {
                errorSpan.textContent = '';
                errorSpan.style.display = 'none';
            }
        });

        document.getElementById('pieceidentite').addEventListener('change', function() {
            var fileInput = this;
            var errorSpan = document.getElementById('pieceidentite-error');
            var allowedExtensions = /(\.png|\.jpg|\.jpeg|\.pdf)$/i; // Add the extension "pdf" to the regex

            if (!allowedExtensions.exec(fileInput.value)) {
                errorSpan.textContent = 'Veuillez sélectionner un fichier de type PNG, JPG, JPEG ou PDF.';
                errorSpan.style.display = 'block';
            } else {
                errorSpan.textContent = '';
                errorSpan.style.display = 'none';
            }
        });


        document.getElementById('pieceetranger').addEventListener('change', function() {
            var fileInput = this;
            var errorSpan = document.getElementById('pieceetranger-error');
            var allowedExtensions = /(\.png|\.jpg|\.jpeg|\.pdf)$/i;

            if (!allowedExtensions.exec(fileInput.value)) {
                errorSpan.textContent = 'Veuillez sélectionner un fichier de type PNG, JPG, JPEG ou PDF.';
                errorSpan.style.display = 'block';
            } else {
                errorSpan.textContent = '';
                errorSpan.style.display = 'none';
            }
        });

        $(document).ready(function() {
            $('#handicap').change(function() {
                var selectedOption = $(this).val();
                if (selectedOption == 'OUI') {
                    $('#typehandicap').removeClass('hidden');
                    $('#type_handicap').attr('required', 'required');
                } else {
                    $('#typehandicap').addClass('hidden');
                    $('#type_handicap').removeAttr('required');
                }
            });
        });

        $(document).ready(function() {
            $('#langueinter_select').change(function() {
                var selectedLangueInter = $(this).val();
                if (selectedLangueInter == 13) {
                    $('#typelangueinter').removeClass('hidden');
                    $('#new_langueinter').attr('required', 'required');
                } else {
                    $('#typelangueinter').addClass('hidden');
                    $('#new_langueinter').removeAttr('required');
                }
            });
        });

        $(document).ready(function() {
            $('#lanquelocal_select').change(function() {
                var selectedLangueLocale = $(this).val();
                if (selectedLangueLocale == 15) {
                    $('#typelanguelocale').removeClass('hidden');
                    $('#new_languelocal').attr('required', 'required');
                } else {
                    $('#typelanguelocale').addClass('hidden');
                    $('#new_languelocal').removeAttr('required');
                }
            });
        });

        $(document).ready(function() {
            $('#metier_select').change(function() {
                var selectedFiliere = $(this).val();
                if (selectedFiliere == 51) {
                    $('#typefiliere').removeClass('hidden');
                    $('#new_metier').attr('required', 'required');
                } else {
                    $('#typefiliere').addClass('hidden');
                    $('#new_metier').removeAttr('required');
                }
            });
        });

        $(document).ready(function() {
            $('#diplome_select').change(function() {
                var selectedDiplome = $(this).val();
                if (selectedDiplome == 27) {
                    $('#typediplome').removeClass('hidden');
                    $('#new_diplome').attr('required', 'required');
                } else {
                    $('#typediplome').addClass('hidden');
                    $('#new_diplome').removeAttr('required');
                }
            });
        });

        $(document).ready(function() {
            $('#nationalite_select').change(function() {
                var nationalite_select = $(this).val();
                if(nationalite_select == 127){
                    $('#cni').show();
                    $('#pieceidentite').attr('required', 'required');
                    $('#etranger').hide();
                }else{
                    $('#etranger').show();
                    $('#pieceetranger').attr('required', 'required');
                    $('#cni').hide();
                }
            });
        });
    </script>
@endsection