<?php
    use Carbon\Carbon;

    $datejour = gmdate('Y-m-d');
?>
@extends('layouts.appp')

@section('title')
    {{ $demandeur->name }} {{ $demandeur->prenoms }}
@endsection

@section('titre')
    {{ $demandeur->name }} {{ $demandeur->prenoms }}
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion des demandeurs</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.demandeur.carte.expiree') }}">Liste des demandeurs carte expirée</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Détails</a></li>
            </ol>
        </div>
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Détails : {{ $demandeur->name }} {{ $demandeur->prenoms }}</h4>
                    <div class="float-end">
                        @if($demandeur->user_validitecarte < $datejour)
                            <span class="badge badge-danger light">Carte exiprée</span>
                        @elseif($demandeur->user_statut == "VALIDE")
                            <span class="badge badge-success light">Compte validé</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Infos générales</a>
                            </li>
                            @if($demandeur->user_statut == "VALIDE" and $demandeur->user_carte_statut == "VALIDE")
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#voir-carte"><i class="la la-file mr-2"></i> Voir la carte</a>
                                </li>
                            @endif
                            @if($demandeur->user_statut == "BROUILLON")
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#voir-cni"><i class="la la-file mr-2"></i> CIN</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#voir-pieceetranger"><i class="la la-file mr-2"></i> Permis de séjour,...</a>
                                </li>
                            @endif
                            @if($demandeur->user_validitecarte < $datejour)
                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#activer-compte"><i class="fa fa-check-circle mr-2"></i> Renouveler la carte ou Fermer le compte</a>
                                    </li>
                                @endif
                            @endif
                            @if($demandeur->user_validitecarte < $datejour)
                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CARTE_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP"))
                                    @if($demandeur->region_id == Auth::user()->region_id)
                                        <li class="nav-item">
                                            <a class="nav-link" data-toggle="tab" href="#activer-compte"><i class="fa fa-check-circle mr-2"></i> Renouveler la carte ou Fermer le compte</a>
                                        </li>
                                    @endif
                                @endif
                            @endif  
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                            <div class="tab-content">
                                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                    @if($demandeur->profil_photo !=null and $demandeur->profil_photo !="")
                                                                        <img class="img-fluid" src="{{ asset('assets/img/profil/'.$demandeur->profil_photo) }}" alt="">
                                                                    @else
                                                                        @if($demandeur->genre == "F")
                                                                            <img class="img-fluid" src="{{ asset('assets/img/profil/femme.png') }}" alt="">
                                                                        @else
                                                                            <img class="img-fluid" src="{{ asset('assets/img/profil/homme.jpg') }}" alt="">
                                                                        @endif
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                            <div class="product-detail-content">
                                                                <div class="new-arrival-content pr">
                                                                    <p class="text-couleur">Nom & Prénoms : {{ $demandeur->name }} {{ $demandeur->prenoms }}</p>
                                                                    <p class="text-couleur">Adresse Email : {{ $demandeur->email }}</p>
                                                                    <p class="text-couleur">Téléphone : {{ $demandeur->telephone }}</p>
                                                                    <p class="text-couleur">Genre : 
                                                                        @if($demandeur->genre =="F")
                                                                            Femme
                                                                        @else
                                                                            Homme
                                                                        @endif
                                                                    </p>
                                                                    <p class="text-couleur">Date de naissance :
                                                                        @php
                                
                                                                            $date_naissance = $demandeur->datenaissance;

                                                                            $date = Carbon::parse($date_naissance)->locale('fr_FR')->translatedFormat('d F Y');

                                                                            echo $date;
                                                                        @endphp
                                                                    </p>
                                                                    <p class="text-couleur">Lieu de naissance : {{ $demandeur->lieunaissance }}</p>
                                                                    @if($pays)<p class="text-couleur">Nationalité : {{ $pays->nom_fr }}</p>@endif
                                                                    @if($region)<p class="text-couleur">Lieu de résidence : {{ $region->region_nom }}</p>@endif
                                                                    <p class="text-couleur">Département : {{ $demandeur->departement }}</p>
                                                                    <p class="text-couleur">Situation matrimoniale : {{ $demandeur->situationmatrimoniale }}</p>
                                                                    <p class="text-couleur">Nombre d'enfant : {{ $demandeur->nombreenfant }}</p>
                                                                    <p class="text-couleur">Handicap : 
                                                                        @if($demandeur->handicap == "OUI")
                                                                            {{ $demandeur->type_handicap }}
                                                                        @else
                                                                            Aucun handicap
                                                                        @endif
                                                                    </p>
                                                                    <p class="text-couleur">Commune : {{ $demandeur->commune }}</p>
                                                                    <p class="text-couleur">Quartier/Village : {{ $demandeur->village_quart }}</p>
                                                                    <p class="text-couleur">Emploi souhaité : <?php echo html_entity_decode($demandeur->emploisouhaite) ?></p>                                                                    
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div><hr>                                                 
                                                    <h2 class="text-center mt-3">Autres informations</h2>
                                                    <div class="row mt-3">
                                                        <div class="col-md-6">
                                                            @if($metier)
                                                                <p class="text-couleur">Filière :
                                                                    @if($metier->metier_id == 51)
                                                                        {{ $demandeur->new_metier }}
                                                                    @else
                                                                        {{ $metier->metier_libelle }}
                                                                    @endif
                                                                </p>
                                                            @endif
                                                            @if($diplome)
                                                                <p class="text-couleur">Diplôme : 
                                                                    @if($diplome->diplome_id == 27)
                                                                        {{ $demandeur->new_diplome }}
                                                                    @else
                                                                        {{ $diplome->diplomelib }}
                                                                    @endif
                                                                </p>
                                                            @endif
                                                            @if($niveauintruction)<p class="text-couleur">Niveau d'instruction : {{ $niveauintruction->niveau_lib }}</p>@endif
                                                            @if($languelocale)
                                                                <p class="text-couleur">Langue Locale : 
                                                                    @if($languelocale->languelocal_id == 15)
                                                                        {{ $demandeur->new_languelocal }}
                                                                    @else
                                                                        {{ $languelocale->languelocal_lib }}
                                                                    @endif
                                                                </p>
                                                            @endif
                                                        </div>
                                                        <div class="col-md-6">
                                                            @if($categoriepro)<p class="text-couleur">Categorie Professionnelle : {{ $categoriepro->catepro_lib }}</p>@endif
                                                            @if($typedemandeur)<p class="text-couleur">Type demandeur : {{ $typedemandeur->situation_lib }}</p>@endif
                                                            @if($langueinter)
                                                                <p class="text-couleur">Langue internationale : 
                                                                    @if($langueinter->langueinter_id == 13)
                                                                        {{ $demandeur->new_langueinter }}
                                                                    @else
                                                                        {{ $langueinter->langueinter_lib }}
                                                                    @endif
                                                                </p>
                                                            @endif
                                                            <p class="text-couleur">Année d'expérience : {{ $demandeur->experience }}</p>
                                                        </div>
                                                    </div>                                                   
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="voir-carte">
                                <div class="pt-4">
                                    @if($demandeur->user_carte_statut != null and $demandeur->user_carte_statut != "")
                                        <embed src="{{ asset('carteanpe/'.$demandeur->user_carte) }}" width="920" height="700" type="application/pdf"/>
                                    @else
                                        <center>
                                            <h2 style="color: red; font-weight: bold; font-style: italic;">Ce demandeur d'emploi ne dispose pas de carte générée</h2>
                                        </center>
                                    @endif
                                </div>
                            </div>
                            <div class="tab-pane fade" id="voir-cni">
                                <div class="pt-4">
                                    @if($demandeur->user_cni !=null and $demandeur->user_cni !="")
                                        <embed src="{{ asset('assets/img/profil/documents/'.$demandeur->user_cni) }}" width="920" height="700" type="application/pdf"/>
                                    @else
                                        <center>
                                            <h2 style="color: red; font-weight: bold; font-style: italic;">Ce demandeur d'emploi ne dispose pas de carte d'identité nationale</h2>
                                        </center>
                                    @endif
                                </div>
                            </div>
                            <div class="tab-pane fade" id="voir-pieceetranger">
                                <div class="pt-4">
                                    @if($demandeur->user_dpc !=null and $demandeur->user_dpc !="")
                                        <embed src="{{ asset('assets/img/profil/documents/'.$demandeur->user_dpc) }}" width="920" height="700" type="application/pdf"/>
                                    @else
                                        <center>
                                            <h2 style="color: red; font-weight: bold; font-style: italic;">Ce demandeur d'emploi ne dispose pas permis de séjour, carte...</h2>
                                        </center>
                                    @endif
                                </div>
                            </div>
                            <div class="tab-pane fade" id="voir-cv">
                                <div class="pt-4">
                                    <embed src="{{ asset('cv/'.$demandeur->user_cv) }}" width="920" height="700" type="application/pdf"/>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="activer-compte">
                                <div class="pt-4">
                                    <form action="{{ route('admin.postrenouveler.carte.expiree',$demandeur->id) }}" method="POST">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Renouveler la carte ou Fermeture du compte <span class="text-danger">*</span></label>
                                                <select class="form-control" name="action" required>
                                                    <option value="">Choisissez un action</option>
                                                    <option value="Renouveler la carte">Renouveler la carte</option>
                                                    <option value="Fermeture du compte">Fermeture du compte</option>
                                                </select>
                                            </div>
                                            <diV class="col-md-12 mt-3">
                                                <label>Observation <span class="text-danger">*</span></label>
                                                <textarea class="form-control" rows="6" name="observation" placeholder="Entrer l'observation ici..." required></textarea>
                                            </diV>
                                            <div class="col-md-12 mt-3">
                                                <button class="btn btn-info"><i class="fa fa-check-circle mr-2"></i>Valider</button>
                                            </div>                                           
                                        </div>
                                    </form>
                                </div>
                            </div> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection