@extends('layouts.appp')

@section('title')
    Liste des candidatures
@endsection

@section('titre')
    Liste des candidatures
@endsection

@section('content') 
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion Demandeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des candidatures</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND"))
                    <div class="card-header">
                        <h4 class="card-title">Liste des candidatures</h4>
                        <div class="float-end">
                            @if($candidats->count() > 0)
                                <a href="{{ route('admin.candidature-valider-export.pdf') }}" class="badge badge-primary">Export PDF</a>
                                <a href="{{ route('admin.candidature-valider-export.excel') }}" class="badge badge-success">Export Excel</a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">                        
                        <form action="{{ route('admin.liste.candidature') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="">Région</label>
                                        <select id="metier_select" name="r">
                                            <option value="">Choisissez une region</option>
                                            @foreach($regions as $region)
                                                <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label>Tranche d'âge</label>
                                    <select id="single-select" name="a">
                                        <option value="">Choissisez un tranche d'âge</option>
                                        @foreach($trancheages as $trancheage)
                                            <option @if($trancheage_select == $trancheage->trancheage_id) selected @endif value="{{ $trancheage->trancheage_id}}">{{ $trancheage->trancheage_lib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Genre</label>
                                    <select name="g" class="form-control">
                                        <option value="">Choissisez un genre</option>
                                        <option @if($genre_select == "F") selected @endif value="F">Femme</option>
                                        <option @if($genre_select == "H") selected @endif value="H">Homme</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Situation matrimoniale</label>
                                    <select class="form-control" name="s">
                                        <option value="">Choisissez une situation</option>
                                        <option @if($situation_select == "CELIBATAIRE") selected @endif value="CELIBATAIRE">CELIBATAIRE</option>
                                        <option @if($situation_select == "MARIE(E)") selected @endif value="MARIE(E)">MARIE(E)</option>
                                        <option @if($situation_select == "DIVORCE(E)") selected @endif value="DIVORCE(E)">DIVORCE(E)</option>
                                        <option @if($situation_select == "VEUF(E)") selected @endif value="VEUF(E)">VEUF(E)</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row mt-3">                                
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Titre Offre</th>
                                        <th>Nom & Prénoms</th>
                                        <th>Date Abonnement</th>
                                        <th>Statut</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($candidats as $candidature)
                                        <tr>
                                            <td>
                                                @if($candidature->profil_photo != null)
                                                    <img src="{{ asset('assets/img/profil/'.$candidature->profil_photo) }}" class="img-fluid" width="55" alt="">
                                                @else
                                                    <img src="{{ asset('assets/img/profil/avatar.png') }}" class="img-fluid" width="55" alt="">
                                                @endif
                                            </td>
                                            <td>
                                                <div class="cats-box rounded bg-white d-flex align-items-center">
                                                    <div class="cats-box-caption px-2">
                                                        <h4 class="fs-md mb-0 ft-medium" style="font-size:16px !important">{{ $candidature->offretitre }}</h4>
                                                        <div class="d-block mb-2 position-relative">
                                                            <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>{{ $candidature->typecontratlib }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ $candidature->name }} {{ $candidature->prenoms }}</td>
                                            <td>{{ \Carbon\Carbon::parse($candidature->abonnement_datecrea)->format('d/m/Y') }}</td>
                                            <td>
                                                @if($candidature->candidature_statut == "BROUILLON")
                                                    <span class="badge badge-danger">Brouillon</span>
                                                @elseif($candidature->candidature_statut == "VALIDE")
                                                    <span class="badge badge-primary">Active</span>
                                                @elseif($candidature->candidature_statut == "APPROUVE")
                                                    <span class="badge badge-success">En contrat</span>
                                                @endif
                                            </td>
                                            <td class="text-center"> 
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND"))
                                                    @if($candidature->candidature_statut == "APPROUVE")
                                                        <a href="{{ route('admin.demandeur.details', [$candidature->user_id, Stdfn::clean_url($candidature->prenoms)]) }}" class="" title="DETAILS"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-fluid" width="23"></a>
                                                    @else
                                                        <a href="{{ route('admin.valider.candidature',$candidature->candidature_id) }}" title="APPROUVE LA CANDIDATURE" style="cursor:pointer"><img src="{{ asset('assets/img/icons/validercone.png') }}" class="img-fluid" width="25"></a>
                                                    @endif                                                    
                                                @endif
                                            </td>                                               
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection