
@extends('layouts.appp')

@section('title')
    Liste des demandeurs d'emploi
@endsection

@section('titre')
    Liste des demandeurs d'emploi
@endsection

@section('content')
    <div class="container-fluid"> 
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion demandeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des demandeurs d'emploi</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des demandeurs d'emploi</h4>
                        <div class="float-end">
                            @if($demandeurs->count() > 0)
                                <a href="{{ route('admin.demandeur-emploi-export.pdf') }}" class="badge badge-primary">Export PDF</a>
                                <a href="{{ route('admin.demandeur-emploi-export.excel') }}" class="badge badge-success">Export Excel</a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.liste.demandeur') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="">Région</label>
                                        <select id="metier_select" name="r">
                                            <option value="">Choisissez une region</option>
                                            @foreach($regions as $region)
                                                <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label>Tranche d'âge</label>
                                    <select id="single-select" name="a">
                                        <option value="">Choissisez un tranche d'âge</option>
                                        @foreach($trancheages as $trancheage)
                                            <option @if($trancheage_select == $trancheage->trancheage_id) selected @endif value="{{ $trancheage->trancheage_id}}">{{ $trancheage->trancheage_lib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Genre</label>
                                    <select name="g" class="form-control">
                                        <option value="">Choissisez un genre</option>
                                        <option @if($genre_select == "F") selected @endif value="F">Femme</option>
                                        <option @if($genre_select == "H") selected @endif value="H">Homme</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Situation matrimoniale</label>
                                    <select class="form-control" name="s">
                                        <option value="">Choisissez une situation</option>
                                        <option @if($situation_select == "CELIBATAIRE") selected @endif value="CELIBATAIRE">CELIBATAIRE</option>
                                        <option @if($situation_select == "MARIE(E)") selected @endif value="MARIE(E)">MARIE(E)</option>
                                        <option @if($situation_select == "DIVORCE(E)") selected @endif value="DIVORCE(E)">DIVORCE(E)</option>
                                        <option @if($situation_select == "VEUF(E)") selected @endif value="VEUF(E)">VEUF(E)</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr> 
                                        <th class="d-none"></th>
                                        <th>Nom & Prénoms</th>
                                        <th>Email</th>
                                        <th>Téléphone</th>
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP"))
                                        <th>Statut</th>
                                        @endif
                                        <th class="text-center">WhatsApp</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody> 
									@foreach($demandeurs as $demandeur)
                                        <tr>
                                            <td class="d-none"></td>
											<td>
                                                @if(!empty($demandeur->profil_photo))
                                                    <img src="{{ asset('assets/img/profil/'.$demandeur->profil_photo) }}" width="30" alt="" class="mr-2">
                                                @else
                                                    <img src="{{ asset('assets/img/profil/avatar.png') }}" width="30" alt="" class="mr-2">
                                                @endif
                                                {{ $demandeur->name }} {{ $demandeur->prenoms }}
                                            </td>
											<td>{{ $demandeur->email }}</td>
											<td>{{ $demandeur->telephone }}</td>
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                            <td>
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    @if($demandeur->user_statut == "BROUILLON")
                                                        <a href="{{ route('admin.activer.demandeur',$demandeur->id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a> 
                                                    @else
                                                        <a href="{{ route('admin.desactiver.demandeur',$demandeur->id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a>
                                                    @endif
                                                @endif
                                            </td>
                                            @endif
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP"))
                                            <td>
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP"))
                                                    @if($demandeur->user_statut == "VALIDE")
                                                        @if($demandeur->region_id == Auth::user()->region_id)
                                                            <a href="{{ route('admin.desactiver.demandeur',$demandeur->id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                        @else
                                                            <span class="badge badge-info">{{$demandeur->user_statut}}</span>
                                                        @endif
                                                    @else
                                                        @if($demandeur->region_id == Auth::user()->region_id)
                                                            <a href="{{ route('admin.activer.demandeur',$demandeur->id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                        @else
                                                            <span class="badge badge-info">{{$demandeur->user_statut}}</span>
                                                        @endif
                                                    @endif
                                                @endif
                                            </td>
                                            @endif
                                            <td class="text-center">
                                                <a href="https://wa.me/<?php echo $demandeur->indicatif . $demandeur->telephone; ?>?text=<?php echo urlencode($url."/carteanpe/".$demandeur->user_carte); ?>" target="_blank"><img src="{{ asset('assets/img/whatsapp.png') }}" style="color:green !important; width: 30px;"></a>
                                            </td>
											<td class="text-center">
                                                <a href="{{ route('admin.demandeur.details', [$demandeur->id, Stdfn::clean_url($demandeur->prenoms)]) }}" class="" title="DETAILS"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-fluid" width="23" alt=""></a>
                                                @if($demandeur->user_carte_statut =="VALIDE")
                                                    <a href="{{ asset('carteanpe/'.$demandeur->user_carte) }}" target="_blank" title="VOIR LA CARTE" class=""><img src="{{ asset('assets/img/icons/voircarte.png') }}" class="img-fluid" width="23" alt=""></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    <span data-toggle="modal" data-target="#supprimerdemandeur{{$demandeur->id}}" title="SUPPRIMER"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "DEL_DEMP") and $demandeur->region_id == Auth::user()->region_id)
                                                    <span data-toggle="modal" data-target="#supprimerdemandeur{{$demandeur->id}}" title="SUPPRIMER"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" alt=""></span>
                                                @endif
                                            </td>
										</tr> 
                                        <div class="modal fade" id="supprimerdemandeur{{$demandeur->id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer le demandeur d'emploi : {{ $demandeur->name }} {{ $demandeur->prenoms }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.demandeur.supprimer',$demandeur->id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                       
									@endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function(){
            //Confirmer Supprimer Candidat
            $('.supprimerdemandeur').click(function() {
                var candidatname = $(this).attr('data-name');
                var candidatsupurl = $(this).attr('data-url');
                Swal.fire({
                    title: 'ÊTES-VOUS SÛRS ?',
                    text: "Vous êtes sur le point de supprimer le demandeur d'emploi : "+candidatname+" !",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Valider',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                    window.location = ""+candidatsupurl+""
                    Swal.fire(
                        'VALIDER !',
                        'Le demandeur d\'emploi a bien été supprimé.',
                        'success'
                    )
                    }
                })
            });
        });
    </script>
@endsection