@extends('layouts.appp')

@section('title')
    Extraction des profils de candidature
@endsection

@section('titre')
    Extraction des profils de candidature
@endsection
 
@section('content')
    <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion demandeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Extraction des profils de candidature</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des profils de candidature</h4>
                        @if($profilcandidature->count() > 0)
                            <div class="float-end">
                                <a href="{{ route('admin.extraction.donnees') }}" class="badge badge-success">Exporter la liste</a>
                            </div>
                        @endif
                    </div>
                    <div class="card-body"> 
                        <form action="{{ route('admin.profil.candidature') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <label>Type de formation</label>
                                     <input type="text" name="f" class="form-control" value="{{ $formation_selected }}" placeholder="Entrer le type de formation">
                                </div>
                                <div class="col-md-6">
                                    <label>Expérience professionnelle</label>
                                     <input type="text" name="e" class="form-control" value="{{ $experiencepro_selected }}" placeholder="Entrer l'expérience professionnelle">
                                </div>
                                <div class="col-md-6 mt-3">
                                    <label>Spécialité</label>
                                    <input type="text" name="s" class="form-control" value="{{ $specialite_selected }}" placeholder="Entrer la spécialité">
                                </div>
                                <div class="col-md-6 mt-3">
                                    <label>Diplômes</label>
                                    <select id="diplome_select" name="d">
                                        <option value="">Choissisez un diplôme</option>
                                        @foreach($diplomes as $diplome)
                                            <option @if($diplome_selected == $diplome->diplome_id) selected @endif value="{{ $diplome->diplome_id }}">{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <label>Métiers</label>
                                    <select id="metier_select" name="m">
                                        <option value="">Choissisez un métier</option>
                                        @foreach($filieres as $filiere)
                                            <option @if($metier_selected == $filiere->metier_id) selected @endif value="{{ $filiere->metier_id }}">{{ $filiere->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <div class="form-group">
                                        <label class="">Région</label>
                                        <select id="single-select" name="r">
                                            <option value="">Choisissez une region</option>
                                            @foreach($regions as $region)
                                                <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <label>Année d'expérience</label>
                                    <input type="text" name="a" class="form-control" value="{{ $experience_selected }}" placeholder="Entrer l'année d'expérience">
                                </div>
                                <div class="col-md-3 mt-3">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                                <div class="col-md-3 mt-3">
                                    <label class="mt-3"></label>
                                    <a href="{{ route('admin.profil.candidature') }}" class="btn btn-warning btn-block">Réinitialiser</a>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Nom & Prénom</th>
                                        <th>Diplôme</th>
                                        <th>Métier</th>
                                        <th>Année d'Expérience</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($profilcandidature as $candidature)
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                            <tr>
                                                <td>
                                                    @if(!empty($candidature->profil_photo))
                                                        <img src="{{ asset('assets/img/profil/'.$candidature->profil_photo) }}" width="30" alt="">
                                                    @else
                                                        <img src="{{ asset('assets/img/profil/avatar.png') }}" width="20" alt="">
                                                    @endif
                                                </td>
                                                <td>{{ $candidature->name }} {{$candidature->prenoms}}</td>
                                                <td>
                                                    @if($candidature->diplome_id == 27)
                                                        {{ $candidature->new_diplome }}
                                                    @else
                                                        {{ $candidature->diplomelib }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($candidature->metier_id == 51)
                                                        {{ $candidature->new_metier }}
                                                    @else
                                                        {{ $candidature->metier_libelle }}
                                                    @endif
                                                </td> 
                                                <td><?php echo(htmlspecialchars_decode($candidature->experience)) ?></td> 
                                                <td class="text-center">
                                                    <a style="cursor:pointer;" href="" data-toggle="modal" data-target="#modal_details{{ $candidature->id }}" title="DÉTAILS" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                </td>                                               
                                            </tr>
                                        @endif
                                        @if($candidature->region_id == Auth::user()->region_id)
                                            <tr>
                                                <td>
                                                    @if(!empty($candidature->profil_photo))
                                                        <img src="{{ asset('assets/img/profil/'.$candidature->profil_photo) }}" width="30" alt="">
                                                    @else
                                                        <img src="{{ asset('assets/img/profil/avatar.png') }}" width="20" alt="">
                                                    @endif
                                                </td>
                                                <td>{{ $candidature->name }} {{$candidature->prenoms}}</td>
                                                <td>
                                                    @if($candidature->diplome_id == 27)
                                                        {{ $candidature->new_diplome }}
                                                    @else
                                                        {{ $candidature->diplomelib }}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($candidature->metier_id == 51)
                                                        {{ $candidature->new_metier }}
                                                    @else
                                                        {{ $candidature->metier_libelle }}
                                                    @endif
                                                </td> 
                                                <td>{{ $candidature->experience }}</td> 
                                                <td class="text-center">
                                                    <a style="cursor:pointer;" href="" data-toggle="modal" data-target="#modal_details{{ $candidature->id }}" title="DÉTAILS" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                </td>                                               
                                            </tr>
                                        @endif
                                        <div id="modal_details{{ $candidature->id }}" class="modal fade" tabindex="-1">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;DETAILS DE : {{ $candidature->name }} {{$candidature->prenoms}}</h5>
                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                                <div class="tab-content">
                                                                    <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                        @if($candidature->profil_photo)
                                                                            <img class="img-fluid" src="{{ asset('assets/img/profil/'.$candidature->profil_photo) }}" alt="" style="border: 2px solid #000;" width="260">
                                                                        @else
                                                                            <img class="img-fluid" src="{{ asset('assets/img/profil/avatar.png') }}" alt="" style="border: 2px solid #000;" width="260">
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                                <div class="product-detail-content">
                                                                    <div class="new-arrival-content pr">
                                                                        <p class="text-couleur">Nom & Prénoms : {{ $candidature->name }} {{ $candidature->prenoms }}</p>
                                                                        <p class="text-couleur">Adresse Email : {{ $candidature->email }}</p>
                                                                        <p class="text-couleur">Téléphone : {{ $candidature->telephone }}</p>
                                                                        <p class="text-couleur">Genre : 
                                                                            @if($candidature->genre =="F")
                                                                                Femme
                                                                            @else
                                                                                Homme
                                                                            @endif 
                                                                        </p>
                                                                        @if($candidature->metier)
                                                                            <p class="text-couleur">Filière :
                                                                                @if($candidature->metier->metier_id == 51)
                                                                                    {{ $candidature->new_metier }}
                                                                                @else
                                                                                    {{ $candidature->metier->metier_libelle }}
                                                                                @endif
                                                                            </p>
                                                                        @endif
                                                                        @if($candidature->diplome)
                                                                            <p class="text-couleur">Dernier Diplôme :
                                                                                @if($candidature->diplome->diplome_id == 27)
                                                                                    {{ $candidature->new_diplome }}
                                                                                @else
                                                                                    {{ $candidature->diplome->diplomelib }}
                                                                                @endif
                                                                            </p>
                                                                        @endif
                                                                        <p class="text-couleur">Département : {{ $candidature->departement }}</p>
                                                                        <p class="text-couleur">Commaune : {{ $candidature->commune }}</p>
                                                                        <p class="text-couleur">Quartier/Village : {{ $candidature->village_quart }}</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div> 
                                                        <hr>
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des formations</h6>
                                                                @foreach($candidature->formations as $formation)
                                                                    <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $formation->formation_diplome }}</small><br>
                                                                @endforeach
                                                                <br>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des expériences professionnelles</h6>
                                                                @foreach($candidature->experiencepro as $experience)
                                                                    <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $experience->experiencepro_titre }}</small><br>
                                                                @endforeach
                                                                <br>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des spécialités</h6>
                                                                @foreach($candidature->specialites as $specialite)
                                                                    <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $specialite->specialite_intitule }}</small><br>
                                                                @endforeach
                                                            </div>
                                                        </div>                   
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                                                        @if($candidature->user_cv !=null and $candidature->user_cv != "")
                                                        <a href="{{ asset('assets/img/profil/documents/'.$candidature->user_cv) }}" target="_blank" class="btn btn-primary"><i class="fas fa-address-card mr-1"></i> Ouvrir le CV</a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>                                        
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection