@extends('layouts.appp')

@section('title')
    Valider le contrat
@endsection

@section('titre')
    Valider le contrat
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion des demandeurs</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.liste.candidature') }}">Liste des candidatures</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Valider contrat</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Valider le contrat</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form  action="{{ route('admin.savevalider.candidature',$candidature->candidature_id) }}" method="POST">
                                @csrf
                                @if(Session::has('info_erreur'))
                                    <div class="alert alert-danger alert-styled-left alert-dismissible">
                                        <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
                                        <span class="font-weight-semibold">
                                            {{Session::get('info_erreur')}}
                                        </span>
                                    </div>
                                @endif
                                <input type="hidden" name="candidature_id" value="{{ $candidature->candidature_id }}">
                                <div class="form-row">
                                    <div class="form-group col-md-4">
                                        <label>Type de contrat</label>
                                        <select class="form-control" id="typecontrat_id"name="typecontrat_id" required>
                                            <option value="">Sélectionnez un type de contrat</option>
                                            @foreach($typecontrats as $contrat)
                                                <option value="{{ $contrat->typecontrat_id }}">{{ $contrat->typecontratlib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>Date de Début</label>
                                        <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control" name="datedebut">
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label>Date de Fin</label>
                                        <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control" name="datefin">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary">Valider le contrat</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection