@extends('layouts.appp')

@section('title')
    Créer un compte employeurs
@endsection

@section('titre')
    Créer un compte employeurs
@endsection

@section('content')
    <style>
    </style>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript::void(0)">Gestion employeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Créer un compte employeur</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-xxl-12">
                                <h2><i class="fa fa-cogs mr-2" aria-hidden="true"></i>Informations Générales</h2><hr>
                                <form method="POST" action="{{ route('admin.save.creer.entreprise') }}" enctype="multipart/form-data">
									@csrf
                                    <div class="form-group">
                                        <label class="">Designation <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control rounded @error('raisonsociale') is-invalid @enderror"  name="raisonsociale" value="{{ old('raisonsociale') }}" placeholder="Raison sociale" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Adresse <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('adresse') is-invalid @enderror"  name="adresse" value="{{ old('adresse') }}" placeholder="Adresse">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Contact <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('contact') is-invalid @enderror"  name="contact" value="{{ old('contact') }}" placeholder="+227 20 73 33 84" onkeypress="isInputNumber(event)">
                                            </div>
                                        </div>
                                    </div><hr>
                                    <h2><i class="fa fa-map-marker mr-2" aria-hidden="true"></i>Coordonnées Interlocuteur</h2><hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Nom & Prénoms <span style="color:red">*</span></label>
                                                <input type="text" class="form-control rounded @error('nom') is-invalid @enderror" name="nom" required value="{{ old('nom') }}" placeholder="Entrer votre nom & prénoms" onkeyup="this.value=this.value.toUpperCase()">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Contact Interlocuteur <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded"  name="contactinterlo" value="{{ old('contactinterlo') }}" placeholder="+227 20 73 33 84" onkeypress="isInputNumber(event)">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="">Qualité <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control rounded @error('qualite') is-invalid @enderror"  name="qualite" value="{{ old('qualite') }}" placeholder="Qualité" onkeyup="this.value=this.value.toUpperCase()">
                                    </div><hr>
                                    <h2><i class="fa fa-users mr-2" aria-hidden="true"></i>Effectif de l'entreprise</h2><hr>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Homme <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('nbrehomme') is-invalid @enderror"  name="nbrehomme" value="{{ old('nbrehomme')  }}" placeholder="Nombre d'homme" onkeypress="isInputNumber(event)">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Femme <span style="color:red">*</span></label>
                                                <input type="text" required class="form-control rounded @error('nbrfemme') is-invalid @enderror"  name="nbrfemme" value="{{ old('nbrfemme') }}" placeholder="Nombre de femme" onkeypress="isInputNumber(event)">
                                            </div>
                                        </div>
                                    </div><hr>
                                    <h2><i class="fa fa-cubes mr-2" aria-hidden="true"></i>Autres Informations</h2><hr>
                                    <div class="form-group">
                                        <label class="">Activité <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control rounded @error('activite') is-invalid @enderror"  name="activite" value="{{ old('activite') }}" placeholder="Activité" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Nationalité <span style="color:red">*</span></label>
                                                <select required class="form-control @error('nationalite_id') is-invalid @enderror" name="nationalite_id">
                                                    <option value="">Choisissez une nationalité</option>
                                                    @foreach($nationalites as $nationalite)
                                                        <option value="{{ $nationalite->nationalite_id }}" {{ old('nationalite_id') == $nationalite->nationalite_id ? 'selected' : '' }}>{{ $nationalite->nationalite_lib }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Région <span style="color:red">*</span></label>
                                                <select required id="single-select" name="region_id">
                                                    <option value="">Choisissez une region</option>
                                                    @if(Auth::user()->profil_id == 4)
                                                        @foreach($region_agent as $region)
                                                            <option value="{{ $region->region_id }}" {{ old('region_id') == $region->region_id ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                                        @endforeach
                                                    @endif
                                                    @if(Auth::user()->profil_id == 1)
                                                        @foreach($regions as $region)
                                                            <option value="{{ $region->region_id }}" {{ old('region_id') == $region->region_id ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Branche d'activité <span style="color:red">*</span></label>
                                                <select required id="automatic-selection" name="secteuractivite_id">
                                                    <option value="">Choisissez une branche d'activité</option>
                                                    @foreach($activites as $activite)
                                                        <option value="{{ $activite->secteuractivite_id }}" {{ old('secteuractivite_id') == $activite->secteuractivite_id ? 'selected' : '' }}>{{ $activite->secteuractivitelib }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Statut <span style="color:red">*</span></label>
                                                <select required class="form-control @error('statutentreprise_id') is-invalid @enderror" name="statutentreprise_id">
                                                    <option value="">Choisissez un statut</option>
                                                    @foreach($statuts as $statut)
                                                        <option value="{{ $statut->statutentreprise_id }}" {{ old('statutentreprise_id') == $statut->statutentreprise_id ? 'selected' : '' }}>{{ $statut->statutentreprise_lib }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">N° CNSS</label>
                                                <input type="text" class="form-control rounded @error('ncnss') is-invalid @enderror"  name="ncnss" value="{{ old('ncnss') }}" placeholder="Entre le numéro CNSS" onkeyup="this.value=this.value.toUpperCase()">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="">Situation <span style="color:red">*</span></label>
                                                <select required class="form-control @error('situationentreprise_id') is-invalid @enderror" name="situationentreprise_id">
                                                    <option value="">Choisissez une situation</option>
                                                    @foreach($situations as $situation)
                                                        <option value="{{ $situation->situationentreprise_id }}" {{ old('situationentreprise_id') == $situation->situationentreprise_id ? 'selected' : '' }}>{{ $situation->situationentreprise_lib }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
										<div class="col-md-12">
                                            <div class="form-group">
                                                <label class="">Logo entreprise<small>( Fichier autorisé : png, jpg, jpeg)</small></label>
                                                <input type="file" class="form-control rounded @error('entreprise_logo') is-invalid @enderror"  name="entreprise_logo" value="{{ old('entreprise_logo') }}">
											</div>
                                        </div>
                                    </div><hr>
                                    <h2><i class="fa fa-unlock-alt mr-2" aria-hidden="true"></i>Email & Mot de passe</h2><hr>                                    
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="">Email <span style="color:red">*</span></label>
                                                <input type="email" required class="form-control rounded @error('email') is-invalid @enderror"  name="email" value="{{ old('email') }}" placeholder="Entre l'adresse email">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="">Mot de passe <span style="color:red">*</span></label>
                                                <input type="password" required class="form-control rounded @error('password') is-invalid @enderror"  name="password" placeholder="******">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="">Confirmer mot de passe <span style="color:red">*</span></label>
                                                <input type="password" id="password-confirm" required class="form-control rounded"  name="password_confirmation" placeholder="******">
                                            </div>
                                        </div>
                                    </div><hr>
									<button class="btn btn-primary float-end">Créer le compte</button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<script>
		function isInputNumber(evt){
			
			var ch = String.fromCharCode(evt.which);
			
			if(!(/[0-9]/.test(ch))){
				evt.preventDefault();
			}        
		} 
	</script>
@endsection 