@extends('layouts.appp')

@section('title')
    <?php echo html_entity_decode($user->raisonsociale) ?>
@endsection

@section('titre')
    <?php echo html_entity_decode($user->raisonsociale) ?>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion employeurs</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.liste.entreprise') }}">Liste des employeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Détails</a></li>
            </ol>
        </div>
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Détails : <?php echo html_entity_decode($user->raisonsociale) ?></h4>
                    <div class="float-end">
                        @if($user->user_statut == "BROUILLON")
                            <span class="badge badge-danger light">En attente de validation</span>
                        @elseif($user->user_statut == "VALIDE")
                            <span class="badge badge-success light">Compte validé</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Informations générale</a>
                            </li>
                            @if($user->user_statut =="VALIDE")
                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_OFF"))
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#offres-publiees"><i class="la la-file mr-2"></i> Liste des offres publiées</a>
                                    </li>
                                @endif
                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND"))
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#contrat"><i class="la la-book mr-2"></i> Liste des contrats</a>
                                    </li>
                                @endif
                            @endif
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP"))
                                @if($user->user_statut == "BROUILLON")
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#validercompte"><i class="fa fa-check-circle mr-2"></i> Valider le compte</a>
                                    </li>
                                @endif
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6  col-md-6 col-xxl-5 ">
                                                            <div class="tab-content">
                                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                    <img class="img-fluid" src="{{ asset('assets/img/entreprise/'.$user->entreprise_logo) }}" alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-9 col-lg-6  col-md-6 col-xxl-7 col-sm-12">
                                                            <div class="product-detail-content">
                                                                <div class="new-arrival-content pr">
                                                                    <h4><?php echo html_entity_decode($user->raisonsociale) ?></h4> 
                                                                    @if($user->nationalite_id !=null or $user->nationalite_id !="")<p>Nationalité : {{ $nationalite->nationalite_lib }}</p>@endif
                                                                    @if($user->region_id !=null or $user->region_id !="")<p>Region : {{ $region->region_nom }}</p>@endif
                                                                    <p>Email : {{ $user->email }}</p>
                                                                    @if($user->statutentreprise_id !=null or $user->statutentreprise_id !="")<p>Statut : {{ $statutentreprise->statutentreprise_lib }}</p>@endif
                                                                    @if($user->situationentreprise_id !=null or $user->situationentreprise_id !="")<p>Situation actuelle : 
                                                                        @if($situationentreprise->situationentreprise_lib == "EN ACTIVITEE")
                                                                            <span class="badge badge-success light">{{ $situationentreprise->situationentreprise_lib }}</span>
                                                                        @elseif($situationentreprise->situationentreprise_lib == "VEILLEUSE")
                                                                            <span class="badge badge-warning light">{{ $situationentreprise->situationentreprise_lib }}</span>  
                                                                        @else
                                                                            <span class="badge badge-danger light">{{ $situationentreprise->situationentreprise_lib }}</span>
                                                                        @endif
                                                                    </p>@endif
                                                                    @if($user->secteuractivite_id !=null or $user->secteuractivite_id !="")<p>Branche activité : {{ $secteuractivite->secteuractivitelib }}</p>@endif
                                                                    <p class="text-content">
                                                                        <strong>Adresse</strong><br>
                                                                        <?php echo html_entity_decode($user->adresse) ?>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="offres-publiees">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th>Titre de l'offre</th>
                                                    <th>Status</th>
                                                    <th>Date de clôture</th>
                                                    <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($offres as $offre)
                                                    <tr>
                                                        <td>
                                                            <div class="cats-box rounded bg-white d-flex align-items-center">
                                                                <div class="cats-box-caption px-2">
                                                                    <h4 class="fs-md mb-0 ft-medium">{{ $offre->offretitre }}</h4>
                                                                    <div class="d-block mb-2 position-relative">
                                                                        <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i>{{ $offre->offre_ville }}</span>
                                                                        <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>{{ $offre->contrat->typecontratlib }}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            @if($offre->offre_statut == "BROUILLON")
                                                                <span class="badge badge-danger light">Brouillon</span>
                                                            @elseif($offre->offre_statut == "VALIDE")
                                                                <span class="badge badge-warning light">Active</span>
                                                            @elseif($offre->offre_statut == "PUBLIE")
                                                                <span class="badge badge-success light">Publié</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if($offre->offre_datefin > gmdate('Y-m-d'))
                                                                <span class="badge badge-success">{{ \Carbon\Carbon::parse($offre->offre_datefin)->format('d/m/Y') }}</span>
                                                            @else
                                                                <span class="badge badge-danger">Offre expirée</span>
                                                            @endif
                                                        </td>
                                                        <td class="text-center">
                                                            <a href="{{ route('admin.details.offre',$offre->offre_id) }}" title="DETAILS OFFRE" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                        </td>                                     
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="contrat">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th>Candidat</th>
                                                    <th>Type de Contrat</th>
                                                    <th>Date de début</th>
                                                    <th>Date de clôture</th>
                                                    <th class="text-center">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($contrats as $contrat)
                                                    <tr>
                                                        <td>{{ $contrat->name }} {{ $contrat->prenoms }}</td>
                                                        <td>{{ $contrat->offre_id }} | {{ $contrat->typecontratlib }}</td>
                                                        <td>{{ \Carbon\Carbon::parse($contrat->candidature_datedebcrt)->format('d/m/Y') }}</td>
                                                        <td>
                                                            @if($contrat->candidature_datefincrt != null and $contrat->candidature_datefincrt < $datejour)
                                                                <span class="badge badge-danger">{{ \Carbon\Carbon::parse($contrat->candidature_datefincrt)->format('d/m/Y') }}</span>
                                                            @else
                                                                <span class="badge badge-success">Date de clôture non définie</span>
                                                            @endif   
                                                        </td>
                                                        <td class="text-center">
                                                            @php $datejour = gmdate('Y-m-d') @endphp
                                                                
                                                            @if($contrat->candidature_datefincrt != null and $contrat->candidature_datefincrt < $datejour)                                                                
                                                                <span class="messagecontrat" data-url="{{ route('admin.rapelle.entreprise',$contrat->candidature_id) }}" data-id="{{ $contrat->offre_id }}" data-name="{{ $contrat->name }} {{ $contrat->prenoms }}" data-first="{{ $contrat->typecontratlib }}" title="RAPPELLE DE LA FIN DU CONTRAT"><img src="{{ asset('assets/img/icons/message.png') }}" width="30"></span>
                                                            @else
                                                                <span class="badge badge-success">Contrat en cours</span>
                                                            @endif                                            
                                                        </td>                                               
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="validercompte">
                                <div class="pt-4">
                                    <form action="{{ route('admin.entreprise.validercompte',$user->id) }}" method="POST">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Avis de validation <span class="text-danger">*</span></label>
                                                <select class="form-control" name="avis" required>
                                                    <option value="">Choisissez un avis</option>
                                                    <option value="OUI">Avis favorable</option>
                                                    <option value="NON">Avis non favorable</option>
                                                </select>
                                            </div>
                                            <diV class="col-md-12 mt-3">
                                                <label>Observation <span class="text-danger">*</span></label>
                                                <textarea class="form-control" rows="6" name="observation" placeholder="Entrer l'observation..." required></textarea>
                                            </diV>
                                            <div class="col-md-12 mt-3">
                                                <button class="btn btn-info"><i class="fa fa-check-circle mr-2"></i>Valider</button>
                                            </div>                                           
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection