@extends('layouts.appp')

@section('title')
    <?php echo html_entity_decode($user->raisonsociale) ?>
@endsection

@section('titre')
    <?php echo html_entity_decode($user->raisonsociale) ?>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion employeurs</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.valider.entreprise') }}">Liste des employeurs à valider</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Valider</a></li>
            </ol>
        </div>
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Détails : <?php echo html_entity_decode($user->raisonsociale) ?></h4>
                    <div class="float-end">
                        @if($user->user_statut == "BROUILLON")
                            <span class="badge badge-danger light">En attente de validation</span>
                        @elseif($user->user_statut == "VALIDE")
                            <span class="badge badge-success light">Compte validé</span>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <!-- Nav tabs -->
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Informations générale</a>
                            </li>
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP"))   
                                @if($user->user_statut == "BROUILLON")
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#valider-compte"><i class="fa fa-check-circle mr-2"></i>Valider le compte</a>
                                    </li>
                                @endif
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6  col-md-6 col-xxl-5 ">
                                                            <div class="tab-content">
                                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                    <img class="img-fluid" src="{{ asset('assets/img/entreprise/'.$user->entreprise_logo) }}" alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-9 col-lg-6  col-md-6 col-xxl-7 col-sm-12">
                                                            <div class="product-detail-content">
                                                                <div class="new-arrival-content pr">
                                                                    <h4><?php echo html_entity_decode($user->raisonsociale) ?></h4>
                                                                    <p>Nationalité : {{ $nationalite->nationalite_lib }}</p>
                                                                    <p>Region : {{ $region->region_nom }}</p>
                                                                    <p>Statut : {{ $statutentreprise->statutentreprise_lib }}</p>
                                                                    <p>Situation actuelle : 
                                                                        @if($situationentreprise->situationentreprise_lib == "EN ACTIVITEE")
                                                                            <span class="badge badge-success light">{{ $situationentreprise->situationentreprise_lib }}</span>
                                                                        @elseif($situationentreprise->situationentreprise_lib == "VEILLEUSE")
                                                                            <span class="badge badge-warning light">{{ $situationentreprise->situationentreprise_lib }}</span>  
                                                                        @else
                                                                            <span class="badge badge-danger light">{{ $situationentreprise->situationentreprise_lib }}</span>
                                                                        @endif
                                                                    </p>
                                                                    <p>Branche activité : {{ $secteuractivite->secteuractivitelib }}</p>
                                                                    <p>Interlocuteur : {{ $user->name }}</p>
                                                                    <p>Email : {{ $user->email }}</p>
                                                                    <p>Contact : {{ $user->contact }}</p>
                                                                    <p class="text-content">
                                                                        <strong>Adresse</strong><br>
                                                                        {{ $user->adresse }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="valider-compte">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <form method="POST" action="{{ route('admin.save.entreprise.valider',$user->id) }}" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group">
                                                <label class="">Avis <span style="color:red">*</span></label>
                                                <select class="form-control" name="avis" required>
                                                    <option value="">Choisissez un avis</option>
                                                    <option value="OUI">Avis Favorable</option>
                                                    <option value="NON">Avis non Favorable</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="">Observation <span style="color:red">*</span></label>
                                                <textarea class="form-control" required name="observation" placeholder="Entrer l'observation..." rows="4"></textarea>
                                            </div>
                                            <button class="btn btn-primary">Enregistrer la validation</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection