@extends('layouts.appp')

@section('title')
    Liste des des employeurs
@endsection

@section('titre')
    Liste des des employeurs
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion employeurs</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des employeurs</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des employeurs</h4>
                        <div class="float-end">
                            @if($entreprises->count() > 0)
                                <a href="{{ route('admin.entreprise.exprot-pdf') }}" class="badge badge-primary">Export PDF</a>
								<a href="{{ route('admin.entreprise.exprot-excel') }}" class="badge badge-success">Export Excel</a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">
                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP")  or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_EMP"))
                        <form method="get" action="{{ route('admin.liste.entreprise') }}">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="">Nationalité</label>
                                        <select class="form-control" name="n">
                                            <option value="">Choisissez une nationalité</option>
                                            @foreach($nationalites as $nationalite)
                                                <option @if($nationalite_selected == $nationalite->nationalite_id) selected @endif value="{{ $nationalite->nationalite_id }}">{{ $nationalite->nationalite_lib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="">Région</label>
                                        <select id="single-select" name="r">
                                            <option value="">Choisissez une region</option>
                                            @foreach($regions as $region)
                                                <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="">Statut</label>
                                        <select class="form-control" name="t">
                                            <option value="">Choisissez un statut</option>
                                            @foreach($statuts as $statut)
                                                <option @if($statut_selected == $statut->statutentreprise_id) selected @endif value="{{ $statut->statutentreprise_id }}">{{ $statut->statutentreprise_lib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="">Situation</label>
                                        <select class="form-control" name="s">
                                            <option value="">Choisissez une situation</option>
                                            @foreach($situations as $situation)
                                                <option @if($situation_selected == $situation->situationentreprise_id) selected @endif value="{{ $situation->situationentreprise_id }}">{{ $situation->situationentreprise_lib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <button class="btn btn-info">Rechercher</button>
                        </form>
                        <hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr> 
                                        <th></th>
                                        <th>Raison sociale</th>
                                        <th>Interlocuteur</th>
                                        <th>Contact</th>
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_EMP"))
                                        <th>Statut</th>
                                        @endif
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
									@foreach($entreprises as $entreprise)
                                        <tr>
                                            <td>
                                                <img src="{{ asset('assets/img/entreprise/'.$entreprise->entreprise_logo) }}" class="img-fluid" width="55" alt="">
                                            </td>
											<td><?php echo html_entity_decode($entreprise->raisonsociale) ?></td>
                                            <td>{{ $entreprise->name }}</td>
											<td>{{ $entreprise->contact }}</td> 
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_EMP"))
                                                <td>
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                        @if($entreprise->user_statut == "VALIDE")
                                                            <a href="{{ route('admin.fermer.compte',$entreprise->id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a>
                                                        @else
                                                            <a href="{{ route('admin.activer.compte',$entreprise->id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                        @endif
                                                    @endif
                                                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_EMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_EMP"))
                                                        @if($entreprise->user_statut == "VALIDE")
                                                            @if($entreprise->region_id == Auth::user()->region_id)
                                                                <a href="{{ route('admin.fermer.compte',$entreprise->id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                            @else
                                                                <span class="badge badge-info">{{$entreprise->user_statut}}</span>
                                                            @endif
                                                        @else
                                                            @if($entreprise->region_id == Auth::user()->region_id)
                                                                <a href="{{ route('admin.activer.compte',$entreprise->id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                            @else
                                                                <span class="badge badge-info">{{$entreprise->user_statut}}</span>
                                                            @endif
                                                        @endif
                                                    @endif
                                                </td>
                                            @endif
											<td class="text-center">
                                                <a href="{{ route('admin.entreprise.details', [$entreprise->id, Stdfn::clean_url($entreprise->raisonsociale)]) }}" style="cursor:pointer" title="DETAILS DU COMPTE"><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                @if($entreprise->user_origine == "Locale")
                                                    <a href="{{ route('admin.modifier.entreprise', [$entreprise->id, Stdfn::clean_url($entreprise->raisonsociale)]) }}" title="MODIFIER LE COMPTE" style="cursor:pointer"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    <span data-toggle="modal" data-target="#supprimereemployeur{{$entreprise->id}}" title="SUPPRIMER L'EMPLOYEUR" title="SUPPRIMER EMPLOYEUR"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="26" alt=""></span>
											    @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "DEL_EMP") and $entreprise->region_id == Auth::user()->region_id)
                                                    <span data-toggle="modal" data-target="#supprimerentreprise{{$entreprise->id}}" title="SUPPRIMER L'EMPLOYEUR" title="SUPPRIMER EMPLOYEUR"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="26" alt=""></span>
                                                @endif
                                            </td>
										</tr>
                                        <div class="modal fade" id="supprimereemployeur{{$entreprise->id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer l'employeur : {{$entreprise->raisonsociale}}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.entreprise.supprimer',$entreprise->id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
									@endforeach
                                </tbody>
                            </table>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection