@extends('layouts.appp')

@section('title')
    Liste des profils demandés
@endsection

@section('titre')
    Liste des profils demandés
@endsection

@section('content')
    <style type="text/css">
        .float-end{
            float: right;
        }
    </style>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion de la Cvthèque</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des profils demandés</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des profils demandées</h4>
                    </div>
                    <div class="card-body">
                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CVTH") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CVTH"))
                        <form action="{{ route('admin.liste.cvtheque') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>Région</label>
                                    <select id="single-select" name="r">
                                        <option value="">Choissisez une région</option>
                                        @foreach($regions as $region)
                                            <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id}}">{{ $region->region_nom }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label>Diplômes</label>
                                    <select id="metier_select" name="d">
                                        <option value="">Choissisez un diplôme</option>
                                        @foreach($diplomes as $diplome)
                                            <option @if($diplome_selected == $diplome->diplome_id) selected @endif value="{{ $diplome->diplome_id }}">{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label>Métiers</label>
                                    <select id="diplome_select" name="m">
                                        <option value="">Choissisez un métier</option>
                                        @foreach($filieres as $filiere)
                                            <option @if($metier_selected == $filiere->metier_id) selected @endif value="{{ $filiere->metier_id }}">{{ $filiere->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <label>Année d'expérience</label>
                                    <input type="text" name="a" class="form-control" value="{{ $experience_selected }}" placeholder="Entrer l'année d'expérience">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <form method="POST" action="{{ route('admin.valider.cvtheque') }}">  
                            @csrf                            
                            <div class="table-responsive">                            
                                <table id="example3" class="display min-w850">
                                    <thead>
                                        <tr>
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CVTH"))
                                            <th></th>
                                            @endif
                                            <th>Nom & Prénom</th>
                                            <th>Diplôme</th>
                                            <th>Métier</th>
                                            <th>Année d'Expérience</th>
                                            <th>Employeur</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($profil_recommandes as $profil)
                                            <tr>
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CVTH"))
                                                    <td>
                                                        <input type="checkbox" value="{{ $profil->cvtheque_id }}" name="cvtheque_id[]">
                                                    </td>
                                                @endif
                                                <td>{{ $profil->name }} {{$profil->prenoms}}</td>
                                                <td>{{ $profil->diplomelib }}</td>
                                                <td>{{ $profil->metier_libelle }}</td> 
                                                <td>{{ $profil->experience }}</td>                                 
                                                <td>
                                                    @php
                                                        $employeur = App\Models\User::where(['users.id'=>$profil->employeur_id])->first();
                                                        echo($employeur->raisonsociale);
                                                    @endphp
                                                </td>                                 
                                            </tr>
                                        @endforeach
                                    </tbody>
                                    <tfoot>
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CVTH"))
                                        <tr>
                                            <td colspan="6">
                                                @if($profil_recommandes->count() > 0)
                                                    <button type="submit" class="btn btn-primary float-end">Envoyer la demande</button>
                                                @endif
                                            </td>
                                        </tr>
                                        @endif
                                    </tfoot>
                                </table>
                            </div>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection