<!DOCTYPE html>
<html>
<head>
<style>
  #customers {
    font-family: Arial, Helvetica, sans-serif;
    border-collapse: collapse;
    width: 100%;
    font-size: 9px;
  }

  #customers td, #customers th {
    border: 1px solid #ddd;
    padding: 8px;
  }

  #customers tr:nth-child(even){background-color: #f2f2f2;}

  #customers tr:hover {background-color: #ddd;}

  #customers th {
    padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #04AA6D;
    color: white;
  }

  .impression{
    float: right;
    font-style: italic;
    font-size: 11px;
  }
</style>
</head>
<body>

<h4><center>LISTE DES CONSEILLERS</center></h4>

<table id="customers">
  <tr>
    <th>Nom & Prénoms</th>
    <th>Adresse Email</th>
    <th>Fonction</th>
    <th>Région</th>
    <th>Code</th>
    <th>Date création</th>
  </tr>
  @foreach($conseillers as $conseiller)
    <tr>
      <td>{{ $conseiller->name }} {{ $conseiller->prenoms }}</td>
      <td>{{ $conseiller->email }}</td>
      <td>{{ $conseiller->fonction_libelle }}</td>
      <td>{{ $conseiller->region_nom }}</td>
      <td>{{ $conseiller->code_conseiller }}</td>
      <td>{{ \Carbon\Carbon::parse($conseiller->date_creation)->format('d-m-Y')}}</td>
    </tr>
  @endforeach
</table>
<footer>  
  <p class="impression">Document imprimé le <?php echo(gmdate('Y-m-d')) ?> à <?php echo(gmdate('H:i:s')) ?> sur <span style="color:blue">www.jobboard.target-ci.com</span></p>
</footer>
</body>
</html>