<!doctype html>
<html>
<head>
<style>
  #customers {
    font-family: Arial, Helvetica, sans-serif;
    border-collapse: collapse;
    width: 100%;
    font-size: 8px;
  }

  #customers td, #customers th {
    border: 1px solid #ddd;
    padding: 8px;
  }

  #customers tr:nth-child(even){background-color: #f2f2f2;}

  #customers tr:hover {background-color: #ddd;}

  #customers th {
    padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #04AA6D;
    color: white;
  }

  .impression{
    float: right;
    font-size: 10px;
    font-style: italic;
  }
</style>
</head>
<body>
<h4 style="text-align: center;">LISTE DES DEMANDES D'EMPLOI</h4>

<table id="customers">
  <tr>
    <th>Nom & Prénoms</th>
    <th>Genre</th>
    <th>Téléphone</th>
    <th>Email</th>
    <th>Titre offre</th>
    <th>Type contrat</th>
    <th>Date</th>
    <th>Statut</th>
  </tr>
  @foreach($demandeemploi as $demandeur)
    <tr>
      <td>{{ $demandeur->name }} {{ $demandeur->prenoms }}</td>
      <td>{{ $demandeur->genre }}</td>
      <td>{{ $demandeur->telephone }}</td>
      <td>{{ $demandeur->email }}</td>
      <td>{{ $demandeur->offretitre }}</td>
      <td>{{ $demandeur->typecontratlib }}</td>
      <td>{{ \Carbon\Carbon::parse($demandeur->candidature_datecrea)->format('d/m/Y') }}</td>
      <td>{{ $demandeur->candidature_statut }}</td>
    </tr>
  @endforeach
</table>
<footer>  
  <p class="impression">Document imprimé le <?php echo(gmdate('Y-m-d')) ?> à <?php echo(gmdate('H:i:s')) ?></p>
</footer>
</body>
</html>