<html>
<head>
	<title>LISTE DES DEMANDEURS D'EMPLOI</title>
	<meta charset="utf-8" />
	<style>
		html, body, div, spany
		h1, h2, h3, h4, h5, h6, p
		table, caption, tbody, tfoot, thead, tr, th, td{
			margin: 0;
			padding: 0;
			border: 0;
			font-size: 100%;
			font: inherit;
			vertical-align: baseline;
		}
		body {
			line-height: 1;
		}
		table {
			border-collapse: collapse;
			border-spacing: 0;
		}

		body {
		    max-width: 1100px;
		    margin: 0px auto; padding: 10px;
		    font-family: Arial;
		}
		th, td {
			display: table-cell;
		    vertical-align: middle;
		}

		/* MAIN TABLE CSS - START */
		#mainTableDiv {
			width: 100%;
			margin: 0; padding: 0;
			margin: 10px auto 0px;
		}
		#mainTable {
			width: 100%; position: relative;
			background-color: white;
			border: 2px solid #000;
			border-radius: 5px;
			border-spacing: 2px;
			margin: 0px;
			z-index: 8;
		}
		#mainTable th, #mainTable td {
			border: 1px solid #000;
			padding: 3px 5px;
		}
		/* MAIN TABLE CSS - END */

		#mainTable th{
		    background-color: orange;
		    color: white; font-weight: normal;
		    text-align: center;
		    font-weight: normal;
		}
		th, td {
		    display: table-cell;
		    padding: 2px 10px; margin: auto;
		}
	</style>
</head>
<body>
	<div id="mainTableDiv">
		<table id="mainTable">
			<thead>
				<tr style="font-size:8px !important">
					<th>ID</th>
					<th>NOM & PRÉNOMS</th>
					<th>DATE NAISS</th>
					<th>LIEU NAISS</th>
					<th>SEXE</th>
					<th>NATIONALITÉ</th>
					<th>NIVEAU</th>
					<th>DIPLÔME</th>
					<th>FILIÈRE</th>
					<th>TÉLÉPHONE</th>
					<th>EMAIL</th>
				</tr>
			</thead>
			<tbody>
				@foreach($demandeurs as $demandeur)
					<tr style="font-size:8px !important">
						<td>{{ $demandeur->identifiant }}</td>
						<td>{{ $demandeur->name }} {{ $demandeur->prenoms }}</td>
						<td>{{ \Carbon\Carbon::parse($demandeur->datenaissance)->format('d-m-Y')}}</td>
						<td>{{ $demandeur->lieunaissance }}</td>
						<td>
							@if($demandeur->genre == "H")
								Homme
							@else
								Femme
							@endif						
						</td>
						<td>{{ $demandeur->nom_fr }}</td>
						<td>{{ $demandeur->niveau_lib }}</td>
						<td>{{ $demandeur->diplomelib }}</td>
						<td>{{ $demandeur->metier_libelle }}</td>
						<td>{{ $demandeur->telephone }}</td>
						<td>{{ $demandeur->email }}</td>
					</tr>
				@endforeach
			</tbody>
		</table>
	</div>
</body>
</html>