<!DOCTYPE html>
<html>
<head>
<style>
  #customers {
    font-family: Arial, Helvetica, sans-serif;
    border-collapse: collapse;
    width: 100%;
    font-size: 9px;
  }

  #customers td, #customers th {
    border: 1px solid #ddd;
    padding: 8px;
  }

  #customers tr:nth-child(even){background-color: #f2f2f2;}

  #customers tr:hover {background-color: #ddd;}

  #customers th {
    padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #04AA6D;
    color: white;
  }

  .impression{
    float: right;
    font-style: italic;
    font-size: 11px;
  }
</style>
</head>
<body>

<h4><center>LISTE DES OFFRES PUBLIEES</center></h4>

<table id="customers">
  <tr>
    <th>Entreprise</th>
    <th>Titre offre</th>
    <th>Filière</th>
    <th>Diplôme</th>
    <th>Contrat</th>
    <th>Région</th>
    <th>Nbre Poste</th>
    <th>Statut</th>
    <th>Date fin</th>
  </tr>
  @foreach($offres as $offre)
    <tr>
      <td>{{ $offre->raisonsociale }}</td>
      <td>{{ $offre->offretitre }}</td>
      <td>{{ $offre->metier_libelle }}</td>
      <td>{{ $offre->diplomelib }}</td>
      <td>{{ $offre->typecontratlib }}</td>
      <td>{{ $offre->region_nom }}</td>
      <td>{{ $offre->offrenombreposte }}</td>
      <td>{{ $offre->offre_statut }}</td>
      <td @if($offre->offre_datefin < gmdate('Y-m-d')) style="background:red" @endif>
        @if($offre->offre_datefin >= gmdate('Y-m-d'))
          {{ \Carbon\Carbon::parse($offre->offre_datefin)->format('d/m/Y') }}
        @else
          Offre expirée
        @endif
      </td>
    </tr>
  @endforeach
</table>
<footer>  
  <p class="impression">Document imprimé le <?php echo(gmdate('Y-m-d')) ?> à <?php echo(gmdate('H:i:s')) ?></p>
</footer>
</body>
</html>


