@extends('layouts.appp')

@section('title')
   Mon Compte
@endsection

@section('titre')
   Mon Compte
@endsection

@section('content')
    <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Mon compte</a></li>
                <!--li class="breadcrumb-item active"><a href="javascript:void(0)">Mon profil</a></li-->
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <div class="profile-tab">
                            <div class="custom-tab-1">
                                <ul class="nav nav-tabs">
                                    <li class="nav-item"><a href="#info-generale" data-toggle="tab" class="nav-link active show"><i class="fa fa-gears" style="margin-right: 15px !important;"></i>Informations Générales</a>
                                    </li>
                                    <li class="nav-item"><a href="#edit-compte" data-toggle="tab" class="nav-link"><i class="fa fa-user-circle" style="margin-right: 15px !important;"></i>Modifier mon compte</a>
                                    </li>
                                    <li class="nav-item"><a href="#edit-motpasse" data-toggle="tab" class="nav-link"><i class="fa fa-key" style="margin-right: 15px !important;"></i>Modifier mot de passe</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div id="info-generale" class="tab-pane fade active show">
                                        <div class="profile-personal-info">
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <div class="card">
                                                        <div class="card-body">
                                                            <div class="row">
                                                                <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                                    <div class="tab-content">
                                                                        <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                            @if($utilisateur->profil_photo)
                                                                                <img class="img-fluid" src="{{ asset('assets/img/profil/'.$utilisateur->profil_photo) }}" alt="">
                                                                            @else
                                                                                <img class="img-fluid" src="{{ asset('assets/img/profil/avatar.png') }}" alt="">
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                                    <div class="product-detail-content">
                                                                        <div class="new-arrival-content pr">
                                                                            <p class="text-couleur">Nom & Prénoms : {{ $utilisateur->civilite }}. {{ $utilisateur->name }} {{ $utilisateur->prenoms }}</p>
                                                                            <p class="text-couleur">Adresse Email : {{ $utilisateur->email }}</p>
                                                                            <p class="text-couleur">Numéro de téléphone : {{ $utilisateur->telephone }}</p>
                                                                            <p class="text-couleur">Type d'agent : {{ $utilisateur->qualite }}</p>
                                                                            @if($utilisateur->profil_id ==4 )<p class="text-couleur">Region : {{ $region->region_nom }}</p>@endif
                                                                        </div>
                                                                    </div>                                                                    
                                                                </div>
                                                            </div>
                                                            @if($utilisateur->profil_id ==4 )
                                                                <hr>
                                                                <h2>Vos tâches autorisées</h2>
                                                                <div class="row mt-3" style="background:#ccc; color:#000; font-weight:bold"> 
                                                                    @foreach($action_autorisees as $action_autorisee)
                                                                        <div class="col-md-6">
                                                                            <i class="fa fa-check-circle mr-2" style="color:green; font-size: 20px;"></i> {{ $action_autorisee->action_libelle }}
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    <div id="edit-compte" class="tab-pane fade">
                                        <div class="pt-3">
                                            <div class="settings-form">
                                                <form method="POST" action="{{ route('admin.save.modifer.compte') }}" enctype="multipart/form-data">
                                                    @csrf
                                                    @if($utilisateur->profil_id == 1)
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Nom <span class="text-danger">*</span></label>
                                                                <input type="text" class="form-control" name="nom" value="{{ $utilisateur->name }}" placeholder="Entrer le nom" required>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Prénoms <span class="text-danger">*</span></label>
                                                                <input type="text" class="form-control" name="prenoms" value="{{ $utilisateur->prenoms }}" placeholder="Entrer le prénoms" required>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Civilité <span class="text-danger">*</span></label>
                                                                <select name="civilite" class="form-control" required>
                                                                    <option value="" selected>Choisir une civilité</option>
                                                                    <option @if($utilisateur->civilite == "Mme") selected @endif value="Mme" {{ old('civilite') == 'Mme' ? 'selected' : '' }}>Madame</option>
                                                                    <option @if($utilisateur->civilite == "Mlle") selected @endif value="Mlle" {{ old('civilite') == 'Mlle' ? 'selected' : '' }}>Mademoiselle</option>
                                                                    <option @if($utilisateur->civilite == "Mr") selected @endif value="Mr" {{ old('civilite') == 'Mr' ? 'selected' : '' }}>Monsieur</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Type d'agent <span class="text-danger">*</span></label>
                                                                <input type="text" class="form-control" name="qualite" value="{{ $utilisateur->qualite }}" placeholder="Entrer le type d'agent" required>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Email <span class="text-danger">*</span></label>
                                                                <input type="email" class="form-control" name="email" value="{{ $utilisateur->email }}" placeholder="Entrer le email" required readonly>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Photo de profil <small>(Logo utilisé pour afficher vos offres d'emploi interne)</small></label>
                                                                <input type="file" class="form-control" name="profil_photo" value="{{ $utilisateur->profil_photo }}">
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if($utilisateur->profil_id == 4)
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6">
                                                                <label>Nom <span class="text-danger">*</span></label>
                                                                <input type="text" class="form-control" name="nom" value="{{ $utilisateur->name }}" placeholder="Entrer le nom" required>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Prénoms <span class="text-danger">*</span></label>
                                                                <input type="text" class="form-control" name="prenoms" value="{{ $utilisateur->prenoms }}" placeholder="Entrer le prénoms" required>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Civilité <span class="text-danger">*</span></label>
                                                                <select name="civilite" class="form-control" required>
                                                                    <option value="" selected>Choisir une civilité</option>
                                                                    <option @if($utilisateur->civilite == "Mme") selected @endif value="Mme" {{ old('civilite') == 'Mme' ? 'selected' : '' }}>Madame</option>
                                                                    <option @if($utilisateur->civilite == "Mlle") selected @endif value="Mlle" {{ old('civilite') == 'Mlle' ? 'selected' : '' }}>Mademoiselle</option>
                                                                    <option @if($utilisateur->civilite == "Mr") selected @endif value="Mr" {{ old('civilite') == 'Mr' ? 'selected' : '' }}>Monsieur</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Région <span class="text-danger">*</span></label>
                                                                @foreach($regions as $region)
                                                                    <input type="hidden" name="region_id" value="{{ $region->region_id }}">
                                                                    <input type="text" class="form-control" value="{{ $region->region_nom }}" readonly>
                                                                @endforeach
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Type d'agent <span class="text-danger">*</span></label>
                                                                <input type="text" class="form-control" name="qualite" value="{{ $utilisateur->qualite }}" placeholder="Entrer le type d'agent" readonly>
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <label>Email <span class="text-danger">*</span></label>
                                                                <input type="email" class="form-control" name="email" value="{{ $utilisateur->email }}" placeholder="Entrer le email" required readonly>
                                                            </div>
                                                            <div class="form-group col-md-12">
                                                                <label>Photo de profil</label>
                                                                <input type="file" class="form-control" name="profil_photo" value="{{ $utilisateur->profil_photo }}">
                                                            </div>
                                                        </div>
                                                    @endif
                                                    <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                                                </form> 
                                            </div>
                                        </div>
                                    </div>
                                    <div id="edit-motpasse" class="tab-pane fade">
                                        <div class="pt-3">
                                            <div class="settings-form">                        
                                                <form class="_apply_form_form" method="POST" action="{{ route('admin.save.password') }}" enctype="multipart/form-data">   
                                                    @csrf                     
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Mot de passe actuel <span style="color:red">*</span></label>
                                                                <input type="password" required class="form-control" id="current_password" name="current_password">                                                                
                                                            </div>
                                                        </div> 
                                                        <div class="col-md-12">                      
                                                            <div class="form-group">
                                                                <label>Nouveau mot de passe <span style="color:red">*</span></label>
                                                                <input type="password" required class="form-control" id="new_password" name="new_password">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-12">                        
                                                            <div class="form-group">
                                                                <label>Confirmer le nouveau mot de passe <span style="color:red">*</span></label>
                                                                <input type="password" required class="form-control" id="new_password_confirmation" name="new_password_confirmation">
                                                            </div> 
                                                        </div>
                                                    </div>                            
                                                    <div class="form-group">
                                                        <button class="btn btn-primary" type="submit">Enregistrer les modifications</button>
                                                    </div>                            
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function isInputNumber(evt){
            
            var ch = String.fromCharCode(evt.which);
            
            if(!(/[0-9]/.test(ch))){
                evt.preventDefault();
            }        
        }
    </script>
@endsection