@extends('layouts.appp')

@section('title')
    <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('titre')
    <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('content')
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion offres</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.liste.offre') }}">Liste des offres</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Détails</a></li>
        </ol>
    </div>
    <div class="row"> 
        <div class="col-lg-12">

            <div class="card">
                <div class="card-header"> <?php echo html_entity_decode($offre->offretitre) ?> 
                    <span class="float-right">
                        @if($offre->offre_statut == "BROUILLON")
                            <span class="badge badge-danger light">En attente de publication</span>
                        @elseif($offre->offre_statut == "VALIDE")
                            <span class="badge badge-warning light">Activé</span>
                        @elseif($offre->offre_statut == "PUBLIE")
                            <span class="badge badge-success light">Publié</span>
                        @endif
                    </span> 
                </div>
                <div class="card-body">
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Infos générales</a>
                            </li>
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND"))
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#liste-candidature"><i class="fa fa-graduation-cap mr-2"></i> Liste des candidatures</a>
                                </li>
                            @endif
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                @if($offre->offre_statut == "BROUILLON")
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#publier-offre"><i class="fa fa-check-circle mr-2"></i> Valider publier l'offre</a>
                                    </li>
                                @endif
                            @endif
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF"))
                                @if($offre->offre_statut == "BROUILLON")
                                    <li class="nav-item">
                                        <a class="nav-link" data-toggle="tab" href="#publier-offre"><i class="fa fa-check-circle mr-2"></i> Valider publier l'offre</a>
                                    </li>
                                @endif
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                            <div class="tab-content">
                                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                    @if($user->entreprise_logo !=null and $user->entreprise_logo !="")
                                                                        <img class="img-fluid" src="{{ asset('assets/img/entreprise/'.$user->entreprise_logo) }}" alt="" style="border: 2px solid #000;" width="250">
                                                                    @else
                                                                        <img class="img-fluid" src="{{ asset('assets/img/profil/warning.png') }}" alt="" style="border: 2px solid #000;" width="250">
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                            <div class="product-detail-content">
                                                                <div class="new-arrival-content pr">
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <p><span style="font-weight:bold;">Titre : </span><?php echo html_entity_decode($offre->offretitre) ?></p>
                                                                            <p><span style="font-weight:bold;">Métier : </span>{{ $offre->metier->metier_libelle }}</p>
                                                                            <p><span style="font-weight:bold;">Diplôme : </span>{{ $offre->diplome->diplomelib }}</p>
                                                                            <p><span style="font-weight:bold;">Année Expérience : </span>{{ $offre->offre_anneeexperience }}</p>
                                                                            <p><span style="font-weight:bold;">Contrat : </span>{{ $offre->contrat->typecontratlib }}</p>
                                                                            <p><span style="font-weight:bold;">Nbre de Poste : </span>{{ $offre->offrenombreposte }}</p>
                                                                            <p><span style="font-weight:bold;">Date de publication : </span>{{ \Carbon\Carbon::parse($offre->offre_datecrea)->format('d/m/Y') }}</p>
                                                                            <p><span style="font-weight:bold;">Date de clôture : </span>{{ \Carbon\Carbon::parse($offre->offre_datefin)->format('d/m/Y') }}</p>
                                                                        </div>
                                                                    </div><br>
                                                                </div>
                                                                <hr>
                                                                <div class="jb-list-01-title d-inline">
                                                                    @foreach($offre->regions as $region)
                                                                        <span class="mr-2 mb-2 d-inline-flex px-2 py-1 rounded {{ $region->region_couleur }} text-capitalize">{{ $region->region_nom }}</span>
                                                                    @endforeach 
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div><hr>                                                 
                                                    <h2 class="text-center mt-3">Autres informations</h2>
                                                    <div class="row mt-3">
                                                        <div class="col-md-6">
                                                            <h3>Description</h3>
                                                            <?php echo html_entity_decode($offre->offredescription) ?>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h3>Profil</h3>
                                                            <?php echo html_entity_decode($offre->offre_profil) ?>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h3>Mission</h3>
                                                            <?php echo html_entity_decode($offre->offre_mission) ?>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <h3>Composition du dossier</h3>
                                                            <?php echo html_entity_decode($offre->offre_dossier) ?>
                                                        </div>
                                                    </div>                                                   
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="liste-candidature">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th>Titre de l'offre</th>
                                                    <th class="text-center">Date d'abonnement</th>
                                                    <th class="text-center">Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($candidatures as $candidature)
                                                    <tr>
                                                        <td><?php echo html_entity_decode($offre->offretitre) ?></td>
                                                        <td class="text-center">{{ \Carbon\Carbon::parse($candidature->candidature_datecrea)->format('d/m/Y') }}</td>
                                                        <td class="text-center">
                                                            @if($candidature->candidature_statut == "BROUILLON")
                                                                <span class="badge badge-danger">Brouillon</span>
                                                            @elseif($candidature->candidature_statut == "VALIDE")
                                                                <span class="badge badge-warning">Active</span>
                                                             @elseif($candidature->candidature_statut == "APPROUVE")
                                                                <span class="badge badge-success">Approuvé</span>
                                                            @endif
                                                        </td>                                              
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="publier-offre">
                                <div class="pt-4">
                                    <form action="{{ route('admin.offre.publiervalider', $offre->offre_id) }}" method="POST">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label>Avis de validation <span class="text-danger">*</span></label>
                                                <select class="form-control" name="avis" required>
                                                    <option value="">Choisissez un avis</option>
                                                    <option value="OUI">Avis favorable</option>
                                                    <option value="NON">Avis non favorable</option>
                                                </select>
                                            </div>
                                            <diV class="col-md-12 mt-3">
                                                <label>Observation <span class="text-danger">*</span></label>
                                                <textarea class="form-control" rows="6" name="observation" placeholder="Entrer l'observation..." required></textarea>
                                            </diV>
                                            <div class="col-md-12 mt-3">
                                                <button class="btn btn-info"><i class="fa fa-check-circle mr-2"></i>Valider</button>
                                            </div>                                           
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection