@extends('layouts.appp')

@section('title')
    Modifier : <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('titre')
    Modifier : <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('content')
<script>
document.addEventListener('DOMContentLoaded', function() {
  var soumissionSelect = document.getElementById('soumission-select');
  var liensoumissionGroup = document.getElementById('liensoumission-group');
  var liensoumissionInput = document.querySelector('input[name="liensoumission"]');
  var liensoumissionError = document.getElementById('liensoumission-error');

  soumissionSelect.addEventListener('change', function() {
    var selectedOption = soumissionSelect.value;

    if (selectedOption === 'ANPE') {
      liensoumissionGroup.style.display = 'none';
      liensoumissionInput.removeAttribute('required');
      liensoumissionInput.value = '';
      liensoumissionError.textContent = '';
    } else {
      liensoumissionGroup.style.display = 'block';
      liensoumissionInput.setAttribute('required', 'required');
      
      if (selectedOption === 'PAR MAIL') {
        liensoumissionInput.setAttribute('type', 'email');
        liensoumissionError.textContent = 'Entrer un email valide';
      } else if (selectedOption === 'LIEN SITE WEB') {
        liensoumissionInput.setAttribute('type', 'url');
        liensoumissionError.textContent = 'Entrer une URL valide';
      } else {
        liensoumissionInput.setAttribute('type', 'text');
        liensoumissionError.textContent = '';
      }
    }
  });

  soumissionSelect.dispatchEvent(new Event('change'));
});
</script>
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion  offre</a></li>
            <li class="breadcrumb-item"><a href="{{ route('admin.valider.offre') }}">Offres à valider</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Modifier</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Modifier : <?php echo html_entity_decode($offre->offretitre) ?></h4>
                    <a href="{{ route('admin.valider.offre') }}" class="btn btn-primary float-end"><i class="fa fa-tasks"></i> Liste offres à valider</a>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form method="POST" action="{{ route('admin.savemodifieroffreemploi', $offre->offre_id) }}">
                            @csrf
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Titre de l'offre <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('titre') is-invalid @enderror" name="titre" value="{{ $offre->offretitre }}" placeholder="Exemple : Développeur Web" required>
                                </div>
                                @if($offre->user_id !=1)
	                                <div class="col-md-6">
	                                    <label>Employeur <span class="text-danger">*</span></label>
	                                    <select name="user_id" id="contrat-select" required class="form-control @error('user_id') is-invalid @enderror">
	                                        <option value="">Choisir un employeur</option>
	                                        @foreach($employeurs as $employeur)
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or $employeur->region_id == Auth::user()->region_id)
	                                               <option @if($offre->user_id == $employeur->id) selected @endif value="{{ $employeur->id }}" {{ old('user_id') == $employeur->id ? 'selected' : '' }}>{{ $employeur->raisonsociale }}</option>
	                                            @endif
                                            @endforeach
	                                    </select>
	                                </div>
                                @else
                                <div class="col-md-6">
                                	<label>ANPE</label>
                                	<input type="hidden" name="user_id" value="{{ $anpe->id }}">
                                	<input type="text" value="{{ $anpe->raisonsociale }}" class="form-control" readonly>
                                </div>
                                @endif
                            </div> 
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Lieu <span class="text-danger">*</span></label>
                                    <select id="multi-value-select" multiple="multiple" name="region_ids[]" required>
                                        <option value="">Choisir un ou des lieu(x)</option>
                                        @foreach($regions as $region)
                                            <option value="{{ $region->region_id }}" {{ in_array($region->region_id, old('region_ids', [])) || ($offre->regions->contains('region_id', $region->region_id)) ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Type de Contrat <span class="text-danger">*</span></label>
                                    <select id="contrat-select" class="form-control rounded @error('typecontrat_id') is-invalid @enderror" name="typecontrat_id" required>
                                        <option value="">Sélectionnez un type de contrat</option>
                                        @foreach($typecontrat as $contrat)
                                            <option @if($offre->typecontrat_id == $contrat->typecontrat_id) selected @endif value="{{ $contrat->typecontrat_id }}" {{ old('typecontrat_id') == $contrat->typecontrat_id ? 'selected' : '' }}>{{ $contrat->typecontratlib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Type de métier <span class="text-danger">*</span></label>
                                    <select id="metier-select" class="form-control rounded @error('metier_id') is-invalid @enderror" name="metier_id" required>
                                        <option value="">Sélectionnez un métier</option>
                                        @foreach($metiers as $metier)
                                            <option @if($offre->metier_id == $metier->metier_id) selected @endif value="{{ $metier->metier_id }}" {{ old('metier_id') == $metier->metier_id ? 'selected' : '' }}>{{ $metier->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Niveau d'étude <span class="text-danger">*</span></label>
                                    <select id="diplome-select" class="form-control rounded @error('diplome_id') is-invalid @enderror" name="diplome_id" required>
                                        <option value="">Sélectionnez une niveau d'étude</option>
                                        @foreach($diplomes as $diplome)
                                            <option @if($offre->diplome_id == $diplome->diplome_id) selected @endif value="{{ $diplome->diplome_id }}" {{ old('diplome_id') == $diplome->diplome_id ? 'selected' : '' }}>{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Année d'expérence <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control rounded @error('annexperience') is-invalid @enderror" name="annexperience" value="{{$offre->offre_anneeexperience }}" placeholder="Année d'expérence" required>
                                </div>
                                <div class="col-md-6">
                                    <label>Nombre de Poste <span class="text-danger">*</span></label>
                                    <input type="text" onkeypress="isInputNumber(event)" class="form-control rounded @error('nombreposte') is-invalid @enderror" name="nombreposte" value="{{ $offre->offrenombreposte }}" placeholder="Nombre de poste" required>
                                </div> 
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Date de clôture <span class="text-danger">*</span></label>
                                    <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control rounded @error('datefin') is-invalid @enderror" name="datefin" value="{{ $offre->offre_datefin }}">
                                </div>
                                @if($offre->user_id != 1)
                                <div class="col-md-6">
                                    <label>Soumission par mail ou un lien <span class="text-danger">*</span></label>
                                    <select class="form-control" required name="soumission" id="soumission-select">
                                      <option value="">Soumet-on par mail ou un lien ?</option>
                                      <option @if($offre->offre_soumission == "PAR MAIL") selected @endif value="PAR MAIL" {{ old('soumission') == 'PAR MAIL' ? 'selected' : '' }}>Par email</option>
                                      <option @if($offre->offre_soumission == "LIEN SITE WEB") selected @endif value="LIEN SITE WEB" {{ old('soumission') == 'LIEN SITE WEB' ? 'selected' : '' }}>Lien site Web</option>
                                      <option @if($offre->offre_soumission == "ANPE") selected @endif value="ANPE" {{ old('soumission') == 'ANPE' ? 'selected' : '' }}>ANPE</option>
                                    </select>
                                </div>
                                @endif
                            </div>
                            @if($offre->user_id != 1)
                                <div class="form-group" id="liensoumission-group">
                                  <label>Lien ou mail de soumission</label>
                                  <input type="text" class="form-control" name="liensoumission" value="{{ $offre->offre_liensoumission }}" placeholder="Entrer le mail ou le lien de soumission">
                                  <span id="liensoumission-error" class="text-danger"></span>
                                </div>
                            @endif
                            <div class="form-group">
                                <label>Description <span class="text-danger">*</span></label>
                                <textarea id="summernote" class="form-control" name="description" required><?php echo html_entity_decode($offre->offredescription) ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Mission <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="exampleMission" name="mission" rows="3" required><?php echo html_entity_decode($offre->offre_mission) ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Profil <span class="text-danger">*</span></label>
                                <textarea id="OffreProfil" name="profil" required><?php echo html_entity_decode($offre->offre_profil) ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Composition du dossier <span class="text-danger">*</span></label>
                                <textarea id="CompositionDossier" name="dossier" required><?php echo html_entity_decode($offre->offre_dossier) ?></textarea>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>            
    function isInputNumber(evt){
        
        var ch = String.fromCharCode(evt.which);
        
        if(!(/[0-9]/.test(ch))){
            evt.preventDefault();
        }        
    }    
</script>
@endsection