@extends('layouts.appp')

@section('title')
    Liste des offres expirées
@endsection

@section('titre')
    Liste des offres expirées
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion offres</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Offres expirées</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des offres expirées</h4>
                        <div class="float-end">
                            @if($offres->count() > 0)
                                <a href="{{ route('admin.export-offre-expiree.pdf') }}" class="badge badge-primary">Export PDF</a>
                                <a href="{{ route('admin.export-offre-expiree.excel') }}" class="badge badge-success">Export Excel</a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">                         
                        <form action="{{ route('admin.offre.expiree') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Métier</label>
                                    <select id="metier_select" name="m">
                                        <option value="">Choissisez un métier</option>
                                        @foreach($metiers as $metier)
                                            <option @if($metier_selected == $metier->metier_id) selected @endif value="{{ $metier->metier_id}}">{{ $metier->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label>Diplôme</label>
                                    <select id="diplome_select" name="d">
                                        <option value="">Choisissez un diplôme</option>
                                        @foreach($diplomes as $diplome)
                                            <option @if($diplome_selected == $diplome->diplome_id) selected @endif value="{{ $diplome->diplome_id }}">{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label>Contrat</label>
                                    <select class="form-control rounded" name="c">
                                        <option value="">Sélectionnez un contrat</option>
                                        @foreach($contrats as $contrat)
                                            <option @if($contrat_selected == $contrat->typecontrat_id) selected @endif value="{{ $contrat->typecontrat_id }}">{{ $contrat->typecontratlib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mt-3">                                
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Titre de l'offre</th>
                                        <th>Status</th>
                                        <th class="text-center">Date Expiration</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($offres as $offre)
                                        <tr>
                                            <td>
                                                <div class="text-center"><img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
                                            </td>
                                            <td>
                                                <div class="cats-box rounded bg-white d-flex align-items-center">
                                                    <div class="cats-box-caption px-2">
                                                        <h4 class="fs-md mb-0 ft-medium"><?php echo html_entity_decode($offre->offretitre) ?></h4>
                                                        <div class="d-block mb-2 position-relative">
                                                            <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>{{ $offre->typecontratlib }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                @if($offre->offre_statut == "BROUILLON")
                                                    <span class="badge badge-danger light">Brouillon</span>
                                                @elseif($offre->offre_statut == "VALIDE")
                                                    <span class="badge badge-warning light">Active</span>
                                                @elseif($offre->offre_statut == "PUBLIE")
                                                    <span class="badge badge-success light">Publié</span>
                                                @endif
                                            </td>
                                            <td class="text-center">{{ \Carbon\Carbon::parse($offre->offre_datefin)->format('d/m/Y') }}</td>
                                            <td class="text-center">
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    <a href="{{ route('admin.details.offre',$offre->offre_id) }}" title="DETAILS DE L'OFFRE" style="cursor: pointer;"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-flui" style="margin-top:1px" width="26" alt=""></a>
                                                    <span class="" title="RELANCER L'OFFRE" data-toggle="modal" data-target="#RelancerOffre{{ $offre->id }}"><img src="{{ asset('assets/img/icons/relancer.png') }}" class="img-fluid" width="30" alt=""></span>                                              
                                                    <span class="ml-1" data-toggle="modal" data-target="#supprimeroffre{{$offre->offre_id}}" title="SUPPRIMER L'OFFRE"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></span>                                                
                                                @endif

                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_OFF"))
                                                    <a href="{{ route('admin.details.offre',$offre->offre_id) }}" title="DETAILS DE L'OFFRE" style="cursor: pointer;"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-flui" style="margin-top:1px" width="26" alt=""></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF"))
                                                    <span class="" title="RELANCER L'OFFRE" data-toggle="modal" data-target="#RelancerOffre{{ $offre->id }}"><img src="{{ asset('assets/img/icons/relancer.png') }}" class="img-fluid" width="30" alt=""></span>                                              
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "DEL_OFF"))
                                                    <span class="" data-toggle="modal" data-target="#supprimeroffre{{$offre->offre_id}}" title="SUPPRIMER L'OFFRE"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></span>                                                
                                                @endif
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="RelancerOffre{{ $offre->id }}">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Relancer l'offre : <?php echo html_entity_decode($offre->offretitre) ?></h5>
                                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                                                    </div>
                                                    <form method="POST" action="{{ route('admin.publier.relanceroffre',$offre->offre_id) }}" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <label>Nouvelle date de clôture</label>
                                                            <input type="date" name="datefin" class="form-control" value="{{ old('datefin') }}" min="<?php echo date('Y-m-d'); ?>" required>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info">Relancer l'offre</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div> 

                                        <div class="modal fade" id="supprimeroffre{{$offre->offre_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer l'offre d'emploi : <?php echo html_entity_decode($offre->offretitre) ?>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.offre',$offre->offre_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection