
@extends('layouts.appp')

@section('title')
    Publier une offre
@endsection

@section('titre')
    Publier une offre
@endsection

@section('content')
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion  offre</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Publier une offre</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Enregistrer une nouvelle offre</h4>
                    <a href="{{ route('admin.liste.offre') }}" class="btn btn-primary float-end"><i class="fa fa-tasks"></i> Liste Offres</a>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form method="POST" action="{{ route('admin.savepublieroffreemploi') }}">
                            @csrf
                            <div class="form-group">
                                <label>Titre de l'offre <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('titre') is-invalid @enderror" name="titre" value="{{ old('titre') }}" placeholder="Exemple : Développeur Web" required>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Lieu <span class="text-danger">*</span></label>
                                    <select id="multi-value-select" multiple="multiple" name="region_ids[]" required>
                                        <option value="">Choisir un ou des lieu(x)</option>
                                        @foreach($regions as $region)
                                            <option value="{{ $region->region_id }}" {{ old('region_id') == $region->region_id ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Type de Contrat <span class="text-danger">*</span></label>
                                    <select id="contrat-select" class="form-control rounded @error('typecontrat_id') is-invalid @enderror" name="typecontrat_id" required>
                                        <option value="">Sélectionnez un type de contrat</option>
                                        @foreach($typecontrat as $contrat)
                                            <option value="{{ $contrat->typecontrat_id }}" {{ old('typecontrat_id') == $contrat->typecontrat_id ? 'selected' : '' }}>{{ $contrat->typecontratlib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Type de métier <span class="text-danger">*</span></label>
                                    <select id="metier-select" class="form-control rounded @error('metier_id') is-invalid @enderror" name="metier_id" required>
                                        <option value="">Sélectionnez un métier</option>
                                        @foreach($metiers as $metier)
                                            <option value="{{ $metier->metier_id }}" {{ old('metier_id') == $metier->metier_id ? 'selected' : '' }}>{{ $metier->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Niveau d'étude <span class="text-danger">*</span></label>
                                    <select id="diplome-select" class="form-control rounded @error('diplome_id') is-invalid @enderror" name="diplome_id" required>
                                        <option value="">Sélectionnez une niveau d'étude</option>
                                        @foreach($diplomes as $diplome)
                                            <option value="{{ $diplome->diplome_id }}" {{ old('diplome_id') == $diplome->diplome_id ? 'selected' : '' }}>{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Année d'expérence <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control rounded @error('annexperience') is-invalid @enderror" name="annexperience" value="{{ old('annexperience') }}" placeholder="Année d'expérence" required>
                                </div>
                                <div class="col-md-6">
                                    <label>Nombre de Poste <span class="text-danger">*</span></label>
                                    <input type="text" onkeypress="isInputNumber(event)" class="form-control rounded @error('nombreposte') is-invalid @enderror" name="nombreposte" value="{{ old('nombreposte') }}" placeholder="Nombre de poste" required>
                                </div> 
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Date de clôture <span class="text-danger">*</span></label>
                                    <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control rounded @error('datefin') is-invalid @enderror" name="datefin" value="{{ old('datefin') }}" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Description <span class="text-danger">*</span></label>
                                <textarea id="summernote" class="form-control" name="description" required>{{ old('description') }}</textarea>
                            </div>
                            <div class="form-group">
                                <label>Mission <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="exampleMission" name="mission" rows="3" required>{{ old('mission') }}</textarea>
                            </div>
                            <div class="form-group">
                                <label>Profil <span class="text-danger">*</span></label>
                                <textarea id="OffreProfil" name="profil" required>{{ old('profil') }}</textarea>
                            </div>
                            <div class="form-group">
                                <label>Composition du dossier <span class="text-danger">*</span></label>
                                <textarea id="CompositionDossier" name="dossier" required>{{ old('dossier') }}</textarea>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Publier l'offre</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>             
    function isInputNumber(evt){
        
        var ch = String.fromCharCode(evt.which);
        
        if(!(/[0-9]/.test(ch))){
            evt.preventDefault();
        }        
    }    
</script>
@endsection