@extends('layouts.appp')

@section('title')
    Listes des diplômes
@endsection

@section('titre')
    Listes des diplômes
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Paramétrage de base</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Listes des diplômes</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Listes des diplômes</h4>
                    </div>
                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM"))
                    <div class="card-body">                       
                        <form action="{{ route('admin.save.diplome') }}" method="POST" class="mb-10">
                            @csrf
                            <div class="row">
                                <div class="col-md-8">
                                    <label>Libellé du diplôme <span class="text-danger">*</span></label>
                                    <input type="text" name="libelle" value="" class="form-control" placeholder="Entrer le libellé du diplôme" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Ajouter le diplôme</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Libellé</th>
                                        <th>Date création</th>
                                        <th>Statut</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($diplomes as $diplome)
                                        <tr>
                                            <td class="d-none"></td>
                                            <td>{{ $diplome->diplomelib }}</td>
                                            <td>{{ \Carbon\Carbon::parse($diplome->diplome_datecrea)->format('d/m/Y') }}</td>
                                            <td>
                                                @if($diplome->diplome_statut == "VALIDE")
                                                    <a href="{{ route('admin.desactiver.diplome',$diplome->diplome_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                @else
                                                    <a href="{{ route('admin.activer.diplome',$diplome->diplome_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                @endif
                                            </td>
                                            <td class="text-center"> 
                                                <span  data-toggle="modal" data-target="#ModifierDiplome{{ $diplome->diplome_id }}" style="cursor:pointer" title="MODIFIER LE DIPLÔME"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></span>
                                                <span data-toggle="modal" data-target="#supprimerdiplome{{$diplome->diplome_id}}" title="SUPPRIMER LE DIPLÔME"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></span>
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="ModifierDiplome{{ $diplome->diplome_id }}">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Modifier : {{ $diplome->diplomelib }}</h5>
                                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                                                        </button>
                                                    </div>
                                                    <form method="POST" action="{{ route('admin.modifier.diplome',$diplome->diplome_id) }}" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <label>Libelle <span class="text-danger">*</span></label>
                                                            <input type="text" name="libelle" placeholder="Entrer le libellé du diplôme" class="form-control" required value="{{ $diplome->diplomelib }}">
                                                            <br>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info">Enregistrer</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal fade" id="supprimerdiplome{{$diplome->diplome_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer le diplôme : {{ $diplome->diplomelib }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.diplome',$diplome->diplome_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

    